/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.demension.DemensionVo;
import com.hotent.uc.params.demension.OrgSelectInitVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.AuthFilterUtil;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/demension/v2/"})
@Api(tags={"\u7ef4\u5ea6\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class DemensionController2
extends BaseController2<DemensionManager, Demension> {
    @Resource
    DemensionManager demensionService;
    @Autowired
    OrgAuthManager orgAuthService;

    @RequestMapping(value={"dems/getDemList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ef4\u5ea6 \u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7ef4\u5ea6\u5217\u8868")
    public CommonResult<PageList<Demension>> getDemList(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        AuthFilterUtil.setDemAuthFilter(filter);
        PageList query = this.demensionService.query(filter);
        return CommonResult.ok().value((Object)query);
    }

    @RequestMapping(value={"dem/addDem"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7ef4\u5ea6", httpMethod="POST", notes="\u6dfb\u52a0\u7ef4\u5ea6")
    public CommonResult<String> addDem(@ApiParam(name="dem", value="\u7ef4\u5ea6\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DemensionVo dem) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.addDem(dem);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/deleteDem"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u6279\u91cf\u5220\u9664\u7ef4\u5ea6", httpMethod="DELETE", notes="\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u6279\u91cf\u5220\u9664\u7ef4\u5ea6")
    public CommonResult<String> deleteDem(@ApiParam(name="codes", value="\u7ef4\u5ea6\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody(required=false) String codes) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.deleteDem(codes);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/deleteDemByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6ids\u6279\u91cf\u5220\u9664\u7ef4\u5ea6", httpMethod="DELETE", notes="\u6839\u636e\u7ef4\u5ea6ids\u6279\u91cf\u5220\u9664\u7ef4\u5ea6")
    public CommonResult<String> deleteDemByIds(@ApiParam(name="ids", value="\u7ef4\u5ea6id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam(required=false) String ids) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.deleteDemByIds(ids);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/updateDem"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7ef4\u5ea6", httpMethod="PUT", notes="\u66f4\u65b0\u7ef4\u5ea6")
    @UpdateMethod(type=DemensionVo.class)
    public CommonResult<String> updateDem(@ApiParam(name="dem", value="\u7ef4\u5ea6\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DemensionVo dem) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.updateDem(dem);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/getDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f")
    public CommonResult<Demension> getDem(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        Demension dem = this.demensionService.getByCode(code);
        return CommonResult.ok().value((Object)dem);
    }

    @RequestMapping(value={"demUser/getUsersByDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u4e0b\u7684\u6240\u6709\u4eba\u5458", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u4e0b\u7684\u6240\u6709\u4eba\u5458")
    public CommonResult<List<UserVo>> getUsersByDem(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        List<UserVo> users = this.demensionService.getUsersByDem(code);
        return CommonResult.ok().value(users);
    }

    @RequestMapping(value={"demUser/getOrgsByDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ef4\u5ea6\u4e0b\u7684\u6240\u6709\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7ef4\u5ea6\u4e0b\u7684\u6240\u6709\u7ec4\u7ec7")
    public CommonResult<List<Org>> getOrgsByDem(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        List<Org> orgs = this.demensionService.getOrgsByDem(code);
        return CommonResult.ok().value(orgs);
    }

    @RequestMapping(value={"dem/setDefaultDem"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6", httpMethod="PUT", notes="\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6")
    public CommonResult<String> setDefaultDem(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.setDefaultDem(code);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/cancelDefaultDem"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u9ed8\u8ba4\u7ef4\u5ea6", httpMethod="PUT", notes="\u53d6\u6d88\u9ed8\u8ba4\u7ef4\u5ea6")
    public CommonResult<String> cancelDefaultDem(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        CommonResult<String> CommonResult2 = this.demensionService.cancelDefaultDem(code);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/getDefaultDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u4fe1\u606f")
    public CommonResult<Demension> getDefaultDem() throws Exception {
        Demension demension = this.demensionService.getDefaultDemension();
        return CommonResult.ok().value((Object)demension);
    }

    @RequestMapping(value={"dem/deleteDemPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ef4\u5ea6\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ef4\u5ea6\u6570\u636e")
    public CommonResult<Integer> deleteDemPhysical() throws Exception {
        Integer num = this.demensionService.removePhysical();
        CommonResult<Integer> CommonResult2 = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/deleteDemPhysical"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ef4\u5ea6\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ef4\u5ea6\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<Demension>> getDemByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        OrgExportObject exportObject = new OrgExportObject();
        exportObject.setBtime(btime);
        exportObject.setEtime(etime);
        List<Demension> demensionList = this.demensionService.getDemByTime(exportObject);
        return CommonResult.ok().value(demensionList);
    }

    @RequestMapping(value={"dem/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7ef4\u5ea6\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7ef4\u5ea6\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7ef4\u5ea6\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        CommonResult<Boolean> CommonResult2 = this.demensionService.isCodeExist(code);
        return CommonResultUtil.getResult(CommonResult2);
    }

    @RequestMapping(value={"dem/getOrgSelectListInit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u521d\u59cb\u5316\u7ec4\u7ec7\u9009\u62e9\u5668\u63a7\u4ef6\u6570\u636e", httpMethod="GET", notes="\u67e5\u8be2\u6240\u6709\u673a\u6784\u5404\u7ef4\u5ea6\u6570\u636e\uff0c\u5e76\u4e14\u6309\u7167\u4ece\u5c5e\u5173\u7cfb\u7ec4\u88c5")
    public CommonResult<OrgSelectInitVo> getOrgSelectListInit(@RequestParam(required=true) String code) throws Exception {
        ObjectNode objectNode = this.demensionService.getOrgSelectListInit(code);
        OrgSelectInitVo orgSelectInitVo = new OrgSelectInitVo();
        orgSelectInitVo.setOgSelectList(objectNode.get("orgSelectList"));
        orgSelectInitVo.setInitGanAndDem(objectNode.get("initGanAndDem"));
        return CommonResult.ok().value((Object)orgSelectInitVo);
    }
}

