/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.EncryptUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.ElectronicSealManager;
import com.hotent.uc.model.ElectronicSeal;
import com.hotent.uc.params.seal.ImportSignatureObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/electronicSeal/v1"})
@Api(tags={"electronicSealController"})
@ApiGroup(group={"group_uc"})
public class ElectronicSealController
extends UcBaseController<ElectronicSealManager, ElectronicSeal> {
    @Resource
    ElectronicSealManager electronicSealManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="uc_electronic_seal\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6uc_electronic_seal\u5217\u8868")
    public PageList<ElectronicSeal> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.electronicSealManager.query(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="uc_electronic_seal\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="uc_electronic_seal\u6570\u636e\u8be6\u60c5")
    public ElectronicSeal get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (ElectronicSeal)this.electronicSealManager.get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> save(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        return this.electronicSealManager.saveElectronicSeal(electronicSeal);
    }

    @PostMapping(value={"userSave"})
    @ApiOperation(value="front\u7528\u6237\u81ea\u5df1\u6dfb\u52a0\u7535\u5b50\u7b7e\u7ae0", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> userSave(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        CommonResult<String> commonResult = this.electronicSealManager.userSaveElectronicSeal(electronicSeal);
        return CommonResultUtil.getResult(commonResult);
    }

    @PostMapping(value={"mobileUpdate"})
    @ApiOperation(value="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0", httpMethod="POST", notes="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0")
    public CommonResult<String> mobileUpdate(@RequestBody ElectronicSeal electronicSeal) throws Exception {
        CommonResult<String> commonResult = this.electronicSealManager.mobileUpdateElectronicSeal(electronicSeal);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"getElectronicSeal"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id")
    public CommonResult<String> getUser(@ApiParam(name="password", value="\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801") @RequestParam(required=true) Optional<String> password, @ApiParam(name="secretFree", value="\u662f\u5426\u514d\u5bc6") @RequestParam(required=true) Optional<Boolean> secretFree) throws Exception {
        return this.electronicSealManager.getUser(password, secretFree);
    }

    @GetMapping(value={"/getSealByUserId/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7535\u5b50\u7b7e\u7ae0")
    public ElectronicSeal getSealByUserId(@PathVariable(value="userId") String userId) {
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)userId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return null;
        }
        electronicSeal.setPassword("");
        return electronicSeal;
    }

    @GetMapping(value={"/getSealByCurrentUserId"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7535\u5b50\u7b7e\u7ae0")
    public ElectronicSeal getCurrentUserSeal() {
        ElectronicSeal res = this.electronicSealManager.getCurrentUserSeal();
        return res;
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664uc_electronic_seal\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664uc_electronic_seal\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.electronicSealManager.removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/saveSignatureBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", httpMethod="POST", notes="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e")
    public CommonResult<String> saveSignatureBatch(@ApiParam(name="signatureData", value="\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", required=true) @RequestBody ImportSignatureObject signatureData) throws Exception {
        return ((ElectronicSealManager)this.baseService).importSignature(signatureData);
    }

    private String encryptSealPassword(String blankPswd) throws Exception {
        return EncryptUtil.encrypt((String)blankPswd);
    }
}

