/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.uc.manager.MatrixColDefManager;
import com.hotent.uc.manager.MatrixManager;
import com.hotent.uc.model.Matrix;
import com.hotent.uc.model.User;
import com.hotent.uc.params.matrix.OneMatrixDataVo;
import com.hotent.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/matrix/v2"})
@Api(tags={"matrixController2"})
@ApiGroup(group={"group_uc"})
public class MatrixController2
extends BaseController2<MatrixManager, Matrix> {
    @Resource
    MatrixManager matrixManager;
    @Resource
    MatrixColDefManager matrixColDefManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public CommonResult<PageList<Matrix>> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("createBy", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
            queryFilter.addFilter("managerId", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
        }
        PageList pageList = this.matrixManager.query(queryFilter);
        return CommonResult.ok().value((Object)pageList);
    }

    @PostMapping(value={"/listDetail"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public CommonResult<PageList<Matrix>> listDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        PageList<Matrix> matrixPageList = this.matrixManager.listDetail(queryFilter);
        return CommonResult.ok().value(matrixPageList);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public CommonResult<Matrix> get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        Matrix matrix = this.matrixManager.getDetail(id);
        return CommonResult.ok().value((Object)matrix);
    }

    @RequestMapping(value={"getByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801/\u522b\u540d\u83b7\u53d6\u77e9\u9635", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public CommonResult<Matrix> getByAlias(@ApiParam(name="code", value="code", required=true) @RequestParam String code) throws Exception {
        if (BeanUtils.isEmpty((Object)code)) {
            return CommonResult.error().message("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Matrix matrix = this.matrixManager.getByAlias(code);
        return CommonResult.ok().value((Object)matrix);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="matrix", value="\u77e9\u9635\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody Matrix matrix) throws Exception {
        CommonResult<String> commonResult = this.matrixManager.controllerSave(matrix);
        return CommonResultUtil.getResult(commonResult);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.matrixManager.batchRemove(ids);
        String msg = ThreadMsgUtil.getMessage();
        if (msg != null && !msg.contains("\u4e0d\u5141\u8bb8\u5220\u9664")) {
            msg = "\u6279\u91cf\u5220\u9664\u6210\u529f";
        }
        return CommonResult.ok().message(msg);
    }

    @GetMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="publish")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        this.matrixManager.publish(id);
        return CommonResult.ok().message("\u53d1\u5e03\u6210\u529f\uff01");
    }

    @GetMapping(value={"/saveManager"})
    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458", httpMethod="GET", notes="saveManager")
    public CommonResult<String> saveManager(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="userId", value="\u7ba1\u7406\u5458userId", required=true) @RequestParam String userId, @ApiParam(name="fullname", value="\u7ba1\u7406\u5458\u540d\u79f0", required=true) @RequestParam String fullname) throws Exception {
        this.matrixManager.saveManager(id, userId, fullname);
        return CommonResult.ok().message("\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"/getUsers"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public List<Map<String, Object>> getUsers(@RequestBody Map<String, Object> params) throws Exception {
        List<Map<String, Object>> mapList = this.matrixManager.getUsers(params);
        return mapList;
    }

    @PostMapping(value={"/data/list/{matrixId}"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    @ResponseBody
    public CommonResult<OneMatrixDataVo> dataList(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        Map<String, Object> map = this.matrixManager.getData(matrixId, queryFilter, true);
        OneMatrixDataVo oneMatrixDataVo = new OneMatrixDataVo();
        if (BeanUtils.isNotEmpty(map)) {
            oneMatrixDataVo.setColFields((List)map.get("colFields"));
            oneMatrixDataVo.setMatrix((Matrix)((Object)map.get("matrix")));
            oneMatrixDataVo.setPageList((PageList<Map<String, Object>>)((PageList)map.get("data")));
        }
        return CommonResult.ok().value((Object)oneMatrixDataVo);
    }

    @GetMapping(value={"/data/getOneData"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u6761\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u67d0\u6761\u6570\u636e")
    @ResponseBody
    public Object getOneData(@ApiParam(name="pk", value="pk") @RequestParam String pk, @ApiParam(name="matrixId", value="matrixId") @RequestParam String matrixId) throws Exception {
        if (StringUtil.isNotEmpty((String)pk)) {
            Map<String, Object> map = this.matrixManager.getOneData(matrixId, pk);
            return map;
        }
        Map<String, Object> map = this.matrixManager.getBlankOneData(matrixId);
        return map;
    }

    @PostMapping(value={"/data/save/{matrixId}"})
    @ApiOperation(value="\u4fdd\u5b58\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u4fdd\u5b58\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> dataSave(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="data", value="data") @RequestBody String data) throws Exception {
        this.matrixManager.saveData(matrixId, data);
        return CommonResult.ok().message("\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/data/remove/{matrixId}"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55")
    public CommonResult<String> dataRemove(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, String ... ids) throws Exception {
        this.matrixManager.dataRemove(matrixId, ids);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f\uff01");
    }
}

