/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.dao.OrgUserDao;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.UserImportManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserUnderManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgAuth;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgParams;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.OrgTree;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserUnder;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.group.GroupIdentity;
import com.hotent.uc.params.org.OaAsyncObject;
import com.hotent.uc.params.org.OrgAuthVo;
import com.hotent.uc.params.org.OrgPostVo;
import com.hotent.uc.params.org.OrgTreeVo;
import com.hotent.uc.params.org.OrgUserVo;
import com.hotent.uc.params.org.OrgVo;
import com.hotent.uc.params.orgRole.OrgRoleVo;
import com.hotent.uc.params.post.PostDueVo;
import com.hotent.uc.params.user.UserUnderVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.AuthFilterUtil;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/api/org/v2/"})
@Api(tags={"\u7ec4\u7ec7\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class OrgController2
extends BaseController2<OrgManager, Org> {
    @Autowired
    OrgManager orgService;
    @Autowired
    DemensionManager demService;
    @Autowired
    OrgPostManager postService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    UserUnderManager userUnderService;
    @Autowired
    UserImportManager userImportService;
    @Resource
    OrgRoleManager orgRoleService;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    OrgJobManager orgJobManager;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    UserManager userService;
    @Resource
    OrgParamsManager orgParamsService;
    @Resource
    OrgUserDao orgUserDao;

    @RequestMapping(value={"orgUser/deleteOrgById"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u548c\u7528\u6237id\u5220\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5e76\u5c97\u4f4did\u4e3a\u7a7a", httpMethod="DELETE", notes="\u6839\u636e\u7ec4\u7ec7id\u548c\u7528\u6237id\u5220\u9664\u7ec4\u7ec7\u4e0b\u7684\u7528\u6237\uff0c\u5e76\u5c97\u4f4did\u4e3a\u7a7a")
    public CommonResult<String> deleteOrgById(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        CommonResult<String> commonResult = this.orgUserService.deleteOrgById(orgId, userId);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/getOrgPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public CommonResult<PageList<Org>> getOrgPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Org> queryFilter) throws Exception {
        PageList list = this.orgService.query(queryFilter);
        List rows = list.getRows();
        Optional.ofNullable(rows).ifPresent(org -> {
            Locale locale = LocaleContextHolder.getLocale();
            for (Org orgItem : org) {
                String i18nKey = String.format("org.%s", orgItem.getCode());
                orgItem.setName(I18nUtil.handleI18nMessage((String)i18nKey, (String)orgItem.getName(), (Locale)locale));
            }
        });
        return CommonResult.ok().value((Object)list);
    }

    @RequestMapping(value={"org/addOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7", httpMethod="POST", notes="\u6dfb\u52a0\u7ec4\u7ec7")
    public CommonResult<String> addOrg(@ApiParam(name="orgVo", value="\u7ec4\u7ec7\u89c6\u56fe", required=true) @RequestBody OrgVo orgVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.addOrg(orgVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"org/deleteOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u5220\u9664\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u5220\u9664\u7ec4\u7ec7\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\uff0c\u8fde\u540c\u5176\u5b50\u7ec4\u7ec7\u3001\u7ec4\u7ec7\u53c2\u6570\u3001\u5c97\u4f4d\u3001\u7ec4\u7ec7\u4eba\u5458\u5173\u7cfb\u53ca\u5bf9\u5e94\u4e0b\u5c5e\u4e00\u8d77\u5220\u9664")
    public CommonResult<String> deleteOrg(@ApiParam(name="codes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestBody String codes) throws Exception {
        CommonResult<String> commonResult = this.orgService.deleteOrg(codes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"org/updateOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7", httpMethod="POST", notes="\u4fee\u6539\u7ec4\u7ec7")
    @UpdateMethod(type=OrgVo.class)
    public CommonResult<String> updateOrg(@ApiParam(name="orgVo", value="\u7ec4\u7ec7\u89c6\u56fe", required=true) @RequestBody OrgVo orgVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.updateOrg(orgVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"org/getOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7")
    public CommonResult<Org> getOrg(@ApiParam(name="code", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgCode", code);
        map.put("group", "true");
        List list = this.orgUserDao.getUserNumByOrgCode(map);
        Org org = this.orgService.getOrg(code);
        org.setNowNum(list.size());
        return CommonResult.ok().value((Object)org);
    }

    @RequestMapping(value={"org/getOrgLimitByCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u9650\u7f16", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u9650\u7f16")
    public CommonResult<PageList<Org>> getOrgLimitByCodes(@ApiParam(name="codes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String codes) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("code", (Object)codes, QueryOP.IN, FieldRelation.AND, "group_1");
        PageList query = this.orgService.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)query) && BeanUtils.isNotEmpty((Object)query.getRows())) {
            for (Org org : query.getRows()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List list = this.orgUserDao.getUserNumByOrgCode(map);
                org.setNowNum(list.size());
            }
        }
        return CommonResult.ok().value((Object)query);
    }

    @RequestMapping(value={"org/get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7")
    public CommonResult<Org> get(@ApiParam(name="id", value="\u7ec4\u7ec7id", required=true) @RequestParam String id) throws Exception {
        Org org = (Org)this.orgService.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)org)) {
            org = this.orgService.getByCode(id);
        }
        return CommonResult.ok().value((Object)org);
    }

    @RequestMapping(value={"org/getOrgMaster"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7528\u6237\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u5f53\u524d\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public CommonResult<Org> getOrgMaster() throws Exception {
        Org org = this.orgService.getOrgMaster(ContextUtil.getCurrentUser().getAccount());
        return CommonResult.ok().value((Object)org);
    }

    @RequestMapping(value={"orgParam/saveOrgParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570", httpMethod="POST", notes="\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570\uff0c\u53c2\u6570params\u683c\u5f0f[{\"alias\":\"a1\",\"value\":\"v1\"},{\"alias\":\"a2\",\"value\":\"v2\"}]")
    public CommonResult<String> saveOrgParams(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="params", value="\u53c2\u6570\u503c", required=true) @RequestBody List<ObjectNode> params) throws Exception {
        CommonResult<String> commonResult = this.orgService.saveOrgParams(orgCode, params);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgParam/getOrgParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public CommonResult<List<OrgParams>> getOrgParams(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        List<OrgParams> orgParamsList = this.orgService.getOrgParams(orgCode);
        return CommonResult.ok().value(orgParamsList);
    }

    @RequestMapping(value={"orgParam/getParamByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u548c\u53c2\u6570\u522b\u540d\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public CommonResult<OrgParams> getParamByAlias(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        CommonResult<OrgParams> commonResult = this.orgService.getParamByAlias(orgCode, alias);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgUser/addOrgUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u5165\u7528\u6237", httpMethod="POST", notes="\u5411\u7ec4\u7ec7\u4e2d\u52a0\u5165\u7cfb\u7edf\u5df2\u6709\u7684\u7528\u6237")
    public CommonResult<String> addOrgUser(@ApiParam(name="orgUserVo", value="\u7ec4\u7ec7\u7528\u6237", required=true) @RequestBody OrgUserVo orgUserVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.addOrgUser(orgUserVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgUser/addOrgUserByCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u662f\u7ed9\u7528\u6237\u8bbe\u7f6e\u7ec4\u7ec7", httpMethod="POST", notes="\u65b0\u589e\u7528\u6237\u662f\u7ed9\u7528\u6237\u8bbe\u7f6e\u7ec4\u7ec7")
    public CommonResult<String> addOrgUserByCode(@ApiParam(name="account", value="\u7ec4\u7ec7\u7528\u6237", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        String[] orgCodes;
        for (String code : orgCodes = orgCode.split(",")) {
            OrgUserVo orgUserVo = new OrgUserVo();
            orgUserVo.setAccount(account);
            orgUserVo.setOrgCode(code);
            this.orgService.addOrgUser(orgUserVo);
        }
        return CommonResult.ok().message("\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgUser/delOrgUser"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u53d6\u6d88\u52a0\u5165\u7ec4\u7ec7", httpMethod="DELETE", notes="\u7528\u6237\u53d6\u6d88\u52a0\u5165\u7ec4\u7ec7\uff0cids\u4e3a\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbid\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delOrgUser(@ApiParam(name="ids", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbid\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        CommonResult<String> commonResult = this.orgService.delOrgUserByUserIds(ids);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgUser/getUserIsMaster"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u4e3b\u7ec4\u7ec7")
    public CommonResult<Boolean> getUserIsMaster(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String demCode) throws Exception {
        CommonResult<Boolean> commonResult = this.orgService.getUserIsMaster(account, demCode);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/setMaster"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMaster(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        CommonResult<String> commonResult = this.orgService.setMaster(account, postCode);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/getTreeDataByDem"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6811", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6811")
    public CommonResult<List<OrgTree>> getTreeDataByDem(@ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String demCode, @ApiParam(name="pOrgCode", value="\u7236\u7ec4\u7ec7\u7f16\u7801", required=false) @RequestParam(required=false) String pOrgCode) throws Exception {
        List<OrgTree> orgTreeList = this.orgService.getTreeDataByDem(demCode, pOrgCode);
        return CommonResult.ok().value(orgTreeList);
    }

    @RequestMapping(value={"orgUser/setOrgCharge"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\uff08\u53d6\u6d88\uff09\uff08\u4e3b\uff09\u8d1f\u8d23\u4eba", httpMethod="PUT", notes="isCharge\u4e3atrue\u8868\u793a\u8bbe\u7f6e\u4e3b\u8d1f\u8d23\u4eba\uff0c\u4e3afalse\u65f6\uff0c\u82e5\u6b64\u65f6\u4e3a\u8d1f\u8d23\u4eba\uff0c\u5219\u964d\u4e3a\u975e\u8d1f\u8d23\u4eba")
    public CommonResult<String> setOrgCharge(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="isCharge", value="\u662f\u5426\u8bbe\u7f6e\u4e3b\u8d1f\u8d23\u4eba", required=true) @RequestParam Boolean isCharge) throws Exception {
        CommonResult<String> commonResult = this.orgService.setOrgCharge(account, orgCode, isCharge);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userUnder/addUserUnders"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u4eba\u5458\u6dfb\u52a0\u4e0b\u5c5e", httpMethod="POST", notes="\u7ec4\u7ec7\u4eba\u5458\u6dfb\u52a0\u4e0b\u5c5e")
    public CommonResult<String> addUserUnders(@ApiParam(name="userUnder", value="\u4e0b\u5c5e\u7528\u6237", required=true) @RequestBody UserUnderVo userUnder) throws Exception {
        CommonResult<String> commonResult = this.orgService.addUserUnders(userUnder);
        return commonResult;
    }

    @RequestMapping(value={"userUnder/delUserUnders"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u4eba\u5458\u5220\u9664\u4e0b\u5c5e", httpMethod="DELETE", notes="\u7ec4\u7ec7\u4eba\u5458\u5220\u9664\u4e0b\u5c5e")
    public CommonResult<String> delUserUnders(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        CommonResult<String> commonResult = this.orgService.delUserUnders(account, orgCode);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userUnder/getUserUnders"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e")
    public CommonResult<List<UserVo>> getUserUnders(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        List<UserVo> userVoList = this.orgService.getUserUnders(account, orgCode);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"userUnder/getUserUndersPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e(\u542b\u5206\u9875)", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5728\u67d0\u7ec4\u7ec7\u4e0b\u7684\u4e0b\u5c5e(\u542b\u5206\u9875)", hidden=true)
    public CommonResult<PageList<UserUnder>> getUserUndersPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        Page list = (Page)this.userUnderService.getUserUnder(filter);
        PageList userUnderPageList = new PageList((IPage)list);
        return CommonResult.ok().value((Object)userUnderPageList);
    }

    @RequestMapping(value={"userUnder/delUnderUserByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u4e0b\u5c5e", httpMethod="DELETE", notes="\u6839\u636eid\u5220\u9664\u4e0b\u5c5e\uff0c\u591a\u4e2a\u7528\u6237\u9017\u53f7\u9694\u5f00", hidden=true)
    public CommonResult<String> delUnderUserByIds(@ApiParam(name="ids", value="\u8bb0\u5f55id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        String[] idArr = ids.split(",");
        this.userUnderService.removeByIds(idArr);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgAuth/saveOrgAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406", httpMethod="POST", notes="\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406")
    public CommonResult<String> saveOrgAuth(@ApiParam(name="orgAuthVo", value="\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406", required=true) @RequestBody OrgAuthVo orgAuthVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.saveOrgAuth(orgAuthVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgAuth/deleteOrgAuth"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5206\u7ea7\u7ba1\u7406", httpMethod="DELETE", notes="\u5220\u9664\u5206\u7ea7\u7ba1\u7406")
    public CommonResult<String> deleteOrgAuth(@ApiParam(name="id", value="\u5206\u7ea7\u7ba1\u7406id", required=true) @RequestParam String id) throws Exception {
        CommonResult<String> commonResult = this.orgService.deleteOrgAuth(id);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgAuths/getOrgAuthList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u5217\u8868")
    public CommonResult<PageList<OrgAuth>> getOrgAuthList(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false) @RequestParam(required=false) String orgCode, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode) throws Exception {
        Page<OrgAuth> list = this.orgService.getOrgAuthList(account, orgCode, demCode);
        PageList orgAuthPageList = new PageList(list);
        return CommonResult.ok().value((Object)orgAuthPageList);
    }

    @RequestMapping(value={"orgAuth/getOrgAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406")
    public CommonResult<OrgAuth> getOrgAuth(@ApiParam(name="id", value="\u5206\u7ea7\u7ba1\u7406id", required=true) @RequestParam String id) throws Exception {
        OrgAuth orgAuth = this.orgService.getOrgAuth(id);
        return CommonResult.ok().value((Object)orgAuth);
    }

    @RequestMapping(value={"orgs/getByParentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7", httpMethod="GET", notes="\u6839\u636e\u7236\u7ec4\u7ec7id\u83b7\u53d6\u5b50\u7ec4\u7ec7")
    public CommonResult<List<Org>> getByParentId(@ApiParam(name="parentId", value="\u7236\u7ec4\u7ec7id", required=true) @RequestParam String parentId) throws Exception {
        if (BeanUtils.isEmpty((Object)this.orgService.get((Serializable)((Object)parentId)))) {
            throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7id\u3010" + parentId + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        List<Org> orgList = this.orgService.getByParentId(parentId);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgs/getOrgsByparentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7(\u53ea\u83b7\u53d6\u5e95\u4e0b\u4e00\u5c42\u5b50\u7ec4\u7ec7)", httpMethod="GET", notes="\u6839\u636e\u7236\u7ec4\u7ec7id\u83b7\u53d6\u5b50\u7ec4\u7ec7")
    public CommonResult<List<Org>> getOrgsByparentId(@ApiParam(name="parentId", value="\u7236\u7ec4\u7ec7id", required=false) @RequestParam(required=false) String parentId) throws Exception {
        List<Org> orgList = this.orgService.getOrgsByparentId(parentId);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgs/getUserOrgs"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\uff08\u4e3b\uff09\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\uff08\u4e3b\uff09\u7ec4\u7ec7")
    public CommonResult<List<Org>> getUserOrgs(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u7ec4\u7ec7", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        List<Org> orgList = this.orgService.getUserOrgs(account, demCode, isMain);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgs/getOrgsByAccount"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public CommonResult<List<Org>> getOrgsByAccount(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account) throws Exception {
        List<Org> orgList = this.orgService.getOrgsByAccount(account);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgs/getOrgListByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public CommonResult<List<Org>> getOrgListByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        List<Org> orgList = this.orgService.getOrgListByUserId(userId);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgs/getUserOrgPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7")
    public CommonResult<PageList<HashMap<String, Object>>> getUserOrgPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter) throws Exception {
        IPage p = this.orgUserService.getUserOrgPage(filter);
        PageList pageList = new PageList(p);
        return CommonResult.ok().value((Object)pageList);
    }

    @RequestMapping(value={"orgUsers/getUsersByOrgCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u4eba\u5458", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u4eba\u5458\uff0corgCodes\u7ec4\u7ec7\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<List<UserVo>> getUsersByOrgCodes(@ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCodes, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u5c97\u4f4d", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        List<UserVo> userVoList = this.orgService.getUsersByOrgCodes(orgCodes, isMain);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"orgUsers/getChargesByOrgId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u7684\u8d1f\u8d23\u4eba\u7ec4\u7ec7\u5173\u7cfb", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u7ec4\u7ec7\u7684\u8d1f\u8d23\u4eba\u7ec4\u7ec7\u5173\u7cfb")
    public CommonResult<List<User>> getChargesByOrgId(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u7ec4\u7ec7", required=false) @RequestParam(required=false) Boolean isMain, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801\uff08\u4e0d\u4f20\u5219\u4e3a\u9ed8\u8ba4\u7ef4\u5ea6\uff09", required=false) @RequestParam(required=false) Boolean demCode) throws Exception {
        List<User> userList = this.orgService.getChargesByOrgId(orgId, isMain, demCode);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"orgPosts/getPostsByOrgCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u5c97\u4f4d\uff0corgCodes\u7ec4\u7ec7\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<List<OrgPost>> getPostsByOrgCodes(@ApiParam(name="orgCodes", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCodes, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u5c97\u4f4d", required=false) @RequestParam(required=false) Boolean isMain) throws Exception {
        List<OrgPost> orgPostList = this.orgService.getPostsByOrgCodes(orgCodes, isMain);
        return CommonResult.ok().value(orgPostList);
    }

    @RequestMapping(value={"orgPosts/getOrgPostPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5c97\u4f4d\u5217\u8868\uff08\u5206\u9875\uff09")
    public CommonResult<PageList<OrgPost>> getOrgPostPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        String postAuthSql = AuthFilterUtil.getPostAuthSql();
        if (StringUtil.isNotEmpty((String)postAuthSql)) {
            queryFilter.addParams("authSql", (Object)postAuthSql);
        }
        PageList<OrgPost> pageList = this.postService.getOrgPost(queryFilter);
        return CommonResult.ok().value(pageList);
    }

    @RequestMapping(value={"orgs/getByLevel"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u7ea7\u522b\u83b7\u53d6\u7ec4\u7ec7", httpMethod="GET", notes=" \u6839\u636e\u7ea7\u522b\u83b7\u53d6\u7ec4\u7ec7")
    public CommonResult<List<Org>> getByLevel(@ApiParam(name="level", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam String level, @ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=false) @RequestParam(required=false) String demCode) throws Exception {
        List<Org> orgList = this.orgService.getByLevel(level, demCode);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"userPost/saveUserPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d", httpMethod="POST", notes=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d\uff0caccounts\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> saveUserPost(@ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        CommonResult<String> commonResult = this.orgService.saveUserPost(accounts, postCode);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userPost/saveUserPosts"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d", httpMethod="POST", notes=" \u7528\u6237\u52a0\u5165\u5230\u5c97\u4f4d\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> saveUserPosts(@ApiParam(name="account", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="postCodes", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCodes) throws Exception {
        CommonResult<String> commonResult = this.orgService.saveUserPosts(account, postCodes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userPost/delUserPost"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7528\u6237\u9000\u51fa\u5c97\u4f4d", httpMethod="DELETE", notes=" \u7528\u6237\u9000\u51fa\u5c97\u4f4d\uff0caccounts\u7528\u6237\u5e10\u53f7\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delUserPost(@ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts, @ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode) throws Exception {
        CommonResult<String> commonResult = this.orgService.delUserPost(accounts, postCode);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/saveOrgPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7ec4\u7ec7\u6dfb\u52a0\u5c97\u4f4d", httpMethod="POST", notes=" \u7ec4\u7ec7\u6dfb\u52a0\u5c97\u4f4d")
    public CommonResult<String> saveOrgPost(@ApiParam(name="orgPostVo", value="\u7ec4\u7ec7\u5c97\u4f4d", required=true) @RequestBody OrgPostVo orgPostVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.saveOrgPost(orgPostVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/updateOrgPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u5c97\u4f4d", httpMethod="POST", notes="\u66f4\u65b0\u5c97\u4f4d")
    public CommonResult<String> updateOrgPost(@ApiParam(name="orgPostVo", value="\u7ec4\u7ec7\u5c97\u4f4d", required=true) @RequestBody OrgPostVo orgPostVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.updateOrgPost(orgPostVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/getOrgPost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u5c97\u4f4did\u6216\u7f16\u7801\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f", httpMethod="GET", notes=" \u6839\u636e\u5c97\u4f4d\u7f16\u7801\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f")
    public CommonResult<OrgPost> getOrgPost(@ApiParam(name="postCode", value="\u5c97\u4f4d\u4ee3\u7801", required=true) @RequestParam String postCode) throws Exception {
        OrgPost p = this.postService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)p)) {
            p = (OrgPost)this.postService.get((Serializable)((Object)postCode));
        }
        return CommonResult.ok().message("\u83b7\u53d6\u5c97\u4f4d\u6210\u529f").value((Object)p);
    }

    @RequestMapping(value={"orgPost/getOrgPostByUserAccount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u6240\u5c5e\u5c97\u4f4d", httpMethod="GET", notes=" \u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u6240\u5c5e\u5c97\u4f4d")
    public CommonResult<List<OrgPost>> getOrgPostByUserAccount(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        List<OrgPost> list = this.postService.getListByAccount(account, null);
        return CommonResult.ok().value(list);
    }

    @RequestMapping(value={"orgPost/deleteOrgPost"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u5c97\u4f4d", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u5c97\u4f4d\uff0c\u8fde\u540c\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458\u4fe1\u606f\u4e00\u8d77\u5220\u9664\uff0cpostCodes\u5c97\u4f4d\u7f16\u7801\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> deleteOrgPost(@ApiParam(name="postCodes", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCodes) throws Exception {
        CommonResult<String> commonResult = this.orgService.deleteOrgPost(postCodes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/setPostMaster"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u8bbe\u7f6e\u7ec4\u7ec7\uff08\u53d6\u6d88\uff09\u8d23\u4efb\u5c97\u4f4d", httpMethod="PUT", notes=" \u8bbe\u7f6e\u7ec4\u7ec7\uff08\u53d6\u6d88\uff09\u8d23\u4efb\u5c97\u4f4d")
    public CommonResult<String> setPostMaster(@ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode, @ApiParam(name="isMain", value="\u662f\u5426\u8d23\u4efb\u5c97\u4f4d", required=true) @RequestParam Boolean isMain) throws Exception {
        CommonResult<String> commonResult = this.orgService.setPostMaster(postCode, isMain);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userPost/setUserPostDueTime"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u8bbe\u7f6e\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f", httpMethod="PUT", notes=" \u8bbe\u7f6e\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f")
    public CommonResult<String> setUserPostDueTime(@ApiParam(name="postDueVo", value="\u4eba\u5458\u5c97\u4f4d\u6709\u6548\u671f", required=true) @RequestBody PostDueVo postDueVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.setUserPostDueTime(postDueVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userPost/validOrgUser"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u6821\u9a8c\u6240\u6709\u7528\u6237\u5c97\u4f4d\u662f\u5426\u6709\u6548", httpMethod="PUT", notes=" \u6821\u9a8c\u6240\u6709\u7528\u6237\u5c97\u4f4d\u662f\u5426\u6709\u6548")
    public CommonResult<String> validOrgUser() throws Exception {
        CommonResult<String> commonResult = this.orgService.validOrgUser();
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgRole/addOrgRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u7ec4\u7ec7\u6dfb\u52a0\u89d2\u8272", httpMethod="POST", notes=" \u7ec4\u7ec7\u6dfb\u52a0\u89d2\u8272")
    public CommonResult<String> addOrgRole(@ApiParam(name="orgRoleVo", value="\u7ec4\u7ec7\u89d2\u8272", required=true) @RequestBody OrgRoleVo orgRoleVo) throws Exception {
        this.orgService.addOrgRole(orgRoleVo);
        return CommonResult.ok().message("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgRole/delOrgRoleByCode"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u6307\u5b9a\u89d2\u8272", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u6307\u5b9a\u89d2\u8272\uff0croleCodes\u89d2\u8272\u7f16\u7801\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00")
    public CommonResult<String> delOrgRoleByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="roleCodes", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String roleCodes) throws Exception {
        this.orgService.delOrgRoleByCode(orgCode, roleCodes);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgRole/delAllOrgRole"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u5220\u9664\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272", httpMethod="DELETE", notes=" \u5220\u9664\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272")
    public CommonResult<String> delAllOrgRole(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        this.orgService.delAllOrgRole(orgCode);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgRoles/getOrgRoleByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u83b7\u53d6\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272", httpMethod="GET", notes=" \u83b7\u53d6\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u89d2\u8272\uff0c\u82e5\u81ea\u8eab\u6709\u89d2\u8272\u5219\u8fd4\u56de\u81ea\u8eab\u7684\u89d2\u8272\uff0c\u82e5\u81ea\u8eab\u6ca1\u6709\u89d2\u8272\uff0c\u5219\u8fd4\u56de\u6700\u8fd1\u7684\u7236\u7ec4\u7ec7\u6240\u62e5\u6709\u7684\u53ef\u7ee7\u627f\u7684\u89d2\u8272")
    public CommonResult<List<Role>> getOrgRoleByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        List<Role> roleList = this.orgService.getOrgRoleByCode(orgCode);
        return CommonResult.ok().value(roleList);
    }

    @RequestMapping(value={"org/deleteOrgPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u6570\u636e")
    public CommonResult<Integer> deleteOrgPhysical() throws Exception {
        Integer num = this.orgService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"org/deletePostPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5c97\u4f4d\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5c97\u4f4d\u6570\u636e")
    public CommonResult<Integer> deletePostPhysical() throws Exception {
        Integer num = this.orgService.removePostPhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"org/deleteOrgUserPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e")
    public CommonResult<Integer> deleteOrgUserPhysical() throws Exception {
        Integer num = this.orgService.removeOrgUserPhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/getByParentAndDem"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6id  \u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ef4\u5ea6id\u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7\uff0c\u53c2\u6570{\"demId\":\"1\",\"parentId\":\"1\"}")
    public CommonResult<List<OrgTree>> getByParentAndDem(@ApiParam(name="params", value="\u53c2\u6570\u503c") @RequestBody OrgTreeVo params) throws Exception {
        List<OrgTree> orgTreeList = this.orgService.getOrgTreeByParentAndDem(params);
        return CommonResult.ok().value(orgTreeList);
    }

    @GetMapping(value={"orgs/children/{orgId}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6orgId\u7684\u4e0b\u7ea7\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6orgId\u7684\u4e0b\u7ea7\u7ec4\u7ec7")
    public CommonResult<List<Org>> getByParentAndDem(@ApiParam(name="orgId", value="\u7ec4\u7ec7id") @PathVariable String orgId) throws Exception {
        QueryFilter filter = QueryFilter.build();
        filter.addParams("parentId", (Object)(" ('" + orgId + "') "));
        List<Org> list = this.orgService.getByParentAndDem(filter);
        return CommonResult.ok().value(list);
    }

    @RequestMapping(value={"orgs/getByParentAndDemToTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ef4\u5ea6id  \u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7", httpMethod="POST", notes="\u6839\u636e\u7ef4\u5ea6id\u83b7\u53d6\u5bf9\u5e94\u7ef4\u5ea6\u4e0b\u7684\u7ec4\u7ec7\uff0c\u53c2\u6570{\"demId\":\"1\",\"parentId\":\"1\"}")
    public CommonResult<List<OrgTree>> getByParentAndDemToTree(@ApiParam(name="params", value="\u53c2\u6570\u503c") @RequestBody OrgTreeVo params) throws Exception {
        List<OrgTree> orgTreeList = this.orgService.getByParentAndDemToTree(params);
        return CommonResult.ok().value(orgTreeList);
    }

    @RequestMapping(value={"orgUsers/getOrgUserPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u4eba\u5458\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u4eba\u5458\u5217\u8868")
    public CommonResult<PageList<HashMap<String, Object>>> getOrgUserPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<HashMap<String, Object>> pageList = this.orgService.getOrgUserPage(queryFilter);
        return CommonResult.ok().value(pageList);
    }

    @RequestMapping(value={"orgPost/setMasterById"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u901a\u8fc7id\uff0c\u8bbe\u7f6e\u4eba\u5458\uff08\u53d6\u6d88\uff09\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMasterById(String ... id) throws Exception {
        this.orgUserService.setMaster(id);
        return CommonResult.ok().message("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgPost/setMasterByIds"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4eba\u5458\u4e3b\u5c97\u4f4d", httpMethod="PUT", notes="\u901a\u8fc7id\uff0c\u8bbe\u7f6e\u4eba\u5458\u4e3b\u5c97\u4f4d")
    public CommonResult<String> setMasterByIds(String ... ids) throws Exception {
        this.orgUserService.setMasterByIds(ids);
        return CommonResult.ok().message("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"orgUsers/setUnderUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u6279\u91cf\u6dfb\u52a0\u4e0b\u5c5e", httpMethod="POST", notes="\u7528\u6237\u6279\u91cf\u6dfb\u52a0\u4e0b\u5c5e", hidden=true)
    public CommonResult<String> setUnderUsers(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId, @ApiParam(name="account", value="\u4e0a\u7ea7\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String account, @ApiParam(name="underAccounts", value="\u4e0b\u7ea7\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String underAccounts) throws Exception {
        CommonResult<String> commonResult = this.orgService.setUnderUsers(orgId, account, underAccounts);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgUsers/addUsersForOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ec4\u7ec7\u6279\u91cf\u52a0\u5165\u7528\u6237", httpMethod="POST", notes="\u7ec4\u7ec7\u6279\u91cf\u52a0\u5165\u7528\u6237", hidden=true)
    public CommonResult<String> addUsersForOrg(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="accounts", value="\u7528\u6237\u5e10\u53f7", required=true) @RequestParam String accounts) throws Exception {
        CommonResult<String> commonResult = this.orgService.addUsersForOrg(orgCode, accounts);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/getOrgByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<Org>> getOrgByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<Org> orgList = this.orgService.getOrgByTime(exportObject);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgParams/getOrgParamByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<OrgParams>> getOrgParamByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<OrgParams> orgParamsList = this.orgService.getOrgParamByTime(exportObject);
        return CommonResult.ok().value(orgParamsList);
    }

    @RequestMapping(value={"orgPosts/getOrgPostByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<OrgPost>> getOrgPostByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<OrgPost> orgPostList = this.orgService.getOrgPostByTime(exportObject);
        return CommonResult.ok().value(orgPostList);
    }

    @RequestMapping(value={"orgRoles/getOrgRoleByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<OrgRole>> getOrgRoleByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<OrgRole> orgRoleList = this.orgService.getOrgRoleByTime(exportObject);
        return CommonResult.ok().value(orgRoleList);
    }

    @RequestMapping(value={"orgUsers/getOrgUserByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<OrgUser>> getOrgUserByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<OrgUser> orgUserList = this.orgService.getOrgUserByTime(exportObject);
        return CommonResult.ok().value(orgUserList);
    }

    @RequestMapping(value={"userUnders/getUserUnderByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u4e2d\u4e0b\u5c5e\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7ec4\u7ec7\u4e2d\u4e0b\u5c5e\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<UserUnder>> getUserUnderByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        List<UserUnder> userUnderList = this.orgService.getUserUnderByTime(exportObject);
        return CommonResult.ok().value(userUnderList);
    }

    @RequestMapping(value={"org/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7ec4\u7ec7\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7ec4\u7ec7\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        CommonResult<Boolean> commonResult = this.orgService.isCodeExist(code);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgPost/isPostCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u5c97\u4f4d\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u5c97\u4f4d\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isPostCodeExist(@ApiParam(name="code", value="\u5c97\u4f4d\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        CommonResult<Boolean> commonResult = this.orgService.isPostCodeExist(code);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/oaAsync"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u540c\u6b65OA\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e", httpMethod="POST", notes="\u540c\u6b65OA\u7ec4\u7ec7\u5c97\u4f4d\u6570\u636e")
    public CommonResult<String> oaAsync(@ApiParam(name="oaAsyncObject", value="\u540c\u6b65\u53c2\u6570", required=true) @RequestBody OaAsyncObject oaAsyncObject, HttpServletRequest request) throws Exception {
        String ip = OrgUtil.getIpAddress(request);
        CommonResult<String> commonResult = this.userImportService.syncSoap(oaAsyncObject, ip);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgRoles/getOrgRoleList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09")
    public CommonResult<PageList<OrgRole>> getOrgRoleList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList list = this.orgRoleService.query(queryFilter);
        return CommonResult.ok().value((Object)list);
    }

    @RequestMapping(value={"orgRoles/saveOrgRole"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f")
    public CommonResult<String> saveOrgRole(@ApiParam(name="vo", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody OrgRoleVo vo) throws Exception {
        CommonResult<String> commonResult = this.orgService.addOrgRole(vo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgRoles/removeOrgRole"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u4fdd\u5b58\u7ec4\u7ec7\u89d2\u8272\u4fe1\u606f")
    public CommonResult<String> removeOrgRole(@ApiParam(name="code", value="\u5c97\u4f4d\u7f16\u7801") @RequestParam(required=true) String id) throws Exception {
        CommonResult<String> commonResult = this.orgService.delOrgRoleById(id);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/updateOrgPos"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7\u6240\u5728\u6811\u7684\u4f4d\u7f6e", httpMethod="POST", notes="\u66f4\u65b0\u7ec4\u7ec7\u6240\u5728\u6811\u7684\u4f4d\u7f6e\uff08\u6811\u7ed3\u6784\u62d6\u52a8\u4fdd\u5b58\uff09")
    public CommonResult<String> updateOrgPos(@ApiParam(name="orgId", value="\u79fb\u52a8\u8282\u70b9id", required=true) @RequestParam String orgId, @ApiParam(name="parentId", value="\u79fb\u81f3\uff08\u76ee\u6807\uff09\u8282\u70b9id", required=true) @RequestParam String parentId) throws Exception {
        CommonResult<String> commonResult = this.orgService.updateOrgPos(orgId, parentId);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgs/exportUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e")
    public void exportUsers(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="isChildre", value="\u662f\u5426\u5305\u542b\u5b50\u7ec4\u7ec7\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam Boolean isChildre) throws Exception {
        File file;
        String excelPath;
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        String path = this.orgService.exportData(orgCode, isChildre = Boolean.valueOf(BeanUtils.isEmpty((Object)isChildre) ? true : isChildre));
        if (StringUtil.isNotEmpty((String)path)) {
            excelPath = path + ".xls";
            file = new File(excelPath);
            if (!file.exists()) {
                throw new RuntimeException("\u751f\u6210Excel\u6587\u4ef6\u5931\u8d25\uff01");
            }
        } else {
            throw new RuntimeException("\u5bfc\u51fa\u7ec4\u7ec7\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String excelName = file.getName();
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)excelPath, (String)excelName);
        FileUtil.deleteFile((String)file.getParentFile().getPath());
    }

    @RequestMapping(value={"org/getMainGroup"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public CommonResult<Org> getMainGroup(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam Optional<String> demId) throws Exception {
        Org org = this.orgService.getMainGroup(userId, demId.orElse(""));
        return CommonResult.ok().value((Object)org);
    }

    @RequestMapping(value={"org/getParentMainOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff08\u5305\u542b\u7236\u7ea7\u7ec4\u7ec7\uff09", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff08\u5305\u542b\u7236\u7ea7\u7ec4\u7ec7\uff09")
    public CommonResult<Map<String, Org>> getParentMainOrg(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        Map<String, Org> stringOrgMap = this.orgService.getParentMainOrg(userId);
        return CommonResult.ok().value(stringOrgMap);
    }

    @RequestMapping(value={"orgJobs/getJobsByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1")
    public CommonResult<List<OrgJob>> getJobsByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        List<OrgJob> orgJobList = this.orgJobManager.getListByUserId(userId);
        return CommonResult.ok().value(orgJobList);
    }

    @RequestMapping(value={"org/isSupOrgByCurrMain"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u5f53\u524d\u7528\u6237\u4e3b\u90e8\u95e8\u662f\u5426\u6709\u4e0a\u7ea7 ", httpMethod="GET", notes="\u5224\u65ad\u5f53\u524d\u7528\u6237\u4e3b\u90e8\u95e8\u662f\u5426\u6709\u4e0a\u7ea7 ")
    public CommonResult<Boolean> isSupOrgByCurrMain(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId, @ApiParam(name="level", value="\u7ea7\u522b", required=true) @RequestParam Integer level) throws Exception {
        Boolean flag = this.orgService.isSupOrgByCurrMain(userId, demId, level);
        return CommonResult.ok().value((Object)flag);
    }

    @RequestMapping(value={"org/getSupOrgByCurrMain"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u7ec4\u7ec7\u5173\u7cfb", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u7ec4\u7ec7\u5173\u7cfb")
    public CommonResult<OrgUser> getSupOrgByCurrMain(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId) throws Exception {
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(userId, demId);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            OrgUser orgUser = orgUsers.get(0);
            return CommonResult.ok().value((Object)orgUser);
        }
        return CommonResult.ok().message("\u8be5\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u7ec4\u7ec7\u5173\u7cfb\u6682\u65e0\uff01");
    }

    @RequestMapping(value={"org/getMainPostOrOrgByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u3001\u4e3b\u7ec4\u7ec7(\u4f18\u5148\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u7684\uff0c\u6ca1\u6709\u65f6\u83b7\u53d6\u5176\u4ed6\u7ef4\u5ea6\u7684)", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u4e3b\u5c97\u4f4d\u3001\u4e3b\u7ec4\u7ec7(\u4f18\u5148\u83b7\u53d6\u9ed8\u8ba4\u7ef4\u5ea6\u7684\uff0c\u6ca1\u6709\u65f6\u83b7\u53d6\u5176\u4ed6\u7ef4\u5ea6\u7684)")
    public CommonResult<OrgUser> getMainPostOrOrgByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        OrgUser orgUser = this.orgUserService.getMainPostOrOrgByUserId(userId);
        return CommonResult.ok().value((Object)orgUser);
    }

    @RequestMapping(value={"/orgusers/getCustomLevelCharge"}, method={RequestMethod.GET})
    public CommonResult<List<User>> getCustomLevelCharge(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="isMainCharge", required=true) boolean isMainCharge) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        List<Object> chargesByOrg = new ArrayList();
        if (BeanUtils.isEmpty(userOrg)) {
            return CommonResult.ok().value(chargesByOrg);
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getChargesByOrg(org.getCode(), isMainCharge);
            break;
        }
        return CommonResult.ok().value(chargesByOrg);
    }

    @RequestMapping(value={"/orgusers/getCustomLevelPost"}, method={RequestMethod.GET})
    public CommonResult<Set<GroupIdentity>> getCustomLevelPost(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="postCode", required=true) String postCode) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        Set<Object> chargesByOrg = new HashSet();
        if (BeanUtils.isEmpty(userOrg)) {
            return CommonResult.ok().value(chargesByOrg);
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByPostCodeAndOrgCode(postCode, org.getCode());
            break;
        }
        return CommonResult.ok().value(chargesByOrg);
    }

    @RequestMapping(value={"/orgusers/getCustomLevelJob"}, method={RequestMethod.GET})
    public CommonResult<Set<GroupIdentity>> getCustomLevelJob(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="level", required=true) String level, @RequestParam(value="jobCode", required=true) String jobCode) throws Exception {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        Set<Object> chargesByOrg = new HashSet();
        if (BeanUtils.isEmpty(userOrg)) {
            return CommonResult.ok().value(chargesByOrg);
        }
        Org org = userOrg.get(0);
        while (!"0".equals(org.getParentId())) {
            String orgId = org.getParentId();
            if (!level.equals((org = (Org)this.orgService.get((Serializable)((Object)orgId))).getGrade())) continue;
            chargesByOrg = this.userService.getByJobCodeAndOrgCode(jobCode, org.getCode());
            break;
        }
        return CommonResult.ok().value(chargesByOrg);
    }

    @RequestMapping(value={"/orgusers/getStartOrgParam"}, method={RequestMethod.GET})
    public CommonResult<String> getStartOrgParam(@RequestParam(value="userId", required=true) String userId, @RequestParam(value="param", required=true) String param) {
        List<Org> userOrg = this.orgService.getUserOrg(userId, "", true);
        String paramValue = "";
        if (BeanUtils.isEmpty(userOrg)) {
            return CommonResult.ok().value((Object)paramValue);
        }
        Org org = userOrg.get(0);
        OrgParams byOrgIdAndAlias = this.orgParamsService.getByOrgIdAndAlias(org.getId(), param);
        String value = byOrgIdAndAlias.getValue();
        return CommonResult.ok().value((Object)paramValue);
    }

    @RequestMapping(value={"orgpost/getFullname"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u6240\u5728\u7684\u4eba\u5458\uff0c\u4e00\u822c\u53ea\u6709\u4e00\u4f4d", httpMethod="GET", notes="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u5c97\u4f4d\u6240\u5728\u7684\u4eba\u5458\uff0c\u4e00\u822c\u53ea\u6709\u4e00\u4f4d")
    public CommonResult<List<Map<String, Object>>> getFullname(@ApiParam(name="postId", value="\u5c97\u4f4did", required=true) @RequestParam String postId) throws Exception {
        List<Map<String, Object>> mapList = this.postService.getFullname(postId);
        return CommonResult.ok().value(mapList);
    }

    @RequestMapping(value={"orgpost/getPostByJobId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1id\u67e5\u8be2\u5c97\u4f4d\u4ee5\u53ca\u8fd9\u4e9b\u5c97\u4f4d\u6240\u5c5e\u7684\u7ec4\u7ec7\u5168\u8def\u5f84", httpMethod="GET", notes="\u6839\u636e\u804c\u4f4did\u67e5\u8be2\u5c97\u4f4d\u4ee5\u53ca\u8fd9\u4e9b\u5c97\u4f4d\u6240\u5c5e\u7684\u7ec4\u7ec7\u5168\u8def\u5f84")
    public CommonResult<List<Map<String, Object>>> getPostByJobId(@ApiParam(name="jobId", value="\u804c\u52a1id", required=true) @RequestParam String jobId) throws Exception {
        List<Map<String, Object>> mapList = this.postService.getPostByJobId(jobId);
        return CommonResult.ok().value(mapList);
    }

    @RequestMapping(value={"org/getPathNames"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u7ec4\u83b7\u53d6\u7ec4\u7ec7\u5168\u8def\u5f84", httpMethod="POST", notes="\u6839\u636e\u7528\u6237id\u83b7\u5f97\u4e3b\u5c97\u4f4d\u7684\u5c97\u4f4d\u7ec4")
    public CommonResult<List<Map<String, String>>> getPathNames(@ApiParam(name="userIds", value="\u7528\u6237id\u7ec4", required=false) @RequestParam List<String> userIds) throws Exception {
        List<Map<String, String>> mapList = this.orgService.getPathNames(userIds);
        return CommonResult.ok().value(mapList);
    }

    @RequestMapping(value={"org/getChildrenIds"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b50\u7ec4\u7ec7ID\uff08\u5305\u542b\u81ea\u5df1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5b50\u7ec4\u7ec7ID\uff08\u5305\u542b\u81ea\u5df1\uff09")
    public CommonResult<Map<String, Set<String>>> getChildrenIds(@ApiParam(name="ids", value="\u7ec4\u7ec7id", required=true) @RequestParam Map<String, String> ids) throws Exception {
        Map<String, Set<String>> childrenIds = this.orgService.getChildrenIds(ids);
        return CommonResult.ok().value(childrenIds);
    }

    @RequestMapping(value={"org/getOrgListByDemId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public CommonResult<List<Org>> getOrgListByDemId(@ApiParam(name="demId", value="\u7ef4\u5ea6id", required=true) @RequestParam String demId) throws Exception {
        List<Org> orgList = this.orgService.getOrgListByDemId(demId);
        return CommonResult.ok().value(orgList);
    }

    @RequestMapping(value={"orgusers/getUserOrgNowNumByOrgId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf")
    public CommonResult<Integer> getUserOrgNowNumByOrgId(@ApiParam(name="orgId", value="\u7ec4\u7ec7id", required=true) @RequestParam String orgId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("group", "true");
        List list = this.orgUserDao.getUserNumByOrgId(map);
        int size = list.size();
        return CommonResult.ok().value((Object)size);
    }

    @RequestMapping(value={"orgusers/getUserOrgNowNumByOrgIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7id\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u9762\u7684\u4eba\u5458\u6570\u91cf")
    public CommonResult<List<Map<String, Object>>> getUserOrgNowNumByOrgIds(@ApiParam(name="orgIds", value="\u7ec4\u7ec7id\u96c6\u5408", required=true) @RequestParam String orgIds) throws Exception {
        String[] value;
        ArrayList mapList = new ArrayList();
        for (String orgId : value = orgIds.split(",")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> numMap = new HashMap<String, Object>();
            map.put("orgId", orgId);
            map.put("group", "true");
            List list = this.orgUserDao.getUserNumByOrgId(map);
            numMap.put("orgId", orgId);
            numMap.put("num", list.size());
            mapList.add(numMap);
        }
        return CommonResult.ok().value(mapList);
    }

    @RequestMapping(value={"org/addOrgFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf", httpMethod="POST", notes="\u4ece\u7b2c\u4e09\u65b9\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u6dfb\u52a0\u5230\u672c\u7cfb\u7edf")
    public CommonResult<String> addOrgFromExterUni(@ApiParam(name="org", value="\u7ec4\u7ec7", required=true) @RequestBody Org orgVo) throws Exception {
        CommonResult<String> commonResult = this.orgService.addOrgFromExterUni(orgVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @Deprecated
    @RequestMapping(value={"org/getSuperiorPost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868")
    public CommonResult<Map<String, Object>> getSuperiorPost(@RequestParam(value="userId", required=true) String userId) {
        Map<String, Object> map = this.postService.getSuperiorPost(userId);
        return CommonResult.ok().value(map);
    }

    @RequestMapping(value={"org/getFillOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d")
    public CommonResult<Org> getFillOrg(@ApiParam(name="demId", value="\u7ef4\u5ea6Id", required=true) @RequestParam Optional<String> demId, @ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam Optional<String> grade) throws Exception {
        CommonResult<Org> commonResult = this.orgService.getFillOrg(demId.orElse(""), grade.orElse("2"));
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgParam/getParamById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u53c2\u6570", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7Id\u548c\u53c2\u6570\u522b\u540d\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570")
    public CommonResult<String> getParamById(@ApiParam(name="orgId", value="\u7ec4\u7ec7\u4ee3\u7801", required=true) @RequestParam String orgId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        String value = "";
        OrgParams params = this.orgService.getParamById(orgId, alias);
        if (BeanUtils.isNotEmpty((Object)params)) {
            value = params.getValue();
        }
        return CommonResult.ok().value((Object)value);
    }

    @RequestMapping(value={"orgParam/isOrgHasParamKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u5224\u65ad\u662f\u5426\u6709\u8be5\u53c2\u6570", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570")
    public CommonResult<Boolean> isOrgHasParamKey(@ApiParam(name="orgId", value="\u7ec4\u7ec7Id", required=true) @RequestParam String orgId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        boolean flag = this.orgService.isOrgHasParamKey(orgId, alias);
        return CommonResult.ok().value((Object)flag);
    }

    @RequestMapping(value={"orgParam/hasOrgParamKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570", httpMethod="GET", notes="\u5224\u65ad\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u662f\u5426\u6709\u8be5\u53c2\u6570")
    public CommonResult<Boolean> hasOrgParamKey(@ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b", required=true) @RequestParam String grade, @ApiParam(name="userId", value="\u7528\u6237Id", required=true) @RequestParam String userId, @ApiParam(name="alias", value="\u53c2\u6570\u4ee3\u7801", required=true) @RequestParam String alias) throws Exception {
        boolean flag = this.orgService.hasOrgParamKey(grade, userId, alias);
        return CommonResult.ok().value((Object)flag);
    }

    @RequestMapping(value={"org/getOrgsByIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7id\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public CommonResult<List<Org>> getOrgsByIds(@ApiParam(name="ids", value="\u7ec4\u7ec7ids") @RequestParam(required=true) String ids) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ID_", (Object)ids, QueryOP.IN);
        List orgs = this.orgService.queryNoPage(queryFilter);
        return CommonResult.ok().value((Object)orgs);
    }

    @RequestMapping(value={"org/getOrgsByCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7ec4\u7ec7code\u83b7\u53d6\u7ec4\u7ec7(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public CommonResult<List<Org>> getOrgsByCodes(@ApiParam(name="codes", value="\u7ec4\u7ec7codes") @RequestParam(required=true) String codes) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("CODE_", (Object)codes, QueryOP.IN);
        List orgs = this.orgService.queryNoPage(queryFilter);
        return CommonResult.ok().value((Object)orgs);
    }
}

