/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgJobRelationManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.params.org.OrgJobRelationVO;
import com.hotent.uc.params.org.OrgJobUserParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/orgJob/v1/"})
public class OrgJobController
extends BaseController<OrgJobManager, OrgJob> {
    @Resource
    OrgJobRelationManager orgJobRelationManager;
    @Resource
    OrgUserManager orgUserManager;

    @PostMapping(value={"orgJobs/queryJobs"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u52a1")
    public PageList<OrgJob> queryJobs(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u6761\u4ef6", required=true) @RequestBody QueryFilter<OrgJob> queryFilter) {
        return ((OrgJobManager)this.baseService).queryJobs(queryFilter);
    }

    @PostMapping(value={"orgJobs/job/user"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="", httpMethod="POST")
    public CommonResult<String> createOrgJobUser(@RequestBody @Valid OrgJobUserParam orgJobUserParam) {
        this.orgUserManager.createOrgJobUser(orgJobUserParam);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"orgJobs/relations"}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u804c\u52a1\u5173\u8054\u5173\u7cfb", httpMethod="POST")
    public CommonResult<String> createOrgJobRelation(@RequestBody @Valid OrgJobRelationVO orgJobRelationVO) {
        this.orgJobRelationManager.createOrgJobRelation(orgJobRelationVO);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f");
    }

    @DeleteMapping(value={"orgJobs/relation"}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u5173\u8054\u5173\u7cfb", httpMethod="DELETE")
    public CommonResult<String> removeOrgJobRelation(@RequestParam String orgId, String ... jobIds) {
        this.orgJobRelationManager.removeByJobIds(Arrays.asList(jobIds), orgId);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

