/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.manager.ParamsManager;
import com.hotent.uc.manager.TenantTypeManager;
import com.hotent.uc.manager.UserParamsManager;
import com.hotent.uc.model.OrgParams;
import com.hotent.uc.model.Params;
import com.hotent.uc.model.UserParams;
import com.hotent.uc.params.params.ParamVo;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/params/v2/"})
@Api(tags={"\u7528\u6237\u7ec4\u7ec7\u53c2\u65702"})
@ApiGroup(group={"group_uc"})
public class ParamsController2
extends BaseController2<ParamsManager, Params> {
    @Resource
    ParamsManager paramsService;
    @Resource
    UserParamsManager userParamsService;
    @Resource
    OrgParamsManager orgParamsService;
    @Resource
    TenantTypeManager tenantTypeManager;

    @RequestMapping(value={"params/getParamsPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53c2\u6570\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u53c2\u6570\u5217\u8868")
    public CommonResult<PageList<Params>> getParamsPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        boolean isTenant = false;
        List querys = filter.getQuerys();
        for (QueryField qfield : querys) {
            if (!"TYPE_".equals(qfield.getProperty()) || !"3".equals(qfield.getValue())) continue;
            isTenant = true;
            break;
        }
        filter.addFilter("is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        PageList query = isTenant ? this.paramsService.queryWithType(filter) : this.paramsService.query(filter);
        return CommonResult.ok().value((Object)query);
    }

    @RequestMapping(value={"userParams/getUserParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7684\u53c2\u6570\u5217\u8868")
    public CommonResult<List<Params>> getUserParams() throws Exception {
        List<Params> paramsList = this.paramsService.getByType("1");
        return CommonResult.ok().value(paramsList);
    }

    @RequestMapping(value={"orgParams/getOrgParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u7684\u53c2\u6570\u5217\u8868")
    public CommonResult<List<Params>> getOrgParams() throws Exception {
        List<Params> paramsList = this.paramsService.getByType("2");
        return CommonResult.ok().value(paramsList);
    }

    @RequestMapping(value={"param/addParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u53c2\u6570", httpMethod="POST", notes="\u6dfb\u52a0\u53c2\u6570")
    public CommonResult<String> addParams(@ApiParam(name="param", value="\u53c2\u6570\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ParamVo param) throws Exception {
        CommonResult<String> commonResult = this.paramsService.addParams(param);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"param/deleteParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u5220\u9664\u53c2\u6570", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u53c2\u6570")
    public CommonResult<String> deleteParams(@ApiParam(name="codes", value="\u53c2\u6570\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        CommonResult<String> commonResult = this.paramsService.deleteParams(codes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"param/deleteParamsByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570id\u5220\u9664\u53c2\u6570", httpMethod="DELETE", notes="\u6839\u636eid\u5220\u9664\u53c2\u6570")
    public CommonResult<String> deleteParamsByIds(@ApiParam(name="ids", value="\u53c2\u6570id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        CommonResult<String> commonResult = this.paramsService.deleteParamsByIds(ids);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"param/updateParams"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u53c2\u6570\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0", httpMethod="PUT", notes="\u66f4\u65b0\u53c2\u6570\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u4e88\u66f4\u65b0")
    @UpdateMethod(type=ParamVo.class)
    public CommonResult<String> updateParams(@ApiParam(name="param", value="\u53c2\u6570\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody ParamVo param) throws Exception {
        CommonResult<String> commonResult = this.paramsService.updateParams(param);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"param/getParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u3001\u79df\u6237\u7c7b\u578b\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u53c2\u6570\u4fe1\u606f")
    public CommonResult<Params> getParams(@ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code, @ApiParam(name="tenantTypeId", value="\u79df\u6237\u7c7b\u578b", required=true) @RequestParam String tenantTypeId) throws Exception {
        Params params = this.paramsService.getByTeam(code, tenantTypeId);
        return CommonResult.ok().value((Object)params);
    }

    @RequestMapping(value={"param/getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53c2\u6570\u7f16\u7801\u83b7\u53d6\u53c2\u6570\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u53c2\u6570\u4fe1\u606f")
    public CommonResult<Params> getByAlias(@ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        Params params = this.paramsService.getByAlias(code);
        return CommonResult.ok().value((Object)params);
    }

    @RequestMapping(value={"userParam/getUserParamsByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570")
    public CommonResult<UserParams> getUserParamsByCode(@ApiParam(name="account", value="\u7528\u6237\u8d26\u6237", required=true) @RequestParam String account, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        UserParams userParams = this.paramsService.getUserParamsByCode(account, code);
        return CommonResult.ok().value((Object)userParams);
    }

    @RequestMapping(value={"userParam/getUserParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6307\u5b9a\u53c2\u6570")
    public CommonResult<UserParams> getUserParamsById(@ApiParam(name="userId", value="\u7528\u6237ID", required=true) @RequestParam String userId, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        UserParams userParams = this.paramsService.getUserParamsById(userId, code);
        return CommonResult.ok().value((Object)userParams);
    }

    @RequestMapping(value={"orgParam/getOrgParamsByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570")
    public CommonResult<OrgParams> getOrgParamsByCode(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        OrgParams orgParams = this.paramsService.getOrgParamsByCode(orgCode, code);
        return CommonResult.ok().value((Object)orgParams);
    }

    @RequestMapping(value={"orgParam/getOrgParamsById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u6307\u5b9a\u53c2\u6570")
    public CommonResult<OrgParams> getOrgParamsById(@ApiParam(name="orgId", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgId, @ApiParam(name="code", value="\u53c2\u6570\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        OrgParams orgParams = this.paramsService.getOrgParamsById(orgId, code);
        return CommonResult.ok().value((Object)orgParams);
    }

    @RequestMapping(value={"Param/deleteParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u53c2\u6570")
    public CommonResult<Integer> deleteParamPhysical() throws Exception {
        Integer num = this.paramsService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userParam/deleteUserParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteUserParamPhysical() throws Exception {
        Integer num = this.userParamsService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"orgParam/deleteOrgParamPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u53c2\u6570\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7ec4\u7ec7\u53c2\u6570\u6570\u636e")
    public CommonResult<Integer> deleteOrgParamPhysical() throws Exception {
        Integer num = this.orgParamsService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"params/getParamsByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<Params>> getParamsByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        List<Params> paramsList = this.paramsService.getParamsByTime(btime, etime);
        return CommonResult.ok().value(paramsList);
    }

    @RequestMapping(value={"params/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u7528\u6237\u7ec4\u7ec7\u53c2\u6570\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        CommonResult<Boolean> commonResult = this.paramsService.isCodeExist(code);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"tenantParams/getTenantParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u79df\u6237\u7c7b\u578b\u7684\u53c2\u6570\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u79df\u6237\u7c7b\u578b\u7684\u53c2\u6570\u5217\u8868")
    public CommonResult<List<Params>> getTenantParams(@ApiParam(name="tenantTypeId", value="\u79df\u6237\u7c7b\u578bid") @RequestParam(required=true) String tenantTypeId) throws Exception {
        List<Params> paramsList = this.paramsService.getByTenantTypeId(tenantTypeId);
        return CommonResult.ok().value(paramsList);
    }
}

