/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.ShiftRuleManager;
import com.hotent.uc.manager.ShiftUserManager;
import com.hotent.uc.model.ShiftRule;
import com.hotent.uc.model.ShiftUser;
import com.hotent.uc.params.user.DurationParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/shiftRule/v1"})
@Api(tags={"shiftRuleController"})
public class ShiftRuleController
extends UcBaseController<ShiftRuleManager, ShiftRule> {
    @Resource
    ShiftRuleManager shiftRuleManager;
    @Resource
    ShiftUserManager shiftUserManager;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u8f6e\u73ed\u89c4\u5219\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u8f6e\u73ed\u89c4\u5219\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="shiftRule", value="uc_shift_rule\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ShiftRule shiftRule) throws Exception {
        ShiftRule checkShiftRule = this.shiftRuleManager.getByKey(shiftRule);
        if (BeanUtils.isNotEmpty((Object)checkShiftRule) && !StringUtils.equals((String)checkShiftRule.getId(), (String)shiftRule.getId())) {
            return new CommonResult(false, "\u5df2\u5b58\u5728key\u4e3a" + checkShiftRule.getKey() + "\u7684\u8f6e\u73ed\u89c4\u5219\uff0c\u8bf7\u66f4\u6362key\u503c\uff01");
        }
        String msg = "\u6dfb\u52a0\u8f6e\u73ed\u89c4\u5219\u6210\u529f";
        if (StringUtil.isEmpty((String)shiftRule.getId())) {
            this.shiftRuleManager.create((Model)shiftRule);
        } else {
            this.shiftRuleManager.update((Model)shiftRule);
            msg = "\u66f4\u65b0\u8f6e\u73ed\u89c4\u5219\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.shiftRuleManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveShiftUser"})
    @ApiOperation(value="\u4fdd\u5b58\u6392\u73ed\u4eba\u5458", httpMethod="POST", notes="\u4fdd\u5b58\u6392\u73ed\u4eba\u5458")
    public CommonResult<String> saveShiftUser(@RequestBody List<ShiftUser> shiftUsers) {
        this.shiftUserManager.saveShiftUser(shiftUsers);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/removeShiftUser"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u8f6e\u73ed\u89c4\u5219\u8bb0\u5f55")
    public CommonResult<String> removeShiftUser(String ... ids) throws Exception {
        this.shiftUserManager.removeByUserIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/computeSendDate"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4", httpMethod="GET", notes="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4")
    public Long computeSendDate(@RequestParam(value="userId") String userId, @RequestParam(value="minute") long minute) throws Exception {
        return this.shiftRuleManager.computeSendDate(userId, minute);
    }

    @PostMapping(value={"/computeDuration"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4", httpMethod="GET", notes="\u8ba1\u7b97\u53d1\u9001\u65f6\u95f4")
    public Long computeDuration(@RequestParam(value="userId") String userId, @RequestBody DurationParam param) throws Exception {
        return this.shiftRuleManager.computeDuration(userId, param.getStartDate(), param.getEndDate());
    }
}

