/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.model.TenantManage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantManage/v1"})
@Api(tags={"\u79df\u6237\u7ba1\u7406 "})
@ApiGroup(group={"group_uc"})
public class TenantManageController
extends UcBaseController<TenantManageManager, TenantManage> {
    @Resource
    TenantManageManager tenantManageManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u79df\u6237\u7ba1\u7406 \u5217\u8868")
    public PageList<TenantManage> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<TenantManage> res = this.tenantManageManager.listJson(queryFilter);
        return res;
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u7ba1\u7406 \u6570\u636e\u8be6\u60c5")
    public TenantManage get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        return (TenantManage)this.tenantManageManager.get((Serializable)((Object)id));
    }

    @GetMapping(value={"/getAll"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u79df\u6237\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u5168\u90e8\u79df\u6237\u660e\u7ec6")
    public List<TenantManage> getTenantAll() throws Exception {
        return this.tenantManageManager.getAll();
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406 \u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7ba1\u7406 \u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantManage", value="\u79df\u6237\u7ba1\u7406 \u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantManage tenantManage) throws Exception {
        CommonResult<String> commonResult = this.tenantManageManager.saveTenantManage(tenantManage);
        return commonResult;
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406 \u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7ba1\u7406 \u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantManageManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"checkCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728")
    public boolean checkCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        TenantManage tenant = this.tenantManageManager.getByCode(code);
        return BeanUtils.isNotEmpty((Object)((Object)tenant));
    }

    @RequestMapping(value={"getTenantByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u83b7\u53d6\u79df\u6237\u7c7b\u578b", httpMethod="GET", notes="\u901a\u8fc7\u7f16\u7801\u83b7\u53d6\u79df\u6237\u7c7b\u578b")
    public CommonResult<TenantManage> getTenantByCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)this.tenantManageManager.getByCode(code));
    }

    @GetMapping(value={"getDefaultStyleById"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u79df\u6237\u9ed8\u8ba4\u98ce\u683c", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u79df\u6237\u9ed8\u8ba4\u98ce\u683c")
    public CommonResult<String> getDefaultStyleById(@ApiParam(name="code", value="\u79df\u6237id") @RequestParam String id) throws Exception {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)this.tenantManageManager.getDefaultStyleById(id));
    }
}

