/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.RSAUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.AccountOrIdVo;
import com.hotent.base.vo.ClientInfo;
import com.hotent.uc.api.model.Group;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.dto.UserSeletorDto;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.UcGroupManager;
import com.hotent.uc.manager.UserImportManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.manager.UserUnderManager;
import com.hotent.uc.manager.UserUniteManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserGroup;
import com.hotent.uc.model.UserParams;
import com.hotent.uc.model.UserRole;
import com.hotent.uc.params.common.DataSyncObject;
import com.hotent.uc.params.common.DataSyncVo;
import com.hotent.uc.params.common.UserExportObject;
import com.hotent.uc.params.echarts.ChartOption;
import com.hotent.uc.params.group.GroupIdentity;
import com.hotent.uc.params.params.ParamObject;
import com.hotent.uc.params.user.TriggerVo;
import com.hotent.uc.params.user.UserImportVo;
import com.hotent.uc.params.user.UserMarkObject;
import com.hotent.uc.params.user.UserPolymer;
import com.hotent.uc.params.user.UserPwdObject;
import com.hotent.uc.params.user.UserRelObject;
import com.hotent.uc.params.user.UserStatusVo;
import com.hotent.uc.params.user.UserUnderVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.service.UserManagerDetailsServiceImpl;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/user/v2/"})
@Api(tags={"\u7528\u6237\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class UserController2
extends BaseController2<UserManager, User> {
    @Autowired
    UserManager userService;
    @Autowired
    UserImportManager userImportService;
    @Autowired
    UserManagerDetailsServiceImpl userManagerDetailsServiceImpl;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    OrgManager orgManager;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    OrgPostManager orgPostManager;
    @Autowired
    OrgJobManager orgJobManager;
    @Autowired
    UcGroupManager ucGroupManager;
    @Resource
    UserUnderManager userUnderManager;
    @Resource
    UserUniteManager userUniteManager;

    @RequestMapping(value={"users/getUserPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff0cUserVo\u5bf9\u8c61\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff0cUserVo\u5bf9\u8c61\uff09")
    public CommonResult<PageList<UserVo>> getUserPage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList query = this.userService.query(queryFilter);
        PageList<UserVo> userVoPageList = this.convertVoPageList((PageList<User>)query);
        return CommonResult.ok().value(userVoPageList);
    }

    @RequestMapping(value={"users/getOrgUserQuery"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u6839\u636e\u7ef4\u5ea6\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u804c\u52a1\u3001\u89d2\u8272\u8fdb\u884c\u8fc7\u6ee4\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u6839\u636e\u7ef4\u5ea6\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u804c\u52a1\u3001\u89d2\u8272\u8fdb\u884c\u8fc7\u6ee4\uff09")
    public CommonResult<PageList<User>> getOrgUserQuery(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<User> queryFilter) throws Exception {
        IPage<User> list = this.userService.getOrgUserQuery(queryFilter);
        PageList userPageList = new PageList(list);
        return CommonResult.ok().value((Object)userPageList);
    }

    @RequestMapping(value={"users/getAllUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7528\u6237", httpMethod="GET", notes="\u83b7\u53d6\u7cfb\u7edf\u4e2d\u6240\u6709\u7528\u6237")
    public CommonResult<List<User>> getAllUser() throws Exception {
        List userList = this.userService.getAll();
        return CommonResult.ok().value((Object)userList);
    }

    @RequestMapping(value={"users/queryByType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public CommonResult<PageList<UserVo>> queryByType(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("ucuser.IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "delete_group");
        queryFilter.addFilter("ucuser.STATUS_", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "delete_group");
        PageList<User> query = this.userService.queryByType(queryFilter);
        PageList<UserVo> userVoPageList = this.convertVoPageList(query);
        return CommonResult.ok().value(userVoPageList);
    }

    @RequestMapping(value={"user/addUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237", httpMethod="POST", notes="\u6dfb\u52a0\u7528\u6237")
    public CommonResult<String> addUser(@ApiParam(name="user", value="\u7528\u6237\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody @Valid UserVo user) throws Exception {
        this.userService.addUser(user);
        return CommonResult.ok().message("\u7528\u6237\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"user/saveUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\uff0c\u4fdd\u5b58\u7528\u6237(\u5305\u62ec\u89d2\u8272\u3001\u7ec4\u7ec7\u548c\u5c97\u4f4d\u4fe1\u606f)", httpMethod="POST", notes="\u6dfb\u52a0\u7528\u6237(\u5305\u62ec\u89d2\u8272\u3001\u7ec4\u7ec7\u548c\u5c97\u4f4d\u4fe1\u606f)")
    @UpdateMethod(type=UserPolymer.class)
    public CommonResult<String> saveUser(@ApiParam(name="userPolymer", value="\u7528\u6237\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody UserPolymer userPolymer) throws Exception {
        this.userService.saveUser(userPolymer);
        return CommonResult.ok().message("\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"user/saveUserBaseInfo"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @UpdateMethod(type=UserVo.class)
    public CommonResult<String> saveUserBaseInfo(@ApiParam(name="vo", value="\u7528\u6237\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody UserVo vo) throws Exception {
        this.userService.saveUser(vo);
        return CommonResult.ok().message("\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"user/deleteUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u5220\u9664\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u6807\u8bc6\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\u5220\u9664\u7528\u6237\uff0c\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<String> deleteUser(@ApiParam(name="userMark", value="\u7528\u6237\u6807\u8bc6") @RequestBody(required=false) UserMarkObject userMark) throws Exception {
        CommonResult<String> commonResult = this.userService.deleteUser(userMark);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/deleteUserByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u5220\u9664\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="DELETE", notes="\u6839\u636e\u7528\u6237id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\u5220\u9664\u7528\u6237\uff0c\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<String> deleteUserByIds(@ApiParam(name="ids", value="\u7528\u6237\u6807\u8bc6") @RequestParam(required=false) String ids) throws Exception {
        CommonResult<String> commonResult = this.userService.deleteUserByIds(ids);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/updateUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\uff08\u66f4\u65b0\u90e8\u5206\u4fe1\u606f\uff09", httpMethod="POST", notes="\u66f4\u65b0\u7528\u6237\uff08\u4e0d\u4f1a\u66f4\u65b0id\u3001\u5bc6\u7801\u3001\u5e10\u53f7\u3001\u5934\u50cf\u3001\u6765\u6e90\u3001\u662f\u5426\u5220\u9664\u3001\u7248\u672c\u53f7\u4fe1\u606f\uff09")
    @UpdateMethod(type=UserVo.class)
    @CacheEvict(value={"eip:uc:userName"}, key="#user.account")
    public CommonResult<String> updateUser(@ApiParam(name="user", value="\u7528\u6237\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody UserVo user) throws Exception {
        this.userService.updateUser(user);
        return CommonResult.ok().message("\u7528\u6237\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"user/getUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09{\"account\":\"\u7528\u6237\u8d26\u53f7\",\"userNumber\":\"\u7528\u6237\u5de5\u53f7\"}")
    public CommonResult<UserVo> getUser(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String account, @ApiParam(name="userNumber", value="\u7528\u6237\u5de5\u53f7") @RequestParam(required=false) String userNumber) throws Exception {
        UserVo userVo = this.userService.getUser(this.getJsonString(account, userNumber));
        return CommonResult.ok().value((Object)userVo);
    }

    @RequestMapping(value={"user/getByAccount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult<User> getByAccount(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) Optional<String> account) throws Exception {
        User user = this.userService.getByAccount(account.orElse(ContextUtil.getCurrentUser().getAccount()));
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"user/getUserByAccounts"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public CommonResult<List<UserVo>> getUserByAccounts(@ApiParam(name="accounts", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String accounts) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("account_", (Object)accounts, QueryOP.IN);
        List<UserVo> users = this.userService.queryUser(queryFilter);
        return CommonResult.ok().value(users);
    }

    @RequestMapping(value={"user/loadUserByUsername"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<IUser> loadUserByUsername(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String account) throws Exception {
        IUser user = (IUser)this.userManagerDetailsServiceImpl.loadUserByUsername(account);
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"user/changUserPsd"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u5bc6\u7801", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u5bc6\u7801\uff08\u8d26\u53f7\u548c\u5de5\u53f7\u4efb\u4f20\u5176\u4e00\uff0c\u4e24\u4e2a\u90fd\u6709\u503c\u65f6\uff0c\u53ea\u7528\u8d26\u53f7\uff09")
    public CommonResult<String> changUserPsd(@ApiParam(name="userPwdObject", value="\u7528\u6237\u5bc6\u7801\u76f8\u5173\u53c2\u6570", required=true) @RequestBody UserPwdObject userPwdObject) throws Exception {
        userPwdObject.setNewPwd(RSAUtil.Decrypt((String)userPwdObject.getNewPwd()));
        userPwdObject.setOldPwd(RSAUtil.Decrypt((String)userPwdObject.getOldPwd()));
        userPwdObject.setAccount(ContextUtil.getCurrentUser().getAccount());
        CommonResult<String> commonResult = this.userService.changUserPsd(userPwdObject);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/modifiUserPsd"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7528\u6237\u4fee\u6539\u5bc6\u7801", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u5bc6\u7801\uff08\u8d26\u53f7\u548c\u5de5\u53f7\u4efb\u4f20\u5176\u4e00\uff0c\u4e24\u4e2a\u90fd\u6709\u503c\u65f6\uff0c\u53ea\u7528\u8d26\u53f7\uff09")
    public CommonResult<String> modifiUserPsd(@ApiParam(name="userPwdObject", value="\u7528\u6237\u5bc6\u7801\u76f8\u5173\u53c2\u6570", required=true) @RequestBody UserPwdObject userPwdObject) throws Exception {
        CommonResult<String> commonResult = this.userService.changUserPsd(userPwdObject);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/updateUserPsw"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u4fee\u6539\u7528\u6237\u5bc6\u7801", httpMethod="POST", notes="\u7ba1\u7406\u5458\u4fee\u6539\u7528\u6237\u5bc6\u7801\uff08\u4e0d\u7528\u4f20\u65e7\u5bc6\u7801\uff1b\u8d26\u53f7\u548c\u5de5\u53f7\u4efb\u4f20\u5176\u4e00\uff0c\u4e24\u4e2a\u90fd\u6709\u503c\u65f6\uff0c\u53ea\u7528\u8d26\u53f7\uff09")
    public CommonResult<String> updateUserPsw(@ApiParam(name="userPwdObject", value="\u7528\u6237\u5bc6\u7801\u76f8\u5173\u53c2\u6570", required=true) @RequestBody UserPwdObject userPwdObject) throws Exception {
        userPwdObject.setNewPwd(RSAUtil.Decrypt((String)userPwdObject.getNewPwd()));
        userPwdObject.setAccount(RSAUtil.Decrypt((String)userPwdObject.getAccount()));
        CommonResult<String> commonResult = this.userService.updateUserPsw(userPwdObject);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"users/importExcelUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165Excel\u7528\u6237", httpMethod="POST", notes="\u5bfc\u5165Excel\u7528\u6237")
    public CommonResult<String> importExcelUser(@ApiParam(name="demCode", value="\u7ef4\u5ea6\u7f16\u7801", required=true) @RequestParam String demCode, @ApiParam(name="file", value="\u5bfc\u5165\u7684Excel\u6587\u4ef6", required=true) @RequestBody MultipartFile file, @ApiParam(name="repeatConver", value="\u7528\u6237\u7ec4\u7ec7\u3001\u5c97\u4f4d\u5173\u7cfb\u6570\u636e\u5bfc\u5165\u6a21\u5f0f\uff08\u8986\u76d6\uff1a\u5148\u5220\u9664\u65e7\u7684\u7ec4\u7ec7\u3001\u5c97\u4f4d\u5173\u7cfb\u6570\u636e\uff0c\u518d\u6309excel\u4e2d\u7684\u6570\u636e\u751f\u6210\u65b0\u5173\u7cfb\u6570\u636e\uff1b\u65b0\u589e\uff1a\u4e0d\u5220\u9664\u65e7\u6570\u636e\uff0cexcel\u4e2d\u7684\u6570\u636e\u505a\u65b0\u589e\u5904\u7406\uff08\u5982\u679c\u548c\u65e7\u7684\u4e00\u6837\uff0c\u4e0d\u4f1a\u589e\u52a0\u591a\u4efd\uff09\uff09", required=false) @RequestParam Optional<Boolean> repeatConver) throws Exception {
        CommonResult<String> commonResult = this.userImportService.importExcelUser(file, demCode, repeatConver.orElse(false));
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/saveUserParams"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u53c2\u6570", httpMethod="POST", notes="\u4fdd\u5b58\u7528\u6237\u53c2\u6570")
    public CommonResult<String> saveUserParams(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="params", value="\u7528\u6237\u53c2\u6570", required=true) @RequestBody List<ParamObject> params) throws Exception {
        CommonResult<String> commonResult = this.userService.saveUserParams(account, params);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/getUserParams"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u6237\u83b7\u53d6\u7528\u6237\u6240\u6709\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u53c2\u6570")
    public CommonResult<List<UserParams>> getUserParams(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        List<UserParams> userParamsList = this.userService.getUserParams(account);
        return CommonResult.ok().value(userParamsList);
    }

    @RequestMapping(value={"user/getParamByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u6237\u548c\u53c2\u6570\u7f16\u7801\u83b7\u53d6\u7528\u6237\u6240\u6709\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6240\u6709\u53c2\u6570")
    public CommonResult<UserParams> getParamByCode(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="code", value="\u53c2\u6570\u522b\u540d", required=true) @RequestParam String code) throws Exception {
        UserParams userParams = this.userService.getParamByCode(account, code);
        return CommonResult.ok().value((Object)userParams);
    }

    @RequestMapping(value={"userOrg/getMainOrgByDemCode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u3001\u7ef4\u5ea6\uff0c\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u4e3b\u7ec4\u7ec7\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u4e3b\u7ec4\u7ec7\u4fe1\u606f\uff0c\u53c2\u6570\u5bf9\u8c61\u7684\u5c5e\u6027isMain\u4e0elevel\u662f\u65e0\u6548\u53c2\u6570\uff0c\u8be5\u65b9\u6cd5\u53ea\u83b7\u53d6\u4e3b\u7ec4\u7ec7\u4fe1\u606f")
    public CommonResult<Org> getMainOrgByDemCode(@ApiParam(name="userRelObject", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u53c2\u6570", required=true) @RequestBody UserRelObject userRelObject) throws Exception {
        CommonResult<Org> commonResult = this.userService.getMainOrgByDemCode(userRelObject);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userPost/getUserPosts"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u3001\u7ef4\u5ea6\uff0c\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u5c97\u4f4d\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u5c97\u4f4d\u4fe1\u606f")
    public CommonResult<List<OrgPost>> getUserPosts(@ApiParam(name="userRelObject", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u53c2\u6570", required=true) @RequestBody UserRelObject userRelObject) throws Exception {
        List<OrgPost> orgPostList = this.userService.getUserPosts(userRelObject);
        return CommonResult.ok().value(orgPostList);
    }

    @RequestMapping(value={"userOrgs/getImmeSuperior"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u3001\u7ef4\u5ea6\u3001\u7ea7\u522b\uff0c\u83b7\u53d6\u7528\u6237\u76f4\u5c5e\u4e0a\u7ea7\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u76f4\u5c5e\u4e0a\u7ea7\u4fe1\u606f\uff08\u76f4\u5c5e\u7ec4\u7ec7\u4e2d\u7684\u4e3b\u8d1f\u8d23\u4eba\uff09")
    public CommonResult<Set<GroupIdentity>> getImmeSuperior(@ApiParam(name="userRelObject", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u53c2\u6570", required=true) @RequestBody UserRelObject userRelObject) throws Exception {
        Set<GroupIdentity> groupIdentities = this.userService.getImmeSuperior(userRelObject);
        return CommonResult.ok().value(groupIdentities);
    }

    @RequestMapping(value={"userOrgs/getImmeUnders"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u3001\u7ef4\u5ea6\u3001\u7ea7\u522b\uff0c\u83b7\u53d6\u7528\u6237\u76f4\u5c5e\u4e0b\u7ea7\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u76f4\u5c5e\u4e0b\u7ea7\uff08\u76f4\u5c5e\u7ec4\u7ec7\u4e2d\u7684\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\uff09\u4fe1\u606f\uff08\u83b7\u53d6\u89c4\u5219\uff1a\u7528\u6237\u6240\u5728\u7ec4\u7ec7\uff0c1\u3001\u7ec4\u7ec7\u4e2d\u6709\u8d23\u4efb\u5c97\u4f4d\uff0c\u7528\u6237\u5728\u8d23\u4efb\u5c97\u4f4d\u4e2d\uff1b2\u3001\u7ec4\u7ec7\u4e2d\u6ca1\u6709\u8d23\u4efb\u5c97\u4f4d\uff0c\u8be5\u7528\u6237\u4e3a\uff08\u4e3b\uff09\u8d1f\u8d23\u4eba\uff09")
    public CommonResult<Set<GroupIdentity>> getImmeUnders(@ApiParam(name="userRelObject", value="\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u53c2\u6570", required=true) @RequestBody UserRelObject userRelObject) throws Exception {
        Set<GroupIdentity> groupIdentities = this.userService.getImmeUnders(userRelObject);
        return CommonResult.ok().value(groupIdentities);
    }

    @RequestMapping(value={"userJob/getUserJobs"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u83b7\u53d6\u7528\u6237\u804c\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u804c\u52a1\u4fe1\u606f\uff0c\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09{\"account\":\"\u7528\u6237\u8d26\u53f7\",\"userNumber\":\"\u7528\u6237\u5de5\u53f7\"}")
    public CommonResult<List<OrgJob>> getUserJobs(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account, @ApiParam(name="userNumber", value="\u7528\u6237\u5de5\u53f7") @RequestParam(required=false) String userNumber) throws Exception {
        List<OrgJob> orgJobList = this.userService.getUserJobs(this.getJsonString(account, userNumber));
        return CommonResult.ok().value(orgJobList);
    }

    @RequestMapping(value={"userGroup/getUserGroups"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\uff08\u6216\u5de5\u53f7\uff09\u83b7\u53d6\u7528\u6237\u7fa4\u7ec4\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u7fa4\u7ec4\u4fe1\u606f\uff0c\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09{\"account\":\"\u7528\u6237\u8d26\u53f7\",\"userNumber\":\"\u7528\u6237\u5de5\u53f7\"}")
    public CommonResult<List<UserGroup>> getUserGroups(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account, @ApiParam(name="userNumber", value="\u7528\u6237\u5de5\u53f7") @RequestParam(required=false) String userNumber) throws Exception {
        List<UserGroup> userGroupList = this.userService.getUserGroups(this.getJsonString(account, userNumber));
        return CommonResult.ok().value(userGroupList);
    }

    @RequestMapping(value={"users/getNewUsersFromAD"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5b9a\u65f6\u83b7\u53d6AD\u65b0\u589e\u4eba\u5458\u4fe1\u606f", httpMethod="GET", notes="\u5b9a\u65f6\u83b7\u53d6AD\u65b0\u589e\u4eba\u5458\u4fe1\u606f\uff08\u83b7\u53d6\u4f20\u5165\u65f6\u95f4\u53ca\u4e4b\u540e\u4eceAD\u57df\u540c\u6b65\u8fc7\u6765\u7684\u4eba\u5458\u5217\u8868\uff09")
    public CommonResult<List<UserVo>> getNewUsersFromAD(@ApiParam(name="date", value="AD\u540c\u6b65\u65f6\u95f4\uff08\u5982\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09", required=true) @RequestParam String date) throws Exception {
        List<UserVo> userVoList = this.userService.getNewUsersFromAD(date);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"users/syncADUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="AD\u57df\u540c\u6b65", httpMethod="GET", notes="\u5b9a\u65f6AD\u57df\u540c\u6b65")
    public CommonResult<String> syncADUsers(@ApiParam(name="action", value="\u540c\u6b65\u7c7b\u578b\uff1a\u201call\u201d\u4e3a\u5168\u91cf\uff0c\u5176\u4ed6\u5b57\u7b26\u4e3a\u589e\u91cf", required=true) @RequestParam String action, HttpServletRequest request) throws Exception {
        String ip = OrgUtil.getIpAddress(request);
        CommonResult<String> commonResult = this.userImportService.syncADUsers(action, ip);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"users/getByRoleCodeAndOrgCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u89d2\u8272\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458", httpMethod="GET", notes="\u6839\u636e\u89d2\u8272\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458")
    public CommonResult<Set<GroupIdentity>> getByRoleCodeAndOrgCode(@ApiParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801", required=true) @RequestParam String roleCode, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)roleCode) || StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Set<GroupIdentity> groupIdentities = this.userService.getByRoleCodeAndOrgCode(roleCode, orgCode);
        return CommonResult.ok().value(groupIdentities);
    }

    @RequestMapping(value={"users/getByJobCodeAndOrgCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458", httpMethod="GET", notes="\u6839\u636e\u804c\u52a1\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458")
    public CommonResult<Set<GroupIdentity>> getByJobCodeAndOrgCode(@ApiParam(name="jobCode", value="\u804c\u52a1\u7f16\u7801", required=true) @RequestParam String jobCode, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)jobCode) || StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u804c\u52a1\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Set<GroupIdentity> groupIdentities = this.userService.getByJobCodeAndOrgCode(jobCode, orgCode);
        return CommonResult.ok().value(groupIdentities);
    }

    @RequestMapping(value={"users/getByPostCodeAndOrgCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458", httpMethod="GET", notes="\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5bf9\u5e94\u4eba\u5458")
    public CommonResult<Set<GroupIdentity>> getByPostCodeAndOrgCode(@ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801", required=true) @RequestParam String postCode, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)postCode) || StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Set<GroupIdentity> groupIdentities = this.userService.getByPostCodeAndOrgCode(postCode, orgCode);
        return CommonResult.ok().value(groupIdentities);
    }

    @RequestMapping(value={"users/getUpUsersByUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6240\u6709\u4e0a\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6240\u6709\u4e0a\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09")
    public CommonResult<List<UserVo>> getUpUsersByUser(@ApiParam(name="account", value="\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        List<UserVo> userVoList = this.userService.getUpUsersByUser(account);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"users/getUpUserByUserAndOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5728\u6307\u5b9a\u7ec4\u7ec7\u4e2d\u7684\u4e0a\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5728\u6307\u5b9a\u7ec4\u7ec7\u4e2d\u7684\u4e0a\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09")
    public CommonResult<UserVo> getUpUserByUserAndOrg(@ApiParam(name="account", value="\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u7528\u6237\u5e10\u53f7\u548c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserVo userVo = this.userService.getUpUserByUserAndOrg(account, orgCode);
        return CommonResult.ok().value((Object)userVo);
    }

    @RequestMapping(value={"users/getUnderUsersByUser"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6240\u6709\u4e0b\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u7684\u6240\u6709\u4e0b\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09")
    public CommonResult<List<UserVo>> getUnderUsersByUser(@ApiParam(name="account", value="\u8d26\u53f7", required=true) @RequestParam String account) throws Exception {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)account)) {
            throw new RequiredException("\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<UserVo> userVoList = this.userService.getUnderUsersByUser(account);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"users/getUnderUserByUserAndOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5728\u6307\u5b9a\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5728\u6307\u5b9a\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u7ea7\uff08\u4e0b\u5c5e\u7ba1\u7406\uff09")
    public CommonResult<List<UserVo>> getUnderUserByUserAndOrg(@ApiParam(name="account", value="\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        List<UserVo> userVoList = this.userService.getUnderUserByUserAndOrg(account, orgCode);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"user/deleteUserPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u6570\u636e")
    public CommonResult<Integer> deleteUserPhysical() throws Exception {
        Integer num = this.userService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/forbiddenUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u7981\u7528\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u6807\u8bc6\u7981\u7528\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<String> forbiddenUser(@ApiParam(name="userMark", value="\u7528\u6237\u6807\u8bc6") @RequestBody(required=false) UserMarkObject userMark) throws Exception {
        CommonResult<String> commonResult = this.userService.forbiddenUser(userMark);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/activateUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u6fc0\u6d3b\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u6807\u8bc6\u6fc0\u6d3b\u7528\u6237\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<String> activateUser(@ApiParam(name="userMark", value="\u7528\u6237\u6807\u8bc6") @RequestBody(required=false) UserMarkObject userMark) throws Exception {
        CommonResult<String> commonResult = this.userService.activateUser(userMark);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/leaveUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u7528\u6237\u79bb\u804c\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u6807\u8bc6\u7528\u6237\u79bb\u804c\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09\u53c2\u6570 \uff08\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<String> leaveUser(@ApiParam(name="userMark", value="\u7528\u6237\u6807\u8bc6") @RequestBody(required=false) UserMarkObject userMark) throws Exception {
        CommonResult<String> commonResult = this.userService.leaveUser(userMark);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"users/getUserByPost"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5c97\u4f4d\u7f16\u7801\u83b7\u53d6\u7528\u6237", httpMethod="GET", notes="\u901a\u8fc7\u5c97\u4f4d\u7f16\u7801\u83b7\u53d6\u7528\u6237")
    public CommonResult<List<UserVo>> getUserByPost(@ApiParam(name="postCode", value="\u5c97\u4f4d\u7f16\u7801(\u591a\u4e2a\u7528\u201d,\u201c\u53f7\u5206\u9694)", required=true) @RequestParam String postCode) throws Exception {
        List<UserVo> userVoList = this.userService.getUserByPost(postCode);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"users/exportUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u6570\u636e\uff08\u53ef\u5305\u542b\u7528\u6237\u3001\u673a\u6784\u3001\u7ef4\u5ea6\u3001\u7ec4\u7ec7\u3001\u89d2\u8272\u6570\u636e\uff09")
    public void exportUsers(@ApiParam(name="isOrg", value="\u662f\u5426\u5bfc\u51fa\u7ec4\u7ec7\u76f8\u5173\u6570\u636e\uff08\u5305\u62ec\u7ef4\u5ea6\u3001\u7ec4\u7ec7\u3001\u804c\u52a1\u3001\u5c97\u4f4d\u5df2\u7ecf\u4e4b\u95f4\u7684\u5173\u7cfb\u8868\u6570\u636e\uff09\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam Boolean isOrg, @ApiParam(name="isRole", value="\u662f\u5426\u5bfc\u51fa\u89d2\u8272\u4ee5\u53ca\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam Boolean isRole, @ApiParam(name="isAll", value="\u662f\u5426\u5bfc\u51fa\u67e5\u8be2\u6761\u4ef6\u7684\u5168\u90e8\u6570\u636e\uff08false\uff1a\u53ea\u5bfc\u51fa\u5f53\u524d\u9875\uff09\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam Boolean isAll, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        File file;
        String zipPath;
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        isOrg = BeanUtils.isEmpty((Object)isOrg) ? true : isOrg;
        isRole = BeanUtils.isEmpty((Object)isRole) ? true : isRole;
        isAll = BeanUtils.isEmpty((Object)isAll) ? true : isAll;
        String path = this.userService.exportUsers(isOrg, isRole, isAll, queryFilter);
        if (StringUtil.isNotEmpty((String)path)) {
            zipPath = path + ".zip";
            file = new File(zipPath);
            if (!file.exists()) {
                throw new RuntimeException("\u751f\u6210zip\u6587\u4ef6\u5931\u8d25\uff01");
            }
        } else {
            throw new RuntimeException("\u5bfc\u51fa\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String zipName = file.getName();
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)zipName);
        FileUtil.deleteFile((String)zipPath);
    }

    @RequestMapping(value={"users/importZipUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb", httpMethod="POST", notes="\u5bfc\u5165\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb")
    public CommonResult<String> importZipUser(@ApiParam(name="isNewCode", value="\u662f\u5426\u751f\u6210\u65b0\u7f16\u7801\u3002\u5f53\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u4e14\u5bf9\u5e94\u540d\u79f0\u4e0d\u540c\u65f6\uff1atrue,\u7f16\u7801\u52a0\u540e\u7f00\u751f\u6210\u65b0\u7684\u7f16\u7801\u5bfc\u5165\uff1bfalse\uff1a\u4e0d\u5bfc\u5165\u6570\u636e\u53ca\u76f8\u5173\u8fde\u6570\u636e\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam boolean isNewCode, @ApiParam(name="isCover", value="\u662f\u5426\u8986\u76d6\u66f4\u65b0\u3002\u5982\u679c\u7f16\u7801\u548c\u540d\u79f0\u4e00\u6837\uff0c\u5219\u9ed8\u8ba4\u4e3a\u540c\u4e00\u6761\u6570\u636e\uff1atrue\uff0c\u5c06\u5df2\u5bfc\u5165\u6570\u636e\u4e3a\u51c6\uff0c\u66f4\u65b0\u5176\u4ed6\u5b57\u6bb5\uff0cfalse\uff0c\u4e0d\u66f4\u65b0\u9664\u5173\u8054\u5b57\u6bb5\u4ee5\u5916\u7684\u5b57\u6bb5\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam boolean isCover, @ApiParam(name="isOrg", value="\u662f\u5426\u5bfc\u5165\u7ec4\u7ec7\u76f8\u5173\u6570\u636e\uff08\u5305\u62ec\u7ef4\u5ea6\u3001\u7ec4\u7ec7\u3001\u804c\u52a1\u3001\u5c97\u4f4d\u5df2\u7ecf\u4e4b\u95f4\u7684\u5173\u7cfb\u8868\u6570\u636e\uff09\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam boolean isOrg, @ApiParam(name="isRole", value="\u662f\u5426\u5bfc\u5165\u89d2\u8272\u4ee5\u53ca\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\u3002\u9ed8\u8ba4\u4e3atrue", required=true) @RequestParam boolean isRole, @ApiParam(name="file", value="\u5bfc\u5165\u7684zip\u6587\u4ef6", required=true) @RequestBody MultipartFile file) throws Exception {
        UserImportVo importVo = new UserImportVo();
        importVo.setNewCode(BeanUtils.isNotEmpty((Object)isNewCode) ? isNewCode : false);
        importVo.setCover(BeanUtils.isNotEmpty((Object)isCover) ? isCover : false);
        importVo.setOrg(BeanUtils.isNotEmpty((Object)isOrg) ? isOrg : false);
        importVo.setRole(BeanUtils.isNotEmpty((Object)isRole) ? isRole : false);
        CommonResult<String> commonResult = this.userImportService.importZipUser(file, importVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"users/getUserByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<User>> getUserByTime(@ApiParam(name="userExport", value="\u83b7\u53d6\u7528\u6237\u53c2\u6570", required=true) @RequestBody UserExportObject userExport) throws Exception {
        List<User> userList = this.userService.getUserByTime(userExport);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/getUserParamByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u53c2\u6570\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<UserParams>> getUserParamByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        List<UserParams> userParamsList = this.userService.getUserParamByTime(btime, etime);
        return CommonResult.ok().value(userParamsList);
    }

    @RequestMapping(value={"userRoles/getUserRoleByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<UserRole>> getUserRoleByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        List<UserRole> userRoleList = this.userService.getUserRoleByTime(btime, etime);
        return CommonResult.ok().value(userRoleList);
    }

    @RequestMapping(value={"userRoles/userRolePage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272\u5217\u8868")
    public CommonResult<PageList<UserRole>> userRolePage(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<UserRole> userRolePage = this.userRoleService.getUserRolePage(queryFilter);
        return CommonResult.ok().value(userRolePage);
    }

    @RequestMapping(value={"dataSync/getSyncDataByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u540c\u6b65\u526f\u672c\u6570\u636e\u96c6\u5408", httpMethod="POST", notes="\u83b7\u53d6\u540c\u6b65\u526f\u672c\u6570\u636e\u96c6\u5408\uff08\u672a\u586b\u5199\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\u65f6\u4e3a\u5168\u91cf\uff09")
    public CommonResult<DataSyncVo> getSyncDataByTime(@ApiParam(name="dataSync", value="\u526f\u672c\u6570\u636e\u540c\u6b65\u83b7\u53d6\u53c2\u6570\u7c7b") @RequestBody(required=true) DataSyncObject dataSync) throws Exception {
        DataSyncVo syncDataByTime = this.userService.getSyncDataByTime(dataSync);
        return CommonResult.ok().value((Object)syncDataByTime);
    }

    @RequestMapping(value={"user/getUserRelCharts"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u6807\u8bc6\u83b7\u53d6\u7528\u6237\u6c47\u62a5\u5173\u7cfb\u56fe\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u6c47\u62a5\u5173\u7cfb\u56fe\u4fe1\u606f\uff0c\u53c2\u6570 \uff08\u8d26\u53f7\u3001\u5de5\u53f7\u4efb\u4f20\u4e00\u4e2a\uff09")
    public CommonResult<ChartOption> getUserRelCharts(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account, @ApiParam(name="userNumber", value="\u7528\u6237\u5de5\u53f7") @RequestParam(required=false) String userNumber) throws Exception {
        ChartOption chartOption = this.userService.getUserRelCharts(this.getJsonString(account, userNumber));
        return CommonResult.ok().value((Object)chartOption);
    }

    @RequestMapping(value={"user/setStatus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u7528\u6237\u72b6\u6001", httpMethod="POST", notes="\u6279\u91cf\u8bbe\u7f6e\u7528\u6237\u72b6\u6001")
    public CommonResult<String> setStatus(@ApiParam(name="userStatusVo", value="\u7528\u6237\u72b6\u6001\u53d8\u66f4\u8bf7\u6c42\u53c2\u6570") @RequestBody(required=true) UserStatusVo userStatusVo) throws Exception {
        this.userService.setStatus(userStatusVo);
        return CommonResult.ok().message("\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"user/isAccountExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u8d26\u53f7\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u8d26\u53f7\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isAccountExist(@ApiParam(name="account", value="\u8d26\u53f7") @RequestParam(required=true) String account) throws Exception {
        CommonResult<Boolean> commonResult = this.userService.isAccountExist(account);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/isUserNumberExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u5de5\u53f7\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u5de5\u53f7\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isUserNumberExist(@ApiParam(name="account", value="\u8d26\u53f7") @RequestParam(required=true) String account, @ApiParam(name="userNumber", value="\u5de5\u53f7") @RequestParam(required=true) String userNumber) throws Exception {
        CommonResult<Boolean> commonResult = this.userService.isUserNumberExist(account, userNumber);
        return CommonResultUtil.getResult(commonResult);
    }

    private PageList<UserVo> convertVoPageList(PageList<User> pageList) {
        PageList voPageList = new PageList();
        voPageList.setPage(pageList.getPage());
        voPageList.setPageSize(pageList.getPageSize());
        voPageList.setTotal(pageList.getTotal());
        voPageList.setRows(OrgUtil.convertToUserVoList(pageList.getRows()));
        return voPageList;
    }

    private String getJsonString(String account, String userNumber) throws IOException {
        if (StringUtil.isEmpty((String)account) && StringUtil.isEmpty((String)userNumber)) {
            throw new RequiredException("\u5e10\u53f7\u548c\u5de5\u53f7\u5fc5\u987b\u586b\u5199\u5176\u4e2d\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("account", account);
        json.put("userNumber", userNumber);
        return JsonUtil.toJson((Object)json);
    }

    @RequestMapping(value={"user/updateOneselfPsw"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801", httpMethod="POST", notes="\u7528\u6237\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801\uff09")
    public CommonResult<String> updateOneselfPsw(@ApiParam(name="userPwdObject", value="\u7528\u6237\u5bc6\u7801\u76f8\u5173\u53c2\u6570", required=true) @RequestBody UserPwdObject userPwdObject) throws Exception {
        CommonResult<String> commonResult = this.userService.updateOneselfPsw(userPwdObject);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/uploadPortrait"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0a\u4f20\u5934\u50cf", httpMethod="POST", notes="\u4e0a\u4f20\u5934\u50cf")
    public CommonResult<String> uploadPortrait(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account, @ApiParam(name="file", value="\u4e0a\u4f20\u7684\u5934\u50cf", required=true) @RequestParam MultipartFile file) throws Exception {
        CommonResult<String> commonResult = this.userService.uploadPortrait(account, file);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/portrait/{account}/{filename:.+}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4e0b\u8f7d\u5934\u50cf", httpMethod="GET", notes="\u4e0b\u8f7d\u5934\u50cf")
    public ResponseEntity<?> getFile(@PathVariable String account, @PathVariable String filename) {
        try {
            return ResponseEntity.ok((Object)this.userService.downloadPortrait(account, filename));
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(value={"users/getAllOrgUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7ec4\u7ec7\u4eba\u5458\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7ec4\u7ec7\u4eba\u5458")
    public CommonResult<PageList<UserVo>> getAllOrgUsers(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        Page query = (Page)this.userService.getDemUserQuery(queryFilter);
        PageList<UserVo> userVoPageList = this.convertVoPageList((PageList<User>)new PageList((IPage)query));
        return CommonResult.ok().value(userVoPageList);
    }

    @RequestMapping(value={"user/setTrigger"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4", httpMethod="POST", notes="\u4fee\u6539\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4")
    public CommonResult<String> setTrigger(@ApiParam(name="triggerVo", value="\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1vo\u7c7b") @RequestBody(required=true) TriggerVo triggerVo, HttpServletRequest request) throws Exception {
        String ip = OrgUtil.getIpAddress(request);
        CommonResult<String> commonResult = this.userService.setTrigger(triggerVo, ip);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/getUserById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult<UserVo> getUserById(@ApiParam(name="userId", value="\u7528\u6237ID") @RequestParam(required=false) String userId) throws Exception {
        CommonResult<UserVo> commonResult = this.userService.getUserById(userId);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/getUserByEmail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eemail\u67e5\u8be2\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eemail\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    public CommonResult<List<User>> getUserByEmail(@ApiParam(name="email", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=true) String email) throws Exception {
        List<User> userList = this.userService.getByUserEmail(email);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/getCharges"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public CommonResult<List<User>> getCharges(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="isMain", value="\u662f\u5426\u4e3b\u8d1f\u8d23\u4eba", required=true) @RequestParam Boolean isMain, @ApiParam(name="isP", value="\u662f\u5426\u4e0a\u7ea7\u90e8\u95e8", required=true) @RequestParam Boolean isP) throws Exception {
        List<Object> list = new ArrayList();
        Org org = this.orgManager.getMainGroup(userId, null);
        if (BeanUtils.isNotEmpty((Object)org)) {
            list = this.userService.getChargesByOrg(isP != false ? org.getParentId() : org.getCode(), isMain);
        }
        return CommonResult.ok().value(list);
    }

    @RequestMapping(value={"user/isAdmin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u662f\u5426\u8d85\u7ea7\u7ba1\u7406\u5458", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7")
    public CommonResult<Boolean> isAdmin() throws Exception {
        User user = ContextUtil.getCurrentUser();
        return CommonResult.ok().value((Object)user.isAdmin()).message("\u83b7\u53d6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"users/getSuperFromUnder"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458", httpMethod="GET", notes="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458")
    public CommonResult<List<User>> getSuperFromUnder(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="orgId", value="\u7ec4\u7ec7id\u6216\u7f16\u7801", required=false) @RequestParam(required=false) String orgId, @ApiParam(name="demId", value="\u7ef4\u5ea6id\u6216\u7f16\u7801", required=false) @RequestParam(required=false) String demId) throws Exception {
        List<User> userList = this.userService.getSuperFromUnder(userId, orgId, demId);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/getSuperiorFromUnder"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458", httpMethod="GET", notes="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458")
    public CommonResult<List<User>> getSuperiorFromUnder(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId, @ApiParam(name="demId", value="\u7ef4\u5ea6id\u6216\u7f16\u7801", required=false) @RequestParam(required=false) String demId) throws Exception {
        List<User> userList = this.userService.getSuperiorFromUnder(userId, demId);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"user/getUserMsg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6app\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6app\u7528\u6237\u4fe1\u606f")
    public ResponseEntity<?> getUserMsg(@ApiParam(name="account", value="\u7528\u6237\u522b\u540d", required=false) @RequestParam String account) throws Exception {
        ResponseEntity<?> appUserMsg = this.userService.getAppUserMsg(account);
        return appUserMsg;
    }

    @RequestMapping(value={"user/getOrgMsg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6app\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6app\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f")
    public ResponseEntity<?> getOrgMsg(@ApiParam(name="orgCode", value="\u7ec4\u7ec7\u522b\u540d", required=false) @RequestParam String orgCode) throws Exception {
        ResponseEntity<?> appOrgMsg = this.userService.getAppOrgMsg(orgCode);
        return appOrgMsg;
    }

    @RequestMapping(value={"user/getUnderUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6app\u7528\u6237\u7684\u6240\u6709\u4e0b\u5c5e", httpMethod="GET", notes="\u83b7\u53d6app\u7528\u6237\u7684\u6240\u6709\u4e0b\u5c5e")
    public ResponseEntity<?> getUnderUsers(@ApiParam(name="userId", value="\u7528\u6237id", required=false) @RequestParam String userId) throws Exception {
        try {
            List<User> list = this.userService.getUnderUsersByUserId(userId);
            return ResponseEntity.ok(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.notFound().build();
        }
    }

    @RequestMapping(value={"user/updateUserMessage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u8d44\u6599\u53c2\u6570", httpMethod="POST", notes="\u4fee\u6539\u7528\u6237\u8d44\u6599\u53c2\u6570")
    public Map<String, Object> updateUserMessage(@ApiParam(name="params", value="\u4fee\u6539\u7528\u6237\u8d44\u6599\u53c2\u6570", required=false) @RequestBody Map<String, Object> params) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (!params.containsKey("account")) {
                throw new Exception("\u7f3a\u5c11account\u53c2\u6570");
            }
            User user = this.userService.getByAccount(params.get("account").toString());
            boolean flag = false;
            if (params.containsKey("mobile")) {
                flag = true;
                user.setMobile(params.get("mobile").toString());
            }
            if (params.containsKey("email")) {
                flag = true;
                user.setEmail(params.get("email").toString());
            }
            if (params.containsKey("fullname")) {
                flag = true;
                user.setFullname(params.get("fullname").toString());
            }
            if (params.containsKey("photo")) {
                flag = true;
                String fileId = params.getOrDefault("photo", "").toString();
                if (!"".equals(fileId)) {
                    String photo = "/system/file/v1/downloadFile?fileId=" + fileId;
                    user.setPhoto(photo);
                    map.put("photo", photo);
                }
            }
            if (flag) {
                this.userService.update((Model)user);
            }
            map.put("success", true);
        }
        catch (Exception e) {
            map.put("success", false);
            map.put("message", "\u7cfb\u7edf\u9519\u8bef");
            e.printStackTrace();
        }
        return map;
    }

    @RequestMapping(value={"user/bindOpenId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ed1\u5b9a\u516c\u4f17\u53f7openid", httpMethod="GET", notes="\u7ed1\u5b9a\u516c\u4f17\u53f7openid")
    public CommonResult<String> bindOpenId(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam String account, @ApiParam(name="openid", value="\u7528\u6237openid") @RequestParam String openid) throws Exception {
        CommonResult<String> commonResult = this.userService.bindOpenId(account, openid);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/bindMpOpenId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ed1\u5b9a\u5c0f\u7a0b\u5e8fopenid", httpMethod="GET", notes="\u7ed1\u5b9a\u5c0f\u7a0b\u5e8fopenid")
    public CommonResult<String> bindMpOpenId(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam String account, @ApiParam(name="mpOpenid", value="mpOpenid") @RequestParam String mpOpenid) throws Exception {
        CommonResult<String> commonResult = this.userService.bindMpOpenId(account, mpOpenid);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/getUserDetailed"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6app\u7528\u6237\u7684\u6240\u6709\u4e0b\u5c5e", httpMethod="GET", notes="\u6309\u7528\u6237id\u67e5\u8be2\u6240\u5c5e\u7ec4\u7ec7")
    public Map<String, Object> getUserDetailed(@ApiParam(name="userId", value="\u7528\u6237id", required=false) @RequestParam String userId) throws Exception {
        Map<String, Object> map = this.userService.getUserDetailed(userId);
        return map;
    }

    @RequestMapping(value={"user/getDepHeader"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u6240\u5728\u90e8\u95e8\u8d1f\u8d23\u4eba", httpMethod="GET", notes="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u6240\u5728\u90e8\u95e8\u8d1f\u8d23\u4eba\uff08\u4e0d\u4f20\u4e3a\u5f53\u524d\u4eba\uff09")
    public CommonResult<List<UserVo>> getDepHeader(@ApiParam(name="userId", value="\u7528\u6237id", required=false) @RequestParam Optional<String> userId, @ApiParam(name="isMain", value="\u662f\u5426\u53ea\u53d6\u4e3b\u8d1f\u8d23\u4eba", required=false) @RequestParam Optional<Boolean> isMain) throws Exception {
        String uid = userId.orElse(ContextUtil.getCurrentUserId());
        List<UserVo> userVoList = this.userService.getDepHeader(uid, isMain.orElse(false));
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"user/getDepHeaderByOrg"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8id\u83b7\u53d6\u90e8\u95e8\u8d1f\u8d23\u4eba", httpMethod="GET", notes="\u6839\u636e\u90e8\u95e8id\u83b7\u53d6\u90e8\u95e8\u8d1f\u8d23\u4eba")
    public CommonResult<List<UserVo>> getDepHeaderByOrg(@ApiParam(name="orgId", value="\u90e8\u95e8id", required=false) @RequestParam String orgId, @ApiParam(name="isMain", value="\u662f\u5426\u53ea\u53d6\u4e3b\u8d1f\u8d23\u4eba", required=false) @RequestParam Optional<Boolean> isMain) throws Exception {
        List<UserVo> userVoList = this.userService.getDepHeaderByOrg(orgId, isMain.orElse(false));
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"user/getGroupsByUidAndType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7c7b\u578b\u83b7\u53d6\u5176\u76f8\u5173\u7528\u6237\u7ec4", httpMethod="GET", notes="\u6839\u636e\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7c7b\u578b\u83b7\u53d6\u5176\u76f8\u5173\u7528\u6237\u7ec4")
    public CommonResult<List<Group>> getGroupsByUidAndType(@ApiParam(name="userId", value="\u7528\u6237id", required=false) @RequestParam String userId, @ApiParam(name="type", value="\u7c7b\u578b", required=false) @RequestParam String type) throws Exception {
        List<Group> groupList = this.userService.getGroupsByUserId(userId, type);
        return CommonResult.ok().value(groupList);
    }

    @RequestMapping(value={"user/queryOrgUserRel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7c7b\u578b\u83b7\u53d6\u5176\u76f8\u5173\u7528\u6237\u7ec4", httpMethod="POST", notes="\u6839\u636e\u7528\u6237id\u548c\u7528\u6237\u7ec4\u7c7b\u578b\u83b7\u53d6\u5176\u76f8\u5173\u7528\u6237\u7ec4")
    public List queryOrgUserRel(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.userService.queryOrgUserRel(queryFilter);
    }

    @RequestMapping(value={"user/getDetailByAccountOrId"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u8d26\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public Map<String, Object> getDetailByAccountOrId(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestBody AccountOrIdVo accountOrIdVo) throws Exception {
        return this.userService.getUserDetailByAccountOrId(accountOrIdVo.getAccountOrId());
    }

    @RequestMapping(value={"users/getUserByNameaAndEmal"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u6761\u4ef6", httpMethod="GET", notes="\u6a21\u7cca\u67e5\u8be2\u83b7\u53d6\u7528\u6237\u5217\u8868")
    public CommonResult<List<User>> getUserByNameaAndEmal(@ApiParam(name="key", value="\u67e5\u8be2\u6761\u4ef6", required=false) @RequestParam String query) throws Exception {
        List<User> userList = this.userService.getUserByName(query);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/calculateNodeUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u5904\u7406\u4eba\u5bf9\u8c61\u62bd\u53d6\u5904\u7406\u4eba", httpMethod="POST", notes="\u6839\u636e\u8282\u70b9\u5904\u7406\u4eba\u5bf9\u8c61\u62bd\u53d6\u5904\u7406\u4eba")
    public Map<String, Object> calculateNodeUser(@ApiParam(name="nodeMap", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody Map<String, Object> nodeMap) throws Exception {
        Map<String, Object> calculateNodeUser = this.userService.calculateNodeUser(nodeMap);
        return calculateNodeUser;
    }

    @RequestMapping(value={"user/getUserByOpenId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5fae\u4fe1\u516c\u4f17\u53f7openId\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u5fae\u4fe1\u516c\u4f17\u53f7openId\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult<UserVo> getUserByOpenId(@ApiParam(name="openId", value="\u516c\u4f17\u53f7openId", required=false) @RequestParam String openId) throws Exception {
        CommonResult<UserVo> commonResult = this.userService.getUserByOpenId(openId);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/getUserByMpOpenId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5fae\u4fe1\u516c\u4f17\u53f7openId\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u5fae\u4fe1\u516c\u4f17\u53f7openId\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult<User> getUserByMpOpenId(@ApiParam(name="openId", value="\u516c\u4f17\u53f7openId", required=false) @RequestParam String openId) throws Exception {
        User user = this.userService.getUserByMpOpenId(openId);
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"user/getUserRightMapByIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4f20\u5165\u7684\u7528\u6237id\u96c6\u5408\uff0c\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u96c6\u5408", httpMethod="GET", notes="\u6839\u636e\u4f20\u5165\u7684\u7528\u6237id\u96c6\u5408\uff0c\u83b7\u53d6\u7528\u6237\u7684\u6743\u9650\u96c6\u5408")
    public Map<String, Map<String, String>> getUserRightMapByIds(@ApiParam(name="ids", value="\u7528\u6237id\u96c6\u5408") @RequestParam(required=false) Optional<String> ids) throws Exception {
        String[] split = ids.orElse("").split(",");
        List<String> asList = Arrays.asList(split);
        HashSet<String> hashSet = new HashSet<String>(asList);
        return this.userService.getUserRightMapByIds(hashSet);
    }

    @RequestMapping(value={"user/getUserByIds"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public CommonResult<List<UserVo>> getUserByIds(@ApiParam(name="ids", value="\u7528\u6237id") @RequestParam(required=true) String ids) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ID_", (Object)ids, QueryOP.IN);
        List<UserVo> users = this.userService.queryUser(queryFilter);
        return CommonResult.ok().value(users);
    }

    @RequestMapping(value={"user/getUserByMobile"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u624b\u673a\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult<UserVo> getUserByMobile(String mobile) {
        CommonResult<UserVo> commonResult = this.userService.getUserByMobile(mobile);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/addUserFromExterUni"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237", httpMethod="POST", notes="\u6dfb\u52a0\u7528\u6237")
    public CommonResult<User> addUserFromExterUni(@ApiParam(name="newUser", value="\u7528\u6237", required=true) @RequestBody UserVo newUser) throws Exception {
        User user = this.userService.addUser(newUser);
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"user/getUserInfoBySignData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7b7e\u7f72\u6570\u636e\u83b7\u53d6\u7528\u6237\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u7b7e\u7f72\u6570\u636e\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public ArrayNode getUserInfoBySignData(ArrayNode customSignDatas) throws Exception {
        return this.userService.getUserInfoBySignData(customSignDatas);
    }

    @RequestMapping(value={"user/getTokenByUserUserName"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u7684\u7528\u6237\u540d\uff0c\u62ff\u5230\u7528\u6237\u7684Token\u4fe1\u606f\uff0c\u5b9e\u73b0\u7cfb\u7edf\u5185\u767b\u5f55", httpMethod="POST", notes="\u83b7\u53d6Token\u4fe1\u606f")
    public CommonResult<String> getTokenByUserUserName(@ApiParam(name="username", value="\u7528\u6237\u540d") @RequestParam(required=false) String username) {
        CommonResult<String> commonResult = this.userService.getTokenByUserName(username);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"user/excelExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u7528\u6237", httpMethod="POST", notes="\u5bfc\u51fa\u7528\u6237")
    public void excelExport(@ApiParam(name="users", value="\u7528\u6237") @RequestBody List<String> users, HttpServletResponse httpServletResponse) throws Exception {
        this.userService.userExport(users, httpServletResponse);
    }

    @PostMapping(value={"user/setUnderUser"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e0b\u5c5e\u7528\u6237", httpMethod="POST", notes="\u8bbe\u7f6e\u4e0b\u5c5e\u7528\u6237")
    public CommonResult<String> setUnderUser(@RequestBody UserUnderVo userUnderVo) throws Exception {
        this.userUnderManager.setUnderUser(userUnderVo);
        return CommonResult.ok().message("\u4e0b\u5c5e\u8bbe\u7f6e\u6210\u529f");
    }

    @GetMapping(value={"user/superior"}, produces={"application/json; charset=utf-8"})
    public CommonResult<UserVo> getSuperior(@RequestParam(value="underId") String underId, @RequestParam(value="demId") String demId) throws Exception {
        User superior = this.userUnderManager.getSuperior(underId, demId);
        UserVo userVo = OrgUtil.convertToUserVo(superior);
        return CommonResult.ok().value((Object)userVo);
    }

    @PostMapping(value={"user/updateClientInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u6216\u66f4\u65b0\u7528\u6237\u8bbe\u5907\u4fe1\u606f", httpMethod="POST", notes="\u8bbe\u7f6e\u6216\u66f4\u65b0\u7528\u6237\u8bbe\u5907\u4fe1\u606f")
    public CommonResult<String> updateClientInfo(@RequestBody ClientInfo clientInfo) throws Exception {
        String clientToken;
        User user = this.userService.getByAccount(clientInfo.getAccount());
        String clientId = clientInfo.getClientId() != null ? clientInfo.getClientId() : "";
        String string = clientToken = clientInfo.getClientToken() != null ? clientInfo.getClientToken() : "";
        if (!(!BeanUtils.isNotEmpty((Object)clientId) || clientId.equals(user.getClientId()) && clientToken.equals(user.getClientToken()))) {
            user.setClientId(clientId);
            user.setClientToken(clientToken);
            this.userService.update((Model)user);
            this.deleteUserFromCache(clientInfo.getAccount());
        }
        return CommonResult.ok().message("\u4fe1\u606f\u8bbe\u5907\u4fe1\u606f\u6210\u529f");
    }

    private void deleteUserFromCache(String userAccount) {
        UserController2 bean = (UserController2)((Object)AppUtil.getBean(((Object)((Object)this)).getClass()));
        bean.removeUserFromCache(userAccount);
    }

    @CacheEvict(value={"eip:uc:userName"}, key="#username")
    protected void removeUserFromCache(String username) {
    }

    @PostMapping(value={"/shift/users"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6392\u73ed\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u6392\u73ed\u7528\u6237")
    public CommonResult<PageList> getShiftUser(@RequestBody QueryFilter queryFilter) throws Exception {
        IPage<User> page = this.userService.selectShiftUser(queryFilter);
        PageList pageList = new PageList(page);
        return CommonResult.ok().value((Object)pageList);
    }

    @RequestMapping(value={"users/getUsersNotYetSyncWxWork"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8fd8\u6ca1\u8fdb\u884c\u5fae\u4fe1\u540c\u6b65\u7684\u7528\u6237", httpMethod="GET", notes="\u83b7\u53d6\u8fd8\u6ca1\u8fdb\u884c\u5fae\u4fe1\u540c\u6b65\u7684\u7528\u6237")
    public List<User> getUsersNotYetSyncWxWork(@RequestParam(value="orgIdList", required=false) List<String> orgIdList, @RequestParam(value="bindType", required=false) String bindType) throws Exception {
        return this.userService.getUsersNotYetSyncWxWork(orgIdList, bindType);
    }

    @RequestMapping(value={"users/getUsersNotYetSyncDingtalk"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8fd8\u6ca1\u8fdb\u884c\u9489\u9489\u7684\u7528\u6237", httpMethod="GET", notes="\u83b7\u53d6\u8fd8\u6ca1\u8fdb\u884c\u9489\u9489\u7684\u7528\u6237")
    public CommonResult<List<User>> getUsersNotYetSyncDingtalk(@RequestParam(value="orgIdList") List<String> orgIdList) throws Exception {
        List<User> userList = this.userService.getUsersNotYetSyncDingtalk(orgIdList);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"getUserByWxWorkId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5fae\u4fe1\u901a\u8baf\u5f55\u7684userid\u83b7\u53d6\u7ed1\u5b9a\u7684\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u5fae\u4fe1\u901a\u8baf\u5f55\u7684userid\u83b7\u53d6\u7ed1\u5b9a\u7684\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f")
    public CommonResult<User> getUserByWxWorkId(@RequestParam(value="wxWorkId", required=true) String wxWorkId) throws Exception {
        User user = this.userService.getUserByWxWorkId(wxWorkId);
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"getUserByDingtalkId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u9489\u9489\u901a\u8baf\u5f55\u7684userid\u83b7\u53d6\u7ed1\u5b9a\u7684\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u9489\u9489\u901a\u8baf\u5f55\u7684userid\u83b7\u53d6\u7ed1\u5b9a\u7684\u7528\u6237\u7684\u7528\u6237\u4fe1\u606f")
    public CommonResult<User> getUserByDingtalkId(@RequestParam(value="dingtalkId", required=true) String dingtalkId) throws Exception {
        User user = this.userService.getUserByDingtalkId(dingtalkId);
        return CommonResult.ok().value((Object)user);
    }

    @RequestMapping(value={"users/queryUserWithMainOrgPost"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u5e26\u5206\u9875\u548c\u4e3b\u7ec4\u7ec7\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5217\u8868\uff08\u5e26\u5206\u9875\u548c\u4e3b\u7ec4\u7ec7\u4fe1\u606f\uff09")
    public PageList<UserSeletorDto> queryUserWithMainOrgPost(@ApiParam(name="isMobile", value="\u662f\u5426\u662f\u624b\u673a\u7aef") @RequestParam Optional<Boolean> isMobile, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        if (isMobile.orElse(false).booleanValue()) {
            return this.userService.queryUserWithOrgPost(queryFilter);
        }
        return this.userService.queryUserWithMainOrgPost(queryFilter);
    }

    @RequestMapping(value={"users/getByCompanyRole"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5728\u6539\u7ec4\u7ec7\u4e0b\u7684\u89d2\u8272\u7528\u6237", httpMethod="GET", notes="\u83b7\u53d6\u5728\u6539\u7ec4\u7ec7\u4e0b\u7684\u89d2\u8272\u7528\u6237")
    public CommonResult<List<User>> getByCompanyRole(@ApiParam(name="company", value="\u7ec4\u7ec7\u7f16\u7801") @RequestParam(required=true) String company, @ApiParam(name="role", value="\u89d2\u8272\u7f16\u7801") @RequestParam(required=true) String role) throws Exception {
        List<User> userList = ((UserManager)this.baseService).getByCompanyRole(company, role);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/getLeaderStep"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u53d1\u8d77\u4eba\u7684\u9012\u5f52\u4e0a\u7ea7", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u53d1\u8d77\u4eba\u7684\u9012\u5f52\u4e0a\u7ea7")
    public CommonResult<List<UserVo>> getLeaderStep(@ApiParam(name="userId", value="\u7528\u6237Id") @RequestParam(required=true) String userId, @ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b") @RequestParam(required=true) Integer grade, @ApiParam(name="res", value="\u662f\u5426\u9700\u8981\u4e0a\u7ea7\u9886\u5bfc") @RequestParam(required=true) boolean res) throws Exception {
        List<UserVo> userVoList = this.userService.getLeaderStep(userId, grade, res);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"users/getFgUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458", httpMethod="GET", notes="\u901a\u8fc7\u7ec4\u7ec7\u4e2d\u7684\u4e0b\u5c5e\u8bbe\u7f6e\u83b7\u53d6\u4e0a\u7ea7\u4eba\u5458")
    public CommonResult<List<User>> getFgUsers(@ApiParam(name="orgId", value="\u7ec4\u7ec7Id", required=true) @RequestParam String orgId, @ApiParam(name="orgParam", value="\u7ec4\u7ec7\u6269\u5c55\u53c2\u6570\u522b\u540d", required=false) @RequestParam String orgParam, @ApiParam(name="userParam", value="\u7528\u6237\u6269\u5c55\u53c2\u6570\u522b\u540d", required=false) @RequestParam String userParam) throws Exception {
        List<User> userList = ((UserManager)this.baseService).getFgUsers(orgId, orgParam, userParam);
        return CommonResult.ok().value(userList);
    }

    @RequestMapping(value={"users/getLeaderStepByOrgId"}, method={RequestMethod.GET}, produces={"application/json;charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u9010\u7ea7\u5ba1\u6279", httpMethod="GET", notes="\u6839\u636e\u7ec4\u7ec7ID\u83b7\u53d6\u9010\u7ea7\u5ba1\u6279")
    public CommonResult<List<UserVo>> getLeaderStepByOrgId(@ApiParam(name="orgId", value="\u7528\u6237Id") @RequestParam(required=true) String orgId, @ApiParam(name="grade", value="\u7ec4\u7ec7\u7ea7\u522b") @RequestParam(required=true) Integer grade) throws Exception {
        List<UserVo> userVoList = this.userService.getLeaderStepByOrgId(orgId, grade);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"user/getUsersByCodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u591a\u4e2a\u7528\u6237code\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)", httpMethod="GET", notes="\u6839\u636e\u591a\u4e2a\u7528\u6237code\u83b7\u53d6\u7528\u6237\u4fe1\u606f(\u4ee5\u9017\u53f7\u9694\u5f00)")
    public CommonResult<List<UserVo>> getUsersByCodes(@ApiParam(name="codes", value="\u7528\u6237codes") @RequestParam(required=true) String codes) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("CODE_", (Object)codes, QueryOP.IN);
        List<UserVo> users = this.userService.queryUser(queryFilter);
        return CommonResult.ok().value(users);
    }

    @RequestMapping(value={"user/getUserByUserId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u5c97\u4f4d\u89d2\u8272\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7528\u6237\u7ec4\u7ec7\u5c97\u4f4d\u89d2\u8272\u4fe1\u606f")
    public CommonResult<List<Map<String, Object>>> getUserByUserId(@ApiParam(name="userId", value="\u7528\u6237id", required=true) @RequestParam String userId) throws Exception {
        List<Map<String, Object>> mapList = ((UserManager)this.baseService).getUserByUserId(userId);
        return CommonResult.ok().value(mapList);
    }
}

