/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.ElectronicSealDao;
import com.hotent.uc.manager.ElectronicSealManager;
import com.hotent.uc.manager.PwdStrategyManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.ElectronicSeal;
import com.hotent.uc.model.PwdStrategy;
import com.hotent.uc.model.User;
import com.hotent.uc.params.seal.ImportSignatureObject;
import com.hotent.uc.params.seal.UserSignature;
import com.hotent.uc.util.ContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="electronicSealManager")
public class ElectronicSealManagerImpl
extends BaseManagerImpl<ElectronicSealDao, ElectronicSeal>
implements ElectronicSealManager {
    @Autowired
    UserManager userManager;
    @Autowired
    PwdStrategyManager pwdStrategyManager;
    @Resource
    ElectronicSealManager electronicSealManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    @Override
    public void setIsUse(String id) {
        super.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"IS_USE_", (Object)1)).eq((Object)"ID_", (Object)id));
    }

    @Override
    @Transactional
    public CommonResult<String> importSignature(ImportSignatureObject signatureData) throws Exception {
        if (BeanUtils.isNotEmpty((Object)signatureData) && BeanUtils.isNotEmpty(signatureData.getSignatureList())) {
            List<UserSignature> list = signatureData.getSignatureList();
            ArrayList<String> accounts = new ArrayList<String>();
            HashMap<String, String> signatureMap = new HashMap<String, String>();
            PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
            for (UserSignature userSignature : list) {
                accounts.add(userSignature.getAccount());
                signatureMap.put(userSignature.getAccount(), userSignature.getFileId());
            }
            QueryFilter filter = QueryFilter.build();
            filter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter.addFilter("ACCOUNT_", accounts, QueryOP.IN);
            filter.addFilter("IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
            PageList page = this.userManager.query(filter);
            List users = page.getRows();
            if (BeanUtils.isNotEmpty((Object)users) && users.size() > 0) {
                boolean isSuccess;
                ArrayList<ElectronicSeal> newSeals = new ArrayList<ElectronicSeal>();
                for (User user : users) {
                    ElectronicSeal seal = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)user.getId())).eq((Object)"IS_USE_", (Object)0)));
                    if (BeanUtils.isNotEmpty((Object)((Object)seal)) && signatureData.isRepeatConver()) {
                        this.setIsUse(seal.getId());
                        newSeals.add(this.getNewSeal(user.getId(), (String)signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
                        continue;
                    }
                    if (!BeanUtils.isEmpty((Object)((Object)seal))) continue;
                    newSeals.add(this.getNewSeal(user.getId(), (String)signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
                }
                if (BeanUtils.isNotEmpty(newSeals) && !(isSuccess = this.saveBatch(newSeals))) {
                    throw new RuntimeException("\u7b7e\u7ae0\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff01");
                }
            }
        }
        return new CommonResult(true, "\u5904\u7406\u6210\u529f\uff01");
    }

    @Override
    public CommonResult<String> saveElectronicSeal(ElectronicSeal electronicSeal) throws Exception {
        String currentUserId;
        ElectronicSeal seal;
        String msg = "\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f";
        if (StringUtil.isEmpty((String)electronicSeal.getUserId()) && StringUtil.isNotEmpty((String)electronicSeal.getAccount())) {
            User user = this.userManager.getByAccount(electronicSeal.getAccount());
            electronicSeal.setUserId(user.getId());
        }
        if (BeanUtils.isEmpty((Object)((Object)(seal = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)(currentUserId = electronicSeal.getUserId()))).eq((Object)"IS_USE_", (Object)0))))))) {
            electronicSeal.setIsUse(0);
            electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            this.create((Model)electronicSeal);
        } else {
            this.setIsUse(seal.getId());
            ElectronicSeal electronicSealNew = new ElectronicSeal();
            electronicSealNew.setUserId(electronicSeal.getUserId());
            electronicSealNew.setIsUse(0);
            electronicSealNew.setFileId(electronicSeal.getFileId());
            if (StringUtil.isEmpty((String)electronicSeal.getPassword())) {
                ElectronicSeal electronicSealOld = (ElectronicSeal)this.get((Serializable)((Object)electronicSeal.getId()));
                electronicSealNew.setPassword(electronicSealOld.getPassword());
            } else {
                electronicSealNew.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            }
            this.create((Model)electronicSealNew);
        }
        return CommonResult.ok().value((Object)msg);
    }

    @Override
    public CommonResult<String> userSaveElectronicSeal(ElectronicSeal electronicSeal) throws Exception {
        String msg = "\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f";
        User user = ContextUtil.getCurrentUser();
        if (!user.getPassword().equals(this.passwordEncoder.encode((CharSequence)electronicSeal.getOldPassWord()))) {
            return new CommonResult(false, "\u60a8\u8f93\u5165\u7684\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isEmpty((String)electronicSeal.getId())) {
            electronicSeal.setIsUse(0);
            electronicSeal.setUserId(user.getId());
            electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
            this.create((Model)electronicSeal);
        } else {
            if (StringUtil.isEmpty((String)electronicSeal.getOldPassWord())) {
                return new CommonResult(false, "\u8bf7\u8f93\u5165\u767b\u5f55\u5bc6\u7801");
            }
            ElectronicSeal seal = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)user.getId())).eq((Object)"IS_USE_", (Object)0)));
            if (BeanUtils.isNotEmpty((Object)((Object)seal))) {
                this.setIsUse(electronicSeal.getId());
                ElectronicSeal electronicSealNew = new ElectronicSeal();
                electronicSealNew.setUserId(user.getId());
                electronicSealNew.setIsUse(0);
                electronicSealNew.setFileId(electronicSeal.getFileId());
                if (StringUtil.isNotEmpty((String)electronicSeal.getPassword())) {
                    electronicSealNew.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
                } else {
                    electronicSealNew.setPassword(seal.getPassword());
                }
                this.create((Model)electronicSealNew);
            } else {
                return new CommonResult(false, "\u672a\u83b7\u53d6\u5230\u6b63\u5728\u4f7f\u7528\u7684\u7b7e\u7ae0\u3002");
            }
        }
        return new CommonResult(true, msg);
    }

    @Override
    public CommonResult<String> mobileUpdateElectronicSeal(ElectronicSeal electronicSeal) throws Exception {
        if (StringUtil.isEmpty((String)electronicSeal.getPassword())) {
            return new CommonResult(false, "\u8bf7\u8f93\u5165\u7b7e\u7ae0\u5bc6\u7801");
        }
        User user = ContextUtil.getCurrentUser();
        ElectronicSeal electronicSealOld = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)user.getId())));
        if (BeanUtils.isNotEmpty((Object)((Object)electronicSealOld))) {
            if (!user.getPassword().equals(this.passwordEncoder.encode((CharSequence)electronicSeal.getOldPassWord()))) {
                return new CommonResult(false, "\u60a8\u8f93\u5165\u7684\u767b\u5f55\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u4e0d\u53ef\u66f4\u65b0\u7b7e\u7ae0");
            }
        } else {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u7b7e\u7ae0\uff0c\u8bf7\u5728\u5e94\u7528\u7aef\u6dfb\u52a0\u7b7e\u7ae0\u540e\uff0c\u65b9\u53ef\u4f7f\u7528");
        }
        electronicSealOld.setIsUse(1);
        this.update((Model)electronicSealOld);
        electronicSeal.setUserId(user.getId());
        electronicSeal.setIsUse(0);
        electronicSeal.setPassword(this.encryptSealPassword(electronicSeal.getPassword()));
        this.create((Model)electronicSeal);
        return new CommonResult(true, "\u66f4\u65b0\u7b7e\u7ae0\u6210\u529f");
    }

    @Override
    public ElectronicSeal getCurrentUserSeal() {
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return null;
        }
        electronicSeal.setPassword("");
        return electronicSeal;
    }

    @Override
    public CommonResult<String> getUser(Optional<String> password, Optional<Boolean> secretFree) throws Exception {
        boolean isSecretFree = secretFree.orElse(false);
        if (!isSecretFree && StringUtil.isEmpty((String)password.get())) {
            return new CommonResult(false, "\u8bf7\u8f93\u5165\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801");
        }
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return new CommonResult(false, "\u60a8\u8fd8\u672a\u8bbe\u7f6e\u7b7e\u7ae0\uff0c\u8bf7\u5728\u4e2a\u4eba\u4fe1\u606f\u4e2d\u8bbe\u7f6e\u60a8\u7684\u7b7e\u7ae0");
        }
        if (!isSecretFree && !electronicSeal.getPassword().equals(this.encryptSealPassword(password.get()))) {
            return new CommonResult(false, "\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)electronicSeal.getFileId());
    }

    private ElectronicSeal getNewSeal(String userId, String fileId, String pwd) throws Exception {
        ElectronicSeal newSeal = new ElectronicSeal();
        newSeal.setId(UniqueIdUtil.getSuid());
        newSeal.setIsUse(0);
        newSeal.setUserId(userId);
        newSeal.setFileId(fileId);
        newSeal.setPassword(EncryptUtil.encrypt((String)pwd));
        return newSeal;
    }

    private String encryptSealPassword(String blankPswd) throws Exception {
        return EncryptUtil.encrypt((String)blankPswd);
    }
}

