/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.OrgAuthDao;
import com.hotent.uc.dto.DemensionListDTO;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgAuth;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.org.OrgAuthVo;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgAuthManagerImpl
extends BaseManagerImpl<OrgAuthDao, OrgAuth>
implements OrgAuthManager {
    @Autowired
    OrgManager orgService;
    @Autowired
    UserManager userService;
    @Autowired
    DemensionManager demService;

    @Override
    public IPage<OrgAuth> getAllOrgAuth(QueryFilter<OrgAuth> queryFilter) throws Exception {
        PageBean pageBean = queryFilter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = this.convert2IPage(pageBean);
        }
        queryFilter.addFilter("a.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("b.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("c.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        DemensionListDTO demensionListDTO = this.removeParamAndQueryDemension(queryFilter);
        if (demensionListDTO.noData()) {
            return page.setRecords(OrgAuthManagerImpl.getEmptyAuthPageList(pageBean).getRows());
        }
        IPage<OrgAuth> result = ((OrgAuthDao)this.baseMapper).getAllOrgAuth((IPage<OrgAuth>)page, (Wrapper<OrgAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        this.assignment(demensionListDTO, result.getRecords());
        return result;
    }

    @Override
    public OrgAuth getByOrgIdAndUserId(String orgId, String userId) {
        Demension demension;
        OrgAuth orgAuth = ((OrgAuthDao)this.baseMapper).getByOrgIdAndUserId(orgId, userId);
        if (orgAuth != null && StringUtil.isNotEmpty((String)orgAuth.getDemId()) && (demension = (Demension)this.demService.get((Serializable)((Object)orgAuth.getDemId()))) != null) {
            orgAuth.setDemCode(demension.getDemCode());
            orgAuth.setDemName(demension.getDemName());
        }
        return orgAuth;
    }

    @Override
    public List<OrgAuth> getListByOrgIdAndUserId(String orgId, String userId) {
        List<OrgAuth> list = ((OrgAuthDao)this.baseMapper).getListByOrgIdAndUserId(orgId, userId);
        this.assignment(null, list);
        return list;
    }

    @Override
    public List<OrgAuth> getLayoutOrgAuth(String userId) {
        List<OrgAuth> list = ((OrgAuthDao)this.baseMapper).getLayoutOrgAuth(userId);
        this.assignment(null, list);
        return list;
    }

    @Override
    public List<OrgAuth> getByUserId(String userId) {
        List<OrgAuth> groupAuthList = ((OrgAuthDao)this.baseMapper).getByUserId(userId);
        this.assignment(null, groupAuthList);
        ArrayList<OrgAuth> authList = new ArrayList<OrgAuth>();
        for (OrgAuth auth : groupAuthList) {
            boolean isChild = false;
            for (OrgAuth groupAuth : groupAuthList) {
                boolean flag1 = !auth.getId().equals(groupAuth.getId()) && auth.getDemId().equals(groupAuth.getDemId()) && auth.getOrgPath().startsWith(groupAuth.getOrgPath());
                if (!flag1) continue;
                isChild = true;
            }
            if (isChild) continue;
            authList.add(auth);
        }
        return authList;
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgAuth(OrgAuthVo orgAuthVo) throws Exception {
        String[] accounts;
        if (StringUtil.isEmpty((String)orgAuthVo.getAccount())) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getOrgCode())) {
            throw new RequiredException("\u6dfb\u52a0\u5206\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010orgCode\u3011\u5fc5\u586b\uff01");
        }
        for (String account : accounts = orgAuthVo.getAccount().split(",")) {
            OrgAuth orgAuth = this.getOrgAuthCheck(account, orgAuthVo.getOrgCode(), orgAuthVo, "");
            if (!BeanUtils.isNotEmpty((Object)orgAuth)) continue;
            orgAuth.setId(UniqueIdUtil.getSuid());
            this.create((Model)orgAuth);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u5206\u7ea7\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrgAuth(OrgAuthVo orgAuthVo) throws Exception {
        if (StringUtil.isEmpty((String)orgAuthVo.getAccount())) {
            throw new RequiredException("\u66f4\u65b0\u5206\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff0c\u7528\u6237\u8d26\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getOrgCode())) {
            throw new RequiredException("\u66f4\u65b0\u5206\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010orgCode\u3011\u5fc5\u586b\uff01");
        }
        OrgAuth orgAuth = this.getOrgAuthCheck(orgAuthVo.getAccount(), orgAuthVo.getOrgCode(), null, orgAuthVo.getNewAccount());
        orgAuth.setOrgPerms(orgAuthVo.getOrgPerms());
        orgAuth.setUserPerms(orgAuthVo.getUserPerms());
        orgAuth.setPosPerms(orgAuthVo.getPosPerms());
        orgAuth.setOrgauthPerms(orgAuthVo.getOrgauthPerms());
        orgAuth.setLayoutPerms(orgAuthVo.getLayoutPerms());
        this.update((Model)orgAuth);
        return new CommonResult(true, "\u66f4\u65b0\u5206\u7ea7\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delOrgAuth(String account, String orgCode) throws Exception {
        OrgAuth orgAuth = this.getOrgAuthCheck(account, orgCode, null, "");
        this.remove((Serializable)((Object)orgAuth.getId()));
        return new CommonResult(true, "\u5220\u9664\u5206\u7ea7\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public OrgAuth getOrgAuth(String account, String orgCode) throws Exception {
        OrgAuth orgAuth = this.getOrgAuthCheck(account, orgCode, null, "");
        return orgAuth;
    }

    private OrgAuth getOrgAuthCheck(String account, String orgCode, OrgAuthVo orgAuthVo, String newAccount) throws Exception {
        User user = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        OrgAuth orgAuth = this.getByOrgIdAndUserId(org.getId(), user.getId());
        if (BeanUtils.isNotEmpty((Object)orgAuthVo)) {
            if (BeanUtils.isNotEmpty((Object)orgAuth)) {
                return null;
            }
            Demension dem = this.demService.getByCode(orgAuthVo.getDemCode());
            if (BeanUtils.isEmpty((Object)dem)) {
                throw new RequiredException("\u7f16\u7801\u3010" + orgAuthVo.getDemCode() + "\u3011\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff01");
            }
            if (!org.getDemId().equals(dem.getId())) {
                throw new RequiredException("\u8f93\u5165\u7684\u7ef4\u5ea6\u4e0e\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff01");
            }
            orgAuth = OrgAuthVo.parse(orgAuthVo);
            orgAuth.setOrgId(org.getId());
            orgAuth.setDemId(org.getDemId());
            orgAuth.setUserId(user.getId());
        } else {
            if (BeanUtils.isEmpty((Object)orgAuth)) {
                throw new RequiredException("\u6839\u636e\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u5206\u7ea7\u7ec4\u7ec7\uff01");
            }
            if (StringUtil.isNotEmpty((String)newAccount) && !newAccount.equals(account)) {
                User newuser = this.userService.getByAccount(newAccount);
                if (BeanUtils.isEmpty((Object)newuser)) {
                    throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + newAccount + "\u3011\u4e0d\u5b58\u5728\uff01");
                }
                OrgAuth orgAuth1 = this.getByOrgIdAndUserId(org.getId(), newuser.getId());
                if (BeanUtils.isNotEmpty((Object)orgAuth1)) {
                    throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + newAccount + "\u3011\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u7684\u5206\u7ea7\u7ec4\u7ec7\u5df2\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u5462\u5176\u5b83\u7528\u6237\uff01");
                }
                orgAuth.setUserAccount(newAccount);
                orgAuth.setUserId(newuser.getId());
                orgAuth.setUserName(newuser.getFullname());
            }
        }
        return orgAuth;
    }

    @Override
    public List<OrgAuth> getOrgAuthListByDemAndUser(String demCode, String account) throws Exception {
        if (StringUtil.isEmpty((String)demCode) || StringUtil.isEmpty((String)account)) {
            throw new RequiredException("\u7528\u6237\u8d26\u53f7\u6216\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Demension demension = this.demService.getByCode(demCode);
        if (demension == null) {
            return new ArrayList<OrgAuth>();
        }
        List<OrgAuth> list = ((OrgAuthDao)this.baseMapper).getOrgAuthListByUser(account);
        this.assignment(null, list);
        return list;
    }

    @Override
    public List<OrgAuth> getOrgAuthByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return ((OrgAuthDao)this.baseMapper).queryOnSync((Wrapper<OrgAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((OrgAuthDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public PageList<OrgAuth> queryOrgAuth(QueryFilter<OrgAuth> filter) {
        PageList<OrgAuth> query = this.query(filter);
        return query;
    }

    @Override
    public PageList<OrgAuth> getOrgAuthPage(QueryFilter filter, String orgCode, String account) throws Exception {
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            return new PageList();
        }
        filter.addFilter("a.ORG_ID_", (Object)org.getId(), QueryOP.EQUAL, FieldRelation.AND);
        if (StringUtil.isNotEmpty((String)account)) {
            User user = this.userService.getByAccount(account);
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RequiredException("\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            filter.addFilter("a.USER_ID_", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
        }
        return this.queryOrgAuth((QueryFilter<OrgAuth>)filter);
    }

    @Override
    public List<OrgAuth> getCurrentUserAuthOrgLayout(Optional<String> userId) throws Exception {
        String uId = userId.orElse(null);
        uId = StringUtil.isEmpty((String)uId) ? this.userService.getByAccount(ContextUtil.getCurrentUser().getAccount()).getUserId() : uId;
        List<OrgAuth> orgAuthList = this.getLayoutOrgAuth(uId);
        return orgAuthList;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgAuthDao)this.baseMapper).removePhysical();
    }

    @Transactional(readOnly=true)
    public PageList<OrgAuth> query(QueryFilter<OrgAuth> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        queryFilter.addFilter("a.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("b.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("c.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        DemensionListDTO demensionListDTO = this.removeParamAndQueryDemension(queryFilter);
        if (demensionListDTO.noData()) {
            return OrgAuthManagerImpl.getEmptyAuthPageList(pageBean);
        }
        IPage<OrgAuth> result = ((OrgAuthDao)this.baseMapper).query((IPage<OrgAuth>)this.convert2IPage(pageBean), (Wrapper<OrgAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        this.assignment(demensionListDTO, result.getRecords());
        return new PageList(result);
    }

    private void assignment(DemensionListDTO demensionListDTO, List<OrgAuth> result) {
        Set demIds;
        List demensionList;
        List list = demensionList = demensionListDTO == null ? null : demensionListDTO.getDemensionList();
        if (BeanUtils.isEmpty(demensionList) && BeanUtils.isNotEmpty(result) && BeanUtils.isNotEmpty(demIds = result.stream().map(OrgAuth::getDemId).filter(StringUtil::isNotEmpty).collect(Collectors.toSet()))) {
            demensionList = this.demService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Demension::getId, demIds)).ne(UcBaseModel::getIsDelete, (Object)"1"));
        }
        if (demensionList == null) {
            return;
        }
        Map<String, Demension> demensionMap = demensionList.stream().collect(Collectors.toMap(Demension::getId, demension -> demension));
        for (OrgAuth orgAuth : result) {
            if (!StringUtil.isNotEmpty((String)orgAuth.getDemId()) || !demensionMap.containsKey(orgAuth.getDemId())) continue;
            orgAuth.setDemCode(demensionMap.get(orgAuth.getDemId()).getDemCode());
            orgAuth.setDemName(demensionMap.get(orgAuth.getDemId()).getDemName());
        }
    }

    private static PageList<OrgAuth> getEmptyAuthPageList(PageBean pageBean) {
        PageList orgAuthPageList = new PageList();
        orgAuthPageList.setRows(new ArrayList());
        if (pageBean == null) {
            pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(10));
        }
        orgAuthPageList.setTotal(0L);
        orgAuthPageList.setPageSize((long)pageBean.getPageSize().intValue());
        orgAuthPageList.setPage((long)pageBean.getPage().intValue());
        return orgAuthPageList;
    }

    private DemensionListDTO removeParamAndQueryDemension(QueryFilter<OrgAuth> queryFilter) {
        List demensionList = null;
        boolean flag = false;
        QueryFilter build = QueryFilter.build();
        HashSet<String> ignoreSet = new HashSet<String>(Arrays.asList("demcode", "dem_code_", "demname", "dem_name_", "demdesc", "dem_desc_"));
        List querys = queryFilter.getQuerys();
        for (int i = querys.size() - 1; i >= 0; --i) {
            String property = ((QueryField)querys.get(i)).getProperty();
            if (!property.toLowerCase().startsWith("d.") && !ignoreSet.contains(property.toLowerCase())) continue;
            flag = true;
            ((QueryField)querys.get(i)).setProperty(property.replace("d.", ""));
            build.addQueryField((QueryField)querys.get(i));
            querys.remove(i);
        }
        if (flag) {
            build.addFilter("IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
            demensionList = this.demService.queryNoPage(build);
            List demIds = demensionList.stream().map(Demension::getId).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(demIds)) {
                queryFilter.addQueryField(new QueryField("a.dem_id_", demIds, QueryOP.IN));
            }
        }
        return new DemensionListDTO(flag, demensionList);
    }
}

