/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.OrgJobDao;
import com.hotent.uc.dao.OrgPostDao;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgJobRelationManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgJobRelation;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import com.hotent.uc.params.job.JobVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgJobManagerImpl
extends BaseManagerImpl<OrgJobDao, OrgJob>
implements OrgJobManager {
    @Autowired
    OrgPostDao orgPostDao;
    @Autowired
    UserManager userService;
    @Resource
    OrgPostManager orgPostManager;
    @Resource
    OrgJobRelationManager orgJobRelationManager;
    @Resource
    OrgUserManager orgUserManager;

    @Override
    public OrgJob getByCode(String code) {
        return ((OrgJobDao)this.baseMapper).getByCode(code);
    }

    public OrgJob getById(Serializable id) {
        return (OrgJob)((OrgJobDao)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OrgJob::getId, (Object)id)).ne(UcBaseModel::getIsDelete, (Object)"1"));
    }

    @Override
    public List<OrgJob> getByName(String name) {
        return ((OrgJobDao)this.baseMapper).getByName(name);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            List<OrgPost> relList = this.orgPostDao.getByReldefId(id);
            OrgJob reldef = this.getById((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty(relList)) continue;
            ThreadMsgUtil.addMsg((String)(reldef.getName() + "\u5df2\u4e0e\u5c97\u4f4d\u5173\u8054\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        if (StringUtil.isEmpty((String)ThreadMsgUtil.getMessage((boolean)false))) {
            super.removeByIds(ids);
        }
    }

    @Override
    public List<OrgJob> getListByUserId(String userId) {
        ArrayList<OrgJob> OrgJobs = new ArrayList<OrgJob>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgPost> orgPosts = this.orgPostManager.getRelListByParam(map);
        for (OrgPost orgPost : orgPosts) {
            OrgJob OrgJob2 = (OrgJob)this.get((Serializable)((Object)orgPost.getRelDefId()));
            if (OrgJob2 == null) continue;
            OrgJobs.add(OrgJob2);
        }
        List<OrgUser> orgUserMaster = this.orgUserManager.getListByOrgIdUserId(null, userId);
        for (OrgUser orgUser : orgUserMaster) {
            OrgJob OrgJob3;
            if (!StringUtil.isNotEmpty((String)orgUser.getJobId()) || (OrgJob3 = (OrgJob)this.get((Serializable)((Object)orgUser.getJobId()))) == null) continue;
            OrgJobs.add(OrgJob3);
        }
        OrgUtil.removeDuplicate(OrgJobs, "code");
        return OrgJobs;
    }

    @Override
    public List<OrgJob> getListByAccount(String account) {
        ArrayList<OrgJob> OrgJobs = new ArrayList<OrgJob>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", account);
        List<OrgPost> orgPosts = this.orgPostManager.getRelListByParam(map);
        if (BeanUtils.isEmpty(orgPosts)) {
            return OrgJobs;
        }
        for (OrgPost orgPost : orgPosts) {
            OrgJob OrgJob2 = (OrgJob)this.get((Serializable)((Object)orgPost.getRelDefId()));
            OrgJobs.add(OrgJob2);
        }
        return OrgJobs;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> addJob(JobVo jobVo) throws Exception {
        if (StringUtil.isEmpty((String)jobVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u804c\u52a1\u5931\u8d25\uff0c\u804c\u52a1\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)jobVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u804c\u52a1\u5931\u8d25\uff0c\u804c\u52a1\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (jobVo.getCode().contains(",")) {
            throw new RuntimeException("\u804c\u52a1\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (((OrgJobDao)this.baseMapper).getCountByCode(jobVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u804c\u52a1\u5931\u8d25\uff0c\u804c\u52a1\u7f16\u7801\u3010" + jobVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        OrgJob job = (OrgJob)BeanUtil.copyProperties((Object)jobVo, OrgJob.class, (String[])new String[0]);
        job.setId(UniqueIdUtil.getSuid());
        this.create((Model)job);
        this.saveOrgJob(jobVo.getOrgId(), job.getId());
        return new CommonResult(true, "\u6dfb\u52a0\u804c\u52a1\u6210\u529f\uff01", (Object)"");
    }

    private void saveOrgJob(String orgId, String jobId) {
        if (StringUtil.isEmpty((String)orgId)) {
            return;
        }
        OrgJobRelation orgJobRelation = new OrgJobRelation();
        orgJobRelation.setOrgId(orgId);
        orgJobRelation.setJobId(jobId);
        this.orgJobRelationManager.create((Model)orgJobRelation);
    }

    @Override
    @Transactional
    public CommonResult<String> deleteJob(String codes) throws Exception {
        String msg;
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        StringBuilder posStr = new StringBuilder();
        boolean isTrue = true;
        for (String code : codeArray) {
            OrgJob job = this.getByCode(code);
            if (BeanUtils.isNotEmpty((Object)job)) {
                List<OrgPost> orgPosts = this.orgPostDao.getByReldefId(job.getId());
                if (BeanUtils.isEmpty(orgPosts)) {
                    this.remove((Serializable)((Object)job.getId()));
                    continue;
                }
                posStr.append(code);
                posStr.append("\uff0c");
                isTrue = false;
                continue;
            }
            isTrue = false;
            str.append(code);
            str.append("\uff0c");
        }
        String string = msg = isTrue ? "\u5220\u9664\u804c\u52a1\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c";
        if (!isTrue) {
            if (str.length() > 0) {
                msg = msg + "\u804c\u52a1\u7f16\u7801\u3010" + str.toString().substring(0, str.length() - 1) + "\u3011\u4e0d\u5b58\u5728\uff01";
            }
            if (posStr.length() > 0) {
                msg = msg + "\u804c\u52a1\u7f16\u7801\u3010" + posStr.toString().substring(0, posStr.length() - 1) + "\u3011\u4e0b\u5b58\u5728\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
            }
        }
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteJobByIds(String ids) {
        String msg;
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        StringBuilder posStr = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            OrgJob job = (OrgJob)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)job)) {
                List<OrgPost> orgPosts = this.orgPostDao.getByReldefId(job.getId());
                if (BeanUtils.isEmpty(orgPosts)) {
                    this.remove((Serializable)((Object)job.getId()));
                    continue;
                }
                posStr.append(job.getName());
                posStr.append("\uff0c");
                isTrue = false;
                continue;
            }
            isTrue = false;
            str.append(job.getName());
            str.append("\uff0c");
        }
        String string = msg = isTrue ? "\u5220\u9664\u804c\u52a1\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c";
        if (!isTrue) {
            if (str.length() > 0) {
                msg = msg + "\u804c\u52a1\u7f16\u7801\u3010" + str.toString().substring(0, str.length() - 1) + "\u3011\u4e0d\u5b58\u5728\uff01";
            }
            if (posStr.length() > 0) {
                msg = msg + "\u804c\u52a1\u7f16\u7801\u3010" + posStr.toString().substring(0, posStr.length() - 1) + "\u3011\u4e0b\u5b58\u5728\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01";
            }
        }
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateJob(JobVo jobVo) throws Exception {
        if (StringUtil.isEmpty((String)jobVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u804c\u52a1\u5931\u8d25\uff0c\u804c\u52a1\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        OrgJob job = this.getByCode(jobVo.getCode());
        if (BeanUtils.isEmpty((Object)job)) {
            return new CommonResult(false, "\u66f4\u65b0\u804c\u52a1\u5931\u8d25\uff0c\u804c\u52a1\u7f16\u7801\u3010" + jobVo.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)jobVo.getName())) {
            job.setName(jobVo.getName());
        }
        if (jobVo.getDescription() != null) {
            job.setDescription(jobVo.getDescription());
        }
        if (jobVo.getPostLevel() != null) {
            job.setPostLevel(jobVo.getPostLevel());
        }
        this.update((Model)job);
        return new CommonResult(true, "\u66f4\u65b0\u804c\u52a1\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<UserVo> getUsersByJob(String codes) throws Exception {
        String[] codeArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String code : codeArray = codes.split(",")) {
            OrgJob job = this.getByCode(code);
            String jobId = "";
            jobId = BeanUtils.isNotEmpty((Object)job) ? job.getId() : code;
            List<User> users = this.userService.getListByJobId(jobId);
            if (!BeanUtils.isNotEmpty(users)) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public List<OrgJob> getJobByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        OrgJob job = ((OrgJobDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)job)) ? "\u8be5\u804c\u52a1\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgJobDao)this.baseMapper).removePhysical();
    }

    @Override
    public boolean insertBatch(List<OrgJob> list) {
        return this.saveBatch(list);
    }

    @Override
    public OrgJob getJob(String code) throws Exception {
        OrgJob job = this.getByCode(code);
        if (BeanUtils.isEmpty((Object)job)) {
            job = (OrgJob)this.get((Serializable)((Object)code));
        }
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u3010" + code + "\u3011\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        return job;
    }

    @Override
    public OrgJob getOrgJob(String code) throws Exception {
        OrgJob job = this.getByCode(code);
        if (BeanUtils.isEmpty((Object)job)) {
            job = (OrgJob)this.get((Serializable)((Object)code));
        }
        return job;
    }

    @Override
    public PageList<OrgJob> queryJobs(QueryFilter<OrgJob> queryFilter) {
        return new PageList(((OrgJobDao)this.baseMapper).queryJobs((IPage<OrgJob>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<OrgJob>)this.convert2Wrapper(queryFilter, this.getCurrentModelClass())));
    }

    @Override
    public void fillJobToData(List<Map<String, Object>> records) {
        List orgJobs;
        records.forEach(record -> {
            if (BeanUtils.isEmpty((Object)MapUtil.getIgnoreCase((Map)record, (String)"jobId")) && BeanUtils.isNotEmpty((Object)MapUtil.getIgnoreCase((Map)record, (String)"postJobId"))) {
                record.put("jobId", MapUtil.getIgnoreCase((Map)record, (String)"postJobId"));
            }
        });
        Map<Object, Object> jobMap = new HashMap();
        List jobIds = records.stream().filter(item -> BeanUtils.isNotEmpty(item.get("jobId"))).map(map -> map.get("jobId").toString()).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(jobIds) && BeanUtils.isNotEmpty((Object)(orgJobs = this.listByIds(jobIds)))) {
            jobMap = orgJobs.stream().collect(Collectors.toMap(OrgJob::getId, job -> job));
        }
        for (Map<String, Object> data : records) {
            if (!BeanUtils.isNotEmpty((Object)data.get("jobId")) || !jobMap.containsKey(data.getOrDefault("jobId", "").toString())) continue;
            data.put("jobName", ((OrgJob)jobMap.get(data.get("jobId").toString())).getName());
        }
    }

    @Override
    public List<OrgJob> getByIdsOrCodes(String idsOrCodes) {
        if (BeanUtils.isEmpty((Object)idsOrCodes)) {
            return new ArrayList<OrgJob>();
        }
        List idOrCodeList = Stream.of(idsOrCodes.split(",")).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(OrgJob::getId, idOrCodeList)).or()).in(OrgJob::getCode, idOrCodeList);
        return this.list((Wrapper)wrapper);
    }
}

