/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.OrgParamsDao;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.model.OrgParams;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgParamsManagerImpl
extends BaseManagerImpl<OrgParamsDao, OrgParams>
implements OrgParamsManager {
    @Override
    public List<OrgParams> getByOrgId(String id) {
        return ((OrgParamsDao)this.baseMapper).getByOrgId(id);
    }

    @Override
    @Transactional
    public void saveParams(String orgId, List<ObjectNode> lists) {
        for (ObjectNode ObjectNode2 : lists) {
            String alias = ObjectNode2.get("alias").asText();
            OrgParams params = this.getByOrgIdAndAlias(orgId, alias);
            if (BeanUtils.isNotEmpty((Object)params)) {
                this.remove((Serializable)((Object)params.getId()));
            }
            OrgParams orgParams = new OrgParams();
            orgParams.setAlias(alias);
            orgParams.setValue(JsonUtil.getString((JsonNode)ObjectNode2, (String)"value"));
            orgParams.setOrgId(orgId);
            orgParams.setId(UniqueIdUtil.getSuid());
            this.create((Model)orgParams);
        }
    }

    @Override
    public OrgParams getByOrgIdAndAlias(String groupId, String key) {
        return ((OrgParamsDao)this.baseMapper).getByOrgIdAndAlias(groupId, key);
    }

    @Override
    @Transactional
    public void removeByOrgId(String orgId) {
        ((OrgParamsDao)this.baseMapper).removeByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgParamsDao)this.baseMapper).removePhysical();
    }
}

