/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.google.common.collect.Lists;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.context.BaseContext;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CacheEvictUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.uc.dao.OrgUserDao;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgJobRelationManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserUnderManager;
import com.hotent.uc.manager.impl.RoleManagerImpl;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgJobRelation;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import com.hotent.uc.params.org.OrgJobUserParam;
import com.hotent.uc.params.user.UserPolymerOrgPos;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import poi.easypoi.util.ExcelUtils;
import poi.util.ExcelUtil;

@Service
public class OrgUserManagerImpl
extends BaseManagerImpl<OrgUserDao, OrgUser>
implements OrgUserManager {
    protected Logger logger = LoggerFactory.getLogger(OrgUserManagerImpl.class);
    @Autowired
    DemensionManager demensionManager;
    @Autowired
    OrgManager orgService;
    @Autowired
    BaseContext baseContext;
    @Resource
    UserManager userManager;
    @Resource
    OrgPostManager orgPostManager;
    @Resource
    OrgJobManager orgJobManager;
    @Resource
    OrgJobRelationManager orgJobRelationManager;

    @Override
    @Transactional
    public int updateUserPost(String id, String relId) {
        return ((OrgUserDao)this.baseMapper).updateUserPost(id, relId, LocalDateTime.now());
    }

    @Override
    public OrgUser getOrgUser(String orgId, String userId, String relId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("userId", userId);
        if (StringUtil.isEmpty((String)relId)) {
            params.put("relIdNull", "");
        } else {
            params.put("relId", relId);
        }
        if (BeanUtils.isEmpty(((OrgUserDao)this.baseMapper).getByParms(params))) {
            return null;
        }
        return ((OrgUserDao)this.baseMapper).getByParms(params).get(0);
    }

    @Override
    public List<OrgUser> getListByOrgIdUserId(String orgId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("userId", userId);
        return ((OrgUserDao)this.baseMapper).getByParms(map);
    }

    @Override
    @Transactional
    public int removeByOrgIdUserId(String orgId, String userId) {
        return ((OrgUserDao)this.baseMapper).removeByOrgIdUserId(orgId, userId, LocalDateTime.now());
    }

    @Override
    @Transactional
    public void setMaster(String ... id) throws SQLException {
        OrgUserManager orgUserManager = (OrgUserManager)AppUtil.getBean(OrgUserManager.class);
        for (String i : id) {
            OrgUser orgUser = (OrgUser)this.get((Serializable)((Object)i));
            orgUserManager.removeUserMainOrgCache(orgUser.getUserId());
            orgUserManager.removeUserMainOrgCache("", orgUser.getUserId());
            if (orgUser.getIsMaster() == 0) {
                Org org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId()));
                List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getOrgUserMaster(orgUser.getUserId(), null);
                if (BeanUtils.isNotEmpty(orgUsers)) {
                    ((OrgUserDao)this.baseMapper).cancelUserMasterOrg(orgUser.getUserId(), org.getDemId(), LocalDateTime.now());
                }
                ((OrgUserDao)this.baseMapper).updateUserMasterOrg(i, LocalDateTime.now());
                continue;
            }
            orgUser.setIsMaster(0);
            this.update((Model)orgUser);
        }
    }

    @Override
    public List<OrgUser> getOrgUserMaster(String userId, String demId) {
        if (StringUtil.isNotEmpty((String)demId)) {
            Demension sysDemension = (Demension)this.demensionManager.get((Serializable)((Object)demId));
            if (BeanUtils.isEmpty((Object)sysDemension) && BeanUtils.isNotEmpty((Object)(sysDemension = this.demensionManager.getByCode(demId)))) {
                demId = sysDemension.getId();
            }
        } else {
            Demension sysDemension = this.demensionManager.getDefaultDemension();
            if (BeanUtils.isNotEmpty((Object)sysDemension)) {
                demId = sysDemension.getId();
            }
        }
        return ((OrgUserDao)this.baseMapper).getOrgUserMaster(userId, demId);
    }

    @Override
    public IPage<HashMap<String, Object>> getUserByGroup(QueryFilter queryFilter) {
        IPage<HashMap<String, Object>> userByGroup;
        List records;
        PageBean pageBean = queryFilter.getPageBean();
        IPage convert2iPage = this.convert2IPage(pageBean);
        if (queryFilter.getParams().containsKey("orgId")) {
            queryFilter.addFilter("org.ID_", queryFilter.getParams().get("orgId"), QueryOP.EQUAL);
        }
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        if (BeanUtils.isEmpty((Object)queryFilter.getSorter())) {
            ArrayList fieldSorts = Lists.newArrayList();
            fieldSorts.add(new FieldSort("orguser.ID_", Direction.DESC));
            queryFilter.setSorter((List)fieldSorts);
        }
        if (BeanUtils.isNotEmpty((Object)(records = (userByGroup = ((OrgUserDao)this.baseMapper).getUserByGroup((IPage<OrgUser>)convert2iPage, (Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords()))) {
            List orgPosts;
            List relIds = records.stream().filter(map -> map.containsKey("relId") && BeanUtils.isNotEmpty(map.get("relId"))).map(map -> map.get("relId").toString()).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(relIds) && BeanUtils.isNotEmpty((Object)(orgPosts = this.orgPostManager.listByIds(relIds)))) {
                Map<String, OrgPost> orgPostMap = orgPosts.stream().collect(Collectors.toMap(OrgPost::getId, orgPost -> orgPost));
                for (HashMap record : records) {
                    if (!record.containsKey("relId") || !orgPostMap.containsKey(record.get("relId").toString())) continue;
                    record.put("relName", orgPostMap.get(record.get("relId").toString()).getName());
                    record.put("postCode", orgPostMap.get(record.get("relId").toString()).getCode());
                }
            }
            userByGroup.setRecords(records);
        }
        return userByGroup;
    }

    @Override
    public IPage<HashMap<String, Object>> getUserByGroupPost(QueryFilter queryFilter) {
        if (queryFilter.getParams().containsKey("orgId")) {
            queryFilter.addFilter("org.ID_", queryFilter.getParams().get("orgId"), QueryOP.EQUAL);
        }
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        if (BeanUtils.isEmpty((Object)queryFilter.getSorter())) {
            ArrayList fieldSorts = Lists.newArrayList();
            fieldSorts.add(new FieldSort("orguser.ID_", Direction.DESC));
            queryFilter.setSorter((List)fieldSorts);
        }
        List sorter = queryFilter.getSorter();
        StringBuilder sorterBuilder = new StringBuilder();
        sorter.forEach(r -> {
            String property = r.getProperty().toLowerCase().replace("orguser.id_", " t2.userId").replace("u.account_", " t2.account").replace("u.fullname_", " t2.fullName");
            sorterBuilder.append(property).append(" ").append(r.getDirection()).append(" ").append(",");
        });
        queryFilter.addParams("sorterSql", (Object)sorterBuilder.substring(0, sorterBuilder.toString().length() - 1));
        return ((OrgUserDao)this.baseMapper).getUserByGroupPost((IPage<OrgUser>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void setCharge(String userId, Boolean isCharge, String orgId) throws SQLException {
        List<OrgUser> orgUserList = this.getListByOrgIdUserId(orgId, userId);
        if (BeanUtils.isNotEmpty(orgUserList) && orgUserList.get(0).getIsCharge() != 2 && isCharge.booleanValue()) {
            ((OrgUserDao)this.baseMapper).cancleMainCharge(orgId, LocalDateTime.now());
        }
        for (int i = 0; i < orgUserList.size(); ++i) {
            if (orgUserList.get(i).getIsCharge() == 2) {
                orgUserList.get(i).setIsCharge(1);
            } else if (orgUserList.get(i).getIsCharge() == 1) {
                orgUserList.get(i).setIsCharge(0);
            } else if (orgUserList.get(i).getIsCharge() == 0) {
                orgUserList.get(i).setIsCharge(1);
            }
            if (orgUserList.get(i).getIsCharge() != 2 && isCharge.booleanValue()) {
                orgUserList.get(i).setIsCharge(2);
            }
            this.update((Model)orgUserList.get(i));
        }
    }

    @Override
    public List<OrgUser> getChargesByOrgId(String orgId, Boolean isMain) {
        Integer isCharge = null;
        if (BeanUtils.isNotEmpty((Object)isMain) && isMain.booleanValue()) {
            isCharge = 2;
        }
        return ((OrgUserDao)this.baseMapper).getChargesByOrgId(orgId, isCharge);
    }

    @Override
    public void syncValidOrgUser() {
        List orgUsers = this.getAll();
        for (OrgUser orgUser : orgUsers) {
            try {
                this.validRelIsActive(orgUser);
            }
            catch (Exception e) {
                String msg = "\u6821\u9a8c\u8bbe\u7f6e\u5c97\u4f4d\u6709\u6548\u6027\u5931\u8d25\uff0c\u7528\u6237ID:" + orgUser.getUserId() + "\uff0c\u5c97\u4f4dID\uff1a" + orgUser.getRelId() + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage();
                this.logger.error(msg);
            }
        }
    }

    @Transactional
    private void validRelIsActive(OrgUser orgUser) throws ParseException {
        long time;
        int isRelActive = 1;
        LocalDateTime startDate = orgUser.getStartDate();
        LocalDateTime endDate = orgUser.getEndDate();
        String currentDateStr = DateUtil.getCurrentTime((String)"yyyy-MM-dd");
        LocalDateTime currentDate = DateFormatUtil.parse((String)currentDateStr, (String)"yyyy-MM-dd");
        if (BeanUtils.isNotEmpty((Object)startDate) && BeanUtils.isNotEmpty((Object)endDate)) {
            if (!DateUtil.belongCalendar((LocalDateTime)currentDate, (LocalDateTime)startDate, (LocalDateTime)endDate)) {
                isRelActive = 0;
            }
        } else if (BeanUtils.isNotEmpty((Object)startDate)) {
            long time2 = DateUtil.getTime((LocalDateTime)startDate, (LocalDateTime)currentDate);
            if (time2 < 0L) {
                isRelActive = 0;
            }
        } else if (BeanUtils.isNotEmpty((Object)endDate) && (time = DateUtil.getTime((LocalDateTime)currentDate, (LocalDateTime)endDate)) < 0L) {
            isRelActive = 0;
        }
        orgUser.setIsRelActive(isRelActive);
        this.update((Model)orgUser);
    }

    @Override
    @Transactional
    public void delByOrgId(String orgId) {
        ((OrgUserDao)this.baseMapper).delByOrgId(orgId, LocalDateTime.now());
    }

    @Override
    public List<OrgUser> getByParms(Map<String, Object> params) {
        return ((OrgUserDao)this.baseMapper).getByParms(params);
    }

    @Override
    @Transactional
    public void saveOrgUser(String account, List<UserPolymerOrgPos> orgsPoses) throws Exception {
        CacheEvictUtil.deleteUserDetailsCache((String)account);
        User user = this.userManager.getByAccount(account);
        List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getByUserId(user.getId());
        HashMap<Object, OrgUser> orgMap = new HashMap<Object, OrgUser>();
        HashMap<String, OrgUser> posMap = new HashMap<String, OrgUser>();
        ArrayList<String> orgUserIds = new ArrayList<String>();
        for (OrgUser orgUser : orgUsers) {
            orgUserIds.add(orgUser.getId());
        }
        for (OrgUser orgUser : orgUsers) {
            String orgCode = orgUser.getOrgCode();
            String posCode = orgUser.getPosCode();
            for (UserPolymerOrgPos userPolymerOrgPos : orgsPoses) {
                if ("org".equals(userPolymerOrgPos.getType()) && StringUtil.isEmpty((String)posCode) && orgCode.equals(userPolymerOrgPos.getOrgCode())) {
                    orgMap.put(orgCode, orgUser);
                    orgUserIds.remove(orgUser.getId());
                }
                if (!"pos".equals(userPolymerOrgPos.getType()) || !StringUtil.isNotEmpty((String)posCode) || !posCode.equals(userPolymerOrgPos.getPosCode())) continue;
                posMap.put(posCode, orgUser);
                orgUserIds.remove(orgUser.getId());
            }
        }
        if (orgUserIds.size() > 0) {
            String[] ids = new String[orgUserIds.size()];
            orgUserIds.toArray(ids);
            this.removeByIds(ids);
        }
        ArrayList<String> orgCodeList = new ArrayList<String>();
        ArrayList<String> postCodeList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(orgsPoses)) {
            for (UserPolymerOrgPos userPolymerOrgPos : orgsPoses) {
                if ("org".equals(userPolymerOrgPos.getType())) {
                    orgCodeList.add(userPolymerOrgPos.getOrgCode());
                }
                if (!"pos".equals(userPolymerOrgPos.getType())) continue;
                postCodeList.add(userPolymerOrgPos.getPosCode());
            }
        }
        for (Object code : orgMap.keySet()) {
            orgCodeList.remove(code);
            OrgUser orgUser = (OrgUser)orgMap.get(code);
            orgUser.setIsDelete("0");
            this.update((Model)orgUser);
        }
        for (String orgCode : orgCodeList) {
            this.orgService.addUsersForOrg(orgCode, account);
        }
        for (String code : posMap.keySet()) {
            postCodeList.remove(code);
            OrgUser orgUser = (OrgUser)posMap.get(code);
            orgUser.setIsDelete("0");
            this.update((Model)orgUser);
        }
        for (String posCode : postCodeList) {
            this.orgService.saveUserPost(account, posCode);
        }
    }

    @Override
    @Transactional
    public void checkIsInActiveTime(LocalDateTime date) {
        ((OrgUserDao)this.baseMapper).checkIsInActiveTime(date, date);
    }

    @Override
    public IPage getUserOrgPage(QueryFilter queryFilter) {
        IPage<Map<String, Object>> userOrgPage;
        User user = null;
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys())) {
            List queryFieldList = queryFilter.getQuerys();
            for (QueryField queryField : queryFieldList) {
                if (!"account".equals(queryField.getProperty())) continue;
                String userId = "";
                user = this.userManager.getByAccount(queryField.getValue().toString());
                if (BeanUtils.isNotEmpty((Object)user)) {
                    userId = user.getId();
                }
                queryField.setProperty("userId");
                queryField.setValue((Object)userId);
            }
        }
        if (BeanUtils.isNotEmpty((Object)(userOrgPage = ((OrgUserDao)this.baseMapper).getUserOrgPage((IPage<OrgUser>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords())) {
            List records = userOrgPage.getRecords();
            this.demensionManager.fillDimensionToData(records);
            this.fillUserToData(records, user);
            this.orgJobManager.fillJobToData(records);
        }
        return userOrgPage;
    }

    private void fillUserToData(List<Map<String, Object>> records, User user) {
        List userList;
        List<Object> userIds = new ArrayList();
        if (BeanUtils.isEmpty((Object)user)) {
            userIds = records.stream().filter(map -> BeanUtils.isNotEmpty(map.get("orgUserId"))).map(map -> map.get("orgUserId").toString()).collect(Collectors.toList());
        }
        Map<Object, Object> userMap = new HashMap();
        if (BeanUtils.isNotEmpty(userIds) && BeanUtils.isNotEmpty((Object)(userList = this.userManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(User::getId, userIds)).eq(UcBaseModel::getIsDelete, (Object)"0"))))) {
            userMap = userList.stream().collect(Collectors.toMap(User::getId, user1 -> user1));
        }
        for (Map<String, Object> map2 : records) {
            if (BeanUtils.isNotEmpty(userMap) && map2.containsKey("orgUserId") && userMap.containsKey(map2.get("orgUserId").toString())) {
                map2.put("account", ((User)userMap.get(map2.get("orgUserId").toString())).getAccount());
                map2.put("userName", ((User)userMap.get(map2.get("orgUserId").toString())).getFullname());
                map2.put("STATUS", ((User)userMap.get(map2.get("orgUserId").toString())).getStatus());
            }
            if (!BeanUtils.isNotEmpty((Object)user)) continue;
            map2.put("account", user.getAccount());
            map2.put("userName", user.getFullname());
            map2.put("STATUS", user.getStatus());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgById(String orgId, String userId) throws Exception {
        if (StringUtil.isEmpty((String)orgId)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u8bf7\u4f20\u53c2\u6570\u7ec4\u7ec7ID");
        }
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u8bf7\u4f20\u53c2\u6570\u7528\u6237ID");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("orgId", orgId);
        ((OrgUserDao)this.baseMapper).deleteOrgById(params);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public void setMasterByIds(String ... ids) {
        OrgUserManager orgUserManager = (OrgUserManager)AppUtil.getBean(OrgUserManager.class);
        for (String i : ids) {
            OrgUser orgUser = (OrgUser)this.get((Serializable)((Object)i));
            orgUserManager.removeUserMainOrgCache(orgUser.getUserId());
            orgUserManager.removeUserMainOrgCache("", orgUser.getUserId());
            if (orgUser.getIsMaster() != 0) continue;
            Org org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId()));
            List<OrgUser> orgUsers = ((OrgUserDao)this.baseMapper).getOrgUserMaster(orgUser.getUserId(), null);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                ((OrgUserDao)this.baseMapper).cancelUserMasterOrg(orgUser.getUserId(), org.getDemId(), LocalDateTime.now());
            }
            ((OrgUserDao)this.baseMapper).updateUserMasterOrg(i, LocalDateTime.now());
        }
    }

    @Override
    public List getUserByGroupList(QueryFilter queryFilter) {
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        QueryWrapper queryWrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, this.currentModelClass());
        queryWrapper.groupBy((Object)"u.id_");
        return ((OrgUserDao)this.baseMapper).getUserByGroupList((Wrapper<OrgUser>)queryWrapper);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgUserDao)this.baseMapper).removePhysical();
    }

    @Override
    public List<Map<String, Object>> getUserNumByOrgCode(Map<String, Object> map) {
        return ((OrgUserDao)this.baseMapper).getUserNumByOrgCode(map);
    }

    @Override
    @Transactional
    public void updateUserOrgByPostId(String id, String orgId) {
        ((OrgUserDao)this.baseMapper).updateUserOrgByPostId(id, orgId);
    }

    @Override
    public List<Map<String, Object>> getOrgUserData(QueryFilter queryFilter) {
        List orgPosts;
        List<Map<String, Object>> list = ((OrgUserDao)this.baseMapper).getOrgUserData((Wrapper<OrgUser>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List relIds = list.stream().filter(map -> map.containsKey("relId") && BeanUtils.isNotEmpty(map.get("relId"))).map(map -> map.get("relId").toString()).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(relIds) && BeanUtils.isNotEmpty((Object)(orgPosts = this.orgPostManager.listByIds(relIds)))) {
            Map<String, OrgPost> orgPostMap = orgPosts.stream().collect(Collectors.toMap(OrgPost::getId, orgPost -> orgPost));
            for (Map<String, Object> map2 : list) {
                if (!map2.containsKey("relId") || !orgPostMap.containsKey(map2.get("relId").toString())) continue;
                map2.put("relName", orgPostMap.get(map2.get("relId").toString()).getName());
                map2.put("postCode", orgPostMap.get(map2.get("relId").toString()).getCode());
            }
        }
        return list;
    }

    @Override
    @Transactional
    public void removeByUserId(String id, LocalDateTime now) {
        ((OrgUserDao)this.baseMapper).removeByUserId(id, now);
    }

    @Override
    public Object getChargesByOrgId(String orgId, int i) {
        return ((OrgUserDao)this.baseMapper).getChargesByOrgId(orgId, i);
    }

    @Override
    public List<OrgUser> getByOrgCodeAndroleCode(String orgCode, String roleCode) {
        return ((OrgUserDao)this.baseMapper).getByOrgCodeAndroleCode(orgCode, roleCode);
    }

    @Override
    public List<OrgUser> getByPostCodeAndOrgCode(String orgCode, String postCode) {
        return ((OrgUserDao)this.baseMapper).getByPostCodeAndOrgCode(orgCode, postCode);
    }

    @Override
    public OrgUser getMainPostOrOrgByUserId(String userId) {
        List<OrgUser> mainPostByUserId = ((OrgUserDao)this.baseMapper).getMainPostOrOrgByUserId(userId);
        if (BeanUtils.isNotEmpty(mainPostByUserId)) {
            return mainPostByUserId.get(0);
        }
        return null;
    }

    @Override
    public void delByUserId(String userId) {
        ((OrgUserDao)this.baseMapper).delByUserId(userId);
    }

    @Override
    public boolean insertBatch(List<OrgUser> list) {
        return this.saveBatch(list);
    }

    @Override
    public void removeMores() {
        ((OrgUserDao)this.baseMapper).removeMores();
    }

    @Override
    @Cacheable(value={"eip:uc:userPost"}, key="#userId")
    public String getCacheByKeyOrgPost(String userId) {
        return null;
    }

    @Override
    public List<OrgUser> getListPostAndJob(String userId) {
        Map<String, String> orgPathNameMap;
        List<OrgUser> list = ((OrgUserDao)this.baseMapper).getListPostAndJob(userId);
        List orgIds = list.stream().map(OrgUser::getOrgId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(orgIds) && BeanUtils.isNotEmpty(orgPathNameMap = this.orgService.listByIds(orgIds).stream().collect(Collectors.toMap(Org::getId, Org::getPathName)))) {
            for (OrgUser orgUser : list) {
                if (!orgPathNameMap.containsKey(orgUser.getOrgId())) continue;
                orgUser.setPathName(orgPathNameMap.get(orgUser.getOrgId()));
            }
        }
        return list;
    }

    @Override
    @CacheEvict(value={"eip:uc:userMainOrg"}, key="#userId")
    public void removeUserMainOrgCache(String userId) {
    }

    @Override
    @CacheEvict(value={"eip:uc:userMainOrg"}, key="#demId+'-'+#userId")
    public void removeUserMainOrgCache(String demId, String userId) {
    }

    @Override
    public void batchUpdateOrgUser(List<OrgUser> orgUserList) {
        if (BeanUtils.isEmpty(orgUserList)) {
            return;
        }
        List existList = this.getAll();
        ArrayList<OrgUser> mixed = new ArrayList<OrgUser>();
        for (OrgUser ou2 : existList) {
            if (!"0".equals(ou2.getIsDelete())) continue;
            for (OrgUser orgUser : orgUserList) {
                if (!orgUser.getOrgId().equals(ou2.getOrgId()) || !orgUser.getUserId().equals(ou2.getUserId())) continue;
                mixed.add(orgUser);
            }
        }
        orgUserList.removeAll(mixed);
        orgUserList.forEach(ou -> {
            ou.setIsCharge(0);
            ou.setIsMaster(0);
            ou.setVersion(1);
            ou.setIsRelActive(1);
        });
        if (BeanUtils.isNotEmpty(orgUserList)) {
            this.saveBatch(orgUserList);
        }
    }

    @Override
    public void deleteByIdsAndCache(List<String> idList) {
        for (String id : idList) {
            OrgUser orgUser = (OrgUser)this.get((Serializable)((Object)id));
            if (orgUser == null) continue;
            ((OrgUserManagerImpl)AppUtil.getBean(this.getClass())).removeUserMainOrgCache(orgUser.getUserId());
            ((UserManager)AppUtil.getBean(UserManager.class)).removeUserGroupsCache(orgUser.getUserId());
            ((OrgUserManagerImpl)AppUtil.getBean(this.getClass())).removeUserMainOrgCache("", orgUser.getUserId());
            if (StringUtil.isNotEmpty((String)orgUser.getOrgId())) {
                ((UserUnderManager)AppUtil.getBean(UserUnderManager.class)).delByUserIdAndOrgId(orgUser.getUserId(), orgUser.getOrgId());
            }
            ((RoleManagerImpl)AppUtil.getBean(RoleManagerImpl.class)).removeUserMenuCacheByUserIde(orgUser.getUserId());
        }
        this.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createOrgJobUser(OrgJobUserParam param) {
        this.refreshJobRelation(param);
        param.getJobIds().forEach(jobId -> param.getUserIds().forEach(userId -> {
            List<OrgUser> oldOrgUsers = ((OrgUserDao)this.baseMapper).listJoinJobByOrgAndUserId(param.getOrgId(), (String)userId);
            if (BeanUtils.isEmpty(oldOrgUsers)) {
                this.createOrgUser(param.getOrgId(), (String)userId, (String)jobId);
                return;
            }
            List orgUsers = oldOrgUsers.stream().filter(item -> jobId.equals(item.getJobId()) || jobId.equals(item.getPostJobId())).collect(Collectors.toList());
            if (!orgUsers.isEmpty()) {
                return;
            }
            List<OrgUser> onlyOrgList = oldOrgUsers.stream().filter(item -> StringUtil.isEmpty((String)item.getRelId())).filter(item -> StringUtil.isEmpty((String)item.getJobId())).collect(Collectors.toList());
            if (onlyOrgList.isEmpty()) {
                this.createOrgUser(param.getOrgId(), (String)userId, (String)jobId);
                return;
            }
            onlyOrgList.forEach(item -> {
                item.setJobId((String)jobId);
                LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OrgUser::getId, (Object)item.getId())).set(OrgUser::getJobId, jobId);
                this.update((Wrapper)updateWrapper);
            });
        }));
    }

    private void refreshJobRelation(OrgJobUserParam param) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(OrgJobRelation::getJobId, param.getJobIds())).eq(OrgJobRelation::getOrgId, (Object)param.getOrgId());
        this.orgJobRelationManager.physicalDelete((Wrapper<OrgJobRelation>)wrapper);
        List jobRelation = param.getJobIds().stream().map(jobId -> {
            OrgJobRelation relation = new OrgJobRelation();
            relation.setJobId((String)jobId);
            relation.setOrgId(param.getOrgId());
            return relation;
        }).collect(Collectors.toList());
        this.orgJobRelationManager.saveBatch(jobRelation);
    }

    private void createOrgUser(String orgId, String userId, String jobId) {
        OrgUser orgUser = new OrgUser();
        orgUser.setJobId(jobId);
        orgUser.setOrgId(orgId);
        orgUser.setUserId(userId);
        orgUser.setIsMaster(OrgUser.MASTER_NO);
        orgUser.setIsCharge(0);
        this.create((Model)orgUser);
    }

    @Override
    public void exportUserOrg(QueryFilter queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        String filename = "";
        long start = System.currentTimeMillis();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            if (queryFilter.getParams().containsKey("ids") && BeanUtils.isNotEmpty(queryFilter.getParams().get("ids"))) {
                queryFilter.setQuerys(new ArrayList());
                queryFilter.withQuery(new QueryField("orgUserId", queryFilter.getParams().get("ids"), QueryOP.IN));
            }
            if (queryFilter.getParams().containsKey("titlePre") && queryFilter.getParams().get("titlePre") != null) {
                filename = filename + String.valueOf(queryFilter.getParams().get("titlePre"));
            }
        }
        filename = filename + "_\u6240\u5c5e\u7ec4\u7ec7\u5c97\u4f4d_" + String.valueOf(start);
        IPage userOrgPage = this.getUserOrgPage(queryFilter);
        List list = userOrgPage.getRecords();
        list.forEach(item -> {
            if ("1".equals(item.get("isMaster"))) {
                item.put("isMasterDesc", "\u662f");
            } else {
                item.put("isMasterDesc", "\u5426");
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("demName", "\u7ec4\u7ec7\u7ef4\u5ea6");
        map.put("orgName", "\u7ec4\u7ec7\u540d\u79f0");
        map.put("posName", "\u5c97\u4f4d\u540d\u79f0");
        map.put("isMasterDesc", "\u4e3b\u7ec4\u7ec7/\u4e3b\u5c97\u4f4d");
        Workbook sheets = ExcelUtils.exportExcel((String)filename, map, (List)list);
        ExcelUtil.downloadExcel((Workbook)sheets, (String)filename, (HttpServletResponse)httpServletResponse);
    }
}

