/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.ResouceDao;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.ResouceManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.Resouce;
import com.hotent.uc.model.Role;
import com.hotent.uc.params.resouce.ResouceVo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResouceManagerImpl
extends BaseManagerImpl<ResouceDao, Resouce>
implements ResouceManager {
    @Override
    @Transactional
    public CommonResult<String> saveResouce(ResouceVo resouceVo) {
        if (BeanUtils.isEmpty((Object)resouceVo.getRoleCode())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1a\u89d2\u8272\u7f16\u7801\u5fc5\u586b\uff01");
        }
        RoleManager roleService = (RoleManager)AppUtil.getBean(RoleManager.class);
        Role role = roleService.getByAlias(resouceVo.getRoleCode());
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + resouceVo.getRoleCode() + "\u3011\u7684\u89d2\u8272\u4e0d\u5b58\u5728!");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ROLE_ID_", (Object)role.getId(), QueryOP.EQUAL, FieldRelation.AND);
        List<Resouce> list = this.query(queryFilter.getParams());
        Resouce resouce = null;
        if (list.size() > 0) {
            resouce = list.get(0);
            resouce.setResouce(resouceVo.getResouce());
            this.update((Model)resouce);
        } else {
            resouce = new Resouce();
            resouce.setId(UniqueIdUtil.getSuid());
            resouce.setResouce(resouceVo.getResouce());
            resouce.setRoleId(role.getId());
            this.create((Model)resouce);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public Resouce getByRoleCode(String roleCode) {
        if (BeanUtils.isEmpty((Object)roleCode)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1a\u89d2\u8272\u7f16\u7801\u5fc5\u586b\uff01");
        }
        RoleManager roleService = (RoleManager)AppUtil.getBean(RoleManager.class);
        Role role = roleService.getByAlias(roleCode);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + roleCode + "\u3011\u7684\u89d2\u8272\u4e0d\u5b58\u5728!");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ROLE_ID_", (Object)role.getId(), QueryOP.EQUAL, FieldRelation.AND);
        List<Resouce> list = this.query(queryFilter.getParams());
        return list.size() > 0 ? list.get(0) : new Resouce();
    }

    public List<Resouce> query(Map<String, Object> Params2) {
        List<Resouce> query = this.query(Params2);
        return query;
    }

    @Override
    public String getResouceByAccount(String account) {
        List<Resouce> list = ((ResouceDao)this.baseMapper).getResouceByAccount(account);
        OrgManager service = (OrgManager)AppUtil.getBean(OrgManager.class);
        OrgRoleManager orgRoleService = (OrgRoleManager)AppUtil.getBean(OrgRoleManager.class);
        HashSet<String> roleIdSet = new HashSet<String>();
        try {
            List<Org> orglist = service.getOrgListByAccount(account);
            PageBean pageBean = new PageBean(Integer.valueOf(1), Integer.valueOf(1000));
            for (Org org : orglist) {
                if (!BeanUtils.isNotEmpty((Object)org)) continue;
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addParams("path", (Object)org.getPath());
                queryFilter.setPageBean(pageBean);
                List orgRoles = orgRoleService.query(queryFilter).getRows();
                for (OrgRole orgRole : orgRoles) {
                    if (!BeanUtils.isNotEmpty((Object)orgRole)) continue;
                    roleIdSet.add(orgRole.getRoleId());
                }
            }
            if (roleIdSet.size() > 0) {
                QueryFilter rQueryFilter = QueryFilter.build();
                ArrayList roleIdlist = new ArrayList(roleIdSet);
                rQueryFilter.addFilter("ROLE_ID_", roleIdlist, QueryOP.IN, FieldRelation.AND);
                Map map = rQueryFilter.getParams();
                List<Resouce> list1 = this.query(map);
                list.addAll(list1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashSet<String> resouceSet = new HashSet<String>();
        for (Resouce resouce : list) {
            String[] resouceArr;
            if (!BeanUtils.isNotEmpty((Object)resouce.getResouce())) continue;
            for (String string : resouceArr = resouce.getResouce().split(",")) {
                resouceSet.add(string);
            }
        }
        ArrayList resoucelist = new ArrayList(resouceSet);
        String resouceStr = StringUtil.join(resoucelist, (String)",");
        return resouceStr;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((ResouceDao)this.baseMapper).removePhysical();
    }
}

