/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.TenantIgnoreMenuDao;
import com.hotent.uc.manager.TenantIgnoreMenuManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.model.TenantIgnoreMenu;
import com.hotent.uc.model.TenantManage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantIgnoreMenuManager")
public class TenantIgnoreMenuManagerImpl
extends BaseManagerImpl<TenantIgnoreMenuDao, TenantIgnoreMenu>
implements TenantIgnoreMenuManager {
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    PortalFeignService portalFeignService;

    @Override
    public List<TenantIgnoreMenu> getByTenantId(String tenantId) {
        return ((TenantIgnoreMenuDao)this.baseMapper).getByTenantId(tenantId);
    }

    @Override
    @Transactional
    public void deleteByTenantId(String tenantId) {
        ((TenantIgnoreMenuDao)this.baseMapper).deleteByTenantId(tenantId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    public CommonResult<String> saveByTenantId(String tenantId, List<String> ignoreMenus) {
        if (StringUtil.isEmpty((String)tenantId)) {
            return new CommonResult(false, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)tenantId));
        if (BeanUtils.isEmpty((Object)((Object)tenant))) {
            return new CommonResult(false, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a\u79df\u6237ID\u3010" + tenantId + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        ((TenantIgnoreMenuDao)this.baseMapper).deleteByTenantId(tenantId);
        if (BeanUtils.isNotEmpty(ignoreMenus)) {
            BeanUtils.removeDuplicate(ignoreMenus);
            ArrayList<TenantIgnoreMenu> nmenus = new ArrayList<TenantIgnoreMenu>();
            for (String alias : ignoreMenus) {
                TenantIgnoreMenu menu = new TenantIgnoreMenu();
                menu.setMenuCode(alias);
                menu.setTenantId(tenantId);
                nmenus.add(menu);
            }
            this.saveBatch(nmenus);
        }
        return new CommonResult(true, "\u79df\u6237\u7981\u7528\u83dc\u5355\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\u3002");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initIgnoreMenu(String tenantId) {
        List menus = this.portalFeignService.getMenuList("tenant,sysPwdStrategy,mobile_menu,app_menu");
        ArrayList ignoreMenus = new ArrayList();
        this.remove((Wrapper)Wrappers.lambdaQuery().eq(TenantIgnoreMenu::getTenantId, (Object)tenantId));
        menus.forEach(menu -> {
            TenantIgnoreMenu ignoreMenu = new TenantIgnoreMenu();
            ignoreMenu.setTenantId(tenantId);
            ignoreMenu.setMenuCode(JsonUtil.getString((JsonNode)menu, (String)"alias"));
            ignoreMenus.add(ignoreMenu);
        });
        this.saveBatch(ignoreMenus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createIgnoreMenuByCodes(List<String> codes) {
        List tenants = this.tenantManageManager.list((Wrapper)Wrappers.lambdaQuery().ne(TenantManage::getId, (Object)"-1"));
        ArrayList ignoreMenus = new ArrayList();
        codes.forEach(code -> {
            this.remove((Wrapper)Wrappers.lambdaQuery().eq(TenantIgnoreMenu::getMenuCode, code));
            tenants.forEach(tenant -> {
                TenantIgnoreMenu tenantIgnoreMenu = new TenantIgnoreMenu();
                tenantIgnoreMenu.setTenantId(tenant.getId());
                tenantIgnoreMenu.setMenuCode((String)code);
                ignoreMenus.add(tenantIgnoreMenu);
            });
        });
        this.saveBatch(ignoreMenus);
    }
}

