/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.constants.TenantConstant;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.BpmRuntimeFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.uc.dao.TenantManageDao;
import com.hotent.uc.manager.TenantAuthManager;
import com.hotent.uc.manager.TenantIgnoreMenuManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.TenantAuth;
import com.hotent.uc.model.TenantManage;
import com.hotent.uc.model.User;
import com.hotent.uc.util.ContextUtil;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantManageManager")
public class TenantManageManagerImpl
extends BaseManagerImpl<TenantManageDao, TenantManage>
implements TenantManageManager {
    @Resource
    PortalFeignService portalFeignService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    UserManager userManager;
    @Resource
    TenantAuthManager tenantAuthManager;
    @Resource
    BpmRuntimeFeignService bpmRuntimeFeignService;
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    TenantIgnoreMenuManager tenantIgnoreMenuManager;
    @Value(value="${captcha.isEnabled:0}")
    private Integer captchaEnabled;

    @GlobalTransactional
    public void create(TenantManage t) {
        t.setUpdateTime(DateUtil.getCurrentDate());
        super.create((Model)t);
        this.initTenantAdminAndGuest(t.getId());
        this.tenantIgnoreMenuManager.initIgnoreMenu(t.getId());
        TenantUtil.initData((String)t.getId(), (List)TenantConstant.INIT_UC_DATA_TABLE_NAMES);
        try {
            CommonResult initData = this.portalFeignService.initData(t.getId());
            if (!initData.getState().booleanValue()) {
                throw new BaseException("\u521b\u5efa\u79df\u6237\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u521b\u5efa\u79df\u6237\u521d\u59cb\u5316\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initTenantAdminAndGuest(String tenantId) {
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            User tenantAdmin = new User();
            tenantAdmin.setAccount("admin");
            tenantAdmin.setFullname("\u8d85\u7ea7\u7ba1\u7406\u5458");
            tenantAdmin.setStatus(1);
            tenantAdmin.setId(UniqueIdUtil.getSuid());
            tenantAdmin.setCreateTime(LocalDateTime.now());
            tenantAdmin.setFrom("restful");
            tenantAdmin.setPassword(this.passwordEncoder.encode((CharSequence)"ht@123"));
            tenantAdmin.setPwdCreateTime(LocalDateTime.now());
            tenantAdmin.setTenantId(tenantId);
            this.userManager.create((Model)tenantAdmin);
            User tenantGuest = new User();
            tenantGuest.setAccount("guest");
            tenantGuest.setFullname("\u6e38\u5ba2\u8d26\u53f7");
            tenantGuest.setStatus(1);
            tenantGuest.setId(UniqueIdUtil.getSuid());
            tenantGuest.setCreateTime(LocalDateTime.now());
            tenantGuest.setFrom("restful");
            tenantGuest.setPassword(this.passwordEncoder.encode((CharSequence)"ht@123"));
            tenantGuest.setPwdCreateTime(LocalDateTime.now());
            tenantGuest.setTenantId(tenantId);
            this.userManager.create((Model)tenantGuest);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public TenantManage getByCode(String code) {
        TenantManage result = ((TenantManageDao)this.baseMapper).getByCode(code);
        if (result != null) {
            result.setCaptchaEnabled(this.captchaEnabled);
        }
        return result;
    }

    @Override
    public List<TenantManage> getByTypeId(String typeId) {
        return ((TenantManageDao)this.baseMapper).getByTypeId(typeId);
    }

    @Override
    @Transactional
    public void deleteByTypeId(String typeId) {
        ((TenantManageDao)this.baseMapper).deleteByTypeId(typeId);
    }

    @Override
    public TenantManage getByDomain(String domain) {
        return ((TenantManageDao)this.baseMapper).getByDomain(domain);
    }

    @Override
    public PageList queryWithType(QueryFilter queryFilter) {
        IPage page = this.convert2IPage(queryFilter.getPageBean());
        return new PageList(((TenantManageDao)this.baseMapper).queryWithType((IPage<TenantManage>)page, (Wrapper<TenantManage>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public PageList<TenantManage> listJson(QueryFilter queryFilter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            ArrayList<String> authTypeIds = new ArrayList<String>();
            ArrayList<String> authTenantIds = new ArrayList<String>();
            List<TenantAuth> auths = this.tenantAuthManager.getByUserId(null, null, user.getId());
            if (BeanUtils.isNotEmpty(auths)) {
                for (TenantAuth tenantAuth : auths) {
                    if (StringUtil.isEmpty((String)tenantAuth.getTenantId())) {
                        authTypeIds.add(tenantAuth.getTypeId());
                        continue;
                    }
                    authTenantIds.add(tenantAuth.getTenantId());
                }
            }
            if (BeanUtils.isEmpty(authTypeIds) && BeanUtils.isEmpty(authTenantIds)) {
                authTypeIds.add("0");
                authTenantIds.add("0");
            }
            if (BeanUtils.isNotEmpty(authTypeIds)) {
                queryFilter.addFilter("TYPE_ID_", authTypeIds, QueryOP.IN, FieldRelation.OR, "auth");
            }
            if (BeanUtils.isNotEmpty(authTenantIds)) {
                queryFilter.addFilter("ID_", authTenantIds, QueryOP.IN, FieldRelation.OR, "auth");
            }
        }
        PageList pageList = this.queryWithType(queryFilter);
        return pageList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"eip:uc:tenant:frontStyle"}, key="#tenantManage.id")
    public CommonResult<String> saveTenantManage(TenantManage tenantManage) throws Exception {
        String msg = "\u6dfb\u52a0\u79df\u6237\u7ba1\u7406 \u6210\u529f";
        if (StringUtil.isEmpty((String)tenantManage.getId())) {
            this.tenantManageManager.create((Model)tenantManage);
        } else {
            String tenantId;
            List tasList;
            TenantManage oldManage;
            if ("disabled".equals(tenantManage.getStatus()) && "enable".equals((oldManage = (TenantManage)this.get((Serializable)((Object)tenantManage.getId()))).getStatus()) && BeanUtils.isNotEmpty((Object)(tasList = this.bpmRuntimeFeignService.getTaskListByTenantId(tenantId = tenantManage.getId()))) && tasList.size() > 0) {
                throw new BaseException("\u8be5\u79df\u6237\u4ecd\u6709\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u7981\u7528\uff01");
            }
            this.update((Model)tenantManage);
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(TenantAuth::getTypeId, (Object)tenantManage.getTypeId());
            wrapper.eq(TenantAuth::getTenantId, (Object)tenantManage.getId());
            this.tenantAuthManager.update((Wrapper)wrapper);
            msg = "\u4fdd\u5b58\u6210\u529f";
        }
        return new CommonResult(true, msg, (Object)tenantManage.getId());
    }

    @Override
    @Cacheable(value={"eip:uc:tenant:frontStyle"}, key="#id", ignoreException=false)
    public String getDefaultStyleById(String id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{TenantManage::getId, TenantManage::getDefaultStyle}).eq(TenantManage::getId, (Object)id);
        TenantManage one = (TenantManage)((Object)this.getOne((Wrapper)wrapper));
        Assert.notNull((Object)((Object)one), (String)"\u4e0d\u5b58\u5728\u8be5ID\u7684\u79df\u6237", (Object[])new Object[0]);
        return one.getDefaultStyle();
    }

    @Override
    public List<TenantManage> getByStatus(String typeId, String status) {
        return ((TenantManageDao)this.baseMapper).getByStatus(typeId, status);
    }
}

