/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.google.common.collect.Lists;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.UserUniteDao;
import com.hotent.uc.manager.UserUniteManager;
import com.hotent.uc.model.UserUnite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class UserUniteManagerImpl
extends BaseManagerImpl<UserUniteDao, UserUnite>
implements UserUniteManager {
    @Override
    public void updateUserUnite(UserUnite userUnite) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"user_id_", (Object)userUnite.getUserId());
        UserUnite exist = (UserUnite)((Object)this.getOne((Wrapper)queryWrapper));
        if (BeanUtils.isNotEmpty((Object)((Object)exist))) {
            if (StringUtil.isNotEmpty((String)userUnite.getOpenId())) {
                exist.setOpenId(userUnite.getOpenId());
            }
            if (StringUtil.isNotEmpty((String)userUnite.getWxWorkId())) {
                exist.setWxWorkId(userUnite.getWxWorkId());
            }
            if (StringUtil.isNotEmpty((String)userUnite.getDingtalkId())) {
                exist.setDingtalkId(userUnite.getDingtalkId());
            }
            if (StringUtil.isNotEmpty((String)userUnite.getFlybookId())) {
                exist.setFlybookId(userUnite.getFlybookId());
            }
            if (StringUtil.isNotEmpty((String)userUnite.getMpOpenId())) {
                exist.setMpOpenId(userUnite.getMpOpenId());
            }
            this.update((Model)exist);
        } else {
            this.create((Model)userUnite);
        }
    }

    @Override
    public void updateUserUniteList(List<UserUnite> userUniteList) {
        HashMap<String, UserUnite> map = new HashMap<String, UserUnite>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (UserUnite userUnite : userUniteList) {
            map.put(userUnite.getUserId(), userUnite);
            userIds.add(userUnite.getUserId());
        }
        QueryWrapper qw = (QueryWrapper)new QueryWrapper().in((Object)"user_id_", userIds);
        List existList = ((UserUniteDao)this.baseMapper).selectList((Wrapper)qw);
        for (UserUnite exist : existList) {
            String userId = exist.getUserId();
            UserUnite uu = (UserUnite)((Object)map.get(userId));
            if (uu != null) {
                boolean needToUpdate = false;
                if (BeanUtils.isNotEmpty((Object)uu.getOpenId()) && !uu.getOpenId().equals(exist.getOpenId())) {
                    exist.setOpenId(uu.getOpenId());
                    needToUpdate = true;
                }
                if (BeanUtils.isNotEmpty((Object)uu.getWxWorkId()) && !uu.getWxWorkId().equals(exist.getWxWorkId())) {
                    exist.setWxWorkId(uu.getWxWorkId());
                    needToUpdate = true;
                }
                if (BeanUtils.isNotEmpty((Object)uu.getDingtalkId()) && !uu.getDingtalkId().equals(exist.getDingtalkId())) {
                    exist.setDingtalkId(uu.getDingtalkId());
                    needToUpdate = true;
                }
                if (BeanUtils.isNotEmpty((Object)uu.getFlybookId()) && !uu.getFlybookId().equals(exist.getFlybookId())) {
                    exist.setFlybookId(uu.getFlybookId());
                    needToUpdate = true;
                }
                if (needToUpdate) {
                    ((UserUniteDao)this.baseMapper).updateById((Object)exist);
                }
            }
            map.remove(userId);
        }
        if (BeanUtils.isNotEmpty(map.values())) {
            this.saveBatch(map.values());
        }
    }

    @Override
    public String getDingtalkIdsByUserIds(String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List dingtalkIds;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = this.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(dingtalkIds = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getDingtalkId())).map(UserUnite::getDingtalkId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", dingtalkIds);
            }
        }
        return "";
    }

    @Override
    public String getWxWorkIdsByUserIds(String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List wxWorkIds;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = this.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(wxWorkIds = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getWxWorkId())).map(UserUnite::getWxWorkId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", wxWorkIds);
            }
        }
        return "";
    }

    @Override
    public String getOpenIdsByUserIds(String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List getOpenId;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = this.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(getOpenId = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getOpenId())).map(UserUnite::getOpenId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", getOpenId);
            }
        }
        return "";
    }

    @Override
    public List<String> getFlyBookIdsByUserIds(String userIds) {
        if (BeanUtils.isEmpty((Object)userIds)) {
            return Lists.newArrayList();
        }
        Object[] userIdList = userIds.split(",");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"USER_ID_", userIdList);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getFlybookId())).map(UserUnite::getFlybookId).collect(Collectors.toList());
    }
}

