/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.service.LoginLogService;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.WebUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.manager.LoginLogManager;
import com.hotent.uc.model.LoginLog;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Primary
@Service
public class LoginLogServiceImpl
implements LoginLogService {
    protected static Logger logger = LoggerFactory.getLogger(LoginLogServiceImpl.class);
    @Resource
    LoginLogManager loginLogManager;
    @Resource
    UserDetailsService userDetailsService;

    public void log(String account, String loginType) {
        try {
            HttpServletRequest request = HttpUtil.getRequest();
            this.loginLogManager.removePhysical(account);
            LoginLog log = this.loginLogManager.getByAccount(account);
            String ip = Optional.ofNullable(request).map(item -> item.getHeader("origin-ip")).orElse(WebUtil.getIpAddr((HttpServletRequest)request));
            if (BeanUtils.isEmpty((Object)log)) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);
                if (BeanUtils.isNotEmpty((Object)userDetails)) {
                    IUser user = (IUser)userDetails;
                    log = new LoginLog();
                    log.setAccount(account);
                    log.setName(user.getFullname());
                    log.setId(user.getUserId());
                    log.setLoginSum(1);
                    if ("mobile".equals(loginType)) {
                        log.setMobileSum(log.getMobileSum() + 1);
                    } else {
                        log.setPcSum(log.getPcSum() + 1);
                    }
                    log.setIp(ip);
                    log.setLoginType(loginType);
                    LocalDateTime currentDate = DateUtil.getCurrentDate();
                    log.setCreateTime(currentDate);
                    log.setUpdateTime(currentDate);
                    this.loginLogManager.create((Model)log);
                }
            } else {
                if ("mobile".equals(loginType)) {
                    log.setMobileSum(log.getMobileSum() + 1);
                } else {
                    log.setPcSum(log.getPcSum() + 1);
                }
                log.setLoginSum(log.getLoginSum() + 1);
                log.setIp(ip);
                log.setLoginType(loginType);
                this.loginLogManager.update((Model)log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

