/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.matrix.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.model.Matrix;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.service.matrix.MatrixDataService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractMatrixDataServiceImpl
implements MatrixDataService {
    protected String idColumn = "";
    protected String nameColumn = "";
    protected String codeColumn = "";
    protected String nameDbColumn = "";
    protected String ctrlType = "";
    protected final CommonManager commonManager;

    public AbstractMatrixDataServiceImpl(CommonManager commonManager) {
        this.commonManager = commonManager;
    }

    protected List<MatrixColField> buildSelectFields(Matrix matrix) {
        ArrayList<MatrixColField> colFields = new ArrayList<MatrixColField>();
        colFields.add(new MatrixColField("ID_", "ID_", "\u4e3b\u952e", "id", null));
        for (MatrixColDef col : matrix.getCondList()) {
            colFields.add(new MatrixColField(col.getCondkFieldName(), col.getCode(), col.getName(), "ck", col));
            colFields.add(new MatrixColField(col.getCondvFieldName(), col.getCode(), col.getName(), "cv", col));
        }
        for (MatrixColDef col : matrix.getRoleList()) {
            colFields.add(new MatrixColField(col.getRoleFieldName(), col.getCode(), col.getName(), "ro", col));
        }
        return colFields;
    }

    @Override
    public PageList<Map<String, Object>> query(Matrix matrix, QueryFilter<?> queryFilter) {
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        String sql = this.generateSql(matrix.getCode(), colFields);
        this.convertQueryFilter(colFields, queryFilter);
        this.addQueryFilter(queryFilter);
        PageList dataList = this.commonManager.query(sql, queryFilter);
        if (SQLUtil.getDbType().equals("kingbasees") && BeanUtils.isNotEmpty((Object)dataList.getRows())) {
            ArrayList rowsTemp = Lists.newArrayList();
            dataList.getRows().forEach(item -> {
                HashMap rowTemp = Maps.newHashMap();
                rowTemp.put(this.idColumn, MapUtil.getIgnoreCase((Map)item, (String)this.idColumn, null));
                rowTemp.put(this.nameColumn, MapUtil.getIgnoreCase((Map)item, (String)this.nameColumn, null));
                colFields.stream().map(MatrixColField::getField).forEach(field -> rowTemp.put(field, MapUtil.getIgnoreCase((Map)item, (String)field, null)));
                rowsTemp.add(rowTemp);
            });
            dataList.setRows((List)rowsTemp);
        }
        return dataList;
    }

    public void addQueryFilter(QueryFilter<?> queryFilter) {
    }

    private void convertQueryFilter(List<MatrixColField> colFields, QueryFilter<?> queryFilter) {
        Optional<MatrixColField> first = this.getSuitableColField(colFields);
        String nameField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondvFieldName).orElse(this.nameColumn);
        queryFilter.getQuerys().forEach(query -> {
            if (query.getProperty().equalsIgnoreCase(nameField)) {
                query.setProperty(this.nameDbColumn);
            }
        });
    }

    protected Optional<MatrixColField> getSuitableColField(List<MatrixColField> colFields) {
        return colFields.stream().filter(colField -> {
            String ctrlType = Optional.ofNullable(colField.getColDef()).map(MatrixColDef::getCtrlType).orElse("");
            return this.ctrlType.equals(ctrlType);
        }).findFirst();
    }

    abstract String generateSql(String var1, List<MatrixColField> var2);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(Matrix matrix, List<Map<String, Object>> list, String foreignKey) {
        ArrayList deleteList = new ArrayList();
        ArrayList addList = new ArrayList();
        list.forEach(data -> {
            deleteList.add(data.get("CONDK_" + foreignKey).toString());
            if (this.validateData((Map<String, Object>)data, matrix.getRoleList())) {
                Map<String, Object> newData = this.convertNewData(matrix, (Map<String, Object>)data);
                addList.add(newData);
            }
        });
        this.commonManager.batchDelete("UC_MATRIX_" + matrix.getCode(), "CONDK_" + foreignKey, deleteList);
        if (BeanUtils.isEmpty(addList)) {
            return;
        }
        this.commonManager.batchInsert("UC_MATRIX_" + matrix.getCode(), addList, 1000);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(Matrix matrix, Map<String, Object> data, String foreignKey) {
        List<Map<String, Object>> dataList = Collections.singletonList(data);
        this.save(matrix, dataList, foreignKey);
    }

    protected Map<String, Object> convertNewData(Matrix matrix, Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.put("ID_", map.getOrDefault("ID_", UniqueIdUtil.getSuid()));
        result.put("ID_", map.get("ID_"));
        matrix.getCondList().forEach(cond -> {
            result.put(cond.getCondkFieldName(), map.get(cond.getCondkFieldName()));
            result.put(cond.getCondvFieldName(), map.get(cond.getCondvFieldName()));
        });
        matrix.getRoleList().forEach(role -> result.put(role.getRoleFieldName(), map.get(role.getRoleFieldName())));
        return result;
    }

    private boolean validateData(Map<String, Object> data, List<MatrixColDef> columns) {
        for (MatrixColDef column : columns) {
            if (!BeanUtils.isNotEmpty((Object)MapUtil.getIgnoreCase(data, (String)column.getRoleFieldName()))) continue;
            return true;
        }
        return false;
    }
}

