/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.matrix.impl;

import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlBuilder;
import com.hotent.base.manager.CommonManager;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.service.matrix.MatrixDataService;
import com.hotent.uc.service.matrix.impl.AbstractMatrixDataServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class JobMatrixDataServiceImpl
extends AbstractMatrixDataServiceImpl
implements MatrixDataService {
    public JobMatrixDataServiceImpl(CommonManager commonManager) {
        super(commonManager);
        this.idColumn = "ucJobId";
        this.nameColumn = "ucJobName";
        this.codeColumn = "ucJobCode";
        this.nameDbColumn = "uc_org_job.name_";
        this.ctrlType = "job";
    }

    @Override
    String generateSql(String matrixCode, List<MatrixColField> colFields) {
        Optional<MatrixColField> first = this.getSuitableColField(colFields);
        String codeField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondkFieldName).orElse(this.codeColumn);
        String nameField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondvFieldName).orElse(this.nameColumn);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(String.format("uc_org_job.code_ \"%s\"", codeField));
        fields.add(String.format(this.nameDbColumn + " \"%s\"", nameField));
        for (MatrixColField field : colFields) {
            if (codeField.equals(field.getField()) || nameField.equals(field.getField())) continue;
            fields.add(String.format("%s.%s \"%s\"", "uc_matrix", field.getField(), field.getField()));
        }
        Condition condition = new Condition("uc_org_job.code_", (Object)("uc_matrix." + first.map(MatrixColField::getField).orElse("code_")));
        condition.setPlaceHolder(false);
        SqlBuilder sqlBuilder = SqlBuilder.create().select(fields).from(new String[]{"uc_org_job uc_org_job"}).join("UC_MATRIX_" + matrixCode + " " + "uc_matrix", SqlBuilder.Join.LEFT).on(new Condition[]{condition});
        return sqlBuilder.toString();
    }
}

