/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.util;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.context.ICurrentContext;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import com.hotent.uc.model.User;
import java.util.Locale;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@Primary
public class ContextUtil {
    private static ContextUtil contextUtil;
    private ICurrentContext currentContext;

    public void setCurrentContext(ICurrentContext _currentContext) {
        contextUtil = this;
        ContextUtil.contextUtil.currentContext = _currentContext;
    }

    public static User getCurrentUser() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Assert.notNull((Object)authentication, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            Object principal = authentication.getPrincipal();
            if (principal instanceof User) {
                return (User)principal;
            }
            if (principal instanceof UserDetails) {
                UserDetails ud = (UserDetails)principal;
                User user = (User)JsonUtil.toBean((String)JsonUtil.toJson((Object)ud), User.class);
                return user;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getCurrentUserId() {
        User user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getUserId();
    }

    public static IGroup getCurrentGroup() {
        return null;
    }

    public static String getCurrentGroupId() {
        IGroup iGroup = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)iGroup)) {
            return iGroup.getGroupId();
        }
        return "";
    }

    public static Locale getLocale() {
        return ContextUtil.contextUtil.currentContext.getLocale();
    }

    public static void clearCurrentUser() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearCurrentUser();
        }
    }

    public static void setCurrentUser(IUser user) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)"\u4f20\u5165\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Assert.isNull((Object)authentication, (String)"\u5f53\u524d\u767b\u5f55\u4e0a\u4e0b\u6587\u4e2d\u6709\u767b\u5f55\u7528\u6237\u65f6\u4e0d\u80fd\u8bbe\u7f6e\u7528\u6237");
        UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
    }

    public static IUser getUserByAccount(String account) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)account), (String)"\u5fc5\u987b\u4f20\u5165\u7528\u6237\u8d26\u53f7");
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserByAccount(account);
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)String.format("\u8d26\u53f7\u4e3a\uff1a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", account));
        return user;
    }

    public static void setCurrentUserByAccount(String account) {
        ContextUtil.setCurrentUser(ContextUtil.getUserByAccount(account));
    }

    public static void setCurrentOrg(IGroup group) {
        ContextUtil.contextUtil.currentContext.setCurrentGroup(group);
    }

    public static void setLocale(Locale locale) {
        ContextUtil.contextUtil.currentContext.setLocale(locale);
    }

    public static void cleanLocale() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearLocale();
        }
    }

    public static void clearAll() {
        ContextUtil.cleanLocale();
        ContextUtil.clearCurrentUser();
    }
}

