/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uds.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.ParamsManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserParamsManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgParams;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.Params;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserParams;
import com.hotent.uc.model.UserRole;
import com.hotent.uds.base.vo.OrgJobVo;
import com.hotent.uds.base.vo.OrgPostVo;
import com.hotent.uds.base.vo.OrgUserVo;
import com.hotent.uds.base.vo.OrgVo;
import com.hotent.uds.base.vo.ParamsVo;
import com.hotent.uds.base.vo.RoleVo;
import com.hotent.uds.base.vo.UserVo;
import com.hotent.uds.manager.UserSetter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserSetterImpl
implements UserSetter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OrgJobManager orgJobManager;
    @Resource
    private RoleManager roleManager;
    @Resource
    private OrgPostManager orgPostManager;
    @Resource
    private OrgManager orgManager;
    @Resource
    private UserManager userManager;
    @Resource
    private OrgParamsManager orgParamsManager;
    @Resource
    private UserParamsManager userParamsManager;
    @Resource
    private OrgUserManager orgUserManager;
    @Resource
    private UserRoleManager userRoleManager;
    @Resource
    private DemensionManager demensionManager;
    @Resource
    private ParamsManager paramsManager;

    @Override
    public Boolean setJobs(List<OrgJobVo> orgJobVoList) throws Exception {
        if (CollectionUtils.isEmpty(orgJobVoList)) {
            return true;
        }
        ArrayList<OrgJob> list = new ArrayList<OrgJob>();
        for (OrgJobVo vo : orgJobVoList) {
            if (StringUtil.isEmpty((String)vo.getCode())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u804c\u52a1\u7f16\u7801[%s]\u4e3a\u7a7a\uff01", vo.getName()));
                continue;
            }
            OrgJob orgJob = this.orgJobManager.getByCode(vo.getCode());
            if (orgJob == null) {
                orgJob = new OrgJob();
            }
            BeanUtil.copyProperties((Object)vo, (Object)orgJob, (String[])new String[0]);
            list.add(orgJob);
        }
        return this.orgJobManager.saveOrUpdateBatch(list);
    }

    private OrgJob setJobOne(OrgJobVo orgJobVo) {
        OrgJob orgJob = this.orgJobManager.getByCode(orgJobVo.getCode());
        if (orgJob == null) {
            orgJob = new OrgJob();
            BeanUtil.copyProperties((Object)orgJobVo, (Object)orgJob, (String[])new String[0]);
            this.orgJobManager.save(orgJob);
        }
        return orgJob;
    }

    private Boolean setOrgParams(List<ParamsVo> paramsVoList, String orgId) {
        if (CollectionUtils.isEmpty(paramsVoList) || StringUtil.isEmpty((String)orgId)) {
            return true;
        }
        this.orgParamsManager.removeByOrgId(orgId);
        ArrayList<OrgParams> list = new ArrayList<OrgParams>();
        for (ParamsVo vo : paramsVoList) {
            OrgParams orgParams = new OrgParams();
            orgParams.setAlias(vo.getCode());
            orgParams.setValue(vo.getName());
            orgParams.setOrgId(orgId);
            list.add(orgParams);
        }
        return this.orgParamsManager.saveBatch(list);
    }

    private Boolean setUserParams(List<ParamsVo> paramsVoList, String userId) {
        if (CollectionUtils.isEmpty(paramsVoList) || StringUtil.isEmpty((String)userId)) {
            return true;
        }
        this.userParamsManager.remove((Wrapper)Wrappers.lambdaQuery().eq(UserParams::getUserId, (Object)userId));
        ArrayList<UserParams> list = new ArrayList<UserParams>();
        for (ParamsVo vo : paramsVoList) {
            UserParams userParams = new UserParams();
            userParams.setAlias(vo.getCode());
            userParams.setValue(vo.getName());
            userParams.setUserId(userId);
            list.add(userParams);
        }
        return this.userParamsManager.saveBatch(list);
    }

    @Override
    public Boolean setOrgs(List<OrgVo> orgVoList) {
        if (CollectionUtils.isEmpty(orgVoList)) {
            return true;
        }
        Demension demension = this.demensionManager.getDefaultDemension();
        ArrayList<Org> list = new ArrayList<Org>();
        HashMap<String, List> paramsVoMap = new HashMap<String, List>(orgVoList.size());
        for (OrgVo vo : orgVoList) {
            if (StringUtil.isEmpty((String)vo.getCode())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u7ec4\u7ec7\u7f16\u7801[%s]\u4e3a\u7a7a\uff01", vo.getName()));
                continue;
            }
            Org org = this.orgManager.getByCode(vo.getCode());
            if (org == null) {
                org = new Org();
            }
            paramsVoMap.put(vo.getCode(), vo.getParamsList());
            BeanUtil.copyProperties((Object)vo, (Object)org, (String[])new String[0]);
            if (StringUtil.isEmpty((String)vo.getParentCode())) {
                org.setParentId("0");
            }
            if (demension != null) {
                org.setDemId(demension.getId());
                org.setDemCode(demension.getDemCode());
                org.setDemName(demension.getDemName());
            }
            list.add(org);
        }
        boolean result = this.orgManager.saveOrUpdateBatch(list);
        String demId = demension == null ? "null" : demension.getId();
        for (Org org : list) {
            List paramsVoList = (List)paramsVoMap.get(org.getCode());
            if (!this.setOrgParams(paramsVoList, org.getId()).booleanValue()) {
                this.logger.error(String.format("\u66f4\u65b0 %s[%s] \u7ec4\u7ec7\u53c2\u6570\u5931\u8d25\uff01", org.getName(), org.getCode()));
            }
            this.getOrgPathAndName(orgVoList, list, demId, org);
            Wrapper orgWrapper = (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Org::getParentId, (Object)org.getParentId())).set(Org::getPathName, (Object)org.getPathName())).set(Org::getPath, (Object)org.getPath())).eq(Org::getId, (Object)org.getId());
            if (this.orgManager.update(orgWrapper)) continue;
            this.logger.error(String.format("\u66f4\u65b0 %s[%s] \u7ec4\u7ec7\u7236ID\u5931\u8d25\uff01", org.getName(), org.getCode()));
        }
        return result;
    }

    private void getOrgPathAndName(List<OrgVo> orgVoList, List<Org> list, String demId, Org org) {
        String path;
        String pathName;
        String parentId;
        Org orgParent = null;
        boolean isFromDb = false;
        OrgVo orgVoTemp = orgVoList.stream().filter(o -> o.getCode().equalsIgnoreCase(org.getCode())).findFirst().orElse(null);
        if (orgVoTemp != null && StringUtil.isNotEmpty((String)orgVoTemp.getParentCode())) {
            String parentCode = orgVoTemp.getParentCode();
            orgParent = list.stream().filter(o -> o.getCode().equalsIgnoreCase(parentCode)).findFirst().orElse(null);
            if (orgParent == null) {
                orgParent = this.orgManager.getByCode(parentCode);
                isFromDb = true;
            }
        }
        if (orgParent == null) {
            parentId = "0";
            pathName = "/" + org.getName();
            path = demId + "." + org.getId() + ".";
        } else {
            parentId = orgParent.getId();
            if (!isFromDb) {
                this.getOrgPathAndName(orgVoList, list, demId, orgParent);
            }
            pathName = orgParent.getPathName() + "/" + org.getName();
            path = orgParent.getPath() + org.getId() + ".";
        }
        org.setParentId(parentId);
        org.setPath(path);
        org.setPathName(pathName);
    }

    @Override
    public Boolean setPosts(List<OrgPostVo> orgPostVoList) {
        if (CollectionUtils.isEmpty(orgPostVoList)) {
            return true;
        }
        ArrayList<OrgPost> list = new ArrayList<OrgPost>();
        for (OrgPostVo vo : orgPostVoList) {
            Org org;
            if (StringUtil.isEmpty((String)vo.getCode())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u5c97\u4f4d\u7f16\u7801[%s]\u4e3a\u7a7a\uff01", vo.getName()));
                continue;
            }
            OrgPost orgPost = this.orgPostManager.getByCode(vo.getCode());
            if (orgPost == null) {
                orgPost = new OrgPost();
            }
            BeanUtil.copyProperties((Object)vo, (Object)orgPost, (String[])new String[0]);
            if (vo.getOrgJobVo() != null) {
                OrgJob orgJob = this.setJobOne(vo.getOrgJobVo());
                orgPost.setJobCode(orgJob.getCode());
                orgPost.setJobName(orgJob.getName());
            }
            if (StringUtil.isNotEmpty((String)vo.getOrgCode()) && (org = this.orgManager.getByCode(vo.getOrgCode())) != null) {
                orgPost.setOrgId(org.getId());
            }
            list.add(orgPost);
        }
        return this.orgPostManager.saveOrUpdateBatch(list);
    }

    @Override
    public Boolean setRoles(List<RoleVo> roleVoList, List<Role> list) {
        if (CollectionUtils.isEmpty(roleVoList)) {
            return true;
        }
        for (RoleVo vo : roleVoList) {
            if (StringUtil.isEmpty((String)vo.getCode())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u7ec4\u7ec7\u7f16\u7801[%s]\u4e3a\u7a7a\uff01", vo.getName()));
                continue;
            }
            Role role = this.roleManager.getByAlias(vo.getCode());
            if (role == null) {
                role = new Role();
            }
            BeanUtil.copyProperties((Object)vo, (Object)role, (String[])new String[0]);
            list.add(role);
        }
        return this.roleManager.saveOrUpdateBatch(list);
    }

    @Override
    public Boolean setUsers(List<UserVo> userVoList) throws Exception {
        Serializable user2;
        if (CollectionUtils.isEmpty(userVoList)) {
            return true;
        }
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        HashMap<String, UserVo> userVoMap = new HashMap<String, UserVo>(userVoList.size());
        for (UserVo vo : userVoList) {
            if (StringUtil.isEmpty((String)vo.getAccount())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u7528\u6237\u8d26\u53f7[%s]\u4e3a\u7a7a\uff01", vo.getFullname()));
                continue;
            }
            user2 = this.userManager.getByAccount(vo.getAccount());
            if (user2 == null) {
                user2 = new User();
            }
            userVoMap.put(vo.getAccount(), vo);
            BeanUtil.copyProperties((Object)vo, (Object)user2, (String[])new String[0]);
            list.add(user2);
        }
        boolean result = false;
        MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();
        user2 = null;
        try {
            result = this.userManager.saveOrUpdateBatch(list);
        }
        catch (Throwable throwable) {
            user2 = throwable;
            throw throwable;
        }
        finally {
            if (setThreadLocalIgnore != null) {
                if (user2 != null) {
                    try {
                        setThreadLocalIgnore.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)user2).addSuppressed(throwable);
                    }
                } else {
                    setThreadLocalIgnore.close();
                }
            }
        }
        for (Serializable user2 : list) {
            UserVo vo = (UserVo)userVoMap.get(((User)user2).getAccount());
            if (!this.setOrgUser(vo.getOrgUserVoList(), ((User)user2).getId()).booleanValue()) {
                this.logger.error(String.format("\u66f4\u65b0 %s[%s] \u7528\u6237\u7ec4\u7ec7\u5c97\u4f4d\u5173\u7cfb\u5931\u8d25\uff01", ((User)user2).getFullname(), ((User)user2).getAccount()));
            }
            if (!this.setUserRole(vo.getRoleList(), ((User)user2).getId()).booleanValue()) {
                this.logger.error(String.format("\u66f4\u65b0 %s[%s] \u7528\u6237\u89d2\u8272\u5173\u8054\u8868\u5931\u8d25\uff01", ((User)user2).getFullname(), ((User)user2).getAccount()));
            }
            if (this.setUserParams(vo.getParamsList(), ((User)user2).getId()).booleanValue()) continue;
            this.logger.error(String.format("\u66f4\u65b0 %s[%s] \u7528\u6237\u53c2\u6570\u5931\u8d25\uff01", ((User)user2).getFullname(), ((User)user2).getAccount()));
        }
        return result;
    }

    @Override
    public Boolean setParams(List<ParamsVo> paramsVoList) throws Exception {
        if (CollectionUtils.isEmpty(paramsVoList)) {
            return true;
        }
        ArrayList<Params> list = new ArrayList<Params>();
        for (ParamsVo vo : paramsVoList) {
            if (StringUtil.isEmpty((String)vo.getCode())) {
                this.logger.error(String.format("\u63a5\u6536\u5230\u7684\u53c2\u6570\u7f16\u7801[%s]\u4e3a\u7a7a\uff01", vo.getName()));
                continue;
            }
            Params param = this.paramsManager.getByCode(vo.getCode());
            if (param == null) {
                param = new Params();
            }
            BeanUtil.copyProperties((Object)vo, (Object)param, (String[])new String[0]);
            list.add(param);
        }
        return this.paramsManager.saveOrUpdateBatch(list);
    }

    private Boolean setUserRole(List<RoleVo> roleVoList, String userId) {
        if (CollectionUtils.isEmpty(roleVoList) || StringUtil.isEmpty((String)userId)) {
            return true;
        }
        ArrayList<Role> roleList = new ArrayList<Role>();
        this.setRoles(roleVoList, roleList);
        this.userRoleManager.removeByUserId(userId, LocalDateTime.now());
        ArrayList<UserRole> list = new ArrayList<UserRole>();
        for (RoleVo vo : roleVoList) {
            Role role = roleList.stream().filter(r -> r.getCode().equalsIgnoreCase(vo.getCode())).findFirst().orElse(null);
            if (role == null) continue;
            UserRole userRole = new UserRole();
            userRole.setRoleId(role.getId());
            userRole.setUserId(userId);
            list.add(userRole);
        }
        return this.userRoleManager.saveBatch(list);
    }

    private Boolean setOrgUser(List<OrgUserVo> orgUserVoList, String userId) {
        if (CollectionUtils.isEmpty(orgUserVoList) || StringUtil.isEmpty((String)userId)) {
            return true;
        }
        this.orgUserManager.removeByUserId(userId, LocalDateTime.now());
        ArrayList<OrgUser> list = new ArrayList<OrgUser>();
        for (OrgUserVo vo : orgUserVoList) {
            OrgPost orgPost;
            Org org;
            OrgUser orgUser = new OrgUser();
            BeanUtil.copyProperties((Object)vo, (Object)orgUser, (String[])new String[0]);
            if (StringUtil.isNotEmpty((String)vo.getOrgCode()) && (org = this.orgManager.getByCode(vo.getOrgCode())) != null) {
                orgUser.setOrgId(org.getId());
            }
            if (StringUtil.isNotEmpty((String)vo.getPosCode()) && (orgPost = this.orgPostManager.getByCode(vo.getPosCode())) != null) {
                orgUser.setRelId(orgPost.getId());
            }
            list.add(orgUser);
        }
        return this.orgUserManager.saveBatch(list);
    }
}

