/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.EncryptUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.manager.ElectronicSealManager;
import com.hotent.uc.model.ElectronicSeal;
import com.hotent.uc.params.seal.ImportSignatureObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/electronicSeal/v2"})
@Api(tags={"electronicSealController2"})
@ApiGroup(group={"group_uc"})
public class ElectronicSealController2
extends BaseController2<ElectronicSealManager, ElectronicSeal> {
    @Resource
    ElectronicSealManager electronicSealManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    @PostMapping(value={"save"})
    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> save(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        return CommonResultUtil.getResult(this.electronicSealManager.saveElectronicSeal(electronicSeal));
    }

    @PostMapping(value={"userSave"})
    @ApiOperation(value="front\u7528\u6237\u81ea\u5df1\u6dfb\u52a0\u7535\u5b50\u7b7e\u7ae0", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7ae0\u6210\u529f")
    public CommonResult<String> userSave(@ApiParam(name="electronicSeal", value="\u7535\u5b50\u7b7e\u7ae0\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody ElectronicSeal electronicSeal) throws Exception {
        CommonResult<String> commonResult = this.electronicSealManager.userSaveElectronicSeal(electronicSeal);
        return CommonResultUtil.getResult(commonResult);
    }

    @PostMapping(value={"mobileUpdate"})
    @ApiOperation(value="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0", httpMethod="POST", notes="\u624b\u673a\u7aef\u66f4\u65b0\u7b7e\u7ae0")
    public CommonResult<String> mobileUpdate(@RequestBody ElectronicSeal electronicSeal) throws Exception {
        CommonResult<String> commonResult = this.electronicSealManager.mobileUpdateElectronicSeal(electronicSeal);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"getElectronicSeal"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7b7e\u7ae0id")
    public CommonResult<String> getUser(@ApiParam(name="password", value="\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801") @RequestParam(required=true) Optional<String> password, @ApiParam(name="secretFree", value="\u662f\u5426\u514d\u5bc6") @RequestParam(required=true) Optional<Boolean> secretFree) throws Exception {
        CommonResult commonResult = null;
        boolean isSecretFree = secretFree.orElse(false);
        if (!isSecretFree && StringUtil.isEmpty((String)password.get())) {
            return CommonResultUtil.getResult((CommonResult)new CommonResult(false, "\u8bf7\u8f93\u5165\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801"));
        }
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        commonResult = BeanUtils.isEmpty((Object)((Object)electronicSeal)) ? new CommonResult(false, "\u60a8\u8fd8\u672a\u8bbe\u7f6e\u7b7e\u7ae0\uff0c\u8bf7\u5728\u4e2a\u4eba\u4fe1\u606f\u4e2d\u8bbe\u7f6e\u60a8\u7684\u7b7e\u7ae0") : (!isSecretFree && !electronicSeal.getPassword().equals(this.encryptSealPassword(password.get())) ? new CommonResult(false, "\u7b7e\u7ae0\u4f7f\u7528\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165") : new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)electronicSeal.getFileId()));
        return CommonResultUtil.getResult((CommonResult)commonResult);
    }

    @GetMapping(value={"/getSealByUserId/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u7535\u5b50\u7b7e\u7ae0")
    public CommonResult<ElectronicSeal> getSealByUserId(@PathVariable(value="userId") String userId) {
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)userId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return CommonResult.ok().message("\u6682\u65e0\u7b7e\u7ae0\uff01");
        }
        electronicSeal.setPassword("");
        return CommonResult.ok().value((Object)electronicSeal);
    }

    @GetMapping(value={"/getSealByCurrentUserId"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u7535\u5b50\u7b7e\u7ae0")
    public CommonResult<ElectronicSeal> getCurrentUserSeal() {
        String currentUserId = AuthenticationUtil.getCurrentUserId();
        ElectronicSeal electronicSeal = (ElectronicSeal)((Object)this.electronicSealManager.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IS_USE_", (Object)0)).eq((Object)"USER_ID_", (Object)currentUserId)));
        if (BeanUtils.isEmpty((Object)((Object)electronicSeal))) {
            return CommonResult.ok().message("\u6682\u65e0\u7b7e\u7ae0\uff01");
        }
        electronicSeal.setPassword("");
        return CommonResult.ok().value((Object)electronicSeal);
    }

    @RequestMapping(value={"/saveSignatureBatch"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", httpMethod="POST", notes="\u5904\u7406\u6279\u91cf\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e")
    public CommonResult<String> saveSignatureBatch(@ApiParam(name="signatureData", value="\u5bfc\u5165\u7684\u7528\u6237\u7b7e\u7ae0\u6570\u636e", required=true) @RequestBody ImportSignatureObject signatureData) throws Exception {
        CommonResult<String> commonResult = ((ElectronicSealManager)this.baseService).importSignature(signatureData);
        return CommonResultUtil.getResult(commonResult);
    }

    private String encryptSealPassword(String blankPswd) throws Exception {
        return EncryptUtil.encrypt((String)blankPswd);
    }
}

