/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.params.job.JobVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UpdateMethod;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/job/v2/"})
@Api(tags={"\u804c\u52a1\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class JobController2
extends BaseController2<OrgJobManager, OrgJob> {
    @Resource
    OrgJobManager orgJobService;

    @RequestMapping(value={"job/addJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u804c\u52a1", httpMethod="POST", notes="\u6dfb\u52a0\u804c\u52a1")
    public CommonResult<String> addJob(@ApiParam(name="job", value="\u804c\u52a1\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody JobVo job) throws Exception {
        CommonResult<String> commonResult = this.orgJobService.addJob(job);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"job/deleteJob"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u5220\u9664\u804c\u52a1", httpMethod="POST", notes="\u6839\u636e\u89d2\u7f16\u7801\u8bc6\u5220\u9664\u804c\u52a1")
    public CommonResult<String> deleteJob(@ApiParam(name="codes", value="\u804c\u52a1\u7f16\u7801\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestBody String codes) throws Exception {
        CommonResult<String> commonResult = this.orgJobService.deleteJob(codes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"job/deleteJobByIds"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1id\u5220\u9664\u804c\u52a1", httpMethod="DELETE", notes="\u6839\u636e\u804c\u52a1id\u5220\u9664\u804c\u52a1")
    public CommonResult<String> deleteJobByIds(@ApiParam(name="ids", value="\u804c\u52a1id\uff08\u591a\u4e2a\u7528,\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String ids) throws Exception {
        CommonResult<String> commonResult = this.orgJobService.deleteJobByIds(ids);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"job/updateJob"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u804c\u52a1", httpMethod="PUT", notes="\u66f4\u65b0\u804c\u52a1")
    @UpdateMethod(type=JobVo.class)
    public CommonResult<String> updateJob(@ApiParam(name="job", value="\u804c\u52a1\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody JobVo job) throws Exception {
        CommonResult<String> commonResult = this.orgJobService.updateJob(job);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"job/getJob"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u804c\u52a1\u7f16\u7801\u6216id\u83b7\u53d6\u804c\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u804c\u52a1\u4fe1\u606f")
    public CommonResult<OrgJob> getJob(@ApiParam(name="code", value="\u804c\u52a1\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        OrgJob orgJob = this.orgJobService.getJob(code);
        return CommonResult.ok().value((Object)orgJob);
    }

    @RequestMapping(value={"jobUser/getUsersByJob"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u804c\u52a1\uff08\u591a\u4e2a\uff09\u4e0b\u7684\u6240\u6709\u4eba\u5458", httpMethod="GET", notes="\u83b7\u53d6\u804c\u52a1\u4e0b\u7684\u6240\u6709\u4eba\u5458")
    public CommonResult<List<UserVo>> getUsersByJob(@ApiParam(name="codes", value="\u804c\u52a1\u7f16\u7801\uff08\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u9694\u5f00\uff09", required=true) @RequestParam String codes) throws Exception {
        List<UserVo> users = this.orgJobService.getUsersByJob(codes);
        return CommonResult.ok().value(users);
    }

    @RequestMapping(value={"job/deleteJobPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u804c\u52a1\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u804c\u52a1\u6570\u636e")
    public CommonResult<Integer> deleteJobPhysical() throws Exception {
        Integer num = this.orgJobService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"jobs/getJobByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u804c\u52a1\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u804c\u52a1\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<OrgJob>> getJobByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        List<OrgJob> orgJobs = this.orgJobService.getJobByTime(btime, etime);
        return CommonResult.ok().value(orgJobs);
    }

    @RequestMapping(value={"job/isCodeExist"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u67e5\u8be2\u804c\u52a1\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728", httpMethod="GET", notes="\u67e5\u8be2\u804c\u52a1\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728")
    public CommonResult<Boolean> isCodeExist(@ApiParam(name="code", value="\u804c\u52a1\u7f16\u7801") @RequestParam(required=true) String code) throws Exception {
        CommonResult<Boolean> commonResult = this.orgJobService.isCodeExist(code);
        return CommonResultUtil.getResult(commonResult);
    }
}

