/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.MatrixManager;
import com.hotent.uc.model.Matrix;
import com.hotent.uc.model.User;
import com.hotent.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/uc/matrix/v1"})
@Api(tags={"matrixController"})
@ApiGroup(group={"group_uc"})
public class MatrixController
extends UcBaseController<MatrixManager, Matrix> {
    @Resource
    MatrixManager matrixManager;

    @PostMapping(value={"/listJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public PageList<Matrix> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        User user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("m.CREATE_BY_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
            queryFilter.addFilter("auth.USER_ID_", (Object)user.getUserId(), QueryOP.EQUAL, FieldRelation.OR, "manager");
        }
        if (BeanUtils.isNotEmpty((Object)queryFilter.getSorter())) {
            queryFilter.getSorter().forEach(item -> {
                if ("createTime".equals(item.getProperty())) {
                    item.setProperty("m.CREATE_TIME_");
                }
            });
        }
        return this.matrixManager.listJson(queryFilter);
    }

    @PostMapping(value={"/listDetail"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u7ba1\u7406\u5217\u8868")
    public PageList<Matrix> listDetail(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        return this.matrixManager.listDetail(queryFilter);
    }

    @GetMapping(value={"/getJson"})
    @ApiOperation(value="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u77e9\u9635\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public Matrix get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        Matrix matrix = this.matrixManager.getDetail(id);
        return matrix;
    }

    @RequestMapping(value={"getByCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801/\u522b\u540d\u83b7\u53d6\u77e9\u9635", httpMethod="GET", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public Matrix getByAlias(@ApiParam(name="code", value="code", required=true) @RequestParam String code) throws Exception {
        return this.matrixManager.getByAlias(code);
    }

    @RequestMapping(value={"getMatrixInTypeIds"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801/\u522b\u540d\u83b7\u53d6\u77e9\u9635", httpMethod="POST", notes="\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public List<Matrix> getMatrixInTypeIds(@RequestParam(value="typeIds", required=true) List<String> typeIds) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"TYPE_ID_", typeIds);
        return this.matrixManager.list((Wrapper)wrapper);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="matrix", value="\u77e9\u9635\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody Matrix matrix) throws Exception {
        String msg = "\u4fdd\u5b58\u77e9\u9635\u7ba1\u7406\u6210\u529f";
        Boolean isCodeExist = this.matrixManager.isCodeExist(matrix.getCode(), matrix.getId());
        if (isCodeExist.booleanValue()) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        this.matrixManager.saveMatrix(matrix);
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u77e9\u9635\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.matrixManager.batchRemove(ids);
        String msg = ThreadMsgUtil.getMessage();
        if (msg != null && !msg.contains("\u4e0d\u5141\u8bb8\u5220\u9664")) {
            msg = "\u6279\u91cf\u5220\u9664\u6210\u529f";
        }
        return new CommonResult(true, msg);
    }

    @GetMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03", httpMethod="GET", notes="publish")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        this.matrixManager.publish(id);
        return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
    }

    @GetMapping(value={"/saveManager"})
    @ApiOperation(value="\u4fdd\u5b58\u7ba1\u7406\u5458", httpMethod="GET", notes="saveManager")
    public CommonResult<String> saveManager(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="userId", value="\u7ba1\u7406\u5458userId", required=true) @RequestParam String userId, @ApiParam(name="fullname", value="\u7ba1\u7406\u5458\u540d\u79f0", required=true) @RequestParam String fullname) throws Exception {
        Matrix matrix = (Matrix)this.matrixManager.get((Serializable)((Object)id));
        matrix.setManagerId(userId);
        matrix.setManagerName(fullname);
        this.matrixManager.update((Model)matrix);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/getUsers"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public List<Map<String, Object>> getUsers(@RequestBody Map<String, Object> params) throws Exception {
        return this.matrixManager.getUsers(params);
    }

    @PostMapping(value={"/data/list/{matrixId}"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    @ResponseBody
    public Object dataList(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Matrix> queryFilter) throws Exception {
        Map<String, Object> map = this.matrixManager.getDataWithUcData(matrixId, queryFilter);
        return map;
    }

    @GetMapping(value={"/data/getOneData"})
    @ApiOperation(value="\u83b7\u53d6\u67d0\u6761\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u67d0\u6761\u6570\u636e")
    @ResponseBody
    public Object getOneData(@ApiParam(name="pk", value="pk") @RequestParam String pk, @ApiParam(name="matrixId", value="matrixId") @RequestParam String matrixId) throws Exception {
        if (StringUtil.isNotEmpty((String)pk)) {
            Map<String, Object> map = this.matrixManager.getOneData(matrixId, pk);
            return map;
        }
        Map<String, Object> map = this.matrixManager.getBlankOneData(matrixId);
        return map;
    }

    @PostMapping(value={"/data/save/{matrixId}"})
    @ApiOperation(value="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u77e9\u9635\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> dataSave(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="data", value="data") @RequestBody String data) throws Exception {
        String id = this.matrixManager.saveData(matrixId, data);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)id);
    }

    @DeleteMapping(value={"/data/remove/{matrixId}"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6570\u636e\u8bb0\u5f55")
    public CommonResult<String> dataRemove(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, String ... ids) throws Exception {
        this.matrixManager.dataRemove(matrixId, ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5173\u7cfb\u77e9\u9635xml", httpMethod="GET", notes="\u5bfc\u51fa\u8868\u5355xml")
    public void exportForm(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u5173\u7cfb\u77e9\u9635id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (StringUtil.isEmpty((String)ids)) {
            return;
        }
        String[] idArray = ids.split(",");
        List<String> idList = Arrays.asList(idArray);
        Map<String, String> map = ((MatrixManager)this.baseService).export(idList);
        String fileName = "ht_matrix_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, map, (String)fileName);
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5173\u7cfb\u77e9\u9635\u5bfc\u5165\u524d\u6821\u9a8c", httpMethod="POST", notes="\u5173\u7cfb\u77e9\u9635\u5bfc\u5165\u524d\u6821\u9a8c")
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u5173\u7cfb\u77e9\u9635\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="typeName", value="\u5173\u7cfb\u77e9\u9635\u6807\u8bc6\u540d\u79f0", required=false) @RequestParam Optional<String> typeName) throws Exception {
        return ((MatrixManager)this.baseService).importCheck(request, response, typeId, typeName);
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5173\u7cfb\u77e9\u9635\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u5173\u7cfb\u77e9\u9635\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="typeName", value="\u5173\u7cfb\u77e9\u9635\u6807\u8bc6\u540d\u79f0", required=false) @RequestParam Optional<String> typeName, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6d41\u7a0b\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        return ((MatrixManager)this.baseService).importSave(confirmImport, typeId, typeName, cacheFileId);
    }

    @PostMapping(value={"/data/batch/save/{matrixId}"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u5217\u5b9a\u4e49\u6570\u636e", httpMethod="POST", notes="\u6279\u91cf\u65b0\u589e,\u66f4\u65b0\u77e9\u9635\u5217\u5b9a\u4e49\u6570\u636e")
    public CommonResult<String> batchSave(@ApiParam(name="matrixId", value="\u77e9\u9635id") @PathVariable String matrixId, @ApiParam(name="data", value="data") @RequestBody List<Map<String, Object>> data) throws Exception {
        ((MatrixManager)this.baseService).batchSaveData(matrixId, data);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }
}

