/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.OrgAuth;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.org.OrgAuthVo;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/orgAuth/v1/"})
@Api(tags={"\u7ec4\u7ec7\u5206\u7ea7\u7ba1\u7406"})
@ApiGroup(group={"group_uc"})
public class OrgAuthController
extends UcBaseController<OrgAuthManager, OrgAuth> {
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    OrgManager orgService;
    @Autowired
    UserManager userService;

    @RequestMapping(value={"orgAuths/getOrgAuthPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5206\u7ea7\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7ec4\u7ec7\u5206\u7ea7\u5217\u8868")
    public PageList<OrgAuth> getOrgAuthPage(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter filter, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode, @ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7") @RequestParam(required=false) String account) throws Exception {
        PageList<OrgAuth> res = this.orgAuthService.getOrgAuthPage(filter, orgCode, account);
        return res;
    }

    @RequestMapping(value={"orgAuth/addOrgAuth"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u5206\u7ea7", httpMethod="POST", notes="\u6dfb\u52a0\u7ec4\u7ec7\u5206\u7ea7")
    public CommonResult<String> addOrgAuth(@ApiParam(name="orgAuthVo", value="\u7ec4\u7ec7\u5206\u7ea7\u5bf9\u8c61", required=true) @RequestBody OrgAuthVo orgAuthVo) throws Exception {
        this.orgAuthService.addOrgAuth(orgAuthVo);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"orgAuth/updateOrgAuth"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u5206\u7ea7", httpMethod="PUT", notes="\u4fee\u6539\u7ec4\u7ec7\u5206\u7ea7")
    public CommonResult<String> updateOrgAuth(@ApiParam(name="orgAuthVo", value="\u7ec4\u7ec7\u5206\u7ea7\u5bf9\u8c61", required=true) @RequestBody OrgAuthVo orgAuthVo) throws Exception {
        this.orgAuthService.updateOrgAuth(orgAuthVo);
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"orgAuth/delOrgAuth"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u7ec4\u7ec7\u5206\u7ea7", httpMethod="DELETE", notes="\u5220\u9664\u7ec4\u7ec7\u5206\u7ea7")
    public CommonResult<String> delOrgAuth(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        this.orgAuthService.delOrgAuth(account, orgCode);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"orgAuth/getOrgAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u5206\u7ea7", httpMethod="GET", notes="\u83b7\u53d6\u7ec4\u7ec7\u5206\u7ea7")
    public OrgAuth getOrgAuth(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=true) @RequestParam String orgCode) throws Exception {
        return this.orgAuthService.getOrgAuth(account, orgCode);
    }

    @RequestMapping(value={"orgAuth/deleteOrgAuthPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5206\u7ea7\u7ec4\u7ec7\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u5206\u7ea7\u7ec4\u7ec7\u6570\u636e")
    public CommonResult<Integer> deleteOrgAuthPhysical() throws Exception {
        Integer num = this.orgAuthService.removePhysical();
        return OrgUtil.getRemovePhysiMsg(num);
    }

    @RequestMapping(value={"orgAuths/getOrgAuthByTime"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5206\u7ea7\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="POST", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u5206\u7ea7\u7ec4\u7ec7\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public List<OrgAuth> getOrgAuthByTime(@ApiParam(name="exportObject", value="\u83b7\u53d6\u6570\u636e\u53c2\u6570\u7c7b", required=true) @RequestBody OrgExportObject exportObject) throws Exception {
        return this.orgAuthService.getOrgAuthByTime(exportObject);
    }

    @RequestMapping(value={"orgAuths/getAllOrgAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u7ea7\u7ec4\u7ec7", httpMethod="POST", notes="\u83b7\u53d6\u5206\u7ea7\u7ec4\u7ec7")
    public PageList<OrgAuth> getAllOrgAuth(QueryFilter queryFilter) {
        queryFilter = QueryFilter.build();
        queryFilter.addFilter("b.account_", (Object)ContextUtil.getCurrentUser().getAccount(), QueryOP.EQUAL);
        try {
            IPage<OrgAuth> list = this.orgAuthService.getAllOrgAuth((QueryFilter<OrgAuth>)queryFilter);
            return new PageList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"orgAuths/getCurrentUserAuthOrgLayout"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ec7\u5e03\u5c40\u7ba1\u7406\u6743\u9650", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ec7\u5e03\u5c40\u7ba1\u7406\u6743\u9650")
    public List<OrgAuth> getCurrentUserAuthOrgLayout(@ApiParam(name="userId", value="\u7528\u6237id") @RequestParam Optional<String> userId) throws Exception {
        String uId = userId.orElse(null);
        uId = StringUtil.isEmpty((String)uId) ? this.userService.getByAccount(ContextUtil.getCurrentUser().getAccount()).getUserId() : uId;
        List<OrgAuth> orgAuthList = this.orgAuthService.getLayoutOrgAuth(uId);
        return orgAuthList;
    }
}

