/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.context.BaseContext;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.manager.TenantMailServerManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.model.TenantMailServer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantMailServer/v2"})
@Api(tags={"\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f2"})
@ApiGroup(group={"group_uc"})
public class TenantMailServerController2
extends BaseController2<TenantMailServerManager, TenantMailServer> {
    @Resource
    TenantMailServerManager tenantMailServerManager;
    @Resource
    BaseContext baseContext;
    @Resource
    TenantManageManager tenantManageManager;

    @GetMapping(value={"/getByCurrent"})
    @ApiOperation(value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e\u8be6\u60c5")
    public CommonResult<TenantMailServer> getByCurrent(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam Optional<String> tenantId) throws Exception {
        String currentTenantId = StringUtil.isEmpty((String)tenantId.orElse(null)) ? this.baseContext.getCurrentTenantId() : tenantId.get();
        TenantMailServer mailServer = this.tenantMailServerManager.getByTenantId(currentTenantId);
        if (BeanUtils.isEmpty((Object)((Object)mailServer))) {
            mailServer = new TenantMailServer();
            mailServer.setTenantId(currentTenantId);
        }
        return CommonResult.ok().value((Object)mailServer);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantMailServer", value="\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantMailServer tenantMailServer) throws Exception {
        CommonResult<String> commonResult = this.tenantMailServerManager.saveTenantMailServer(tenantMailServer);
        return CommonResultUtil.getResult(commonResult);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u90ae\u4ef6\u670d\u52a1\u5668\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.tenantMailServerManager.removeByIds(ids);
        return CommonResult.ok().message("\u5220\u9664\u6210\u529f");
    }
}

