/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.context.BaseContext;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.manager.TenantAuthManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.manager.TenantTypeManager;
import com.hotent.uc.model.TenantAuth;
import com.hotent.uc.model.TenantType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/tenantType/v2"})
@Api(tags={"\u79df\u6237\u7c7b\u578b\u7ba1\u74062"})
@ApiGroup(group={"group_uc"})
public class TenantTypeController2
extends BaseController2<TenantTypeManager, TenantType> {
    @Resource
    TenantTypeManager tenantTypeManager;
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    TenantAuthManager tenantAuthManager;
    @Resource
    BaseContext baseContext;

    @GetMapping(value={"/getAll"})
    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u6240\u6709\u79df\u6237\u7c7b\u578b", httpMethod="GET", notes="\u6839\u636e\u72b6\u6001\u83b7\u53d6\u6240\u6709\u79df\u6237\u7c7b\u578b")
    public CommonResult<List<TenantType>> getAll(@ApiParam(name="status:enable\uff08\u542f\u7528\uff09\u3001disabled\uff08\u7981\u7528\uff09", value="\u72b6\u6001", required=false) @RequestParam Optional<String> status) throws Exception {
        List<String> authIds = null;
        List<TenantType> tenantTypeList = this.tenantTypeManager.getByStatus(status.orElse(null), authIds);
        return CommonResult.ok().value(tenantTypeList);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="tenantType", value="\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody TenantType tenantType) throws Exception {
        CommonResult<String> commonResult = this.tenantTypeManager.saveTenantType(tenantType);
        return CommonResultUtil.getResult(commonResult);
    }

    @PostMapping(value={"setDefault"})
    @ApiOperation(value="\u6839\u636e\u79df\u6237\u7c7b\u578b\u7f16\u7801\u8bbe\u7f6e\u9ed8\u8ba4\u79df\u6237\u7c7b\u578b", httpMethod="POST", notes="\u6839\u636e\u79df\u6237\u7c7b\u578b\u7f16\u7801\u8bbe\u7f6e\u9ed8\u8ba4\u79df\u6237\u7c7b\u578b")
    public CommonResult<String> setDefault(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801", required=true) @RequestParam String code) throws Exception {
        CommonResult<String> commonResult = this.tenantTypeManager.setDefault(code);
        return CommonResultUtil.getResult(commonResult);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u79df\u6237\u7c7b\u578b\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        CommonResult<String> commonResult = this.tenantTypeManager.removes(ids);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"checkCode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u79df\u6237\u7c7b\u578b\u7f16\u7801\u662f\u5426\u5b58\u5728")
    public CommonResult<Boolean> checkCode(@ApiParam(name="code", value="\u79df\u6237\u7c7b\u578b\u7f16\u7801") @RequestParam String code) throws Exception {
        TenantType type = this.tenantTypeManager.getByCode(code);
        boolean flag = BeanUtils.isNotEmpty((Object)((Object)type));
        return CommonResult.ok().value((Object)flag);
    }

    private List<String> getAuthId() {
        String currentUserId = this.baseContext.getCurrentUserId();
        ArrayList<String> ids = new ArrayList<String>();
        List<TenantAuth> auths = this.tenantAuthManager.getByUserId(null, null, currentUserId);
        if (BeanUtils.isNotEmpty(auths)) {
            for (TenantAuth tenantAuth : auths) {
                if (!StringUtil.isNotEmpty((String)tenantAuth.getTenantId())) continue;
                ids.add(tenantAuth.getTypeId());
            }
        }
        if (BeanUtils.isEmpty(ids)) {
            ids.add("-1");
        }
        return ids;
    }
}

