/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.NewVersion;
import com.hotent.base.controller.BaseController;
import com.hotent.base.manager.BaseManager;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.ReflectUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.annotation.TableAlias;
import com.hotent.uc.exception.BaseException;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@NewVersion
public class UcBaseController<M extends BaseManager<T>, T extends Model<T>>
extends BaseController<M, T> {
    @Autowired
    CommonManager commonManager;

    @GetMapping(value={"/restoreByAlias/{alias}"})
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u6062\u590d\u903b\u8f91\u5220\u9664\u7684\u6570\u636e")
    public CommonResult<String> restoreByAlias(@ApiParam(name="alias", value="\u5b9e\u4f53\u522b\u540d") @PathVariable String alias) {
        Class currentModelClass = this.baseService.getCurrentModelClass();
        return this.restoreByClassAndAlias(currentModelClass, alias);
    }

    CommonResult<String> restoreByClassAndAlias(Class<?> currentModelClass, String alias) {
        List allField = ReflectUtil.getAllField(currentModelClass);
        TableField aliasField = null;
        TableField logicField = null;
        String aliasDesc = "";
        for (Field f : allField) {
            if (f.getAnnotation(TableAlias.class) != null) {
                aliasField = f.getAnnotation(TableField.class);
                aliasDesc = f.getAnnotation(ApiModelProperty.class).notes();
            }
            if (f.getAnnotation(TableLogic.class) == null) continue;
            logicField = f.getAnnotation(TableField.class);
        }
        if (StringUtil.isEmpty((String)alias)) {
            return CommonResult.error((String)String.format("%s\u4e0d\u80fd\u4e3a\u7a7a", aliasDesc));
        }
        if (aliasField == null) {
            return CommonResult.error((String)"\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u522b\u540d\u5b57\u6bb5\u5b57\u6bb5");
        }
        if (logicField == null) {
            return CommonResult.error((String)"\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u903b\u8f91\u5220\u9664\u5b57\u6bb5");
        }
        TableName tableName = currentModelClass.getAnnotation(TableName.class);
        if (tableName == null) {
            throw new BaseException("\u6062\u590d\u5931\u8d25\uff1a\u5bf9\u8c61\u6ca1\u6709\u8868\u540d\u6ce8\u89e3");
        }
        String sql = String.format("update %s set  %s ='0'  where %s = '%s' ", tableName.value(), logicField.value(), aliasField.value(), alias);
        int execute = this.commonManager.execute(sql);
        if (execute > 0) {
            return CommonResult.ok().message("\u6062\u590d\u6210\u529f");
        }
        return CommonResult.error((String)String.format("\u6062\u590d\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5%s[%s]\u662f\u5426\u5b58\u5728\u8fc7", aliasDesc, alias));
    }
}

