/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.controller.UcBaseController;
import com.hotent.uc.manager.UcGroupManager;
import com.hotent.uc.model.UcGroup;
import com.hotent.uc.util.ContextUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/ucGroup/v1/"})
public class UcGroupController
extends UcBaseController<UcGroupManager, UcGroup> {
    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody UcGroup ucGroup) {
        String msg = "\u6dfb\u52a0\u7fa4\u7ec4\u6210\u529f";
        if (StringUtil.isNotEmpty((String)ucGroup.getId())) {
            ((UcGroupManager)this.baseService).update((Model)ucGroup);
            msg = "\u66f4\u65b0\u7fa4\u7ec4\u6210\u529f";
        } else {
            ucGroup.setCreatorName(ContextUtil.getCurrentUser().getFullname());
            UcGroup existsData = ((UcGroupManager)this.baseService).getByAlias(ucGroup.getCode());
            if (BeanUtils.isNotEmpty((Object)((Object)existsData))) {
                throw new MessagePassingException(String.format("\u522b\u540d\u3010%s\u3011\u5df2\u5b58\u5728", ucGroup.getCode()));
            }
            ((UcGroupManager)this.baseService).save((Object)ucGroup);
        }
        return new CommonResult(msg);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<UcGroup> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<UcGroup> queryFilter) {
        queryFilter.addFilter("create_by_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        return ((UcGroupManager)this.baseService).query(queryFilter);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> remove(String ... ids) {
        ((UcGroupManager)this.baseService).deleteByIds(Arrays.asList(ids));
        return new CommonResult("\u5220\u9664\u7fa4\u7ec4\u6210\u529f");
    }

    @RequestMapping(value={"setCookie"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7528\u6237\u5207\u6362\u5c97\u4f4d\u540e\uff0c\u4fdd\u5b58\u5f53\u524d\u7528\u6237\u5207\u6362\u5c97\u4f4d\u7684\u4fe1\u606f", httpMethod="GET")
    public CommonResult<String> setCurrentUserGroup(@RequestParam(value="postId") String postId) {
        String userId = ContextUtil.getCurrentUser().getId();
        UcGroupController bean = (UcGroupController)((Object)AppUtil.getBean(UcGroupController.class));
        bean.putCache(userId, postId);
        return CommonResult.ok();
    }

    @CachePut(value={"eip:uc:current_user_group_id"}, key="#userId", firstCache=@FirstCache(expireTime=100, timeUnit=TimeUnit.DAYS))
    public String putCache(String userId, String postId) {
        return postId;
    }
}

