/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.controller;

import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController2;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CommonResultUtil;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserRelManager;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserRel;
import com.hotent.uc.params.user.UserRelFilterObject;
import com.hotent.uc.params.user.UserRelVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/userRel/v2/"})
@Api(tags={"\u6c47\u62a5\u5173\u7cfb2"})
@ApiGroup(group={"group_uc"})
public class UserRelController2
extends BaseController2<UserRelManager, UserRel> {
    @Resource
    UserRelManager userRelService;
    @Resource
    UserManager userService;
    @Autowired
    PortalFeignService portalFeignService;

    @RequestMapping(value={"userRels/getUserRelPage"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5217\u8868")
    public CommonResult<PageList> getUserRelPage(@ApiParam(name="filter", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestBody QueryFilter filter) throws Exception {
        PageList pageList = this.userRelService.query(filter);
        return CommonResult.ok().value((Object)pageList);
    }

    @RequestMapping(value={"userRels/getUserRelByTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6c47\u62a5\u7ebf\u5206\u7c7b\u7f16\u7801\u83b7\u53d6\u4e0b\u5c5e\u7684\u6240\u6709\u6c47\u62a5\u7ebf", httpMethod="GET", notes="\u6839\u636e\u6c47\u62a5\u7ebf\u5206\u7c7b\u7f16\u7801\u83b7\u53d6\u4e0b\u5c5e\u7684\u6240\u6709\u6c47\u62a5\u7ebf")
    public CommonResult<List<UserRel>> getUserRelByTypeId(@ApiParam(name="typeId", value="\u5206\u7c7bId", required=true) @RequestParam String typeId) throws Exception {
        List<UserRel> list = this.userRelService.getUserRelByTypeId(typeId);
        List rtnList = BeanUtils.listToTree(list);
        return CommonResult.ok().value((Object)rtnList);
    }

    @RequestMapping(value={"userRels/getChildRelByAilas"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6c47\u62a5\u7ebf\u522b\u540d\u83b7\u53d6\u5176\u76f4\u63a5\u5b50\u8282\u70b9", httpMethod="GET", notes="\u6839\u636e\u6c47\u62a5\u7ebf\u522b\u540d\u83b7\u53d6\u5176\u76f4\u63a5\u5b50\u8282\u70b9")
    public CommonResult<PageList<UserRel>> getChildRelByAilas(@ApiParam(name="alias", value="\u67e5\u8be2\u53c2\u6570", required=true) @RequestParam String alias) throws Exception {
        PageList<UserRel> userRelPageList = this.userRelService.getChildRelByAilas(alias);
        return CommonResult.ok().value(userRelPageList);
    }

    @RequestMapping(value={"userRel/addUserRel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49", httpMethod="POST", notes="\u6dfb\u52a0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49")
    public CommonResult<String> addUserRel(@ApiParam(name="userRelVo", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody List<UserRelVo> userRelVo) throws Exception {
        CommonResult<String> commonResult = this.userRelService.addUserRel(userRelVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userRel/deleteUserRel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801\u5220\u9664\u7528\u6237\u5173\u7cfb\u5b9a\u4e49", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801\u5220\u9664\u7528\u6237\u5173\u7cfb\u5b9a\u4e49")
    public CommonResult<String> deleteUserRel(@ApiParam(name="codes", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801", required=true) @RequestBody String codes) throws Exception {
        CommonResult<String> commonResult = this.userRelService.deleteUserRel(codes);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userRel/updateUserRel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49", httpMethod="POST", notes="\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49")
    public CommonResult<String> updateUserRel(@ApiParam(name="userRelVo", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody UserRelVo userRelVo) throws Exception {
        CommonResult<String> commonResult = this.userRelService.updateUserRel(userRelVo);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userRel/getUserRel"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\u83b7\u53d6\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u4fe1\u606f")
    public CommonResult<UserRel> getUserRel(@ApiParam(name="alias", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        UserRel userRel = this.userRelService.getByAlias(alias);
        return CommonResult.ok().value((Object)userRel);
    }

    @RequestMapping(value={"userRel/getSuperUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u7528\u6237")
    public CommonResult<List<UserVo>> getSuperUser(@ApiParam(name="userRelFilterObject", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801", required=true) @RequestBody UserRelFilterObject userRelFilterObject) throws Exception {
        String typeId = this.userRelService.getRelTypeId(userRelFilterObject);
        List<User> users = this.userRelService.getSuperUser(userRelFilterObject.getAccount(), typeId);
        List<UserVo> userVoList = OrgUtil.convertToUserVoList(users);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"userRel/getAllSuperUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4e0a\u7ea7\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u4e0a\u7ea7\u7528\u6237")
    public CommonResult<List<UserVo>> getAllSuperUser(@ApiParam(name="userRelFilterObject", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801", required=true) @RequestBody UserRelFilterObject userRelFilterObject) throws Exception {
        String typeId = this.userRelService.getRelTypeId(userRelFilterObject);
        List<User> users = this.userRelService.getAllSuperUser(userRelFilterObject.getAccount(), typeId);
        List<UserVo> userVoList = OrgUtil.convertToUserVoList(users);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"userRel/getLowerUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u76f4\u63a5\u4e0b\u7ea7\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u76f4\u63a5\u4e0b\u7ea7\u7528\u6237")
    public CommonResult<List<UserVo>> getLowerUser(@ApiParam(name="userRelFilterObject", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801", required=true) @RequestBody UserRelFilterObject userRelFilterObject) throws Exception {
        String typeId = this.userRelService.getRelTypeId(userRelFilterObject);
        List<User> users = this.userRelService.getLowerUser(userRelFilterObject.getAccount(), typeId);
        List<UserVo> userVoList = OrgUtil.convertToUserVoList(users);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"userRel/getAllLowerUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4e0b\u7ea7\u7528\u6237", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u4e0b\u7ea7\u7528\u6237")
    public CommonResult<List<UserVo>> getAllLowerUser(@ApiParam(name="userRelFilterObject", value="\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7f16\u7801", required=true) @RequestBody UserRelFilterObject userRelFilterObject) throws Exception {
        String typeId = this.userRelService.getRelTypeId(userRelFilterObject);
        List<User> users = this.userRelService.getAllLowerUser(userRelFilterObject.getAccount(), typeId);
        List<UserVo> userVoList = OrgUtil.convertToUserVoList(users);
        return CommonResult.ok().value(userVoList);
    }

    @RequestMapping(value={"userRel/deleteUserRelPhysical"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u5173\u7cfb\u6c47\u62a5\u7ebf\u6570\u636e", httpMethod="DELETE", notes="\u7269\u7406\u5220\u9664\u6240\u6709\u903b\u8f91\u5220\u9664\u4e86\u7684\u7528\u6237\u5173\u7cfb\u6c47\u62a5\u7ebf\u6570\u636e")
    public CommonResult<Integer> deleteUserRelPhysical() throws Exception {
        Integer num = this.userRelService.removePhysical();
        CommonResult<Integer> commonResult = OrgUtil.getRemovePhysiMsg(num);
        return CommonResultUtil.getResult(commonResult);
    }

    @RequestMapping(value={"userRels/getUserRelByTime"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u6c47\u62a5\u7ebf\u8282\u70b9\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09", httpMethod="GET", notes="\u6839\u636e\u65f6\u95f4\u83b7\u53d6\u6c47\u62a5\u7ebf\u8282\u70b9\u6570\u636e\uff08\u6570\u636e\u540c\u6b65\uff09")
    public CommonResult<List<UserRel>> getUserRelByTime(@ApiParam(name="btime", value="\u5f00\u59cb\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-01-01 12:00:00\u62162018-01-01\uff09") @RequestParam(required=false) String btime, @ApiParam(name="etime", value="\u7ed3\u675f\u65f6\u95f4\uff08\u683c\u5f0f\uff1a2018-02-01 12:00:00\u62162018-02-01\uff09") @RequestParam(required=false) String etime) throws Exception {
        List<UserRel> userRelList = this.userRelService.getUserRelByTime(btime, etime);
        return CommonResult.ok().value(userRelList);
    }

    @RequestMapping(value={"userRels/updateRelPos"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u6c47\u62a5\u7ebf\u8282\u70b9\u6240\u5728\u6811\u7684\u4f4d\u7f6e", httpMethod="POST", notes="\u66f4\u65b0\u6c47\u62a5\u7ebf\u8282\u70b9\u6240\u5728\u6811\u7684\u4f4d\u7f6e\uff08\u6811\u7ed3\u6784\u62d6\u52a8\u4fdd\u5b58\uff09")
    public CommonResult<String> updateRelPos(@ApiParam(name="relId", value="\u79fb\u52a8\u8282\u70b9id", required=true) @RequestParam String relId, @ApiParam(name="parentId", value="\u79fb\u81f3\uff08\u76ee\u6807\uff09\u8282\u70b9id", required=true) @RequestParam String parentId) throws Exception {
        CommonResult<String> commonResult = this.userRelService.updateRelPos(relId, parentId);
        return CommonResultUtil.getResult(commonResult);
    }
}

