/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.time.DateUtil;
import com.hotent.uc.dao.CasPageConfigDao;
import com.hotent.uc.manager.CasPageConfigManager;
import com.hotent.uc.model.CasPageConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CasPageConfigManagerImpl
extends BaseManagerImpl<CasPageConfigDao, CasPageConfig>
implements CasPageConfigManager {
    public PageList<CasPageConfig> query(QueryFilter<CasPageConfig> queryFilter) {
        QueryWrapper casPageConfigWrapper = (QueryWrapper)this.convert2Wrapper(queryFilter, this.currentModelClass());
        IPage casPageConfigIPage = this.convert2IPage(queryFilter.getPageBean());
        return new PageList(((CasPageConfigDao)this.baseMapper).queryPage((IPage<CasPageConfig>)casPageConfigIPage, casPageConfigWrapper));
    }

    public boolean removeById(Serializable id) {
        CasPageConfig casPageConfig = (CasPageConfig)super.get(id);
        if (StringUtils.equalsIgnoreCase((String)casPageConfig.getIsDefault(), (String)"1")) {
            throw new BaseException("\u4e0d\u5141\u8bb8\u5220\u9664\u9ed8\u8ba4\u914d\u7f6e");
        }
        return super.removeById(id);
    }

    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return true;
        }
        CasPageConfig defaultPageConfig = this.getDefaultPageConfig();
        for (Serializable serializable : idList) {
            if (!serializable.toString().equals(defaultPageConfig.getIsDefault())) continue;
            throw new BaseException("\u4e0d\u5141\u8bb8\u5220\u9664\u9ed8\u8ba4\u914d\u7f6e");
        }
        return super.removeByIds(idList);
    }

    @Override
    public CasPageConfig getDefaultPageConfig() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CasPageConfig::getIsDefault, (Object)"1")).eq(CasPageConfig::getEnabled, (Object)"1");
        return (CasPageConfig)((Object)((CasPageConfigDao)this.getBaseMapper()).selectOne((Wrapper)wrapper));
    }

    @Override
    public CasPageConfig getNewestPageConfig() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().lt(CasPageConfig::getStartDate, (Object)LocalDateTime.now())).ge(CasPageConfig::getEndDate, (Object)LocalDateTime.now())).eq(CasPageConfig::getEnabled, (Object)"1")).orderByDesc(CasPageConfig::getStartDate)).last(" limit 1");
        CasPageConfig casPageConfig = (CasPageConfig)((Object)((CasPageConfigDao)this.getBaseMapper()).selectOne((Wrapper)wrapper));
        if (Objects.nonNull((Object)casPageConfig)) {
            return casPageConfig;
        }
        wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CasPageConfig::getEnabled, (Object)"1")).orderByDesc(CasPageConfig::getStartDate)).last(" limit 1");
        casPageConfig = (CasPageConfig)((Object)((CasPageConfigDao)this.getBaseMapper()).selectOne((Wrapper)wrapper));
        if (Objects.nonNull((Object)casPageConfig)) {
            return casPageConfig;
        }
        return this.getDefaultPageConfig();
    }

    @Override
    public void getBackgroundImg(String id, Boolean download, HttpServletResponse response) {
        CasPageConfig casPageConfig = null;
        casPageConfig = StringUtils.isNotBlank((String)id) ? (CasPageConfig)this.get((Serializable)((Object)id)) : this.getNewestPageConfig();
        if (StringUtils.isBlank((String)id) && Objects.isNull(casPageConfig.getBackgroundImg())) {
            casPageConfig = this.getDefaultPageConfig();
        }
        this.downloadImg(casPageConfig.getBackgroundImg(), download, response);
    }

    @Override
    public void getLogoImg(String id, Boolean download, HttpServletResponse response) {
        CasPageConfig casPageConfig = null;
        casPageConfig = StringUtils.isNotBlank((String)id) ? (CasPageConfig)this.get((Serializable)((Object)id)) : this.getNewestPageConfig();
        if (Objects.isNull(casPageConfig.getLogo())) {
            casPageConfig = this.getDefaultPageConfig();
        }
        this.downloadImg(casPageConfig.getLogo(), download, response);
    }

    private void downloadImg(byte[] data, Boolean download, HttpServletResponse response) {
        response.reset();
        response.setContentType("image/png");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        if (BooleanUtils.isTrue((Boolean)download)) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "Inline; filename=" + RandomStringUtils.randomNumeric((int)8) + ".png");
        }
        try (ServletOutputStream os = response.getOutputStream();
             ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            os.flush();
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(CasPageConfig entity) {
        if (null != entity) {
            LocalDateTime date;
            String id = entity.getId();
            if (StringUtils.isBlank((String)id) || Objects.isNull(this.getById((Serializable)((Object)id)))) {
                return this.save((Object)entity);
            }
            LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(CasPageConfig::getAlias, (Object)entity.getAlias())).set(CasPageConfig::getHeaderTitle, (Object)entity.getAlias())).set(CasPageConfig::getFooterText, (Object)entity.getFooterText())).set(CasPageConfig::getIsDefault, (Object)(StringUtils.isBlank((String)entity.getIsDefault()) ? "0" : entity.getIsDefault()))).set(CasPageConfig::getEnabled, (Object)(StringUtils.isBlank((String)entity.getEnabled()) ? "0" : entity.getEnabled()))).set(CasPageConfig::getStartDate, (Object)entity.getStartDate())).set(CasPageConfig::getEndDate, (Object)entity.getEndDate())).eq(CasPageConfig::getId, (Object)id)).eq(CasPageConfig::getVersion, (Object)entity.getVersion());
            LocalDate localDate = LocalDate.now();
            if (Objects.isNull(entity.getStartDate())) {
                date = DateUtil.getDate((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth(), (int)0, (int)0, (int)0);
                wrapper.set(CasPageConfig::getStartDate, (Object)date);
            }
            if (Objects.isNull(entity.getEndDate())) {
                date = DateUtil.getDate((int)localDate.getYear(), (int)localDate.getMonthValue(), (int)localDate.getDayOfMonth(), (int)23, (int)59, (int)59);
                wrapper.set(CasPageConfig::getEndDate, (Object)date);
            }
            return this.update((Wrapper)wrapper);
        }
        return false;
    }

    @Override
    public CasPageConfig upload(CasPageConfig paramConfig, String type, MultipartFile file) throws IOException {
        CasPageConfig casPageConfig;
        String id = paramConfig.getId();
        if (StringUtils.isNotBlank((String)id)) {
            casPageConfig = (CasPageConfig)((Object)this.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)paramConfig), (Object)((Object)casPageConfig), (String[])new String[]{"isDefault", "version"});
        } else {
            casPageConfig = paramConfig;
        }
        if (StringUtils.equalsIgnoreCase((String)type, (String)"logo")) {
            casPageConfig.setLogo(file.getBytes());
        } else if (StringUtils.equalsIgnoreCase((String)type, (String)"background")) {
            casPageConfig.setBackgroundImg(file.getBytes());
        }
        casPageConfig.insertOrUpdate();
        return (CasPageConfig)((Object)this.getById((Serializable)((Object)casPageConfig.getId())));
    }

    @Override
    public void removeFile(String id, String type) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(CasPageConfig::getId, (Object)id)).func(consumer -> {
            if (StringUtils.equalsIgnoreCase((String)type, (String)"logo")) {
                consumer.set(CasPageConfig::getLogo, null);
            } else {
                consumer.set(CasPageConfig::getBackgroundImg, null);
            }
        });
        this.update((Wrapper)wrapper);
    }
}

