/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.DemensionDao;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.User;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.demension.DemensionVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.util.OrgUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemensionManagerImpl
extends BaseManagerImpl<DemensionDao, Demension>
implements DemensionManager {
    @Autowired
    OrgManager orgService;
    @Autowired
    UserManager userService;

    @Transactional
    public void removeByIds(String ... ids) {
        for (String demid : ids) {
            this.remove((Serializable)((Object)demid));
            String[] orgIds = this.findOrgIdByDemid(demid);
            if (!BeanUtils.isNotEmpty((Object)orgIds)) continue;
            this.orgService.removeByIds(orgIds);
        }
    }

    private String[] findOrgIdByDemid(String demid) {
        ArrayList<String> strs = new ArrayList<String>();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("demId", (Object)demid, QueryOP.EQUAL, FieldRelation.AND);
        PageList list = this.orgService.query(queryFilter);
        for (Org org : list.getRows()) {
            strs.add(org.getId());
        }
        if (BeanUtils.isNotEmpty(strs)) {
            return strs.toArray(new String[strs.size()]);
        }
        return null;
    }

    @Override
    public Demension getByCode(String code) {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1acode\u7ef4\u5ea6\u7f16\u7801\u5fc5\u586b\uff01");
        }
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728!");
        }
        return dem;
    }

    @Override
    @Cacheable(value={"eip:uc"}, key="defaultDemension", pureKey=true)
    public Demension getDefaultDemension() {
        return ((DemensionDao)this.baseMapper).getDefaultDemension();
    }

    @Override
    @CacheEvict(value={"eip:uc"}, key="defaultDemension", pureKey=true)
    public void cleanDemensionCache() {
    }

    @Override
    @Transactional
    public void setDefaultDemension(String id) throws SQLException {
        if (StringUtil.isNotEmpty((String)id)) {
            Demension demension = (Demension)this.get((Serializable)((Object)id));
            if (BeanUtils.isEmpty((Object)demension)) {
                demension = ((DemensionDao)this.baseMapper).getByCode(id);
            }
            if (BeanUtils.isNotEmpty((Object)demension)) {
                ((DemensionDao)this.baseMapper).setNotDefaultDemension(LocalDateTime.now());
                demension.setIsDefault(1);
                demension.setUpdateTime(LocalDateTime.now());
                this.update((Model)demension);
                DemensionManager demensionManager = (DemensionManager)AppUtil.getBean(DemensionManager.class);
                demensionManager.cleanDemensionCache();
            }
        }
    }

    @Override
    @Transactional
    public CommonResult<String> addDem(DemensionVo demVo) throws Exception {
        if (StringUtil.isEmpty((String)demVo.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u7ef4\u5ea6\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)demVo.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u7ef4\u5ea6\u522b\u540d\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (((DemensionDao)this.baseMapper).getCountByCode(demVo.getCode()) > 0) {
            return new CommonResult(false, "\u6dfb\u52a0\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u522b\u540d\u3010" + demVo.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01", (Object)"");
        }
        Demension dem = new Demension();
        dem.setDemName(demVo.getName());
        dem.setDemCode(demVo.getCode());
        dem.setDemDesc(demVo.getDescription());
        dem.setId(UniqueIdUtil.getSuid());
        if (BeanUtils.isNotEmpty((Object)demVo.getIsDefault()) && demVo.getIsDefault() == 1) {
            Demension defaulDem = ((DemensionDao)this.baseMapper).getDefaultDemension();
            if (BeanUtils.isNotEmpty((Object)defaulDem)) {
                ((DemensionDao)this.baseMapper).setNotDefaultDemension(LocalDateTime.now());
            }
            dem.setIsDefault(1);
        }
        this.create((Model)dem);
        return new CommonResult(true, "\u6dfb\u52a0\u7ef4\u5ea6\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteDemByIds(String ids) throws Exception {
        String rtn;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException("\u5220\u9664\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6ids\u5fc5\u586b");
        }
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        String message = "";
        boolean isTrue = false;
        for (String id : idArray) {
            Demension dem = (Demension)((DemensionDao)this.baseMapper).selectById((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)dem)) {
                List<Org> l = this.orgService.getOrgListByDemId(dem.getId());
                if (BeanUtils.isEmpty(l) && !"1".equals(dem.getIsDefault())) {
                    this.remove((Serializable)((Object)dem.getId()));
                    isTrue = true;
                    continue;
                }
                if (BeanUtils.isEmpty(l) && "1".equals(dem.getIsDefault())) {
                    message = message + "\u3010" + dem.getDemName() + "(" + dem.getDemCode() + ")\u3011\u7684\u7ef4\u5ea6\u662f\u9ed8\u8ba4\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664 ";
                    continue;
                }
                if (!BeanUtils.isNotEmpty(l)) continue;
                message = message + "\u3010" + dem.getDemName() + "(" + dem.getDemCode() + ")\u3011\u7684\u7ef4\u5ea6\u4e0b\u5b58\u5728\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664 ";
                continue;
            }
            str.append(dem.getDemName());
            str.append("\uff0c");
        }
        String string = rtn = StringUtil.isEmpty((String)str.toString()) && StringUtil.isEmpty((String)message) ? "\u5220\u9664\u7ef4\u5ea6\u6210\u529f\uff01" : "";
        if (StringUtil.isEmpty((String)str.toString()) && StringUtil.isNotEmpty((String)message)) {
            rtn = rtn + message;
        }
        if (StringUtil.isNotEmpty((String)str.toString()) && StringUtil.isEmpty((String)message)) {
            rtn = rtn + "\u7ef4\u5ea6\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        }
        if (StringUtil.isNotEmpty((String)str.toString()) && StringUtil.isNotEmpty((String)message)) {
            rtn = rtn + "\u7ef4\u5ea6\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01" + message;
        }
        return new CommonResult(isTrue, rtn, (Object)"");
    }

    @Override
    public void fillDimensionToData(List<Map<String, Object>> records) {
        List dimensionList;
        Map<Object, Object> demensionMap = new HashMap();
        List demId = records.stream().filter(item -> BeanUtils.isNotEmpty((Object)MapUtil.getIgnoreCase((Map)item, (String)"DEM_ID_"))).map(map -> MapUtil.getIgnoreCase((Map)map, (String)"DEM_ID_").toString()).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(demId) && BeanUtils.isNotEmpty((Object)(dimensionList = this.listByIds(demId)))) {
            demensionMap = dimensionList.stream().collect(Collectors.toMap(Demension::getId, dimension -> dimension));
        }
        for (Map<String, Object> data : records) {
            if (!MapUtil.containsIgnoreKey(data, (String)"DEM_ID_") || !demensionMap.containsKey(MapUtil.getIgnoreCase(data, (String)"DEM_ID_").toString())) continue;
            data.put("demName", ((Demension)demensionMap.get(MapUtil.getIgnoreCase(data, (String)"DEM_ID_").toString())).getName());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> deleteDem(String codes) throws Exception {
        String rtn;
        if (StringUtil.isEmpty((String)codes)) {
            throw new RuntimeException("\u5220\u9664\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u3010" + codes + "\u3011\u5fc5\u586b");
        }
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        String message = "";
        boolean isTrue = false;
        for (String code : codeArray) {
            Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
            if (BeanUtils.isNotEmpty((Object)dem)) {
                List<Org> l = this.orgService.getOrgListByDemId(dem.getId());
                if (BeanUtils.isEmpty(l) && !"1".equals(dem.getIsDefault())) {
                    this.remove((Serializable)((Object)dem.getId()));
                    isTrue = true;
                    continue;
                }
                if (BeanUtils.isEmpty(l) && "1".equals(dem.getIsDefault())) {
                    message = message + "\u7f16\u7801\u4e3a\u3010" + dem.getDemCode() + "\u3011\u7684\u7ef4\u5ea6\u662f\u9ed8\u8ba4\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1b";
                    continue;
                }
                if (!BeanUtils.isNotEmpty(l)) continue;
                message = message + "\u7f16\u7801\u4e3a\u3010" + dem.getDemCode() + "\u3011\u7684\u7ef4\u5ea6\u4e0b\u5b58\u5728\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1b";
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        String string = rtn = StringUtil.isEmpty((String)str.toString()) && StringUtil.isEmpty((String)message) ? "\u5220\u9664\u7ef4\u5ea6\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c";
        if (StringUtil.isEmpty((String)str.toString()) && StringUtil.isNotEmpty((String)message)) {
            rtn = rtn + message;
        }
        if (StringUtil.isNotEmpty((String)str.toString()) && StringUtil.isEmpty((String)message)) {
            rtn = rtn + "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        }
        if (StringUtil.isNotEmpty((String)str.toString()) && StringUtil.isNotEmpty((String)message)) {
            rtn = rtn + "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01" + message;
        }
        return new CommonResult(isTrue, rtn, (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateDem(DemensionVo demVo) throws Exception {
        if (StringUtil.isEmpty((String)demVo.getCode())) {
            throw new RequiredException("\u66f4\u65b0\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(demVo.getCode());
        if (BeanUtils.isEmpty((Object)dem)) {
            return new CommonResult(false, "\u66f4\u65b0\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u3010" + demVo.getCode() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)demVo.getName())) {
            dem.setDemName(demVo.getName());
        }
        if (demVo.getDescription() != null) {
            dem.setDemDesc(demVo.getDescription());
        }
        if (BeanUtils.isNotEmpty((Object)demVo.getIsDefault())) {
            if (demVo.getIsDefault() == 1) {
                Demension defaulDem = ((DemensionDao)this.baseMapper).getDefaultDemension();
                if (BeanUtils.isNotEmpty((Object)defaulDem) && !defaulDem.getDemCode().equals(dem.getDemCode())) {
                    ((DemensionDao)this.baseMapper).setNotDefaultDemension(LocalDateTime.now());
                }
                dem.setIsDefault(1);
            } else {
                dem.setIsDefault(0);
            }
        }
        this.update((Model)dem);
        return new CommonResult(true, "\u66f4\u65b0\u7ef4\u5ea6\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<UserVo> getUsersByDem(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7ef4\u5ea6\u7f16\u7801\u5fc5\u586b\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RequiredException("\u7ef4\u5ea6\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        List<Org> orgs = this.orgService.getOrgListByDemId(dem.getId());
        for (Org org : orgs) {
            List<User> users = this.userService.getUserListByOrgId(org.getId());
            if (!BeanUtils.isNotEmpty(users)) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public List<Org> getOrgsByDem(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u7ef4\u5ea6\u7f16\u7801\u5fc5\u586b\uff01");
        }
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RequiredException("\u7ef4\u5ea6\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return this.orgService.getOrgListByDemId(dem.getId());
    }

    @Override
    public CommonResult<String> setDefaultDem(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RequiredException("\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        this.setDefaultDemension(dem.getId());
        return new CommonResult(true, "\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> cancelDefaultDem(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u53d6\u6d88\u9ed8\u8ba4\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RequiredException("\u53d6\u6d88\u9ed8\u8ba4\u7ef4\u5ea6\u5931\u8d25\uff0c\u7ef4\u5ea6\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        if (dem.getIsDefault() != 1) {
            return new CommonResult(false, "\u8be5\u7ef4\u5ea6\u975e\u9ed8\u8ba4\u7ef4\u5ea6\uff0c\u4e0d\u9700\u8981\u53d6\u6d88\u8bbe\u7f6e\uff01", (Object)"");
        }
        ((DemensionDao)this.baseMapper).setNotDefaultDemension(LocalDateTime.now());
        return new CommonResult(true, "\u53d6\u6d88\u9ed8\u8ba4\u7ef4\u5ea6\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<Demension> getDemByTime(OrgExportObject orgExportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(orgExportObject.getBtime(), orgExportObject.getEtime());
        if (StringUtil.isNotEmpty((String)orgExportObject.getDemCodes())) {
            queryFilter.addFilter("CODE_", (Object)orgExportObject.getDemCodes(), QueryOP.IN, FieldRelation.AND);
        }
        return this.queryNoPage(queryFilter);
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Demension dem = ((DemensionDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)dem)) ? "\u8be5\u7ef4\u5ea6\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public ObjectNode getOrgSelectListInit(String code) throws Exception {
        Demension dem;
        ArrayList objects = new ArrayList();
        Org org = (Org)this.orgService.get((Serializable)((Object)code));
        String[] keyArr = new String[2];
        if (BeanUtils.isEmpty((Object)org)) {
            org = this.orgService.getByCode(code);
        }
        if (BeanUtils.isNotEmpty((Object)org) && BeanUtils.isNotEmpty((Object)(dem = (Demension)this.get((Serializable)((Object)org.getDemId()))))) {
            keyArr[1] = dem.getId();
        }
        ObjectNode initObj = JsonUtil.getMapper().createObjectNode();
        initObj.set("orgSelectList", JsonUtil.toJsonNode(objects));
        initObj.set("initGanAndDem", JsonUtil.toJsonNode((Object)keyArr));
        return initObj;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((DemensionDao)this.baseMapper).removePhysical();
    }
}

