/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.HolidayDao;
import com.hotent.uc.manager.HolidayManager;
import com.hotent.uc.manager.HolidayTimeManager;
import com.hotent.uc.manager.ShiftRuleManager;
import com.hotent.uc.model.Holiday;
import com.hotent.uc.model.HolidayTime;
import com.hotent.uc.model.UcBaseModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="holidayManager")
public class HolidayManagerImpl
extends BaseManagerImpl<HolidayDao, Holiday>
implements HolidayManager {
    @Resource
    HolidayTimeManager holidayTimeManager;
    @Resource
    ShiftRuleManager shiftRuleManager;

    public Holiday get(Serializable id) {
        Holiday holiday = (Holiday)super.get(id);
        List<HolidayTime> time = this.holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
    }

    public Holiday getById(Serializable id) {
        Holiday holiday = (Holiday)super.getById(id);
        List<HolidayTime> time = this.holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
    }

    @Transactional
    public void create(Holiday holiday) {
        String id = UniqueIdUtil.getSuid();
        holiday.setId(id);
        holiday.getTime().forEach(item -> {
            item.setHolidayId(id);
            this.holidayTimeManager.create((Model)item);
        });
        super.create((Model)holiday);
    }

    @Transactional
    public void update(Holiday holiday) {
        List<HolidayTime> times = this.holidayTimeManager.getByHolidayId((Serializable)((Object)holiday.getId()));
        Map<String, HolidayTime> existTimes = times.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        for (HolidayTime time : holiday.getTime()) {
            if (!existTimes.containsKey(time.getId())) {
                time.setHolidayId(holiday.getId());
                this.holidayTimeManager.create((Model)time);
                continue;
            }
            this.holidayTimeManager.update((Model)time);
            existTimes.remove(time.getId());
        }
        existTimes.forEach((key, value) -> this.holidayTimeManager.remove((Serializable)((Object)key)));
        super.update((Model)holiday);
    }

    @Override
    public String removeWithCheck(String ... ids) {
        ArrayList<String> failRemoveIds = new ArrayList<String>();
        for (String id : ids) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"holiday_id_", (Object)id);
            List rules = this.shiftRuleManager.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)rules)) {
                failRemoveIds.add("[" + id + "]");
                continue;
            }
            this.remove((Serializable)((Object)id));
        }
        return String.join((CharSequence)"\u3001", failRemoveIds);
    }

    @Override
    public Holiday checkHolidayByKey(Holiday holiday) {
        return ((HolidayDao)this.baseMapper).getByKey(holiday.getKey());
    }

    public List<Holiday> getAll() {
        List holidays = ((HolidayDao)this.baseMapper).selectList((Wrapper)Wrappers.lambdaQuery().eq(UcBaseModel::getIsDelete, (Object)0));
        if (BeanUtils.isNotEmpty((Object)holidays)) {
            Set collect = holidays.stream().map(Holiday::getId).collect(Collectors.toSet());
            List holidayTimes = this.holidayTimeManager.list((Wrapper)Wrappers.lambdaQuery().in(HolidayTime::getHolidayId, new Object[]{0}));
            if (BeanUtils.isNotEmpty((Object)holidayTimes)) {
                Map<String, List<HolidayTime>> map = holidayTimes.stream().collect(Collectors.groupingBy(HolidayTime::getHolidayId));
            }
        }
        return holidays;
    }
}

