/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.MatrixAuthDao;
import com.hotent.uc.manager.MatrixAuthManager;
import com.hotent.uc.manager.MatrixManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.MatrixAuth;
import com.hotent.uc.model.User;
import com.hotent.uc.params.matrix.MatrixAuthAddParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MatrixAuthManagerImpl
extends BaseManagerImpl<MatrixAuthDao, MatrixAuth>
implements MatrixAuthManager {
    @Resource
    private UserManager userManager;
    @Resource
    MatrixManager matrixManager;

    @Override
    public MatrixAuth getDetail(String id) {
        MatrixAuth matrixAuth = (MatrixAuth)this.get((Serializable)((Object)id));
        return matrixAuth;
    }

    @Override
    public PageList<MatrixAuth> queryByMatrixId(QueryFilter queryFilter) {
        this.copyQuerysInParams(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty((Object)pageBean)) {
            pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false));
        }
        IPage<MatrixAuth> query = ((MatrixAuthDao)this.baseMapper).queryByMatrixId((IPage<MatrixAuth>)this.convert2IPage(pageBean), (Wrapper<MatrixAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    @Override
    public CommonResult<String> saveMatrixAuth(MatrixAuthAddParam authAddObject) throws Exception {
        if (StringUtil.isEmpty((String)authAddObject.getAccounts())) {
            return new CommonResult(false, "\u8bbe\u7f6e\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isNotEmpty((String)authAddObject.getMatrixId()) && BeanUtils.isEmpty((Object)this.matrixManager.get((Serializable)((Object)authAddObject.getMatrixId())))) {
            return new CommonResult(false, "\u8bbe\u7f6e\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u5173\u7cfb\u77e9\u9635id\u3010" + authAddObject.getMatrixId() + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        String[] accounts = authAddObject.getAccounts().split(",");
        List<User> users = this.userManager.getByAccounts(Arrays.asList(accounts));
        ArrayList<MatrixAuth> auths = new ArrayList<MatrixAuth>();
        if (BeanUtils.isNotEmpty(users)) {
            Set userAccounts = users.stream().map(User::getAccount).collect(Collectors.toSet());
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{MatrixAuth::getId}).select(new SFunction[]{MatrixAuth::getAccount}).eq(MatrixAuth::getMatrixId, (Object)authAddObject.getMatrixId())).in(MatrixAuth::getAccount, userAccounts);
            List matrixAuths = ((MatrixAuthDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            Set hasUserIds = matrixAuths.stream().map(MatrixAuth::getAccount).collect(Collectors.toSet());
            for (User user : users) {
                if (hasUserIds.contains(user.getAccount())) continue;
                MatrixAuth auth = new MatrixAuth();
                auth.setUserId(user.getId());
                auth.setMatrixId(authAddObject.getMatrixId());
                auth.setAccount(user.getAccount());
                auths.add(auth);
            }
        }
        if (!BeanUtils.isNotEmpty(auths)) {
            return new CommonResult(true, "\u8bbe\u7f6e\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u64cd\u4f5c\u6210\u529f\uff0c\u4f46\u672a\u6dfb\u52a0\u4efb\u4f55\u7ba1\u7406\u5458\u6570\u636e\u3002");
        }
        this.saveBatch(auths);
        return new CommonResult(true, "\u8bbe\u7f6e\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u6210\u529f\u3002");
    }

    @Override
    public CommonResult<String> removeMatrixAuth(String matrixId, String userIds) {
        if (StringUtil.isEmpty((String)userIds)) {
            return new CommonResult(false, "\u5220\u9664\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isNotEmpty((String)matrixId) && BeanUtils.isEmpty((Object)this.matrixManager.get((Serializable)((Object)matrixId)))) {
            return new CommonResult(false, "\u5220\u9664\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u5931\u8d25\uff1a\u5173\u7cfb\u77e9\u9635id\u3010" + matrixId + "\u3011\u4e0d\u5b58\u5728\u3002");
        }
        Object[] ids = userIds.split(",");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{MatrixAuth::getId}).select(new SFunction[]{MatrixAuth::getUserId}).eq(MatrixAuth::getMatrixId, (Object)matrixId)).in(MatrixAuth::getUserId, ids);
        List oldAuths = ((MatrixAuthDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!BeanUtils.isNotEmpty((Object)oldAuths)) {
            return new CommonResult(true, "\u5220\u9664\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u64cd\u4f5c\u6210\u529f\uff0c\u4f46\u672a\u5220\u9664\u4efb\u4f55\u7ba1\u7406\u5458\u6570\u636e\u3002");
        }
        this.removeByIds(oldAuths.stream().map(MatrixAuth::getId).collect(Collectors.toList()));
        return new CommonResult(true, "\u5220\u9664\u5173\u7cfb\u77e9\u9635\u7ba1\u7406\u5458\u6210\u529f\u3002");
    }
}

