/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JAXBUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultColumn;
import com.hotent.table.model.impl.DefaultTable;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.util.MetaDataUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.dao.MatrixDao;
import com.hotent.uc.manager.MatrixAuthManager;
import com.hotent.uc.manager.MatrixColDefManager;
import com.hotent.uc.manager.MatrixManager;
import com.hotent.uc.manager.MatrixProcRelationManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Matrix;
import com.hotent.uc.model.MatrixAuth;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.model.MatrixImportXml;
import com.hotent.uc.model.MatrixProcRelation;
import com.hotent.uc.model.MatrixXml;
import com.hotent.uc.model.User;
import com.hotent.uc.service.matrix.MatrixDataService;
import com.hotent.uc.service.matrix.impl.CommonMatrixDataServiceImpl;
import com.hotent.uc.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="matrixManager")
public class MatrixManagerImpl
extends BaseManagerImpl<MatrixDao, Matrix>
implements MatrixManager {
    @Resource
    ITableOperator tableOperator;
    @Resource
    MatrixColDefManager matrixColDefManager;
    @Resource
    CommonManager commonManager;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    MatrixProcRelationManager matrixProcRelationManager;
    @Resource
    UserManager userManager;
    @Resource
    MatrixAuthManager matrixAuthManager;
    public static final List<String> NORMAL_CTRL_TYPE = ListUtil.of((Object[])new String[]{"dialog", "select", "customInput"});

    @Override
    public Matrix getDetail(String id) {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)matrix))) {
            List<MatrixColDef> condList = this.matrixColDefManager.getCondList(matrix.getId());
            List<MatrixColDef> roleList = this.matrixColDefManager.getRoleList(matrix.getId());
            matrix.setCondList(condList);
            matrix.setRoleList(roleList);
        }
        return matrix;
    }

    @Override
    public Matrix getByCode(String code) {
        return ((MatrixDao)this.baseMapper).getByCode(code);
    }

    @Override
    public Boolean isCodeExist(String code, String id) {
        return ((MatrixDao)this.baseMapper).isCodeExist(code, id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMatrix(Matrix matrix) throws SQLException {
        String matrixId = BeanUtils.isNotEmpty((Object)matrix.getId()) ? matrix.getId() : UniqueIdUtil.getSuid();
        this.validateMatrix(matrix);
        this.saveConditionList(matrixId, matrix.getCondList(), MatrixColDef.COND_COL_TYPE);
        this.saveConditionList(matrixId, matrix.getRoleList(), MatrixColDef.ROLE_COL_TYPE);
        matrix.setUpdateBy(ContextUtil.getCurrentUserId());
        matrix.setUpdateTime(LocalDateTime.now());
        if (StringUtil.isEmpty((String)matrix.getId())) {
            matrix.setId(matrixId);
            this.create((Model)matrix);
        } else {
            this.update((Model)matrix);
            if (matrix.getStatus() == 1) {
                this.createTableByMatrix(matrix);
            }
        }
    }

    private void validateMatrix(Matrix matrix) {
        Assert.notEmpty(matrix.getCondList(), (String)"\u5ba1\u6279\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(matrix.getRoleList(), (String)"\u5ba1\u6279\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean containedSpecialCtrlType = this.containsSpecialCtrlType(matrix);
        Assert.isFalse((boolean)containedSpecialCtrlType, (String)"\u8f93\u5165\u6846\u7c7b\u578b\u7684\u7ec4\u7ec7\u3001\u7528\u6237\u3001\u5c97\u4f4d\u3001\u804c\u52a1\u548c\u89d2\u8272\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a", (Object[])new Object[0]);
    }

    private boolean containsSpecialCtrlType(Matrix matrix) {
        List list = matrix.getCondList().stream().map(MatrixColDef::getCtrlType).filter(item -> !NORMAL_CTRL_TYPE.contains(item)).collect(Collectors.toList());
        return list.size() > 1 || list.size() > 0 && matrix.getCondList().size() > 1;
    }

    private void saveConditionList(String matrixId, List<MatrixColDef> condList, int colType) {
        if (BeanUtils.isEmpty(condList)) {
            this.log.debug("\u6761\u4ef6\u5217\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        }
        List<MatrixColDef> oldCondList = this.matrixColDefManager.getColAllList(matrixId, colType);
        HashMap<String, MatrixColDef> condOldCodeMap = new HashMap<String, MatrixColDef>();
        for (MatrixColDef colDef : oldCondList) {
            condOldCodeMap.put(colDef.getCode(), colDef);
        }
        for (int i = 0; i < condList.size(); ++i) {
            MatrixColDef col = condList.get(i);
            boolean isExist = false;
            if (condOldCodeMap.containsKey(col.getCode())) {
                isExist = true;
                condOldCodeMap.remove(col.getCode());
            }
            col.setSn(i + 1);
            this.matrixColDefManager.saveCol(matrixId, col, colType, isExist);
        }
        for (String code : condOldCodeMap.keySet()) {
            MatrixColDef willDele = (MatrixColDef)((Object)condOldCodeMap.get(code));
            willDele.setIsDele(1);
            this.matrixColDefManager.update((Model)willDele);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleLogical(String[] ids) {
        ((MatrixDao)this.baseMapper).deleLogical(ids);
    }

    @Override
    public void publish(String id) throws SQLException {
        Matrix matrix = this.getDetail(id);
        this.createTableByMatrix(matrix);
        matrix.setStatus(1);
        this.update((Model)matrix);
    }

    private void createTableByMatrix(Matrix matrix) throws SQLException {
        String tableName = "UC_MATRIX_" + matrix.getCode();
        boolean isCreatedTable = this.tableOperator.isTableExist(tableName.toLowerCase());
        if (!isCreatedTable) {
            DefaultTable table = new DefaultTable();
            table.setTableName(tableName.toLowerCase());
            table.setComment(matrix.getName());
            DefaultColumn pk = new DefaultColumn();
            pk.setFieldName("ID_");
            pk.setComment("\u4e3b\u952e");
            pk.setColumnType("varchar");
            pk.setCharLen(64);
            pk.setIsPk(true);
            pk.setIsNull(false);
            table.addColumn((Column)pk);
            List<MatrixColDef> condList = matrix.getCondList();
            for (MatrixColDef matrixColDef : condList) {
                DefaultColumn columnK = this.buildCondK(matrixColDef);
                table.addColumn((Column)columnK);
                DefaultColumn columnV = this.buildCondV(matrixColDef);
                table.addColumn((Column)columnV);
            }
            List<MatrixColDef> roleList = matrix.getRoleList();
            for (MatrixColDef col : roleList) {
                DefaultColumn roleColumn = this.buildRole(col);
                table.addColumn((Column)roleColumn);
            }
            this.tableOperator.createTable((Table)table);
        } else {
            BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)this.databaseContext.getDbType());
            Table table = null;
            try {
                table = baseTableMeta.getTableByName(tableName);
            }
            catch (Exception e) {
                throw new BaseException("\u627e\u4e0d\u5230\u540d\u4e3a" + tableName + "\u7684\u7269\u7406\u8868\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
            }
            List existColumnList = table.getColumnList();
            Set<String> existFieldNames = MatrixManagerImpl.getFieldNameSet(existColumnList);
            List<MatrixColDef> list = matrix.getCondList();
            for (MatrixColDef col : list) {
                DefaultColumn columnV;
                if (col.getStatus() != 0) continue;
                DefaultColumn columnK = this.buildCondK(col);
                if (!existFieldNames.contains(columnK.getFieldName().toLowerCase())) {
                    this.tableOperator.addColumn(tableName, (Column)columnK);
                }
                if (existFieldNames.contains((columnV = this.buildCondV(col)).getFieldName().toLowerCase())) continue;
                this.tableOperator.addColumn(tableName, (Column)columnV);
            }
            List<MatrixColDef> roleList = matrix.getRoleList();
            for (MatrixColDef col : roleList) {
                DefaultColumn roleColumn;
                if (col.getStatus() != 0 || existFieldNames.contains((roleColumn = this.buildRole(col)).getFieldName().toLowerCase())) continue;
                this.tableOperator.addColumn(tableName, (Column)roleColumn);
            }
        }
    }

    private static Set<String> getFieldNameSet(List<Column> existColumnList) {
        HashSet<String> set = new HashSet<String>();
        if (BeanUtils.isNotEmpty(existColumnList)) {
            for (Column col : existColumnList) {
                String colName = col.getFieldName();
                set.add(colName.toLowerCase());
            }
        }
        return set;
    }

    public DefaultColumn buildRole(MatrixColDef col) {
        DefaultColumn roleColumn = new DefaultColumn();
        roleColumn.setFieldName("ROLE_" + col.getCode());
        roleColumn.setComment(col.getName());
        roleColumn.setColumnType("clob");
        return roleColumn;
    }

    public DefaultColumn buildCondK(MatrixColDef col) {
        DefaultColumn columnK = new DefaultColumn();
        columnK.setFieldName("CONDK_" + col.getCode());
        columnK.setComment(col.getName() + "key");
        columnK.setColumnType("varchar");
        columnK.setCharLen(512);
        return columnK;
    }

    public DefaultColumn buildCondV(MatrixColDef col) {
        DefaultColumn columnV = new DefaultColumn();
        columnV.setFieldName("CONDV_" + col.getCode());
        columnV.setComment(col.getName() + "value");
        columnV.setColumnType("varchar");
        columnV.setCharLen(512);
        return columnV;
    }

    private List<MatrixColField> buildSelectFields(Matrix matrix) {
        ArrayList<MatrixColField> colFields = new ArrayList<MatrixColField>();
        colFields.add(new MatrixColField("ID_", "ID_", "\u4e3b\u952e", "id", null));
        for (MatrixColDef col : matrix.getCondList()) {
            colFields.add(new MatrixColField("CONDK_" + col.getCode(), col.getCode(), col.getName(), "ck", col));
            colFields.add(new MatrixColField("CONDV_" + col.getCode(), col.getCode(), col.getName(), "cv", col));
        }
        for (MatrixColDef col : matrix.getRoleList()) {
            colFields.add(new MatrixColField("ROLE_" + col.getCode(), col.getCode(), col.getName(), "ro", col));
        }
        return colFields;
    }

    @Override
    public Map<String, Object> getData(String matrixId, QueryFilter<Matrix> queryFilter, boolean ifCheckPublish) throws Exception {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("UC_MATRIX_" + matrix.getCode());
        if (ifCheckPublish && !tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        PageList dataList = null;
        if (tableExist) {
            String sql = this.constructSelectListSql(matrix.getCode(), colFields);
            dataList = this.commonManager.query(sql, queryFilter);
            if (SQLUtil.getDbType().equals("kingbasees") && BeanUtils.isNotEmpty((Object)dataList.getRows())) {
                ArrayList rowsTemp = Lists.newArrayList();
                dataList.getRows().stream().forEach(item -> {
                    HashMap rowTemp = Maps.newHashMap();
                    colFields.stream().map(MatrixColField::getField).forEach(field -> rowTemp.put(field, MapUtil.getIgnoreCase((Map)item, (String)field, null)));
                    rowsTemp.add(rowTemp);
                });
                dataList.setRows((List)rowsTemp);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colFields", colFields);
        map.put("matrix", (Object)matrix);
        map.put("data", dataList);
        if (!ifCheckPublish) {
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("auth.MATRIX_ID_", (Object)matrixId, QueryOP.EQUAL);
            PageList<MatrixAuth> matrixAuthPageList = this.matrixAuthManager.queryByMatrixId(filter);
            List matrixProcRelations = this.matrixProcRelationManager.list((Wrapper)Wrappers.lambdaQuery().eq(MatrixProcRelation::getMatrixCode, (Object)matrix.getCode()));
            Optional.ofNullable(matrixAuthPageList.getRows()).ifPresent(auths -> map.put("auths", auths));
            Optional.ofNullable(matrixProcRelations).ifPresent(procRelations -> map.put("procRelations", procRelations));
        }
        return map;
    }

    private PageList<Map<String, Object>> getMatrixData(Matrix matrix, QueryFilter<?> filter) {
        Optional<MatrixColDef> first = matrix.getCondList().stream().filter(cond -> !NORMAL_CTRL_TYPE.contains(cond.getCtrlType())).findFirst();
        String ctrlType = first.map(MatrixColDef::getCtrlType).orElse("");
        MatrixDataService matrixDataService = (MatrixDataService)AppUtil.getBean((String)(ctrlType + "MatrixDataServiceImpl"));
        if (BeanUtils.isEmpty((Object)matrixDataService)) {
            CommonMatrixDataServiceImpl service = (CommonMatrixDataServiceImpl)AppUtil.getBean(CommonMatrixDataServiceImpl.class);
            return service.query(matrix, filter);
        }
        return matrixDataService.query(matrix, filter);
    }

    @Override
    public Map<String, Object> getDataWithUcData(String matrixId, QueryFilter<Matrix> queryFilter) {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("UC_MATRIX_" + matrix.getCode());
        Assert.isTrue((boolean)tableExist, (String)"\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03!", (Object[])new Object[0]);
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        PageList<Map<String, Object>> dataList = this.getMatrixData(matrix, queryFilter);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("colFields", colFields);
        map.put("matrix", (Object)matrix);
        map.put("data", dataList);
        return map;
    }

    @Override
    public Map<String, Object> getOneData(String matrixId, String pk) {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("UC_MATRIX_" + matrix.getCode());
        if (!tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        List<MatrixColField> colFields = this.buildSelectFields(matrix);
        String sql = this.constructSelectOneSql(matrix.getCode(), colFields, pk);
        List dataList = this.commonManager.query(sql);
        Map data = dataList != null && dataList.size() > 0 ? (Map)dataList.get(0) : null;
        for (String s : data.keySet()) {
            if (!s.contains("ROLE_") || !BeanUtils.isEmpty(data.get(s))) continue;
            data.put(s, "");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("colFields", colFields);
        map.put("matrix", (Object)matrix);
        map.put("data", data);
        return map;
    }

    @Override
    public Map<String, Object> getBlankOneData(String matrixId) {
        Matrix matrix = this.getDetail(matrixId);
        boolean tableExist = this.tableOperator.isTableExist("UC_MATRIX_" + matrix.getCode());
        if (!tableExist) {
            throw new RuntimeException("\u8be5\u77e9\u9635\u8fd8\u672a\u53d1\u5e03\uff01");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (MatrixColDef col : matrix.getCondList()) {
            if (col.getStatus() != 1) continue;
            data.put("CONDK_" + col.getCode(), "");
            data.put("CONDV_" + col.getCode(), "");
        }
        for (MatrixColDef col : matrix.getRoleList()) {
            if (col.getStatus() != 1) continue;
            data.put("ROLE_" + col.getCode(), "");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        return map;
    }

    @Override
    public PageList<Matrix> listDetail(QueryFilter<Matrix> queryFilter) {
        PageList query = this.query(queryFilter);
        if (query.getRows() != null) {
            for (Matrix matrix : query.getRows()) {
                List<MatrixColDef> condList = this.matrixColDefManager.getCondList(matrix.getId());
                List<MatrixColDef> roleList = this.matrixColDefManager.getRoleList(matrix.getId());
                matrix.setCondList(condList);
                matrix.setRoleList(roleList);
            }
        }
        return query;
    }

    @Override
    public Matrix getByAlias(String code) throws Exception {
        Matrix matrix = this.getByCode(code);
        return this.getDetail(matrix.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> controllerSave(Matrix matrix) throws Exception {
        String msg = "\u4fdd\u5b58\u77e9\u9635\u7ba1\u7406\u6210\u529f";
        Boolean isCodeExist = this.isCodeExist(matrix.getCode(), matrix.getId());
        if (isCodeExist.booleanValue()) {
            return CommonResult.error().message("\u522b\u540d\u5df2\u5b58\u5728");
        }
        this.saveMatrix(matrix);
        return CommonResult.ok().message(msg);
    }

    @Override
    public void saveManager(String id, String userId, String fullname) {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)id));
        matrix.setManagerId(userId);
        matrix.setManagerName(fullname);
        this.update((Model)matrix);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveData(String matrixId, String data) throws Exception {
        Map bean = (Map)JsonUtil.toBean((String)data, Map.class);
        return this.saveData(matrixId, bean);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveData(String matrixId, Map<String, Object> data) {
        Matrix matrix = this.getDetail(matrixId);
        List<MatrixColDef> condList = matrix.getCondList();
        Optional<MatrixColDef> first = condList.stream().filter(item -> !NORMAL_CTRL_TYPE.contains(item.getCtrlType())).findFirst();
        String ctrlType = first.map(MatrixColDef::getCtrlType).orElse("common");
        MatrixDataService service = (MatrixDataService)AppUtil.getBean((String)(ctrlType + "MatrixDataServiceImpl"));
        Assert.notNull((Object)service, (String)("\u4e0d\u5b58\u5728[" + ctrlType + "]\u7684\u6761\u4ef6\u7c7b\u578b"), (Object[])new Object[0]);
        service.save(matrix, data, first.map(MatrixColDef::getCode).orElse("ID_"));
        return (String)data.get("ID_");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dataRemove(String matrixId, String[] ids) {
        Matrix matrix = (Matrix)this.get((Serializable)((Object)matrixId));
        String sql = this.cunstructDeleteSql(matrix.getCode(), ids);
        this.jdbcTemplate.execute(sql);
    }

    public String constructSelectListSql(String matrixCode, List<MatrixColField> colFields) {
        StringBuffer sql = new StringBuffer("select ");
        ArrayList<String> fields = new ArrayList<String>();
        for (MatrixColField field : colFields) {
            fields.add(field.getField());
        }
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql") || dbType.equals("oracle") || dbType.equals("dm") || dbType.equals("kingbasees")) {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append((String)fields.get(i) + " as \"" + (String)fields.get(i) + "\"");
                if (i == fields.size() - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(String.join((CharSequence)",", fields));
        }
        sql.append(" from UC_MATRIX_" + matrixCode + " ");
        return sql.toString();
    }

    public String constructSelectOneSql(String matrixCode, List<MatrixColField> colFields, String pk) {
        StringBuffer sql = new StringBuffer("select ");
        ArrayList<String> fields = new ArrayList<String>();
        for (MatrixColField field : colFields) {
            fields.add(field.getField());
        }
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql") || dbType.equals("oracle") || dbType.equals("dm") || dbType.equals("kingbasees")) {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append((String)fields.get(i) + " as \"" + (String)fields.get(i) + "\"");
                if (i == fields.size() - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(String.join((CharSequence)",", fields));
        }
        sql.append(" from UC_MATRIX_" + matrixCode + " ");
        sql.append(" where ");
        sql.append("ID_ = '" + pk + "'");
        return sql.toString();
    }

    private String cunstructDeleteSql(String matrixCode, String[] ids) {
        StringBuffer sb = new StringBuffer("delete from ");
        sb.append("UC_MATRIX_" + matrixCode + " where ");
        sb.append("ID_ in ('" + String.join((CharSequence)"','", ids) + "')");
        return sb.toString();
    }

    private void insertData(String matrixCode, Map<String, Object> bean) throws Exception {
        StringBuffer sb = new StringBuffer("insert into ");
        sb.append("UC_MATRIX_" + matrixCode);
        ArrayList<String> setFields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String ID_ = UniqueIdUtil.getSuid();
        setFields.add("ID_");
        values.add(ID_);
        for (String key : bean.keySet()) {
            if (Objects.equals("ID_", key)) continue;
            setFields.add(key);
            Object value = bean.get(key);
            if (value instanceof List) {
                values.add(JsonUtil.toJson((Object)value));
                continue;
            }
            if (BeanUtils.isEmpty((Object)value)) {
                values.add("");
                continue;
            }
            values.add(value.toString());
        }
        sb.append("(" + String.join((CharSequence)",", setFields) + ")");
        sb.append(" values ");
        sb.append("(" + String.join((CharSequence)",", values.stream().map(e -> "?").collect(Collectors.toList())) + ")");
        this.commonManager.execute(sb.toString(), values.toArray());
    }

    private void updateData(String matrixCode, Map<String, Object> bean) throws Exception {
        StringBuffer sb = new StringBuffer("update ");
        sb.append("UC_MATRIX_" + matrixCode + " set ");
        ArrayList<String> setFields = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        String ID_ = (String)bean.remove("ID_");
        for (String key : bean.keySet()) {
            Object value = bean.get(key);
            setFields.add(key + "=?");
            if (value instanceof List) {
                values.add(JsonUtil.toJson((Object)value));
                continue;
            }
            if (BeanUtils.isEmpty((Object)value)) {
                values.add("");
                continue;
            }
            values.add(value.toString());
        }
        sb.append(String.join((CharSequence)",", setFields));
        sb.append(" where ID_" + String.format("='%s'", ID_));
        this.commonManager.execute(sb.toString(), values.toArray());
    }

    private String constructIsCondKeyExistSql(String matrixCode, Map<String, Object> bean) throws IOException {
        StringBuffer sb = new StringBuffer("select * from ");
        sb.append("UC_MATRIX_" + matrixCode);
        String dbType = SQLUtil.getDbType();
        ArrayList<String> setFields = new ArrayList<String>();
        for (String key : bean.keySet()) {
            if (key.indexOf("CONDK_") != 0) continue;
            Object value = bean.get(key);
            if (BeanUtils.isNotEmpty((Object)value)) {
                if ("oracle".equals(dbType)) {
                    setFields.add("to_char(" + key + ") = '" + value + "'");
                    continue;
                }
                setFields.add(key + " = '" + value + "'");
                continue;
            }
            String empty = "(" + key + " is null or " + key + "='')";
            setFields.add(empty);
        }
        if (BeanUtils.isNotEmpty((Object)bean.get("ID_"))) {
            setFields.add("ID_ != '" + bean.get("ID_") + "'");
        }
        if (setFields.size() > 0) {
            sb.append(" where ");
        }
        sb.append(String.join((CharSequence)" and ", setFields));
        return sb.toString();
    }

    @Override
    public List<Map<String, Object>> getUsers(Map<String, Object> params) throws Exception {
        String sql = (String)params.get("sql");
        sql = Base64.getFromBase64((String)sql);
        List query = this.commonManager.query(sql);
        return query;
    }

    @Override
    @Transactional
    public void batchRemove(String[] matrixIds) {
        List ids = Arrays.stream(matrixIds).collect(Collectors.toList());
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = (String)iterator.next();
            Matrix matrix = (Matrix)this.get((Serializable)((Object)id));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"matrix_code_", (Object)matrix.getCode());
            List relations = this.matrixProcRelationManager.list((Wrapper)wrapper);
            if ((matrix.getStatus() != 1 || matrix.getEnabled() != 1) && !BeanUtils.isNotEmpty((Object)relations)) continue;
            ThreadMsgUtil.addMsg((String)("\u77e9\u9635\uff1a" + matrix.getName() + "\uff0c\u5df2\u542f\u7528\u6216\u8005\u5b58\u5728\u7ed1\u5b9a\u7684\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01<br/>"));
            iterator.remove();
        }
        if (BeanUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<String> colDefIds = new ArrayList<String>();
        for (String id : ids) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"matrix_id_", (Object)id);
            List colDefs = this.matrixColDefManager.list((Wrapper)wrapper);
            for (MatrixColDef colDef : colDefs) {
                if (!BeanUtils.isNotEmpty((Object)((Object)colDef)) || !BeanUtils.isNotEmpty((Object)colDef.getId())) continue;
                colDefIds.add(colDef.getId());
            }
        }
        this.matrixColDefManager.removeByIds(colDefIds);
        List matrices = ((MatrixDao)this.baseMapper).selectBatchIds(ids);
        for (Matrix matrix : matrices) {
            String matrixCode = matrix.getCode();
            if (!BeanUtils.isNotEmpty((Object)matrixCode)) continue;
            String tableName = "UC_MATRIX_" + matrixCode;
            try {
                this.tableOperator.dropTable(tableName);
            }
            catch (SQLException e) {
                throw new RuntimeException(String.format("\u5220\u9664\u77e9\u9635\u4eba\u5458\u914d\u7f6e\u8868\"%s\"\u5931\u8d25", tableName));
            }
        }
        this.removeByIds(ids);
    }

    @Override
    public Map<String, String> export(List<String> idList) throws Exception {
        MatrixImportXml matrixImportXml = new MatrixImportXml();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false)));
        for (String id : idList) {
            PageList dataList;
            Map<String, Object> mapData = this.getData(id, (QueryFilter<Matrix>)queryFilter, false);
            MatrixXml matrixXml = new MatrixXml();
            List roleList = Lists.newArrayList();
            if (mapData.get("data") != null && (dataList = (PageList)mapData.get("data")) != null) {
                roleList = dataList.getRows();
            }
            matrixXml.setMatrix(mapData.get("matrix") != null ? (Matrix)((Object)mapData.get("matrix")) : new Matrix());
            matrixXml.setColFields(mapData.get("colFields") != null ? (List)mapData.get("colFields") : Lists.newArrayList());
            matrixXml.setDataList(roleList);
            matrixXml.setMatrixAuths((List)Optional.ofNullable(mapData.get("auths")).orElse(Lists.newArrayList()));
            matrixXml.setMatrixProcRelations((List)Optional.ofNullable(mapData.get("procRelations")).orElse(Lists.newArrayList()));
            matrixImportXml.add(matrixXml);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        try {
            map.put("matrix.xml", JAXBUtil.marshall((Object)matrixImportXml, MatrixImportXml.class));
        }
        catch (JAXBException e) {
            throw new RuntimeException("\u5bfc\u51fa\u5173\u7cfb\u77e9\u9635\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public CommonResult<String> importCheck(MultipartHttpServletRequest request, HttpServletResponse response, Optional<String> typeId, Optional<String> typeName) {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            File folder = new File(rootRealPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String xmlStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "matrix.xml"));
            if (StringUtils.isEmpty((String)xmlStr)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            MatrixImportXml matrixImportXml = (MatrixImportXml)JAXBUtil.unmarshall((String)xmlStr, MatrixImportXml.class);
            List<MatrixXml> matrixXmlList = matrixImportXml.getMatrixXmlList();
            ArrayList<String> names = new ArrayList<String>();
            boolean containsCtrl = false;
            for (MatrixXml matrixXml : matrixXmlList) {
                Matrix oldMatrix;
                Matrix matrix = matrixXml.getMatrix();
                if (matrix == null || StringUtil.isEmpty((String)matrix.getCode())) continue;
                List<MatrixColDef> colDefList = matrix.getCondList();
                if (CollectionUtils.isNotEmpty(colDefList)) {
                    for (MatrixColDef colDef : colDefList) {
                        if (!StringUtil.isNotEmpty((String)colDef.getCtrlType())) continue;
                        containsCtrl = true;
                        break;
                    }
                }
                if ((oldMatrix = ((MatrixDao)this.baseMapper).getByCode(matrix.getCode())) == null) continue;
                names.add(oldMatrix.getName() + "\uff08" + oldMatrix.getCode() + "\uff09");
            }
            if (BeanUtils.isEmpty(names)) {
                MatrixManagerImpl matrixManager = (MatrixManagerImpl)AppUtil.getBean(this.getClass());
                matrixManager.importMatrix(matrixImportXml, typeId.orElse(""), typeName.orElse(""));
                message = new CommonResult(true, "\u5bfc\u5165\u6210\u529f" + (containsCtrl ? "\uff08\u82e5\u5f15\u7528\u4e86\u5143\u4ef6\uff0c\u9700\u8981\u5355\u72ec\u5bfc\u5165\u5143\u4ef6\uff09" : ""));
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((MatrixManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, xmlStr);
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u5173\u7cfb\u77e9\u9635\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u7ee7\u7eed\u8986\u76d6\u66f4\u65b0\uff1f" + (containsCtrl ? "\uff08\u82e5\u5f15\u7528\u4e86\u5143\u4ef6\uff0c\u9700\u8981\u5355\u72ec\u5bfc\u5165\u5143\u4ef6\uff09" : ""), (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e) + ",\u4e0d\u652f\u6301\u5bfc\u5165");
            throw new BaseException(message.getMessage());
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    @Override
    @Transactional
    public Object importSave(Optional<Boolean> confirmImport, Optional<String> typeId, Optional<String> typeName, Optional<String> cacheFileId) throws Exception {
        if (confirmImport.orElse(false).booleanValue()) {
            String xmlStr = ((MatrixManagerImpl)AppUtil.getBean(this.getClass())).getImportFileFromCache(cacheFileId.get());
            if (StringUtil.isEmpty((String)xmlStr)) {
                return new CommonResult("\u5bfc\u5165\u7684\u6587\u4ef6\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
            }
            MatrixImportXml matrixImportXml = (MatrixImportXml)JAXBUtil.unmarshall((String)xmlStr, MatrixImportXml.class);
            MatrixManagerImpl matrixManager = (MatrixManagerImpl)AppUtil.getBean(this.getClass());
            matrixManager.importMatrix(matrixImportXml, typeId.orElse(""), typeName.orElse(""));
        }
        ((MatrixManagerImpl)AppUtil.getBean(this.getClass())).delImportFileFromCache(cacheFileId.orElse(""));
        return new CommonResult("\u5bfc\u5165\u6210\u529f\uff08\u82e5\u5f15\u7528\u4e86\u5143\u4ef6\uff0c\u9700\u8981\u5355\u72ec\u5bfc\u5165\u5143\u4ef6\uff09");
    }

    @Override
    @CachePut(value={"eip:matrix:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:matrix:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:matrix:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Transactional
    public void importMatrix(MatrixImportXml matrixImportXml, String typeId, String typeName) throws Exception {
        MatrixManager matrixManager = (MatrixManager)AppUtil.getBean(MatrixManager.class);
        List<MatrixXml> matrixXmlList = matrixImportXml.getMatrixXmlList();
        if (CollectionUtils.isEmpty(matrixXmlList)) {
            return;
        }
        for (MatrixXml matrixXml : matrixXmlList) {
            Matrix matrix = matrixXml.getMatrix();
            matrix.setTypeId(typeId);
            matrix.setTypeName(typeName);
            List<Map<String, Object>> dataList = matrixXml.getDataList();
            if (StringUtil.isEmpty((String)matrix.getCode())) continue;
            Matrix matrixDb = this.getByCode(matrix.getCode());
            matrix.setId(matrixDb == null ? null : matrixDb.getId());
            if (matrixDb != null) {
                matrix.setTenantId(TenantUtil.getCurrentTenantId());
            }
            this.createTableByMatrix(matrix);
            this.saveMatrix(matrix);
            matrixManager.saveDataList(matrix, dataList);
            this.saveOrUpdateMatrixAuths(matrixXml, matrix.getId());
            this.saveOrUpdateMatrixProcRelation(matrixXml);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveDataList(Matrix matrix, List<Map<String, Object>> dataList) throws Exception {
        if (CollectionUtils.isNotEmpty(dataList)) {
            for (Map<String, Object> dataMap : dataList) {
                if (BeanUtils.isEmpty(dataMap)) continue;
                this.resetRoleUser(dataMap);
                String existSql = this.constructIsCondKeyExistSql(matrix.getCode(), dataMap);
                List query = this.commonManager.query(existSql);
                if (query != null && query.size() > 0) {
                    for (Map map : query) {
                        dataMap.put("ID_", map.get("ID_"));
                        this.updateData(matrix.getCode(), dataMap);
                    }
                    continue;
                }
                dataMap.remove("ID_");
                this.insertData(matrix.getCode(), dataMap);
            }
        }
    }

    private void saveOrUpdateMatrixAuths(MatrixXml matrixXml, String matrixId) {
        List<MatrixAuth> matrixAuths = matrixXml.getMatrixAuths();
        if (BeanUtils.isEmpty(matrixAuths)) {
            return;
        }
        List<Object> userList = new ArrayList();
        List accountList = matrixAuths.stream().map(MatrixAuth::getAccount).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(accountList)) {
            userList = this.userManager.getUserByAccounts(StringUtil.join(accountList));
        }
        ArrayList<MatrixAuth> matrixAuthListNew = new ArrayList<MatrixAuth>();
        for (MatrixAuth matrixAuth : matrixAuths) {
            MatrixAuth authOne;
            if (StringUtil.isEmpty((String)matrixId) || StringUtil.isEmpty((String)matrixAuth.getAccount()) || !BeanUtils.isEmpty((Object)((Object)(authOne = (MatrixAuth)((Object)this.matrixAuthManager.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MatrixAuth::getAccount, (Object)matrixAuth.getAccount())).eq(MatrixAuth::getMatrixId, (Object)matrixId))))))) continue;
            matrixAuth.setMatrixId(matrixId);
            IUser user = userList.stream().filter(u -> u.getAccount().equalsIgnoreCase(matrixAuth.getAccount())).findFirst().orElse(null);
            if (user != null) {
                matrixAuth.setUserId(user.getUserId());
            }
            matrixAuthListNew.add(matrixAuth);
        }
        if (CollectionUtils.isNotEmpty(matrixAuthListNew)) {
            this.matrixAuthManager.saveBatch(matrixAuthListNew);
        }
    }

    private void saveOrUpdateMatrixProcRelation(MatrixXml matrixXml) {
        List<MatrixProcRelation> procRelations = matrixXml.getMatrixProcRelations();
        if (BeanUtils.isEmpty(procRelations)) {
            return;
        }
        for (MatrixProcRelation procRelation : procRelations) {
            MatrixProcRelation procRelationOne = (MatrixProcRelation)((Object)this.matrixProcRelationManager.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MatrixProcRelation::getMatrixCode, (Object)procRelation.getMatrixCode())).eq(MatrixProcRelation::getProcDefKey, (Object)procRelation.getProcDefKey())));
            if (BeanUtils.isNotEmpty((Object)((Object)procRelationOne))) {
                procRelationOne.setProcDefKey(procRelation.getProcDefKey());
                procRelationOne.setProcDefName(procRelation.getProcDefName());
                this.matrixProcRelationManager.update((Model)procRelation);
                continue;
            }
            this.matrixProcRelationManager.save((Object)procRelation);
        }
    }

    private void resetRoleUser(Map<String, Object> dataMap) throws Exception {
        for (String key : dataMap.keySet()) {
            if (!StringUtil.isNotEmpty((String)key) || !key.startsWith("ROLE_") || dataMap.get(key) == null || dataMap.get(key) == "null") continue;
            String roleValue = dataMap.get(key).toString();
            if (!roleValue.startsWith("[") || !roleValue.contains("[")) {
                throw new BaseException("\u89e3\u6790\u4eba\u5458\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u56e0\u4e3a\u4e0d\u80fd\u89e3\u6790\u6210\u6b63\u786e\u7684json\u683c\u5f0f\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u4eba\u5458\u4fe1\u606f\uff01");
            }
            ObjectMapper mapper = JsonUtil.getMapper();
            JsonNode jsonNode = mapper.readTree(dataMap.get(key).toString());
            if (Objects.isNull(jsonNode) || !jsonNode.isArray()) continue;
            ArrayNode roleObject = (ArrayNode)jsonNode;
            boolean isChanged = false;
            for (JsonNode node : roleObject) {
                User user;
                String account;
                if (node.get("account") == null || StringUtil.isEmpty((String)(account = node.get("account").asText())) || BeanUtils.isEmpty((Object)(user = this.userManager.getByAccount(account)))) continue;
                ObjectNode roleNode = (ObjectNode)node;
                roleNode.put("id", user.getUserId());
                roleNode.put("fullname", user.getFullname());
                isChanged = true;
            }
            if (!isChanged) continue;
            dataMap.put(key, roleObject);
        }
    }

    @Override
    public PageList<Matrix> listJson(QueryFilter<Matrix> queryFilter) {
        IPage page = this.convert2IPage(queryFilter.getPageBean());
        return new PageList(((MatrixDao)this.baseMapper).listJson((IPage<Matrix>)page, (Wrapper<Matrix>)this.convert2Wrapper(queryFilter, this.currentModelClass())));
    }

    @Override
    public void batchSaveData(String matrixId, List<Map<String, Object>> data) {
        Matrix matrix = this.getDetail(matrixId);
        List<MatrixColDef> condList = matrix.getCondList();
        Optional<MatrixColDef> first = condList.stream().filter(item -> !NORMAL_CTRL_TYPE.contains(item.getCtrlType())).findFirst();
        String ctrlType = first.map(MatrixColDef::getCtrlType).orElse("common");
        MatrixDataService service = (MatrixDataService)AppUtil.getBean((String)(ctrlType + "MatrixDataServiceImpl"));
        Assert.notNull((Object)service, (String)("\u4e0d\u5b58\u5728[" + ctrlType + "]\u7684\u6761\u4ef6\u7c7b\u578b"), (Object[])new Object[0]);
        service.save(matrix, data, first.map(MatrixColDef::getCode).orElse("ID_"));
    }
}

