/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.BpmModelFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.uc.dao.MatrixProcRelationDao;
import com.hotent.uc.manager.MatrixProcRelationManager;
import com.hotent.uc.model.MatrixProcRelation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matrixProcRelationManager")
public class MatrixProcRelationManagerImpl
extends BaseManagerImpl<MatrixProcRelationDao, MatrixProcRelation>
implements MatrixProcRelationManager {
    @Resource
    BpmModelFeignService bpmModelFeignService;

    @Override
    @Transactional
    public void batchHandle(List<MatrixProcRelation> oldMatrixProcRelations, List<MatrixProcRelation> newMatrixProcRelations) {
        if (oldMatrixProcRelations == null) {
            oldMatrixProcRelations = new ArrayList<MatrixProcRelation>();
        }
        if (newMatrixProcRelations == null) {
            newMatrixProcRelations = new ArrayList<MatrixProcRelation>();
        }
        HashSet<MatrixProcRelation> newMatrixProcRelationsSet = new HashSet<MatrixProcRelation>(newMatrixProcRelations);
        List allRelations = oldMatrixProcRelations.stream().filter(newMatrixProcRelationsSet::contains).collect(Collectors.toList());
        for (Object relation : allRelations) {
            String matrixCode = ((MatrixProcRelation)((Object)relation)).getMatrixCode();
            String procDefKey = ((MatrixProcRelation)((Object)relation)).getProcDefKey();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MATRIX_CODE_", (Object)matrixCode);
            queryWrapper.eq((Object)"PROC_DEF_KEY_", (Object)procDefKey);
            List relations = this.list((Wrapper)queryWrapper);
            if (!BeanUtils.isEmpty((Object)relations)) continue;
            this.create((Model)relation);
        }
        List delRelations = oldMatrixProcRelations.stream().filter(item -> !newMatrixProcRelationsSet.contains(item)).collect(Collectors.toList());
        for (MatrixProcRelation delRelation : delRelations) {
            String matrixCode = delRelation.getMatrixCode();
            String procDefKey = delRelation.getProcDefKey();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MATRIX_CODE_", (Object)matrixCode);
            queryWrapper.eq((Object)"PROC_DEF_KEY_", (Object)procDefKey);
            this.remove((Wrapper)queryWrapper);
        }
        HashSet<MatrixProcRelation> oldMatrixProcRelationsSet = new HashSet<MatrixProcRelation>(oldMatrixProcRelations);
        List addRelations = newMatrixProcRelations.stream().filter(item -> !oldMatrixProcRelationsSet.contains(item)).collect(Collectors.toList());
        for (MatrixProcRelation addRelation : addRelations) {
            String matrixCode = addRelation.getMatrixCode();
            String procDefKey = addRelation.getProcDefKey();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MATRIX_CODE_", (Object)matrixCode);
            queryWrapper.eq((Object)"PROC_DEF_KEY_", (Object)procDefKey);
            List relations = this.list((Wrapper)queryWrapper);
            if (!BeanUtils.isEmpty((Object)relations)) continue;
            this.create((Model)addRelation);
        }
    }

    @Override
    public PageList<MatrixProcRelation> getList(QueryFilter queryFilter) throws Exception {
        PageList relationPageList = this.query(queryFilter);
        List relations = relationPageList.getRows();
        for (MatrixProcRelation relation : relations) {
            ObjectNode procDefObjNode = this.bpmModelFeignService.getProcDefByDefKey(relation.getProcDefKey());
            if (!BeanUtils.isNotEmpty((Object)procDefObjNode)) continue;
            String procDefId = procDefObjNode.get("defId").asText();
            String procDefName = procDefObjNode.get("name").asText();
            if (!BeanUtils.isNotEmpty((Object)procDefId) || !BeanUtils.isNotEmpty((Object)procDefName)) continue;
            relation.setProcDefId(procDefId);
            if (procDefName.equals(relation.getProcDefName())) continue;
            relation.setProcDefName(procDefName);
            this.save((Object)relation);
        }
        relationPageList.setRows(relations);
        return relationPageList;
    }

    @Override
    public PageList<MatrixProcRelation> list(QueryFilter queryFilter) {
        PageList relationPageList = this.query(queryFilter);
        List relations = relationPageList.getRows();
        for (MatrixProcRelation relation : relations) {
            ObjectNode procDefObjNode = this.bpmModelFeignService.getProcDefByDefKey(relation.getProcDefKey());
            if (!BeanUtils.isNotEmpty((Object)procDefObjNode)) continue;
            String procDefId = procDefObjNode.get("defId").asText();
            String procDefName = procDefObjNode.get("name").asText();
            if (!BeanUtils.isNotEmpty((Object)procDefId) || !BeanUtils.isNotEmpty((Object)procDefName)) continue;
            relation.setProcDefId(procDefId);
            if (procDefName.equals(relation.getProcDefName())) continue;
            relation.setProcDefName(procDefName);
            this.saveOrUpdate((Object)relation);
        }
        relationPageList.setRows(relations);
        return relationPageList;
    }
}

