/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.uc.dao.ShiftRuleDao;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.manager.HolidayTimeManager;
import com.hotent.uc.manager.ShiftRuleManager;
import com.hotent.uc.model.HolidayTime;
import com.hotent.uc.model.ShiftRule;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="shiftRuleManager")
public class ShiftRuleManagerImpl
extends BaseManagerImpl<ShiftRuleDao, ShiftRule>
implements ShiftRuleManager {
    @Resource
    HolidayTimeManager holidayTimeManager;
    public static final String STYLE = "yyyy-MM-dd HH:mm:ss";

    @Override
    public long computeSendDate(String userId, long minute) throws ParseException, IOException, BaseException {
        long checkDuration = minute * 60L * 1000L;
        ShiftRule rule = this.getRuleByUserId(userId);
        if (BeanUtils.isEmpty((Object)rule)) {
            return DateUtil.getCurrentTimeInMillis() + checkDuration;
        }
        List<HolidayTime> holidayTimes = this.getHolidayTimes(rule.getHolidayId());
        Map<Integer, ObjectNode> shiftMap = this.getMap(rule.getRule());
        long totalWorkTime = 0L;
        long holidayWorkTime = 0L;
        for (int i = 0; i < 7; ++i) {
            ObjectNode dayShift = shiftMap.get(i);
            LocalDateTime shiftStartDateTime = DateFormatUtil.parse((String)("2000-01-01 " + dayShift.get("startTime").asText()), (String)STYLE);
            LocalDateTime shiftEndDateTime = DateFormatUtil.parse((String)("2000-01-01 " + dayShift.get("endTime").asText()), (String)STYLE);
            totalWorkTime += TimeUtil.getTimeMillis((LocalDateTime)shiftEndDateTime) - TimeUtil.getTimeMillis((LocalDateTime)shiftStartDateTime);
        }
        if (holidayTimes.size() > 0) {
            for (HolidayTime holidayTime : holidayTimes) {
                if (holidayTime.getType() != 1) continue;
                holidayWorkTime += TimeUtil.getTimeMillis((LocalDateTime)holidayTime.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)holidayTime.getStartTime());
            }
        }
        if (totalWorkTime == 0L && holidayWorkTime <= checkDuration) {
            throw new BaseException("\u6d41\u7a0b\u8fdb\u884c\u9519\u8bef\uff1a\u4e0b\u4e2a\u8282\u70b9\u5ba1\u6279\u4eba\u7684\u6392\u73ed\u4e2d\u65e0\u5de5\u4f5c\u65f6\u95f4\uff0c\u4e14\u65e0\u8865\u73ed\u65f6\u95f4\u6216\u8865\u73ed\u65f6\u95f4\u5c0f\u4e8e\u50ac\u529e\u65f6\u957f");
        }
        LocalDateTime today = DateUtil.getCurrentDate();
        int count = 0;
        long result = TimeUtil.getTimeMillis((LocalDateTime)today);
        while (checkDuration > 0L) {
            if (count != 0) {
                today = today.plusDays(1L);
            }
            int day = today.getDayOfWeek().getValue() % 7;
            long duration = 0L;
            HolidayTime makeUpDay = this.getMakeUpDay(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)today));
            if (!this.isHoliday(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)today)) && this.isWorkDay(shiftMap.get(day))) {
                ObjectNode shift = shiftMap.get(day);
                LocalDateTime startDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)today, (String)"yyyy-MM-dd ") + shift.get("startTime").asText()), (String)STYLE);
                LocalDateTime endDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)today, (String)"yyyy-MM-dd ") + shift.get("endTime").asText()), (String)STYLE);
                long startTime = TimeUtil.getTimeMillis((LocalDateTime)startDateTime);
                long endTime = TimeUtil.getTimeMillis((LocalDateTime)endDateTime);
                if (endTime - startTime >= checkDuration && count != 0) {
                    duration = checkDuration;
                    result = startTime + duration;
                }
                if (endTime - TimeUtil.getTimeMillis((LocalDateTime)today) > checkDuration && count == 0) {
                    duration = checkDuration;
                    result = TimeUtil.getTimeMillis((LocalDateTime)today) + duration;
                }
                if (today.isBefore(startDateTime) || !today.isBefore(endDateTime) && today.minusDays(1L).isBefore(startDateTime)) {
                    duration = endTime - startTime;
                } else if (today.isBefore(endDateTime)) {
                    duration = endTime - TimeUtil.getTimeMillis((LocalDateTime)today);
                    today = LocalDateTime.of(today.toLocalDate(), LocalTime.MIN);
                }
            } else if (BeanUtils.isNotEmpty((Object)((Object)makeUpDay))) {
                long startTime = TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime());
                long endTime = TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime());
                if (endTime - startTime >= checkDuration && count != 0) {
                    duration = checkDuration;
                    result = startTime + duration;
                }
                if (endTime - TimeUtil.getTimeMillis((LocalDateTime)today) > checkDuration && count == 0) {
                    duration = checkDuration;
                    result = TimeUtil.getTimeMillis((LocalDateTime)today) + duration;
                }
                if (today.isBefore(makeUpDay.getStartTime()) || !today.isBefore(makeUpDay.getEndTime()) && today.minusDays(1L).isBefore(makeUpDay.getStartTime())) {
                    duration = endTime - startTime;
                } else if (today.isBefore(makeUpDay.getEndTime())) {
                    duration = endTime - TimeUtil.getTimeMillis((LocalDateTime)today);
                    today = LocalDateTime.of(today.toLocalDate(), LocalTime.MIN);
                }
            }
            checkDuration -= duration;
            ++count;
        }
        return result;
    }

    @Override
    public long computeDuration(String userId, LocalDateTime startDate, LocalDateTime endDate) throws ParseException, IOException {
        long duration = 0L;
        ShiftRule rule = this.getRuleByUserId(userId);
        if (BeanUtils.isEmpty((Object)rule)) {
            return TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)startDate);
        }
        List<HolidayTime> holidayTimes = this.getHolidayTimes(rule.getHolidayId());
        Map<Integer, ObjectNode> shiftMap = this.getMap(rule.getRule());
        LocalDateTime currentDate = DateFormatUtil.parse((String)DateFormatUtil.format((LocalDateTime)startDate, (String)STYLE));
        while (TimeUtil.getTimeMillis((LocalDateTime)currentDate) < TimeUtil.getTimeMillis((LocalDateTime)endDate)) {
            int day = currentDate.getDayOfWeek().getValue() % 7;
            HolidayTime makeUpDay = this.getMakeUpDay(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)currentDate));
            if (!this.isHoliday(holidayTimes, TimeUtil.getTimeMillis((LocalDateTime)currentDate)) && this.isWorkDay(shiftMap.get(day))) {
                ObjectNode shift = shiftMap.get(day);
                LocalDateTime startDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)currentDate, (String)"yyyy-MM-dd ") + shift.get("startTime").asText()), (String)STYLE);
                LocalDateTime endDateTime = DateFormatUtil.parse((String)(DateFormatUtil.format((LocalDateTime)currentDate, (String)"yyyy-MM-dd ") + shift.get("endTime").asText()), (String)STYLE);
                if (currentDate.isBefore(startDateTime)) {
                    duration = endDate.isBefore(endDateTime) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)startDateTime)) : (duration += TimeUtil.getTimeMillis((LocalDateTime)endDateTime) - TimeUtil.getTimeMillis((LocalDateTime)startDateTime));
                } else if (currentDate.isBefore(endDateTime)) {
                    duration = BeanUtils.isNotEmpty((Object)((Object)makeUpDay)) && endDate.isBefore(makeUpDay.getEndTime()) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)currentDate)) : (endDate.isBefore(endDateTime) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)currentDate)) : (duration += TimeUtil.getTimeMillis((LocalDateTime)endDateTime) - TimeUtil.getTimeMillis((LocalDateTime)currentDate)));
                }
            } else if (BeanUtils.isNotEmpty((Object)((Object)makeUpDay))) {
                if (currentDate.isBefore(makeUpDay.getStartTime())) {
                    duration = endDate.isBefore(makeUpDay.getEndTime()) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime())) : (duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime()));
                    duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getStartTime());
                } else if (currentDate.isBefore(makeUpDay.getEndTime())) {
                    duration = endDate.isBefore(makeUpDay.getEndTime()) ? (duration += TimeUtil.getTimeMillis((LocalDateTime)endDate) - TimeUtil.getTimeMillis((LocalDateTime)currentDate)) : (duration += TimeUtil.getTimeMillis((LocalDateTime)makeUpDay.getEndTime()) - TimeUtil.getTimeMillis((LocalDateTime)currentDate));
                }
            }
            currentDate = LocalDateTime.of(currentDate.toLocalDate(), LocalTime.MIN);
            currentDate = currentDate.plusDays(1L);
        }
        return duration;
    }

    private Map<Integer, ObjectNode> getMap(String rule) throws IOException {
        ArrayNode shifts = (ArrayNode)JsonUtil.toJsonNode((String)rule);
        List shiftList = JsonUtil.arrayToList((ArrayNode)shifts);
        Map<Integer, ObjectNode> shiftMap = shiftList.parallelStream().collect(Collectors.toMap(item -> item.get("date").asInt(), item -> item));
        return shiftMap;
    }

    private List<HolidayTime> getHolidayTimes(String holidayId) {
        List<HolidayTime> holidayTimes = new ArrayList<HolidayTime>();
        if (StringUtil.isNotEmpty((String)holidayId)) {
            holidayTimes = this.holidayTimeManager.getByHolidayId((Serializable)((Object)holidayId));
        }
        return holidayTimes;
    }

    @Override
    public ShiftRule getRuleByUserId(String userId) {
        return ((ShiftRuleDao)this.baseMapper).getRuleByUserId(userId);
    }

    @Override
    public ShiftRule getByKey(ShiftRule shiftRule) {
        return ((ShiftRuleDao)this.baseMapper).getByKey(shiftRule.getKey());
    }

    private boolean isWorkDay(ObjectNode shift) {
        return shift.get("type").asInt() == 1;
    }

    private HolidayTime getMakeUpDay(List<HolidayTime> makeUpDay, long time) {
        List times = makeUpDay.parallelStream().filter(item -> HolidayTime.MAKE_UP_DAY.equals(item.getType())).filter(item -> {
            LocalDateTime startDateTime = LocalDateTime.of(item.getStartTime().toLocalDate(), LocalTime.MIN);
            LocalDateTime endDateTime = LocalDateTime.of(item.getEndTime().toLocalDate(), LocalTime.MAX);
            return this.isBetween(startDateTime, endDateTime, time);
        }).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(times)) {
            return (HolidayTime)((Object)times.get(0));
        }
        return null;
    }

    private boolean isHoliday(List<HolidayTime> holidays, long time) {
        return holidays.parallelStream().filter(item -> HolidayTime.HOLIDAY.equals(item.getType())).filter(item -> this.isBetween(item.getStartTime(), item.getEndTime(), time)).collect(Collectors.counting()).intValue() > 0;
    }

    private boolean isBetween(LocalDateTime startTime, LocalDateTime endTime, long time) {
        return TimeUtil.getTimeMillis((LocalDateTime)startTime) <= time && endTime.toInstant(ZoneOffset.of("+8")).toEpochMilli() > time;
    }
}

