/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.TenantParamsDao;
import com.hotent.uc.manager.ParamsManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.manager.TenantParamsManager;
import com.hotent.uc.model.Params;
import com.hotent.uc.model.TenantManage;
import com.hotent.uc.model.TenantParams;
import com.hotent.uc.params.params.ParamObject;
import com.hotent.uc.util.ContextUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantParamsManager")
public class TenantParamsManagerImpl
extends BaseManagerImpl<TenantParamsDao, TenantParams>
implements TenantParamsManager {
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    ParamsManager paramsService;

    @Override
    public List<TenantParams> getByTenantId(String tenantId) {
        return ((TenantParamsDao)this.baseMapper).getByTenantId(tenantId, ContextUtil.getCurrentUser().getTenantId());
    }

    @Override
    @Transactional
    public void deleteByTenantId(String tenantId) {
        ((TenantParamsDao)this.baseMapper).deleteByTenantId(tenantId);
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserParams(String tenantId, List<ParamObject> params) {
        if (StringUtil.isEmpty((String)tenantId)) {
            return new CommonResult(false, "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            StringBuilder pcodes = new StringBuilder();
            TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)tenantId));
            boolean isTrue = false;
            if (BeanUtils.isEmpty((Object)((Object)tenant))) {
                return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u79df\u6237id\u4e3a\u3010" + tenantId + "\u3011\u7684\u79df\u6237\uff01");
            }
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            if (BeanUtils.isNotEmpty(params)) {
                for (ParamObject paramObject : params) {
                    Params param = null;
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        param = this.paramsService.getTenantByAlias(paramObject.getAlias(), tenantId);
                    }
                    if (BeanUtils.isNotEmpty((Object)param) && "3".equals(param.getType())) {
                        list.add((ObjectNode)JsonUtil.toJsonNode((String)paramObject.toString()));
                        isTrue = true;
                        continue;
                    }
                    pcodes.append(paramObject.getAlias()).append("\uff0c");
                }
            }
            if (BeanUtils.isNotEmpty(list)) {
                this.saveParams(tenantId, list);
                return new CommonResult(true, isTrue && StringUtil.isEmpty((String)pcodes.toString()) ? "\u4fdd\u5b58\u6210\u529f" : "\u90e8\u5206\u4fdd\u5b58\u6210\u529f\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01", (Object)"");
            }
            return new CommonResult(false, "\u672a\u4fdd\u5b58\u4efb\u4f55\u53c2\u6570\uff0c\u79df\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.contains("ORA-12899")) {
                msg = "\u53c2\u6570\u503c\u8fc7\u957f";
            }
            return new CommonResult(false, "\u79df\u6237\u6269\u5c55\u53c2\u6570\u4fdd\u5b58\u5931\u8d25\uff1a" + msg);
        }
    }

    @Transactional
    public void saveParams(String tenantId, List<ObjectNode> lists) throws SQLException {
        for (ObjectNode ObjectNode2 : lists) {
            TenantParams params = ((TenantParamsDao)this.baseMapper).getByTenantIdAndCode(tenantId, ObjectNode2.get("alias").asText());
            if (BeanUtils.isNotEmpty((Object)((Object)params))) {
                if (ObjectNode2.hasNonNull("value") && !"null".equals(ObjectNode2.get("value").asText())) {
                    params.setValue(ObjectNode2.get("value").asText());
                } else {
                    params.setValue("");
                }
                this.update((Model)params);
                continue;
            }
            TenantParams tenantParams = new TenantParams();
            tenantParams.setCode(ObjectNode2.get("alias").asText());
            if (!"null".equals(ObjectNode2.get("value"))) {
                tenantParams.setValue(ObjectNode2.get("value").asText());
            }
            tenantParams.setTenantId(tenantId);
            tenantParams.setId(UniqueIdUtil.getSuid());
            this.create((Model)tenantParams);
        }
    }

    @Override
    public void removeByAlias(String code, String tenantTypeId) {
        List tenants = this.tenantManageManager.list((Wrapper)Wrappers.lambdaQuery().eq(TenantManage::getTypeId, (Object)tenantTypeId));
        List tenantIds = tenants.stream().map(TenantManage::getId).collect(Collectors.toList());
        if (tenantIds.isEmpty()) {
            return;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TenantParams::getCode, (Object)code)).in(TenantParams::getTenantId, tenantIds);
        this.remove((Wrapper)wrapper);
    }
}

