/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.enums.CommonEnum;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.jwt.JwtAuthenticationResponse;
import com.hotent.base.model.CommonResult;
import com.hotent.base.service.TwoVerifyService;
import com.hotent.base.util.GoogleAuthenticator;
import com.hotent.base.util.RSAUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.manager.OneTimeCodeManager;
import com.hotent.uc.manager.TwoVerifyManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.OneTimeCode;
import com.hotent.uc.model.User;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TwoVerifyManagerImpl
implements TwoVerifyManager {
    final int verifyErrorMax = 5;
    @Autowired
    UserManager userService;
    @Autowired
    OneTimeCodeManager oneTimeCodeManager;
    @Autowired
    TwoVerifyService twoVerifyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<OneTimeCode> bindTwoStepVerifySecret(User user, String secret) {
        user.setTwoVerifySecret(secret);
        this.userService.getBaseMapper().updateById((Object)user);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(OneTimeCode::getUserId, (Object)user.getId());
        this.oneTimeCodeManager.remove((Wrapper)queryWrapper);
        List<OneTimeCode> oneTimeCodeList = Stream.iterate(1, i -> i + 1).limit(10L).map(e -> {
            OneTimeCode oneTimeCode = new OneTimeCode();
            String code = MD5.create().digestHex16(UniqueIdUtil.getSuid());
            oneTimeCode.setCode(code);
            oneTimeCode.setUserId(user.getUserId());
            oneTimeCode.setCreateBy(user.getUserId());
            oneTimeCode.setCreator(user.getFullname());
            oneTimeCode.setCreateTime(LocalDateTime.now());
            oneTimeCode.setIsUsed(CommonEnum.YesOrNo.NO.getValue());
            return oneTimeCode;
        }).collect(Collectors.toList());
        this.oneTimeCodeManager.saveBatch(oneTimeCodeList);
        return oneTimeCodeList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeTwoStepVerify(User user) {
        user.setTwoVerifySecret(null);
        this.userService.getBaseMapper().updateById((Object)user);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(OneTimeCode::getUserId, (Object)user.getId());
        this.oneTimeCodeManager.remove((Wrapper)queryWrapper);
    }

    @Override
    public CommonResult twoStepVerify(String token, String code) throws Exception {
        String tokenDec = RSAUtil.Decrypt((String)token);
        JwtAuthenticationResponse jwtAuthenticationResponse = this.twoVerifyService.getTempTokenFromCache(tokenDec);
        if (jwtAuthenticationResponse == null) {
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_OVER_TIME);
        }
        String secret = tokenDec.split("_")[3];
        if (GoogleAuthenticator.authcode((String)code, (String)secret).booleanValue()) {
            this.twoVerifyService.removeTempTokenFromCache(tokenDec);
            return CommonResult.success((Object)jwtAuthenticationResponse);
        }
        OneTimeCode oneTimeCode = this.oneTimeCodeManager.getByUserIdAndCode(jwtAuthenticationResponse.getUserId(), code);
        if (oneTimeCode != null) {
            oneTimeCode.setIsUsed(CommonEnum.YesOrNo.YES.getValue());
            this.oneTimeCodeManager.update((Model)oneTimeCode);
            return CommonResult.success((Object)jwtAuthenticationResponse);
        }
        int errorCount = this.twoVerifyService.getTwoVerifyErrorCountFromCache(tokenDec) + 1;
        if (errorCount >= 5) {
            this.twoVerifyService.removeTempTokenFromCache(tokenDec);
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_FAIL_MAX);
        }
        this.twoVerifyService.putTwoVerifyErrorCountInCache(tokenDec, errorCount);
        return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_FAIL);
    }

    @Override
    public CommonResult twoStepVerifyAndBind(String token, String code) throws Exception {
        String tokenDec = RSAUtil.Decrypt((String)token);
        JwtAuthenticationResponse jwtAuthenticationResponse = this.twoVerifyService.getTempTokenFromCache(tokenDec);
        if (jwtAuthenticationResponse == null) {
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_OVER_TIME);
        }
        String secret = tokenDec.split("_")[3];
        if (!GoogleAuthenticator.authcode((String)code, (String)secret).booleanValue()) {
            return CommonResult.result((ResponseErrorEnums)ResponseErrorEnums.TWO_VERIFY_FAIL);
        }
        User user = (User)this.userService.getById((Serializable)((Object)jwtAuthenticationResponse.getUserId()));
        List<OneTimeCode> oneTimeCodeList = this.bindTwoStepVerifySecret(user, secret);
        this.twoVerifyService.removeTempTokenFromCache(tokenDec);
        return CommonResult.success(oneTimeCodeList);
    }
}

