/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.dao.UcUserSelectorLogDao;
import com.hotent.uc.dto.UserSeletorDto;
import com.hotent.uc.manager.UcUserSelectorLogManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.UcUserSelectorLog;
import com.hotent.uc.util.ContextUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UcUserSelectorLogManagerImpl
extends BaseManagerImpl<UcUserSelectorLogDao, UcUserSelectorLog>
implements UcUserSelectorLogManager {
    @Resource
    private UserManager userService;

    @Override
    public UcUserSelectorLog getDetail(String id) {
        UcUserSelectorLog ucUserSelectorLog = (UcUserSelectorLog)this.get((Serializable)((Object)id));
        return ucUserSelectorLog;
    }

    @Override
    @Transactional
    public void createOrUpdate(UcUserSelectorLog ucUserSelectorLog) {
        this.saveOrUpdate((Object)ucUserSelectorLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addLog(List<String> selectAccounts) {
        String currentUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)currentUserId) && BeanUtils.isNotEmpty(selectAccounts)) {
            String lockKey;
            if (CollUtil.isEmpty(selectAccounts = selectAccounts.stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList()))) {
                return;
            }
            String string = lockKey = (UcUserSelectorLogManager.class + currentUserId).intern();
            synchronized (string) {
                List oldList = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UcUserSelectorLog::getOperUserId, (Object)currentUserId)).in(UcUserSelectorLog::getSelectUserAccount, selectAccounts));
                ArrayList<String> accountsUnhandled = new ArrayList<String>(selectAccounts);
                ArrayList<UcUserSelectorLog> batchList = new ArrayList<UcUserSelectorLog>();
                if (CollUtil.isNotEmpty((Collection)oldList)) {
                    for (UcUserSelectorLog log : oldList) {
                        log.setFrequency(Optional.ofNullable(log.getFrequency()).orElse(0) + 1);
                        batchList.add(log);
                        accountsUnhandled.removeIf(account -> account.equals(log.getSelectUserAccount()));
                    }
                }
                if (CollUtil.isNotEmpty(accountsUnhandled)) {
                    for (String userId : accountsUnhandled) {
                        UcUserSelectorLog log = new UcUserSelectorLog();
                        log.setOperUserId(currentUserId);
                        log.setSelectUserAccount(userId);
                        log.setFrequency(1);
                        log.setUpdateTime(LocalDateTime.now());
                        batchList.add(log);
                    }
                }
                if (CollUtil.isNotEmpty(batchList)) {
                    this.saveOrUpdateBatch(batchList);
                }
            }
        }
    }

    @Override
    public PageList<UserSeletorDto> queryUserWithSelectorLog(Boolean isMobile, QueryFilter queryFilter) {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            queryFilter = QueryFilter.build();
        }
        queryFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(20), Boolean.valueOf(false)));
        queryFilter.addParams("currentUserId", (Object)ContextUtil.getCurrentUserId());
        IPage<UcUserSelectorLog> result = ((UcUserSelectorLogDao)this.baseMapper).getSelectorAccounts((IPage<UcUserSelectorLog>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<UcUserSelectorLog>)this.convert2Wrapper(queryFilter, UcUserSelectorLog.class));
        List<String> accountList = result.getRecords().stream().map(UcUserSelectorLog::getSelectUserAccount).collect(Collectors.toList());
        if (BeanUtils.isEmpty(accountList)) {
            return new PageList();
        }
        queryFilter.addQueryField(new QueryField("uu.account_", accountList, QueryOP.IN));
        PageList<UserSeletorDto> userSeletorDtoPageList = isMobile != false ? this.userService.queryUserWithOrgPost(queryFilter) : this.userService.queryUserWithMainOrgPost(queryFilter);
        if (CollUtil.isNotEmpty((Collection)userSeletorDtoPageList.getRows())) {
            ArrayList userSeletorDtoList = new ArrayList();
            accountList.forEach(account -> userSeletorDtoPageList.getRows().forEach(userSeletorDto -> {
                if (account.equals(userSeletorDto.getAccount())) {
                    userSeletorDtoList.add(userSeletorDto);
                }
            }));
            userSeletorDtoPageList.setRows(userSeletorDtoList);
        }
        return userSeletorDtoPageList;
    }

    @Override
    @Async(value="asyncExecutor")
    public void removeSixMonthBefore() throws Exception {
        LocalDateTime sixMonthsAgo = LocalDateTime.now().minus(Period.ofMonths(6));
        try (MultiTenantIgnoreResult ignoreResult = MultiTenantHandler.setThreadLocalIgnore();){
            this.remove((Wrapper)Wrappers.lambdaQuery().lt(UcUserSelectorLog::getUpdateTime, (Object)sixMonthsAgo));
        }
    }
}

