/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.OrgPostDao;
import com.hotent.uc.dao.RoleDao;
import com.hotent.uc.dao.UserGroupDao;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UserGroupManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserGroup;
import com.hotent.uc.params.userGroup.UserGroupVo;
import com.hotent.uc.util.OrgUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserGroupManagerImpl
extends BaseManagerImpl<UserGroupDao, UserGroup>
implements UserGroupManager {
    @Resource
    OrgManager orgManager;
    @Resource
    RoleDao roleDao;
    @Resource
    OrgPostDao orgPostDao;
    @Resource
    UserManager userManager;
    @Resource
    RoleManager roleManager;
    @Resource
    OrgPostManager orgPostManager;

    @Override
    public UserGroup getByCode(String code) {
        if (StringUtil.isEmpty((String)code)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7fa4\u7ec4\u7f16\u7801\u5fc5\u586b\uff01");
        }
        UserGroup userGroup = ((UserGroupDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)userGroup)) {
            throw new RuntimeException("\u7fa4\u7ec4\u7f16\u7801\uff1a\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return ((UserGroupDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<User> getUserListByGroupId(String id) throws Exception {
        ArrayList<User> list = new ArrayList<User>();
        UserGroup userGroup = (UserGroup)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)userGroup)) {
            list.addAll(OrgUtil.getUserListByTypeId("user", userGroup.getUserId()));
            list.addAll(OrgUtil.getUserListByTypeId("org", userGroup.getOrgId()));
            list.addAll(OrgUtil.getUserListByTypeId("role", userGroup.getRoleId()));
            list.addAll(OrgUtil.getUserListByTypeId("pos", userGroup.getPosId()));
            OrgUtil.removeDuplicate(list);
        }
        return list;
    }

    @Override
    public List<UserGroup> getByUserId(String userId) {
        return ((UserGroupDao)this.baseMapper).getByWhereSql(this.getGroupSql(userId));
    }

    private String getGroupSql(String userId) {
        List<Role> roleList;
        StringBuilder sql = new StringBuilder();
        sql.append(" and user_id_ like '%," + userId + ",%' ");
        List<Org> orgList = this.orgManager.getOrgListByUserId(userId);
        if (BeanUtils.isNotEmpty(orgList)) {
            sql.append(" or ( ");
            boolean orgFirst = true;
            for (Org org : orgList) {
                if (orgFirst) {
                    orgFirst = false;
                } else {
                    sql.append(" or ");
                }
                sql.append(" org_id_ like '%," + org.getId() + ",%' ");
            }
            sql.append(" ) ");
        }
        if (BeanUtils.isNotEmpty(roleList = this.roleManager.getListByUserId(userId))) {
            sql.append(" or ( ");
            boolean orgFirst = true;
            for (Role role : roleList) {
                if (orgFirst) {
                    orgFirst = false;
                } else {
                    sql.append(" or ");
                }
                sql.append(" role_id_ like '%," + role.getId() + ",%' ");
            }
            sql.append(" ) ");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgPost> list = this.orgPostManager.getRelListByParam(map);
        if (BeanUtils.isNotEmpty(list)) {
            sql.append(" or ( ");
            boolean orgFirst = true;
            for (OrgPost orgRel : list) {
                if (orgFirst) {
                    orgFirst = false;
                } else {
                    sql.append(" or ");
                }
                sql.append(" pos_id_ like '%," + orgRel.getId() + ",%' ");
            }
            sql.append(" ) ");
        }
        return sql.toString();
    }

    @Override
    @Transactional
    public CommonResult<String> addUserGroup(UserGroupVo userGroupVo) throws Exception {
        if (StringUtil.isEmpty((String)userGroupVo.getName())) {
            throw new RuntimeException("\u7fa4\u7ec4\u6dfb\u52a0\u5931\u8d25\uff0c\u7fa4\u7ec4\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)userGroupVo.getCode())) {
            throw new RuntimeException("\u6dfb\u52a0\u7fa4\u7ec4\u5931\u8d25\uff0c\u7fa4\u7ec4\u4ee3\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        UserGroup group = ((UserGroupDao)this.baseMapper).getByCode(userGroupVo.getCode());
        if (BeanUtils.isNotEmpty((Object)group)) {
            throw new RuntimeException("\u6dfb\u52a0\u7fa4\u7ec4\u5931\u8d25\uff0c\u7fa4\u7ec4\u7f16\u7801\u3010" + userGroupVo.getCode() + "\u3011\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        User user = OrgUtil.getCurrentUser();
        group = new UserGroup();
        group.setId(UniqueIdUtil.getSuid());
        group.setCode(userGroupVo.getCode());
        group.setDescription(userGroupVo.getDescription());
        group.setName(userGroupVo.getName());
        if (BeanUtils.isNotEmpty((Object)user)) {
            group.setCreator(user.getId());
        }
        this.create((Model)group);
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateUserGroup(UserGroupVo userGroupVo) throws Exception {
        if (StringUtil.isEmpty((String)userGroupVo.getCode())) {
            throw new RuntimeException("\u66f4\u65b0\u7fa4\u7ec4\u5931\u8d25\uff0c\u7fa4\u7ec4\u4ee3\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        UserGroup group = this.getByCode(userGroupVo.getCode());
        if (BeanUtils.isEmpty((Object)group)) {
            throw new RuntimeException("\u66f4\u65b0\u7fa4\u7ec4\u5931\u8d25\uff0c\u6839\u636e\u7fa4\u7ec4\u7f16\u7801\u3010" + userGroupVo.getCode() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        if (StringUtil.isNotEmpty((String)userGroupVo.getName())) {
            group.setName(userGroupVo.getName());
        }
        group.setDescription(userGroupVo.getDescription());
        group.setUpdateTime(LocalDateTime.now());
        this.update((Model)group);
        return new CommonResult(true, "\u66f4\u65b0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delUserGroup(String codes) throws Exception {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        StringBuilder canotDEl = new StringBuilder();
        boolean isTrue = false;
        for (String code : codeArray) {
            UserGroup group = this.getByCode(code);
            if (BeanUtils.isNotEmpty((Object)group)) {
                if (OrgUtil.checkUserGruopIsUserRel("group", group.getId())) {
                    canotDEl.append(code);
                    canotDEl.append("\uff0c");
                    continue;
                }
                this.remove((Serializable)((Object)group.getId()));
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        String msg = "";
        msg = StringUtil.isEmpty((String)str.toString()) && StringUtil.isEmpty((String)canotDEl.toString()) ? "\u5220\u9664\u7fa4\u7ec4\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25";
        if (StringUtil.isNotEmpty((String)str.toString())) {
            msg = msg + "\uff0c\u7fa4\u7ec4\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        }
        if (StringUtil.isNotEmpty((String)canotDEl.toString())) {
            msg = msg + "\uff0c\u7fa4\u7ec4\u7f16\u7801\u4e3a\uff1a" + canotDEl.toString() + "\u7684\u7fa4\u7ec4\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff01";
        }
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> addGroupUsers(String code, List<ObjectNode> json) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7fa4\u7ec4\u4ee3\u7801code\u5fc5\u586b\uff01");
        }
        UserGroup group = this.getByCode(code);
        if (BeanUtils.isEmpty((Object)group)) {
            throw new RuntimeException("\u6839\u636e\u7fa4\u7ec4\u7f16\u7801\u3010" + code + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        if (BeanUtils.isEmpty(json)) {
            throw new RuntimeException("\u7528\u6237\u7ec4\u6570\u636ejson\u4e3a\u7a7a\uff01");
        }
        ArrayNode jsonArr = JsonUtil.getMapper().createArrayNode();
        for (ObjectNode o : json) {
            if (BeanUtils.isEmpty((Object)o.get("type"))) {
                throw new RuntimeException("\u7528\u6237\u7ec4\u6570\u636ejson\u4e2dtype\u5fc5\u586b\uff01");
            }
            String type = o.get("type").toString();
            if (!("user".equals(type) || "org".equals(type) || "pos".equals(type) || "role".equals(type))) {
                throw new RuntimeException("\u7528\u6237\u7ec4\u6570\u636ejson\u4e2dtype\u53ea\u80fd\u586b\u5199user\u3001pos\u3001role\u3001org\u56db\u79cd\u7c7b\u578b\uff01");
            }
            String[] codeArr = o.get("codes").toString().split(",");
            StringBuilder ids = new StringBuilder();
            StringBuilder names = new StringBuilder();
            StringBuilder codes = new StringBuilder();
            for (String c : codeArr) {
                if (StringUtil.isEmpty((String)c)) continue;
                if (StringUtil.isNotEmpty((String)ids.toString())) {
                    ids.append(",");
                    names.append(",");
                    codes.append(",");
                }
                if ("user".equals(type)) {
                    User u = this.userManager.getByAccount(c);
                    if (BeanUtils.isNotEmpty((Object)u)) {
                        ids.append(u.getId());
                        names.append(u.getFullname());
                        codes.append(u.getAccount());
                    } else {
                        throw new RuntimeException("\u7528\u6237\u7f16\u7801\u3010" + c + "\u3011\u4e0d\u5b58\u5728\uff01");
                    }
                }
                if ("org".equals(type)) {
                    Org org = this.orgManager.getByCode(c);
                    if (BeanUtils.isNotEmpty((Object)org)) {
                        ids.append(org.getId());
                        names.append(org.getName());
                        codes.append(org.getCode());
                    } else {
                        throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u3010" + c + "\u3011\u4e0d\u5b58\u5728\uff01");
                    }
                }
                if ("pos".equals(type)) {
                    OrgPost post = this.orgPostDao.getByCode(c);
                    if (BeanUtils.isNotEmpty((Object)post)) {
                        ids.append(post.getId());
                        names.append(post.getName());
                        codes.append(post.getCode());
                    } else {
                        throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u3010" + c + "\u3011\u4e0d\u5b58\u5728\uff01");
                    }
                }
                if (!"role".equals(type)) continue;
                Role r = this.roleDao.getByCode(c);
                if (BeanUtils.isNotEmpty((Object)r)) {
                    ids.append(r.getId());
                    names.append(r.getName());
                    codes.append(r.getCode());
                    continue;
                }
                throw new RuntimeException("\u89d2\u8272\u7f16\u7801\u3010" + c + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            ObjectNode object = JsonUtil.getMapper().createObjectNode();
            object.put("type", type);
            object.put("id", ids.toString());
            object.put("name", names.toString());
            object.put("code", codes.toString());
            if ("user".equals(type)) {
                object.put("title", "\u7528\u6237");
            }
            if ("org".equals(type)) {
                object.put("title", "\u7ec4\u7ec7");
            }
            if ("pos".equals(type)) {
                object.put("title", "\u5c97\u4f4d");
            }
            if ("role".equals(type)) {
                object.put("title", "\u89d2\u8272");
            }
            UserGroupManagerImpl.addObject(jsonArr, object);
        }
        for (int i = 0; i < jsonArr.size(); ++i) {
            ObjectNode o;
            o = (ObjectNode)jsonArr.get(i);
            if ("user".equals(o.get("type"))) {
                if (StringUtil.isNotEmpty((String)o.get("id").toString())) {
                    group.setUserId("," + o.get("id") + ",");
                } else {
                    group.setUserId(null);
                }
            }
            if ("org".equals(o.get("type"))) {
                if (StringUtil.isNotEmpty((String)o.get("id").toString())) {
                    group.setOrgId("," + o.get("id") + ",");
                } else {
                    group.setOrgId(null);
                }
            }
            if ("pos".equals(o.get("type"))) {
                if (StringUtil.isNotEmpty((String)o.get("id").toString())) {
                    group.setPosId("," + o.get("id") + ",");
                } else {
                    group.setPosId(null);
                }
            }
            if (!"role".equals(o.get("type"))) continue;
            if (StringUtil.isNotEmpty((String)o.get("id").toString())) {
                group.setRoleId("," + o.get("id") + ",");
                continue;
            }
            group.setRoleId(null);
        }
        group.setUpdateTime(LocalDateTime.now());
        group.setJson(JsonUtil.toJson((Object)jsonArr));
        this.update((Model)group);
        String msg = "\u7fa4\u7ec4\u52a0\u5165\u7528\u6237\u7ec4\u6210\u529f";
        if (StringUtil.isEmpty((String)group.getUserId()) && StringUtil.isEmpty((String)group.getOrgId()) && StringUtil.isEmpty((String)group.getRoleId()) && StringUtil.isEmpty((String)group.getPosId())) {
            msg = "\u7fa4\u7ec4\u7528\u6237\u7ec4\u7f6e\u7a7a";
        }
        return new CommonResult(true, msg, (Object)"");
    }

    private static ArrayNode addObject(ArrayNode arr, ObjectNode object) {
        if (BeanUtils.isEmpty((Object)arr)) {
            arr.add((JsonNode)object);
            return arr;
        }
        for (int i = 0; i < arr.size(); ++i) {
            ObjectNode o = (ObjectNode)arr.get(i);
            if (o.get("type").equals((Object)object.get("type"))) {
                if (StringUtil.isEmpty((String)o.get("id").toString())) {
                    o.put("id", object.get("id").asText());
                    o.put("name", object.get("name").asText());
                    o.put("code", object.get("code").asText());
                } else {
                    o.put("id", o.get("id") + "," + object.get("id"));
                    o.put("name", o.get("name") + "," + object.get("name"));
                    o.put("code", o.get("code") + "," + object.get("code"));
                }
                arr.remove(i);
                arr.add((JsonNode)o);
                break;
            }
            if (i != arr.size() - 1) continue;
            arr.add((JsonNode)object);
            break;
        }
        return arr;
    }

    private static void dealNewAndOldData(ArrayNode newData, ArrayNode oldData) {
        if (BeanUtils.isEmpty((Object)oldData)) {
            for (int i = 0; i < newData.size(); ++i) {
                ObjectNode o = (ObjectNode)newData.get(i);
                oldData.add((JsonNode)o);
            }
        } else {
            block1: for (int j = 0; j < newData.size(); ++j) {
                ObjectNode n = (ObjectNode)newData.get(j);
                for (int i = 0; i < oldData.size(); ++i) {
                    ObjectNode old = (ObjectNode)oldData.get(i);
                    if (!n.get("type").equals((Object)old.get("type"))) continue;
                    if (StringUtils.isNotEmpty((String)n.get("id").toString())) {
                        old.put("id", n.get("id").toString());
                        old.put("name", n.get("name").toString());
                        old.put("code", n.get("code").toString());
                        continue block1;
                    }
                    old.put("id", "");
                    old.put("name", "");
                    old.put("code", "");
                    continue block1;
                }
            }
        }
    }

    @Override
    public List<User> getGroupUsers(String code) throws Exception {
        if (StringUtil.isEmpty((String)code)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7fa4\u7ec4\u4ee3\u7801code\u5fc5\u586b\uff01");
        }
        UserGroup group = this.getByCode(code);
        if (BeanUtils.isEmpty((Object)group)) {
            throw new RuntimeException("\u6839\u636e\u7fa4\u7ec4\u7f16\u7801\u3010" + code + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        return this.getUserListByGroupId(group.getId());
    }

    @Override
    public List<UserGroup> getUserGroupByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        UserGroup userGroup = ((UserGroupDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)userGroup)) ? "\u8be5\u7fa4\u7ec4\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public CommonResult<String> updateGroupAuth(String code, String account) throws Exception {
        if (StringUtil.isEmpty((String)code) || StringUtil.isEmpty((String)account)) {
            throw new RuntimeException("\u7fa4\u7ec4\u7f16\u7801\u201ccode\u201d\u548c\u7528\u6237\u8d26\u53f7\u201caccount\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserGroup userGroup = ((UserGroupDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)userGroup)) {
            throw new RuntimeException("\u6839\u636e\u7fa4\u7ec4\u7f16\u7801\u3010" + code + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        User user = this.userManager.getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RuntimeException("\u6839\u636e\u7528\u6237\u8d26\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7528\u6237\uff01");
        }
        userGroup.setCreator(user.getId());
        this.update((Model)userGroup);
        return new CommonResult(true, "\u4fee\u6539\u7fa4\u7ec4\u7ba1\u7406\u5458\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserGroupDao)this.baseMapper).removePhysical();
    }
}

