/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.exception.SystemException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.security.MethodAuthService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.CacheEvictUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.PinyinUtil;
import com.hotent.base.util.RSAUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.model.Group;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.dao.DemensionDao;
import com.hotent.uc.dao.UserDao;
import com.hotent.uc.dao.UserParamsDao;
import com.hotent.uc.dto.UserOrgPostPolymerDto;
import com.hotent.uc.dto.UserSeletorDto;
import com.hotent.uc.exception.BaseException;
import com.hotent.uc.exception.HotentHttpStatus;
import com.hotent.uc.exception.NotFoundException;
import com.hotent.uc.exception.RequiredException;
import com.hotent.uc.manager.DemensionManager;
import com.hotent.uc.manager.OperateLogManager;
import com.hotent.uc.manager.OrgAuthManager;
import com.hotent.uc.manager.OrgJobManager;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.OrgParamsManager;
import com.hotent.uc.manager.OrgPostManager;
import com.hotent.uc.manager.OrgRoleManager;
import com.hotent.uc.manager.OrgUserManager;
import com.hotent.uc.manager.ParamsManager;
import com.hotent.uc.manager.PwdStrategyManager;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.TenantAuthManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.manager.UcOrgUniteManager;
import com.hotent.uc.manager.UserGroupManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserParamsManager;
import com.hotent.uc.manager.UserRelManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.manager.UserUniteManager;
import com.hotent.uc.model.Demension;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgJob;
import com.hotent.uc.model.OrgParams;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgRole;
import com.hotent.uc.model.OrgTree;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.Params;
import com.hotent.uc.model.PwdStrategy;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserGroup;
import com.hotent.uc.model.UserParams;
import com.hotent.uc.model.UserRel;
import com.hotent.uc.model.UserRole;
import com.hotent.uc.model.UserUnite;
import com.hotent.uc.model.UserVO;
import com.hotent.uc.params.common.DataSyncObject;
import com.hotent.uc.params.common.DataSyncVo;
import com.hotent.uc.params.common.OrgExportObject;
import com.hotent.uc.params.common.UserExportObject;
import com.hotent.uc.params.echarts.ChartLink;
import com.hotent.uc.params.echarts.ChartNode;
import com.hotent.uc.params.echarts.ChartOption;
import com.hotent.uc.params.group.GroupIdentity;
import com.hotent.uc.params.params.ParamObject;
import com.hotent.uc.params.user.TriggerVo;
import com.hotent.uc.params.user.UserMarkObject;
import com.hotent.uc.params.user.UserPolymer;
import com.hotent.uc.params.user.UserPolymerOrgPos;
import com.hotent.uc.params.user.UserPolymerParam;
import com.hotent.uc.params.user.UserPolymerRole;
import com.hotent.uc.params.user.UserPwdObject;
import com.hotent.uc.params.user.UserRelObject;
import com.hotent.uc.params.user.UserStatusVo;
import com.hotent.uc.params.user.UserVo;
import com.hotent.uc.params.user.WxUser;
import com.hotent.uc.util.ContextUtil;
import com.hotent.uc.util.OrgUtil;
import com.hotent.uc.util.UserPhotoFileFindVisitor;
import com.hotent.uc.vo.UserOrgPostPolymerVo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.functions.T;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import poi.util.ExcelUtil;

@Service
public class UserManagerImpl
extends BaseManagerImpl<UserDao, User>
implements UserManager {
    protected static Logger logger = LoggerFactory.getLogger(UserManagerImpl.class);
    protected static String IMPORT_NEW_SUFFIX = "_imp";
    @Autowired
    ResourceLoader resourceLoader;
    @Value(value="${system.attachment.path:''}")
    private String attachPath;
    @Autowired
    UserRoleManager userRoleManager;
    @Autowired
    OrgUserManager orgUserManager;
    @Autowired
    UserParamsDao userParamsDao;
    @Autowired
    OrgManager orgService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    OrgPostManager orgPostManager;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    UserParamsManager userParamsService;
    @Autowired
    UserGroupManager userGroupService;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    ParamsManager paramsService;
    @Autowired
    UserRelManager userRelService;
    @Autowired
    OrgManager orgManager;
    @Autowired
    DemensionManager demensionManager;
    @Autowired
    OrgJobManager orgJobManager;
    @Autowired
    RoleManager roleManager;
    @Autowired
    OperateLogManager operateLogService;
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    PortalFeignService portalFeignService;
    @Autowired
    JwtTokenHandler jwtTokenHandler;
    @Autowired
    UserDetailsService userDetailsService;
    @Autowired
    PwdStrategyManager pwdStrategyManager;
    @Autowired
    OrgParamsManager orgParamsService;
    @Autowired
    UserUniteManager userUniteManager;
    @Autowired
    UserDao userDao;
    @Autowired
    private UcOrgUniteManager ucOrgUniteManager;
    @Resource
    DemensionDao demensionDao;
    @Resource
    OrgRoleManager orgRoleManager;
    @Resource
    TenantManageManager tenantManageManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User addUser(UserVo user) throws Exception {
        if (StringUtil.isEmpty((String)user.getAccount())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getFullname())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u540d\u79f0\u3010fullname\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)user.getPassword())) {
            throw new RequiredException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u767b\u5f55\u5bc6\u7801\u3010password\u3011\u5fc5\u586b\uff01");
        }
        if (((UserDao)this.baseMapper).getCountByAccount(user.getAccount()) > 0) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5e10\u53f7\u3010" + user.getAccount() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        User u = this.getByNumber(user.getUserNumber());
        if (BeanUtils.isNotEmpty((Object)u)) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u5de5\u53f7\u3010" + user.getUserNumber() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        this.duplicateUserByMobile(user.getAccount(), user.getMobile());
        if (!this.checkEmail(user.getEmail()) && !StringUtil.isEmpty((String)user.getEmail())) {
            throw new RuntimeException("\u6dfb\u52a0\u7528\u6237\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
        }
        User newUser = (User)BeanUtil.copyProperties((Object)user, User.class, (String[])new String[0]);
        newUser.setStatus(1);
        newUser.setId(UniqueIdUtil.getSuid());
        newUser.setCreateTime(LocalDateTime.now());
        newUser.setFrom("restful");
        String password = user.getPassword();
        if (StringUtil.isEmpty((String)user.getPassword())) {
            password = this.pwdStrategyManager.getDefault().getInitPwd();
        }
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)password));
        newUser.setPwdCreateTime(LocalDateTime.now());
        int status = Optional.ofNullable(user.getStatus()).orElse(1);
        if (status != 1 && status != -1 && status != -2 && status != 0) {
            status = 1;
        }
        newUser.setStatus(status);
        this.create((Model)newUser);
        this.userRoleManager.addCommonRoleUser(newUser.getId());
        this.createOrgUser(user.getOrgId(), newUser.getId());
        return newUser;
    }

    private void createOrgUser(String orgId, String userId) {
        if (StringUtil.isEmpty((String)orgId)) {
            return;
        }
        Org org = (Org)this.orgManager.get((Serializable)((Object)orgId));
        Assert.notNull((Object)org, (String)("\u7ec4\u7ec7id\u4e3a" + orgId + "\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728"));
        this.orgManager.addOrgUser(orgId, userId, org.getDemId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUser(UserVo user) throws Exception {
        if (StringUtil.isEmpty((String)user.getAccount())) {
            throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
        }
        User u = this.getByAccount(user.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u6839\u636e\u3010" + user.getAccount() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        if (StringUtil.isNotEmpty((String)user.getUserNumber())) {
            if (!user.getUserNumber().equals(u.getUserNumber()) && BeanUtils.isEmpty((Object)this.getByNumber(user.getUserNumber()))) {
                u.setUserNumber(user.getUserNumber());
            } else if (!user.getUserNumber().equals(u.getUserNumber()) && BeanUtils.isNotEmpty((Object)this.getByNumber(user.getUserNumber()))) {
                throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u5de5\u53f7\u3010" + user.getUserNumber() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
        }
        this.duplicateUserByMobile(user.getAccount(), user.getMobile());
        if (StringUtil.isNotEmpty((String)user.getBirthday())) {
            u.setBirthday(DateFormatUtil.dateParse((String)user.getBirthday(), (String)"yyyy-MM-dd"));
        } else {
            u.setBirthday(null);
        }
        if (StringUtil.isNotEmpty((String)user.getEntryDate())) {
            u.setEntryDate(DateFormatUtil.dateParse((String)user.getEntryDate(), (String)"yyyy-MM-dd"));
        } else {
            u.setEntryDate(null);
        }
        u.setAddress(user.getAddress());
        if (StringUtil.isNotEmpty((String)user.getEmail())) {
            u.setEmail(user.getEmail().toLowerCase());
        } else {
            u.setEmail(user.getEmail());
        }
        if (StringUtil.isNotEmpty((String)user.getShowStatus())) {
            u.setShowStatus(user.getShowStatus());
        }
        u.setPhoto(user.getPhoto());
        u.setFullname(user.getFullname());
        u.setSex(user.getSex());
        u.setMobile(user.getMobile());
        u.setStatus(user.getStatus());
        u.setIdCard(user.getIdCard());
        u.setPhone(user.getPhone());
        u.setPhoto(user.getPhoto());
        u.setEducation(user.getEducation());
        u.setLeaveDate(user.getLeaveDate());
        u.setExpireDate(user.getExpireDate());
        this.update((Model)u);
        CacheEvictUtil.deleteUserDetailsCache((String)u.getAccount());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteUser(UserMarkObject userMark) {
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        if (StringUtil.isNotEmpty((String)userMark.getAccount())) {
            String[] accounts;
            for (String account : accounts = userMark.getAccount().split(",")) {
                User user = ((UserDao)this.baseMapper).getByAccount(account);
                if (BeanUtils.isNotEmpty((Object)user)) {
                    if (OrgUtil.checkUserGruopIsUserRel("user", user.getId())) {
                        msg.append("\u5e10\u53f7\u3010" + account + "\u3011\u7684\u7528\u6237\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                        continue;
                    }
                    this.remove((Serializable)((Object)user.getId()));
                    isTrue = true;
                    continue;
                }
                msg.append("\u5e10\u53f7\u3010" + account + "\u3011\u4e0d\u5b58\u5728\uff0c");
            }
        } else if (StringUtil.isNotEmpty((String)userMark.getUserNumber())) {
            String[] numbers;
            for (String number : numbers = userMark.getUserNumber().split(",")) {
                User user = ((UserDao)this.baseMapper).getByNumber(number);
                if (BeanUtils.isNotEmpty((Object)user)) {
                    if (OrgUtil.checkUserGruopIsUserRel("user", user.getId())) {
                        msg.append("\u5de5\u53f7\u3010" + number + "\u3011\u7684\u7528\u6237\u4e3a\u6c47\u62a5\u8282\u70b9\u4e0d\u80fd\u5220\u9664\uff0c");
                        continue;
                    }
                    this.remove((Serializable)((Object)user.getId()));
                    isTrue = true;
                    continue;
                }
                msg.append("\u5de5\u53f7\u3010" + number + "\u3011\u4e0d\u5b58\u5728\uff0c");
            }
        }
        if (StringUtil.isEmpty((String)userMark.getAccount()) && StringUtil.isEmpty((String)userMark.getUserNumber())) {
            isTrue = false;
            msg.append("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        return new CommonResult(isTrue, BeanUtils.isEmpty((Object)msg) ? "\u5220\u9664\u7528\u6237\u6210\u529f\uff01" : msg.toString(), (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteUserByIds(String ids) {
        String[] idArray = ids.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = true;
        for (String id : idArray) {
            User user = (User)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)user)) {
                if (user.isAdmin()) {
                    throw new RuntimeException("\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u80fd\u5220\u9664!");
                }
                this.remove((Serializable)((Object)user.getId()));
                this.orgUserManager.removeByUserId(id, LocalDateTime.now());
                this.userRoleManager.removeByUserId(id, LocalDateTime.now());
                this.userParamsDao.removeByUserId(id, LocalDateTime.now());
                TenantAuthManager tenantAuthManager = (TenantAuthManager)AppUtil.getBean(TenantAuthManager.class);
                tenantAuthManager.delByUserId(user.getUserId());
                continue;
            }
            isTrue = false;
            msg.append("\u5e10\u53f7\u3010" + id + "\u3011\u4e0d\u5b58\u5728\uff0c");
        }
        return new CommonResult(isTrue, BeanUtils.isEmpty((Object)msg) ? "\u5220\u9664\u7528\u6237\u6210\u529f\uff01" : msg.toString(), (Object)"");
    }

    @Override
    public UserVo getUser(String json) throws Exception {
        User user = this.getUserByJson(json);
        if (BeanUtils.isEmpty((Object)user)) {
            return null;
        }
        UserVo userVo = OrgUtil.convertToUserVo(user);
        List<UserParams> params = this.getUserParams(user.getAccount());
        if (BeanUtils.isNotEmpty(params)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (UserParams param : params) {
                map.put(param.getAlias(), param.getValue());
            }
            userVo.setParams(map);
        }
        return userVo;
    }

    @Override
    public User getByAccount(String account) {
        return ((UserDao)this.baseMapper).getByAccount(account);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User getByAccountAndTenant(String account, String tenantId) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)account), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)tenantId), (String)"\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            User user = (User)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(User::getAccount, (Object)account)).eq(User::getTenantId, (Object)tenantId));
            return user;
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u7528\u6237\u8d26\u53f7[%s][%s]\u5f02\u5e38\uff01", account, tenantId), (Throwable)e);
            return null;
        }
    }

    public User getByMobile(String mobile) {
        return ((UserDao)this.baseMapper).getByMobile(mobile);
    }

    @Override
    public List<User> queryOrgUser(QueryFilter queryFilter) {
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("u.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty(params.get("orgId"))) {
            queryFilter.addFilter("org.ID_", params.get("orgId"), QueryOP.EQUAL);
        }
        return ((UserDao)this.baseMapper).queryOrgUser((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<User> getUserListByOrgId(String orgId) {
        return ((UserDao)this.baseMapper).getUserListByOrgId(orgId);
    }

    @Override
    public List<User> getUserListByOrgIds(String orgIds) {
        if (BeanUtils.isEmpty((Object)orgIds)) {
            return new ArrayList<User>();
        }
        return ((UserDao)this.baseMapper).getUserListByOrgIds(Arrays.asList(orgIds.split(",")));
    }

    @Override
    public List queryOrgUserRel(QueryFilter queryFilter) {
        queryFilter.addFilter("orguser.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        queryFilter.addFilter("org.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        return ((UserDao)this.baseMapper).queryOrgUserRel((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<User> getListByPostCode(String postCode) {
        return ((UserDao)this.baseMapper).getListByPostCode(postCode);
    }

    @Override
    public List<User> getListByPostId(String postId) {
        return ((UserDao)this.baseMapper).getListByPostId(postId);
    }

    @Override
    public List<User> getUserListByRoleId(String roleId) {
        return ((UserDao)this.baseMapper).getUserListByRoleId(roleId);
    }

    @Override
    public List<User> getUserListByRoleIds(String roleIds) {
        if (BeanUtils.isEmpty((Object)roleIds)) {
            return new ArrayList<User>();
        }
        return ((UserDao)this.baseMapper).getUserListByRoleIds(Arrays.asList(roleIds.split(",")));
    }

    @Override
    public List<User> getUserListByRoleCode(String roleCode) {
        return ((UserDao)this.baseMapper).getUserListByRoleCode(roleCode);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        User user = ((UserDao)this.baseMapper).getByAccount("admin");
        for (String id : ids) {
            if (!id.equals(user.getUserId())) continue;
            ThreadMsgUtil.addMsg((String)(ids.length >= 2 ? "admin\u5e10\u53f7\u4e0d\u80fd\u5220\u9664,\u5176\u5b83\u7528\u6237\u5220\u9664\u6210\u529f\u3002" : "admin\u5e10\u53f7\u4e0d\u80fd\u5220\u9664"));
            break;
        }
        if (StringUtil.isEmpty((String)ThreadMsgUtil.getMessage((boolean)false))) {
            ThreadMsgUtil.addMsg((String)"\u7528\u6237\u5220\u9664\u6210\u529f\u3002");
        }
        super.removeByIds(ids);
        UserManagerImpl bean = (UserManagerImpl)AppUtil.getBean(this.getClass());
        for (String id : ids) {
            this.orgUserManager.removeByUserId(id, LocalDateTime.now());
            this.userRoleManager.removeByUserId(id, LocalDateTime.now());
            this.userParamsDao.removeByUserId(id, LocalDateTime.now());
            bean.delUserMenuCache(id);
        }
    }

    @CacheEvict(value={"eip:sys:userMenu"}, key="#userId")
    protected void delUserMenuCache(String userId) {
    }

    @Override
    public List<User> getByUserEmail(String email) {
        return ((UserDao)this.baseMapper).getByUserEmail(email);
    }

    public Org dealOrg(Org org, List<Org> orgList, String preCode, Map<String, String> orgMap) {
        Org rtn = null;
        if (BeanUtils.isEmpty(orgList)) {
            if (BeanUtils.isNotEmpty((Object)orgMap.get(org.getCode()))) {
                org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
            }
            orgList.add(org);
            orgMap.put(org.getCode(), org.getId());
            rtn = org;
        } else {
            Boolean flag = true;
            for (int i = 0; i < orgList.size(); ++i) {
                Org systemOrg;
                if (orgList.get(i).getPathName().equals(org.getPathName())) {
                    flag = false;
                    rtn = orgList.get(i);
                }
                if (orgList.get(i).getName().equals(org.getName()) && orgList.get(i) != org) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + (i + 1));
                }
                if (BeanUtils.isNotEmpty((Object)(systemOrg = this.orgService.getByCode(org.getCode())))) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + (i + 1) + (i + 1));
                }
                if (i != orgList.size() - 1 || !flag.booleanValue()) continue;
                if (BeanUtils.isNotEmpty((Object)orgMap.get(org.getCode()))) {
                    org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
                }
                orgList.add(org);
                orgMap.put(org.getCode(), org.getId());
                rtn = org;
            }
        }
        return rtn;
    }

    public Org dealOrgUnder(String supperPathName, String underPathName, List<Org> orgList, String demId, String preCode, Map<String, String> orgMap) {
        String underName = underPathName.substring(underPathName.lastIndexOf("/") + 1, underPathName.length());
        List<Org> chirList = this.orgService.getByPathName(underPathName);
        if (BeanUtils.isNotEmpty(chirList)) {
            for (Org org : chirList) {
                if (!demId.equals(org.getDemId())) continue;
                return org;
            }
        }
        List<Org> pList = this.orgService.getByPathName(supperPathName);
        ArrayList<Org> parentList = new ArrayList<Org>();
        for (Org org : pList) {
            if (!demId.equals(org.getDemId())) continue;
            parentList.add(org);
        }
        Org chird = new Org();
        if (BeanUtils.isEmpty(parentList)) {
            for (int i = 0; i < orgList.size(); ++i) {
                if (!orgList.get(i).getPathName().equals(supperPathName)) continue;
                chird.setId(UniqueIdUtil.getSuid());
                chird.setParentId(orgList.get(i).getId());
                chird.setDemId(demId);
                chird.setName(underName);
                chird.setPathName(underPathName);
                chird.setPath(orgList.get(i).getPath() + chird.getId() + ".");
                chird.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName));
            }
        } else {
            chird.setId(UniqueIdUtil.getSuid());
            chird.setParentId(((Org)parentList.get(0)).getId());
            chird.setDemId(demId);
            chird.setName(underName);
            chird.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName));
            chird.setPathName(underPathName);
            chird.setPath(((Org)parentList.get(0)).getPath() + chird.getId() + ".");
        }
        return this.dealOrg(chird, orgList, preCode, orgMap);
    }

    public List<OrgJob> dealOrgJob(String reldefNameStr, List<OrgJob> orgJobList, String preCode) {
        if (StringUtil.isEmpty((String)reldefNameStr)) {
            return null;
        }
        String[] reldefNames = reldefNameStr.split(";");
        ArrayList<OrgJob> rtn = new ArrayList<OrgJob>();
        for (String reldefName : reldefNames) {
            OrgJob reldef = null;
            List<OrgJob> selectList = this.orgJobService.getByName(reldefName);
            if (BeanUtils.isNotEmpty(selectList)) {
                reldef = selectList.get(0);
            } else {
                Boolean flag = true;
                reldef = new OrgJob();
                reldef.setId(UniqueIdUtil.getSuid());
                reldef.setCode(PinyinUtil.getPinYinHeadChar((String)reldefName));
                reldef.setName(reldefName);
                OrgJob sysOrgJob = this.orgJobService.getByCode(reldef.getCode());
                if (BeanUtils.isNotEmpty((Object)sysOrgJob)) {
                    reldef.setCode(reldef.getCode() + reldef.getId());
                }
                if (BeanUtils.isEmpty(orgJobList)) {
                    orgJobList.add(reldef);
                } else {
                    for (int i = 0; i < orgJobList.size(); ++i) {
                        if (orgJobList.get(i).getName().equals(reldefName)) {
                            flag = false;
                            reldef = orgJobList.get(i);
                        }
                        if (i != orgJobList.size() - 1 || !flag.booleanValue()) continue;
                        orgJobList.add(reldef);
                    }
                }
            }
            if (!BeanUtils.isNotEmpty((Object)reldef)) continue;
            rtn.add(reldef);
        }
        return rtn;
    }

    public User dealUser(User user, List<User> userList) throws Exception {
        User rtn = new User();
        if (StringUtil.isNotEmpty((String)user.getId())) {
            rtn = user;
        } else {
            Boolean flag = true;
            if (BeanUtils.isEmpty(userList)) {
                user.setId(UniqueIdUtil.getSuid());
                rtn = user;
                userList.add(user);
            } else {
                for (int i = 0; i < userList.size(); ++i) {
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) != user) {
                        logger.error("Excel\u8868\u683c\u4e2d\u7528\u6237\u5e10\u53f7\u91cd\u590d\uff1a" + userList.get(i).getAccount());
                    }
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) == user) {
                        flag = false;
                        rtn = userList.get(i);
                    }
                    if (i != userList.size() - 1 || !flag.booleanValue()) continue;
                    user.setId(UniqueIdUtil.getSuid());
                    rtn = user;
                    userList.add(user);
                }
            }
        }
        return rtn;
    }

    public void dealUserOrgPost(User user, Org org, List<OrgPost> orgPosts, List<OrgUser> orgUserList, List<OrgPost> orgPostList, Map<String, String> orgPostAddMap, String isMaster, String isCharge, Map<String, String> isMasterMap, String demId) {
        if (BeanUtils.isEmpty((Object)org)) {
            return;
        }
        if (BeanUtils.isNotEmpty(orgPosts)) {
            for (OrgPost orgPost : orgPosts) {
                OrgUser orgUser = new OrgUser();
                if (StringUtil.isNotEmpty((String)orgPostAddMap.get(orgPost.getId()))) {
                    Boolean flag = true;
                    if (BeanUtils.isEmpty(orgPostList)) {
                        orgPost.setCode(org.getCode() + "_" + orgPost.getCode());
                        orgPostList.add(orgPost);
                    } else {
                        for (int i = 0; i < orgPostList.size(); ++i) {
                            if (orgPostList.get(i).getOrgId().equals(orgPost.getOrgId()) && orgPostList.get(i).getName().equals(orgPost.getName())) {
                                orgPost = orgPostList.get(i);
                                flag = false;
                            }
                            if (!flag.booleanValue() || i != orgPostList.size() - 1) continue;
                            orgPost.setCode(org.getCode() + "_" + orgPost.getCode());
                            orgPostList.add(orgPost);
                        }
                    }
                }
                QueryFilter filter = QueryFilter.build();
                filter.addFilter("orgId", (Object)orgPost.getOrgId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("relId", (Object)orgPost.getId(), QueryOP.EQUAL, FieldRelation.AND);
                PageList pageList = this.orgUserService.query(filter);
                if (!BeanUtils.isEmpty((Object)pageList.getRows())) continue;
                orgUser.setId(UniqueIdUtil.getSuid());
                orgUser.setOrgId(orgPost.getOrgId());
                orgUser.setRelId(orgPost.getId());
                orgUser.setUserId(user.getId());
                this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
                orgUserList.add(orgUser);
            }
        } else {
            OrgUser orgUser = new OrgUser();
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
            PageList pageList = this.orgUserService.query(filter);
            if (BeanUtils.isEmpty((Object)pageList.getRows())) {
                orgUser.setId(UniqueIdUtil.getSuid());
                orgUser.setOrgId(org.getId());
                orgUser.setUserId(user.getId());
                this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
                orgUserList.add(orgUser);
            }
        }
    }

    private void dealMasterAndCharge(String isMaster, String isCharge, OrgUser orgUser, Map<String, String> isMasterMap, String demId) {
        if (StringUtil.isNotEmpty((String)isMaster) && (isMaster.equals("1") || isMaster.equals("\u662f")) && this.hasMaster(orgUser.getUserId(), orgUser.getOrgId(), demId) && StringUtil.isEmpty((String)isMasterMap.get(orgUser.getUserId() + "_" + demId))) {
            orgUser.setIsMaster(1);
            isMasterMap.put(orgUser.getUserId() + "_" + demId, "1");
        } else {
            orgUser.setIsMaster(0);
        }
        if (StringUtil.isNotEmpty((String)isCharge)) {
            if (isCharge.equals("1")) {
                orgUser.setIsCharge(1);
            } else if (isCharge.equals("2") && BeanUtils.isEmpty((Object)this.orgUserManager.getChargesByOrgId(orgUser.getOrgId(), 2))) {
                orgUser.setIsCharge(2);
            }
        } else {
            orgUser.setIsCharge(0);
        }
    }

    private boolean hasMaster(String userId, String orgId, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgUser> orgUsers = this.orgUserManager.getByParms(map);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            for (OrgUser orgUser : orgUsers) {
                Org org;
                if (orgUser.getOrgId().equals(orgId) || orgUser.getIsMaster() != 1 || !BeanUtils.isNotEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId())))) || !org.getDemId().equals(demId)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<User> getUpUsersByUserId(String underUserId) {
        return ((UserDao)this.baseMapper).getUpUsersByUserId(underUserId);
    }

    @Override
    public User getUpUserByUserIdAndOrgId(String account, String orgCode) {
        User u = this.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        Org o = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        return ((UserDao)this.baseMapper).getUpUserByUserIdAndOrgId(u.getId(), o.getId());
    }

    @Override
    public List<User> getUnderUsersByUserId(String upUserId) {
        return ((UserDao)this.baseMapper).getUnderUsersByUserId(upUserId);
    }

    @Override
    public List<User> getUnderUserByUserIdAndOrgId(String account, String orgCode) {
        User u = this.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        Org o = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("upUserId", u.getId());
        map.put("orgId", o.getId());
        return ((UserDao)this.baseMapper).getUnderUserByUserIdAndOrgId(u.getId(), o.getId());
    }

    @Override
    public List<User> getListByJobId(String jobId) {
        OrgJob orgJob;
        ArrayList<User> list = new ArrayList<User>();
        List<OrgPost> orgPost = this.orgPostManager.getByReldefId(jobId);
        if (BeanUtils.isNotEmpty(orgPost)) {
            for (OrgPost rel : orgPost) {
                List<User> positionUser = this.getListByPostId(rel.getId());
                if (!BeanUtils.isNotEmpty(positionUser)) continue;
                list.addAll(positionUser);
            }
        }
        if ((orgJob = (OrgJob)this.orgJobManager.getById((Serializable)((Object)jobId))) != null) {
            List<User> userByJobCode = ((UserDao)this.baseMapper).getUserByJobCodeAndOrgId(orgJob.getCode(), null);
            CollectionUtil.addAll(list, userByJobCode);
        }
        BeanUtils.removeDuplicate(list);
        return list;
    }

    @Override
    public List<User> getListByJobIds(String jobIds) {
        ArrayList<User> list = new ArrayList<User>();
        List<OrgPost> orgPost = this.orgPostManager.getByReldefIds(jobIds);
        if (BeanUtils.isEmpty(orgPost)) {
            return list;
        }
        List postIds = orgPost.stream().map(OrgPost::getId).collect(Collectors.toList());
        if (BeanUtils.isEmpty(postIds)) {
            return list;
        }
        return this.getUserByPostIds(String.join((CharSequence)",", postIds));
    }

    @Override
    public User getByNumber(String userNumber) {
        return ((UserDao)this.baseMapper).getByNumber(userNumber);
    }

    @Override
    @Transactional
    @CacheEvict(value={"eip:uc:userAccount"}, allEntries=true)
    public CommonResult<String> changUserPsd(UserPwdObject userPwdObject) throws Exception {
        if (StringUtil.isEmpty((String)userPwdObject.getAccount()) && StringUtil.isEmpty((String)userPwdObject.getUserNumber())) {
            throw new RuntimeException(I18nUtil.handleI18nMessage((String)"account.no.job.no.cannot.empty", (String)"\u5e10\u53f7\u548c\u5de5\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01"));
        }
        User user = this.getUserByObject(userPwdObject);
        String oldPwd = userPwdObject.getOldPwd();
        String newPwd = userPwdObject.getNewPwd();
        if (user.getStatus() != 1) {
            String stateStr;
            String string = user.getStatus() == 0 || user.getStatus() == -1 ? (user.getStatus() == 0 ? "\u7528\u6237\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u5bc6\u7801\uff01" : "\u7528\u6237\u672a\u6fc0\u6d3b\uff0c\u4e0d\u80fd\u4fee\u6539\u5bc6\u7801\uff01") : (stateStr = "\u7528\u6237\u5df2\u88ab\u79bb\u804c\uff0c\u4e0d\u80fd\u4fee\u6539\u5bc6\u7801\uff01");
            String i18nKey = user.getStatus() == 0 || user.getStatus() == -1 ? (user.getStatus() == 0 ? "user.has.disabled.cannot.changed.password" : "user.not.activated.cannot.changed.password") : "user.has.resigned.cannot.changed.password";
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)i18nKey, (String)stateStr), (Object)"");
        }
        if (StringUtil.isEmpty((String)oldPwd)) {
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)"user.old.password.cannot.empty", (String)"\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object)"");
        }
        if (StringUtil.isEmpty((String)newPwd)) {
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)"user.new.password.cannot.empty", (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object)"");
        }
        if (newPwd.equals(oldPwd)) {
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)"user.new.pwd.cannot.same.as.old.pwd", (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u65e7\u5bc6\u7801\u4e00\u6837\uff01"), (Object)"");
        }
        PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
        if (BeanUtils.isNotEmpty((Object)((Object)pwdStrategy))) {
            short pwdRule = pwdStrategy.getPwdRule();
            short pwdLength = pwdStrategy.getPwdLength();
            short enable = pwdStrategy.getEnable();
            if (enable == 1) {
                String regex;
                boolean result;
                if (newPwd.length() < pwdLength) {
                    return new CommonResult(false, I18nUtil.getI18nFormat((String)"new.pwd.length.cannot.less.then.value", (String)"\u65b0\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e%s", (Object[])new Object[]{(int)pwdLength}), (Object)"");
                }
                if (pwdRule == 2) {
                    String regex2 = "^(?![a-zA-z]+$)(?!\\d+$)(?![!@#$%^&*]+$)[a-zA-Z\\d!@#$%^&*]+$";
                    boolean result2 = newPwd.matches(regex2);
                    if (!result2) {
                        return new CommonResult(false, I18nUtil.handleI18nMessage((String)"new.pwd.must.contain.num.letters", (String)"\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\uff01"), (Object)"");
                    }
                } else if (pwdRule == 3) {
                    String regex3 = "^(?=.*?[A-Za-z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$";
                    boolean result3 = newPwd.matches(regex3);
                    if (!result3) {
                        return new CommonResult(false, I18nUtil.handleI18nMessage((String)"new.pwd.must.contain.num.letters.chars", (String)"\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\uff01"), (Object)"");
                    }
                } else if (pwdRule == 4 && !(result = newPwd.matches(regex = "^(?=.*?[a-z])(?=.*?[A-Z])(?=.*?\\d)(?=.*?[~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/])[a-zA-Z\\d~!@#$%^&*()_+`\\-={}:\";'<>?,.\\/]*$"))) {
                    return new CommonResult(false, I18nUtil.handleI18nMessage((String)"new.pwd.must.contain.num.large.small.letters.chars", (String)"\u65b0\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u6570\u5b57\u3001\u5927\u5c0f\u5b57\u6bcd\u3001\u7279\u6b8a\u5b57\u7b26\uff01"), (Object)"");
                }
            }
        }
        String oldPswdEncrypt = this.passwordEncoder.encode((CharSequence)oldPwd);
        if (user.getPassword().equals(oldPswdEncrypt)) {
            user.setPassword(this.passwordEncoder.encode((CharSequence)newPwd));
            user.setPwdCreateTime(LocalDateTime.now());
            this.update((Model)user);
            return new CommonResult(true, I18nUtil.handleI18nMessage((String)"new.pwd.change.succeeded", (String)"\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01"), (Object)"");
        }
        return new CommonResult(false, I18nUtil.handleI18nMessage((String)"new.pwd.change.failed.old.pwd.wrong", (String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u66f4\u65b0\u5bc6\u7801\u5931\u8d25\uff01"), (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateUserPsw(UserPwdObject userPwdObject) throws Exception {
        Set collect;
        if (StringUtil.isEmpty((String)userPwdObject.getAccount()) && StringUtil.isEmpty((String)userPwdObject.getUserNumber())) {
            return new CommonResult(false, "\u5e10\u53f7\u548c\u5de5\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (BeanUtils.isEmpty((Object)userPwdObject) || StringUtil.isEmpty((String)userPwdObject.getNewPwd())) {
            return new CommonResult(false, "\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)"");
        }
        if (userPwdObject.getNewPwd().trim().length() < 6) {
            return new CommonResult(false, "\u5bc6\u7801\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e6\u4f4d\uff01", (Object)"");
        }
        String userMarks = userPwdObject.getAccount();
        int type = 1;
        if (StringUtil.isEmpty((String)userMarks) && StringUtil.isNotEmpty((String)userPwdObject.getUserNumber())) {
            userMarks = userPwdObject.getUserNumber();
            type = 2;
        }
        List<User> users = this.getUserByType(userMarks, type);
        User currentUser = ContextUtil.getCurrentUser();
        if (!(currentUser.isAdmin() || (collect = users.stream().map(User::getAccount).collect(Collectors.toSet())).size() <= 1 && collect.contains(currentUser.getAccount()) || this.checkUpdatePasswordAuth())) {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u4fee\u6539\u5bc6\u7801\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Object)"");
        }
        if (BeanUtils.isNotEmpty(users)) {
            for (User user : users) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)userPwdObject.getNewPwd()));
                user.setPwdCreateTime(LocalDateTime.now());
                this.update((Model)user);
            }
            return new CommonResult(true, "\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u672a\u66f4\u65b0\u4efb\u4f55\u7528\u6237\u7684\u5bc6\u7801\uff08\u672a\u627e\u5230\u5bf9\u5e94\u7528\u6237\uff09\uff01", (Object)"");
    }

    private boolean checkUpdatePasswordAuth() {
        MethodAuthService methodAuthService = (MethodAuthService)AppUtil.getBean(MethodAuthService.class);
        List methodAuth = methodAuthService.getMethodAuth();
        Set roles = methodAuth.stream().filter(map -> "/api/user/v1/user/updateUserPsw".equals(map.get("methodRequestUrl"))).map(map -> (String)map.get("roleAlias")).collect(Collectors.toSet());
        if (BeanUtils.isEmpty(roles)) {
            return false;
        }
        Collection<? extends GrantedAuthority> authorities = ContextUtil.getCurrentUser().getAuthorities();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!roles.contains(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkCurUserPsd(UserPwdObject userPwdObject) throws Exception {
        userPwdObject.setAccount(ContextUtil.getCurrentUser().getAccount());
        userPwdObject.setOldPwd(RSAUtil.Decrypt((String)userPwdObject.getOldPwd()));
        User user = this.getUserByObject(userPwdObject);
        if (user == null || StringUtil.isEmpty((String)user.getPassword()) || StringUtil.isEmpty((String)userPwdObject.getOldPwd())) {
            return false;
        }
        return user.getPassword().equals(this.passwordEncoder.encode((CharSequence)userPwdObject.getOldPwd()));
    }

    @Override
    public List<User> getUserByAccounts(String accounts) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("account_", (Object)accounts, QueryOP.IN);
        List users = super.queryNoPage(queryFilter);
        return users;
    }

    @Override
    public List<User> getChargeOrgUsers(String userId) {
        List orgPosts;
        List postId;
        List<User> chargeOrgUsers = ((UserDao)this.baseMapper).getChargeOrgUsers(userId);
        if (BeanUtils.isNotEmpty(chargeOrgUsers) && BeanUtils.isNotEmpty(postId = chargeOrgUsers.stream().map(User::getPostId).collect(Collectors.toList())) && BeanUtils.isNotEmpty((Object)(orgPosts = this.orgPostManager.listByIds(postId)))) {
            Map<String, String> orgPostMap = orgPosts.stream().collect(Collectors.toMap(OrgPost::getId, OrgPost::getName));
            for (User chargeOrgUser : chargeOrgUsers) {
                if (!orgPostMap.containsKey(chargeOrgUser.getPostId())) continue;
                chargeOrgUser.setPostName(orgPostMap.get(chargeOrgUser.getPostId()));
            }
        }
        return chargeOrgUsers;
    }

    @Override
    @Transactional
    public CommonResult<String> updateOneselfPsw(UserPwdObject userPwdObject) throws Exception {
        return new CommonResult(true, "\u66f4\u65b0\u5bc6\u7801\u6210\u529f\uff01", (Object)"");
    }

    private User getUserByJson(String json) throws IOException {
        ObjectNode markJson = (ObjectNode)JsonUtil.toJsonNode((String)json);
        if (BeanUtils.isEmpty((Object)markJson)) {
            throw new RequiredException("\u7528\u6237ID\u3001\u7528\u6237\u5e10\u53f7\u3001\u7528\u6237\u5de5\u53f7\u5fc5\u586b\u5176\u4e2d\u4e00\u4e2a\uff01");
        }
        UserMarkObject userMark = (UserMarkObject)JsonUtil.toBean((JsonNode)markJson, UserMarkObject.class);
        return this.getUserByObject(userMark);
    }

    private PageList<UserVo> convertRestPageList(PageList<User> pageList) {
        PageList voPageList = new PageList();
        voPageList.setPage(pageList.getPage());
        voPageList.setPageSize(pageList.getPageSize());
        voPageList.setTotal(pageList.getTotal());
        voPageList.setRows(OrgUtil.convertToUserVoList(pageList.getRows()));
        return voPageList;
    }

    private User getUserByObject(Object obj) throws IOException {
        User user = null;
        if (BeanUtils.isNotEmpty((Object)obj)) {
            String key = "";
            ObjectNode json = (ObjectNode)JsonUtil.toJsonNode((Object)obj);
            if (json.findValue("account") != null && StringUtil.isNotEmpty((String)json.get("account").asText())) {
                user = this.getByAccount(json.get("account").asText());
                key = json.get("account").asText();
            } else if (json.findValue("userNumber") != null && StringUtil.isNotEmpty((String)json.get("userNumber").asText())) {
                user = this.getByNumber(json.get("userNumber").asText());
                key = json.get("userNumber").asText();
            } else if (json.findValue("userId") != null && StringUtil.isNotEmpty((String)json.get("userId").asText())) {
                user = (User)this.get((Serializable)((Object)json.get("userId").asText()));
                key = json.get("userId").asText();
            }
            if (BeanUtils.isEmpty(user)) {
                return null;
            }
        }
        return user;
    }

    private List<User> getUserByType(String userMarks, int type) {
        ArrayList<User> list;
        block3: {
            String[] strArray;
            block5: {
                block4: {
                    list = new ArrayList<User>();
                    if (!StringUtil.isNotEmpty((String)userMarks)) break block3;
                    strArray = userMarks.split(",");
                    if (type != 1) break block4;
                    for (String str : strArray) {
                        User user = this.getByAccount(str);
                        if (!BeanUtils.isNotEmpty((Object)user)) continue;
                        list.add(user);
                    }
                    break block3;
                }
                if (type != 2) break block5;
                for (String str : strArray) {
                    User user = this.getByNumber(str);
                    if (!BeanUtils.isNotEmpty((Object)user)) continue;
                    list.add(user);
                }
                break block3;
            }
            if (type != 3) break block3;
            for (String str : strArray) {
                User user = (User)this.get((Serializable)((Object)str));
                if (!BeanUtils.isNotEmpty((Object)user)) continue;
                list.add(user);
            }
        }
        return list;
    }

    private String getUserId(String value, int type) {
        String userId = "";
        User user = null;
        if (type == 1) {
            user = this.getByAccount(value);
        } else if (type == 2) {
            user = this.getByNumber(value);
        }
        if (BeanUtils.isNotEmpty((Object)user)) {
            userId = user.getId();
        }
        return userId;
    }

    private String getDemId(UserRelObject userRelObject) {
        String demId = "";
        if (StringUtil.isNotEmpty((String)userRelObject.getDemCode())) {
            Demension demension = this.demensionService.getByCode(userRelObject.getDemCode());
            if (BeanUtils.isNotEmpty((Object)demension)) {
                demId = demension.getId();
            } else {
                throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + userRelObject.getDemCode() + "\u3011\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff01");
            }
        }
        return demId;
    }

    private List<User> getChargesByOrgId(String orgId, Boolean isMain) {
        ArrayList<User> list = new ArrayList<User>();
        List<OrgPost> orgPost = this.orgPostService.getRelCharge(orgId, true);
        if (BeanUtils.isNotEmpty(orgPost)) {
            List<User> users = ((UserDao)this.baseMapper).getListByPostId(orgPost.get(0).getId());
            list.addAll(users);
        } else {
            List<OrgUser> orgUsers = this.orgUserService.getChargesByOrgId(orgId, isMain);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                for (OrgUser orgUser : orgUsers) {
                    User user = (User)this.get((Serializable)((Object)orgUser.getUserId()));
                    list.add(user);
                }
            }
        }
        return list;
    }

    private List<Org> getUserOrgs(UserRelObject userRelObject) throws IOException {
        if (StringUtil.isEmpty((String)userRelObject.getAccount()) && StringUtil.isEmpty((String)userRelObject.getUserNumber())) {
            throw new RuntimeException("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        ArrayList<Org> orgs = new ArrayList();
        User user = this.getUserByObject(userRelObject);
        String demId = this.getDemId(userRelObject);
        if (StringUtil.isNotEmpty((String)demId)) {
            Org org = this.orgService.getMainGroup(user.getId(), demId);
            if (BeanUtils.isNotEmpty((Object)org)) {
                orgs.add(org);
            }
        } else {
            orgs = this.orgService.getMainOrgListByUser(user.getId(), null);
        }
        return orgs;
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserParams(String account, List<ParamObject> params) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException("\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            StringBuilder pcodes = new StringBuilder();
            User user = this.getByAccount(account);
            boolean isTrue = false;
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
            }
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            if (BeanUtils.isNotEmpty(params)) {
                for (ParamObject paramObject : params) {
                    Params param = this.paramsService.getByAlias(paramObject.getAlias());
                    if (BeanUtils.isNotEmpty((Object)param) && "1".equals(param.getType())) {
                        list.add((ObjectNode)JsonUtil.toJsonNode((String)paramObject.toString()));
                        isTrue = true;
                        continue;
                    }
                    pcodes.append(paramObject.getAlias() + "\uff0c");
                }
            }
            if (BeanUtils.isNotEmpty(list)) {
                this.userParamsService.saveParams(user.getId(), list);
                return new CommonResult(true, isTrue && StringUtil.isEmpty((String)pcodes.toString()) ? "\u4fdd\u5b58\u6210\u529f" : "\u90e8\u5206\u4fdd\u5b58\u6210\u529f\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01", (Object)"");
            }
            throw new RuntimeException("\u672a\u4fdd\u5b58\u4efb\u4f55\u53c2\u6570\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.indexOf("ORA-12899") > -1) {
                msg = "\u53c2\u6570\u503c\u8fc7\u957f";
            }
            throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c" + msg);
        }
    }

    @Override
    public List<UserParams> getUserParams(String account) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException("\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userId = this.getUserId(account, 1);
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return this.userParamsService.getByUserId(userId);
    }

    @Override
    public UserParams getParamByCode(String account, String code) throws Exception {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)code)) {
            throw new RuntimeException("\u5e10\u53f7\u548c\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String userId = this.getUserId(account, 1);
        if (StringUtil.isEmpty((String)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return this.userParamsService.getByUserIdAndAlias(userId, code);
    }

    @Override
    public CommonResult<Org> getMainOrgByDemCode(UserRelObject userRelObject) throws Exception {
        User user = this.getUserByObject(userRelObject);
        String demCode = userRelObject.getDemCode();
        if (StringUtil.isEmpty((String)demCode)) {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u7ef4\u5ea6\u7f16\u7801\uff01", null);
        }
        Demension demension = this.demensionService.getByCode(demCode);
        if (BeanUtils.isEmpty((Object)demension)) {
            return new CommonResult(false, "\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u3010" + demCode + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\uff01", null);
        }
        Org org = this.orgService.getMainGroup(user.getUserId(), demension.getId());
        boolean isTrue = BeanUtils.isNotEmpty((Object)org);
        String msg = isTrue ? "\u6210\u529f\u83b7\u53d6\u7528\u6237\u4e3b\u7ec4\u7ec7\uff01" : "\u7528\u6237\u5728\u3010" + demension.getDemName() + "\u3011\u7ef4\u5ea6\u4e0b\u672a\u8bbe\u7f6e\u4e3b\u7ec4\u7ec7\uff01";
        return new CommonResult(isTrue, msg, (Object)org);
    }

    @Override
    public List<OrgPost> getUserPosts(UserRelObject userRelObject) throws Exception {
        List<OrgPost> list;
        User user = this.getUserByObject(userRelObject);
        String demId = "";
        if (StringUtil.isNotEmpty((String)userRelObject.getDemCode())) {
            Demension demension = this.demensionService.getByCode(userRelObject.getDemCode());
            if (BeanUtils.isNotEmpty((Object)demension)) {
                demId = demension.getId();
            } else {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
            }
        }
        if (BeanUtils.isNotEmpty(list = this.orgPostService.getListByUserId(user.getId(), demId)) && BeanUtils.isNotEmpty((Object)userRelObject.getIsMain()) && userRelObject.getIsMain().booleanValue()) {
            ArrayList<OrgPost> list2 = new ArrayList<OrgPost>();
            list2.addAll(list);
            for (OrgPost orgPost : list2) {
                if (!BeanUtils.isNotEmpty((Object)orgPost.getIsCharge()) || 1 == orgPost.getIsCharge()) continue;
                list.remove(orgPost);
            }
        }
        return list;
    }

    @Override
    public Set<GroupIdentity> getImmeSuperior(UserRelObject userRelObject) throws Exception {
        HashSet<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<Org> orgs = this.getUserOrgs(userRelObject);
        for (Org org : orgs) {
            String orgId = org.getParentId();
            if (!StringUtil.isNotEmpty((String)orgId)) continue;
            identitys.addAll(OrgUtil.convertToGroupIdentity(this.getChargesByOrgId(orgId, BeanUtils.isEmpty((Object)userRelObject.getIsMain()) ? false : userRelObject.getIsMain())));
        }
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getImmeUnders(UserRelObject userRelObject) throws Exception {
        HashSet<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<Org> orgs = this.getUserOrgs(userRelObject);
        QueryFilter queryFilter = QueryFilter.build();
        StringBuilder orgIds = new StringBuilder();
        boolean isFirst = true;
        for (Org org : orgs) {
            if (isFirst) {
                isFirst = false;
            } else {
                orgIds.append(",");
            }
            orgIds.append(org.getId());
        }
        if (StringUtil.isEmpty((String)orgIds.toString())) {
            return identitys;
        }
        queryFilter.addFilter("parentId", (Object)orgIds.toString(), QueryOP.IN, FieldRelation.AND);
        List chirldOrgs = this.orgService.query(queryFilter).getRows();
        for (Org org : chirldOrgs) {
            identitys.addAll(OrgUtil.convertToGroupIdentity(this.getUserListByOrgId(org.getId())));
        }
        return identitys;
    }

    @Override
    public List<OrgJob> getUserJobs(String json) throws Exception {
        User user = this.getUserByJson(json);
        return this.orgJobService.getListByUserId(user.getId());
    }

    @Override
    public List<UserGroup> getUserGroups(String json) throws Exception {
        User user = this.getUserByJson(json);
        return this.userGroupService.getByUserId(user.getUserId());
    }

    @Override
    public List<UserVo> getNewUsersFromAD(String dateStr) throws Exception {
        if (StringUtil.isEmpty((String)dateStr)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1adate\u65f6\u95f4\u5fc5\u586b\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("from", (Object)"AD", QueryOP.EQUAL, FieldRelation.AND);
        if (StringUtil.isNotEmpty((String)dateStr)) {
            dateStr = dateStr.trim().length() == 10 ? dateStr + " 00:00:00" : dateStr;
            LocalDateTime date = DateFormatUtil.parse((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
            queryFilter.addFilter("createTime", (Object)date, QueryOP.GREAT_EQUAL, FieldRelation.AND);
        }
        List list = this.query(queryFilter).getRows();
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public Set<GroupIdentity> getByRoleCodeAndOrgCode(String roleCode, String orgCode) throws Exception {
        Role role = this.roleService.getByAlias(roleCode);
        if (BeanUtils.isEmpty((Object)role)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + roleCode + "\u3011\u7684\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        Set<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<User> users = ((UserDao)this.baseMapper).getByOrgIdAndRoleId(org.getId(), role.getId());
        if (BeanUtils.isNotEmpty(users)) {
            identitys = OrgUtil.convertToGroupIdentity(users);
        }
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getByJobCodeAndOrgCode(String jobCode, String orgCode) throws Exception {
        OrgJob job = this.orgJobService.getByCode(jobCode);
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + jobCode + "\u3011\u7684\u804c\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        HashSet<GroupIdentity> identitys = new HashSet();
        List<User> users = ((UserDao)this.baseMapper).getByJobCodeAndOrgCode(orgCode, jobCode);
        List<User> userByJobCode = ((UserDao)this.baseMapper).getUserByJobCodeAndOrgId(jobCode, org.getId());
        CollectionUtil.addAll(users, userByJobCode);
        BeanUtils.removeDuplicate(users);
        identitys = OrgUtil.convertToGroupIdentity(users);
        return identitys;
    }

    @Override
    public Set<GroupIdentity> getByPostCodeAndOrgCode(String postCode, String orgCode) throws Exception {
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + postCode + "\u3011\u7684\u5c97\u4f4d\u4e0d\u5b58\u5728\uff01");
        }
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u7f16\u7801\u4e3a\u3010" + orgCode + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
        }
        Set<GroupIdentity> identitys = new HashSet<GroupIdentity>();
        List<OrgUser> orgUsers = this.orgUserManager.getByPostCodeAndOrgCode(orgCode, postCode);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            ArrayList<User> list = new ArrayList<User>();
            for (OrgUser orgUser : orgUsers) {
                User user = (User)this.get((Serializable)((Object)orgUser.getUserId()));
                if (!BeanUtils.isNotEmpty((Object)user)) continue;
                list.add(user);
            }
            identitys = OrgUtil.convertToGroupIdentity(list);
        }
        return identitys;
    }

    @Override
    public List<UserVo> getUpUsersByUser(String account) throws Exception {
        String userId = this.getUserId(account, 1);
        if (BeanUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return OrgUtil.convertToUserVoList(this.getUpUsersByUserId(userId));
    }

    @Override
    public UserVo getUpUserByUserAndOrg(String account, String orgCode) throws Exception {
        return OrgUtil.convertToUserVo(this.getUpUserByUserIdAndOrgId(account, orgCode));
    }

    @Override
    public List<UserVo> getUnderUsersByUser(String account) throws Exception {
        String userId = this.getUserId(account, 1);
        if (BeanUtils.isEmpty((Object)userId)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        return OrgUtil.convertToUserVoList(this.getUnderUsersByUserId(userId));
    }

    @Override
    public List<UserVo> getUnderUserByUserAndOrg(String account, String orgCode) throws Exception {
        return OrgUtil.convertToUserVoList(this.getUnderUserByUserIdAndOrgId(account, orgCode));
    }

    @Override
    public List<User> getOrgUsers(String orgId, Boolean isMain) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)isMain)) {
            if (isMain.booleanValue()) {
                params.put("isMain", "1");
            } else {
                params.put("isMain", "0");
            }
        }
        params.put("orgId", orgId);
        return ((UserDao)this.baseMapper).getOrgUsers(params);
    }

    @Override
    @Transactional
    public void updatePhoto(String account, String photo) throws Exception {
        User user = ((UserDao)this.baseMapper).getByAccount(account);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RuntimeException("\u6ca1\u627e\u5230\u5e10\u53f7\u4e3a\u3010" + account + "\u3011\u7684\u7528\u6237\uff01");
        }
        user.setPhoto(photo);
        this.update((Model)user);
    }

    @Override
    public CommonResult<String> forbiddenUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, 0);
    }

    @Override
    public CommonResult<String> activateUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, 1);
    }

    @Override
    public CommonResult<String> leaveUser(UserMarkObject userMark) throws Exception {
        return this.toDealUserState(userMark, -2);
    }

    private CommonResult<String> toDealUserState(UserMarkObject userMark, int state) throws SQLException {
        String successMsg;
        String dmsg;
        User user;
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        if (StringUtil.isNotEmpty((String)userMark.getAccount())) {
            String[] accounts;
            for (String account : accounts = userMark.getAccount().split(",")) {
                user = ((UserDao)this.baseMapper).getByAccount(account);
                if (BeanUtils.isNotEmpty((Object)user) && user.getStatus() != state) {
                    this.dealUserState(user, state);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (state == 1 || state == 0 ? (state == 1 ? "\u5df2\u6fc0\u6d3b" : "\u5df2\u88ab\u7981\u7528") : "\u5df2\u88ab\u79bb\u804c");
                msg.append("\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011" + dmsg + "\uff0c");
            }
        }
        if (StringUtil.isNotEmpty((String)userMark.getUserNumber())) {
            String[] numbers;
            for (String number : numbers = userMark.getUserNumber().split(",")) {
                user = ((UserDao)this.baseMapper).getByNumber(number);
                if (BeanUtils.isNotEmpty((Object)user) && user.getStatus() != state) {
                    this.dealUserState(user, state);
                    isTrue = true;
                    continue;
                }
                dmsg = BeanUtils.isEmpty((Object)user) ? "\u4e0d\u5b58\u5728" : (state == 1 || state == 0 ? (state == 1 ? "\u5df2\u6fc0\u6d3b" : "\u5df2\u88ab\u7981\u7528") : "\u5df2\u88ab\u79bb\u804c");
                msg.append("\u7528\u6237\u5de5\u53f7\u3010" + number + "\u3011" + dmsg + "\uff0c");
            }
        }
        String string = state == 1 || state == 0 ? (state == 1 ? "\u6fc0\u6d3b\u7528\u6237\u6210\u529f\uff01" : "\u7528\u6237\u7981\u7528\u6210\u529f") : (successMsg = "\u79bb\u804c\u7528\u6237\u6210\u529f");
        if (StringUtil.isEmpty((String)userMark.getAccount()) && StringUtil.isEmpty((String)userMark.getUserNumber())) {
            isTrue = false;
            msg.append("\u7528\u6237\u5e10\u53f7\u548c\u5de5\u53f7\u81f3\u5c11\u8f93\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        return new CommonResult(isTrue, BeanUtils.isNotEmpty((Object)msg) ? msg.toString() : successMsg, (Object)"");
    }

    @Override
    public List<UserVo> getUserByPost(String postCode) {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1apostCode\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("ID_", (Object)postCode, QueryOP.IN, FieldRelation.OR);
        queryFilter.addFilter("CODE_", (Object)postCode, QueryOP.IN, FieldRelation.OR);
        PageList query = this.orgPostManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
            return new ArrayList<UserVo>();
        }
        ArrayList<String> postCodes = new ArrayList<String>();
        for (OrgPost orgPost : query.getRows()) {
            postCodes.add(orgPost.getCode());
        }
        return OrgUtil.convertToUserVoList(((UserDao)this.baseMapper).getUserByPosts(postCodes));
    }

    @Override
    @Transactional
    public String exportUsers(boolean isOrg, boolean isRole, boolean isAll, QueryFilter queryFilter) throws Exception {
        String zipPath;
        String fileName;
        boolean isOtherAll = isAll && BeanUtils.isEmpty((Object)queryFilter.getQuerys());
        List userList = new ArrayList();
        if (isAll) {
            queryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            userList = this.queryNoPage(queryFilter);
        } else {
            PageList query = this.query(queryFilter);
            userList = query.getRows();
        }
        String zipFilePath = "";
        if (BeanUtils.isNotEmpty(userList)) {
            Field[] baseFields = UserDao.class.getDeclaredFields();
            fileName = "htuc_user_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
            zipPath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + fileName).replace("/", File.separator);
            String excelPath = zipPath + File.separator;
            this.exportExcel(baseFields, userList, "\u7528\u6237\u5217\u8868", "user", excelPath);
            if (isOrg || isRole) {
                ArrayList<String> userIds = new ArrayList<String>();
                if (!isOtherAll) {
                    for (User user : userList) {
                        userIds.add(user.getId());
                    }
                }
                if (isOrg) {
                    this.exportOrg(userIds, baseFields, excelPath, fileName, isOtherAll);
                }
                if (isRole) {
                    this.exportRoles(userIds, baseFields, excelPath, isOtherAll);
                }
            }
        } else {
            throw new RuntimeException("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        ZipUtil.zip((String)zipPath, (Boolean)true);
        zipFilePath = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/").replace("/", File.separator) + fileName;
        return zipFilePath;
    }

    @Transactional
    private void dealUserState(User user, Integer status) throws SQLException {
        if (BeanUtils.isNotEmpty((Object)user)) {
            user.setStatus(status);
            this.update((Model)user);
        }
    }

    @Transactional
    private void exportOrg(List<String> userIds, Field[] baseFields, String excelPath, String fileName, boolean isOtherAll) throws Exception {
        QueryFilter orgUserQueryFilter = QueryFilter.build();
        if (!isOtherAll) {
            orgUserQueryFilter.addFilter("userId", userIds, QueryOP.IN, FieldRelation.AND);
        }
        orgUserQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List orgUsers = this.orgUserManager.queryNoPage(orgUserQueryFilter);
        if (BeanUtils.isNotEmpty((Object)orgUsers)) {
            this.exportExcel(baseFields, orgUsers, "\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\u5217\u8868", "orgUser", excelPath);
            ArrayList<String> orgIds = new ArrayList<String>();
            ArrayList<String> postIds = new ArrayList<String>();
            for (int i = 0; i < orgUsers.size(); ++i) {
                orgIds.add(((OrgUser)orgUsers.get(i)).getOrgId());
                if (!StringUtil.isNotEmpty((String)((OrgUser)orgUsers.get(i)).getRelId())) continue;
                postIds.add(((OrgUser)orgUsers.get(i)).getRelId());
            }
            QueryFilter orgQueryFilter = QueryFilter.build();
            BeanUtils.removeDuplicate(orgIds);
            orgQueryFilter.addFilter("id", orgIds, QueryOP.IN, FieldRelation.AND);
            orgQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List orgs = this.orgManager.queryNoPage(orgQueryFilter);
            if (BeanUtils.isNotEmpty((Object)orgs)) {
                this.exportExcel(baseFields, orgs, "\u7ec4\u7ec7\u5217\u8868", "org", excelPath);
                ArrayList<String> demIds = new ArrayList<String>();
                for (Org org : orgs) {
                    demIds.add(org.getDemId());
                }
                this.exportDemension(baseFields, excelPath, demIds);
            }
            if (BeanUtils.isNotEmpty(postIds)) {
                this.exportJobAndPost(baseFields, excelPath, postIds);
            }
        }
    }

    @Transactional
    private void exportDemension(Field[] baseFields, String excelPath, List<String> demIds) throws Exception {
        BeanUtils.removeDuplicate(demIds);
        QueryFilter demQueryFilter = QueryFilter.build();
        demQueryFilter.addFilter("id", demIds, QueryOP.IN, FieldRelation.AND);
        demQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List dems = this.demensionManager.queryNoPage(demQueryFilter);
        if (BeanUtils.isNotEmpty((Object)dems)) {
            this.exportExcel(baseFields, dems, "\u7ef4\u5ea6\u5217\u8868", "demension", excelPath);
        }
    }

    @Transactional
    private void exportJobAndPost(Field[] baseFields, String excelPath, List<String> postIds) throws Exception {
        BeanUtils.removeDuplicate(postIds);
        QueryFilter postQueryFilter = QueryFilter.build();
        postQueryFilter.addFilter("id", postIds, QueryOP.IN, FieldRelation.AND);
        postQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List orgPosts = this.orgPostManager.queryNoPage(postQueryFilter);
        if (BeanUtils.isNotEmpty((Object)orgPosts)) {
            this.exportExcel(baseFields, orgPosts, "\u5c97\u4f4d\u5217\u8868", "post", excelPath);
            ArrayList<String> jobIds = new ArrayList<String>();
            for (OrgPost orgPost : orgPosts) {
                if (!StringUtil.isNotEmpty((String)orgPost.getRelDefId())) continue;
                jobIds.add(orgPost.getRelDefId());
            }
            QueryFilter jobQueryFilter = QueryFilter.build();
            jobQueryFilter.addFilter("id", jobIds, QueryOP.IN, FieldRelation.AND);
            jobQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List orgJobs = this.orgJobManager.queryNoPage(jobQueryFilter);
            if (BeanUtils.isNotEmpty((Object)orgJobs)) {
                this.exportExcel(baseFields, orgJobs, "\u804c\u52a1\u5217\u8868", "job", excelPath);
            }
        }
    }

    @Transactional
    private void exportRoles(List<String> userIds, Field[] baseFields, String excelPath, boolean isOtherAll) throws Exception {
        BeanUtils.removeDuplicate(userIds);
        QueryFilter userRoleQueryFilter = QueryFilter.build();
        if (!isOtherAll) {
            userRoleQueryFilter.addFilter("userId", userIds, QueryOP.IN, FieldRelation.AND);
        }
        userRoleQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
        List userRoles = this.userRoleManager.queryNoPage(userRoleQueryFilter);
        if (BeanUtils.isNotEmpty((Object)userRoles)) {
            this.exportExcel(baseFields, userRoles, "\u7528\u6237\u89d2\u8272\u5173\u7cfb\u5217\u8868", "userRole", excelPath);
            ArrayList<String> roleIds = new ArrayList<String>();
            for (UserRole userRole : userRoles) {
                roleIds.add(userRole.getRoleId());
            }
            QueryFilter roleQueryFilter = QueryFilter.build();
            roleQueryFilter.addFilter("id", roleIds, QueryOP.IN, FieldRelation.AND);
            roleQueryFilter.addFilter("isDelete", (Object)"1", QueryOP.NOT_EQUAL, FieldRelation.AND, "group_1");
            List roles = this.roleManager.queryNoPage(roleQueryFilter);
            if (BeanUtils.isNotEmpty((Object)roles)) {
                this.exportExcel(baseFields, roles, "\u89d2\u8272\u5217\u8868", "role", excelPath);
            }
        }
    }

    private <E> void exportExcel(Field[] baseFields, List<E> list, String sheetName, String excelName, String excelPath) throws Exception {
        Field[] fields;
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        for (Field field : fields = list.get(0).getClass().getDeclaredFields()) {
            if (field.getModifiers() != 4) continue;
            exportMaps.put(field.getName(), field.getName());
        }
        for (Field field : baseFields) {
            if (field.getModifiers() != 4) continue;
            exportMaps.put(field.getName(), field.getName());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)sheetName, (int)24, exportMaps, list);
        ExcelUtil.saveExcel((HSSFWorkbook)book, (String)excelName, (String)excelPath);
    }

    @Override
    public List<User> getUserByTime(UserExportObject userExport) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(userExport.getBtime(), userExport.getEtime());
        StringBuilder sql = new StringBuilder();
        if (StringUtil.isNotEmpty((String)userExport.getJobCodes())) {
            sql.append(" and ID_ in( select aa.USER_ID_ from uc_org_user aa where aa.is_dele_ = '0' and aa.pos_id_ in (select bb.ID_ from uc_org_post bb where bb.is_dele_='0' and bb.job_id_ in (select cc.id_ from uc_org_job cc where cc.is_dele_='0'  and cc.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getJobCodes(), ","));
            sql.append(" ))) ");
        }
        if (StringUtil.isNotEmpty((String)userExport.getPostCodes())) {
            sql.append(" and ID_ in( select dd.USER_ID_ FROM uc_org_user dd where dd.is_dele_='0' and dd.pos_id_ in( select ee.ID_ from uc_org_post ee where ee.is_dele_='0' and ee.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getPostCodes(), ","));
            sql.append(" )) ");
        } else if (StringUtil.isNotEmpty((String)userExport.getOrgCodes())) {
            sql.append(" and ID_ in( select ff.USER_ID_ FROM uc_org_user ff where ff.is_dele_='0' and ff.org_id_ in( select gg.ID_ from uc_org gg where gg.is_dele_='0' and gg.CODE_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getOrgCodes(), ","));
            sql.append(" )) ");
        } else if (StringUtil.isNotEmpty((String)userExport.getDemCodes())) {
            sql.append(" and ID_ in( select hh.user_id_ FROM uc_org_user hh where hh.is_dele_='0' and hh.org_id_ in( select ii.ID_ from uc_org ii where ii.is_dele_='0' and ii.dem_id_ in(select jj.ID_ from uc_demension jj where jj.is_dele_='0' and jj.code_ in ");
            sql.append(OrgUtil.getSubInSql(userExport.getDemCodes(), ","));
            sql.append(" ))) ");
        }
        if (BeanUtils.isNotEmpty((Object)sql)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dimSql", sql.toString());
            queryFilter.setParams(params);
        }
        return ((UserDao)this.baseMapper).queryByDim((Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<UserParams> getUserParamByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.userParamsService.queryNoPage(queryFilter);
    }

    @Override
    public List<UserRole> getUserRoleByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.userRoleManager.queryNoPage(queryFilter);
    }

    @Override
    public List<User> getChargesByOrg(String orgCode, Boolean isMain) throws Exception {
        Org org = this.orgService.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org) && BeanUtils.isEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)orgCode))))) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u6216id\u3010" + orgCode + "\u4e0d\u5b58\u5728\u3011\uff01");
        }
        List<OrgUser> orgUser = this.orgUserService.getChargesByOrgId(org.getId(), isMain);
        if (BeanUtils.isNotEmpty(orgUser)) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (OrgUser oUser : orgUser) {
                userIds.add(oUser.getUserId());
            }
            QueryFilter filter = QueryFilter.build();
            filter.addFilter("id", userIds, QueryOP.IN, FieldRelation.AND);
            return this.query(filter).getRows();
        }
        return null;
    }

    @Override
    public DataSyncVo getSyncDataByTime(DataSyncObject dataSync) throws Exception {
        DataSyncVo dataSyncVo = new DataSyncVo();
        String btime = dataSync.getBtime();
        String etime = dataSync.getEtime();
        if (dataSync.getIsUser().booleanValue()) {
            UserExportObject userExport = new UserExportObject();
            userExport.setBtime(btime);
            userExport.setEtime(etime);
            userExport.setDemCodes(dataSync.getDemCodes());
            userExport.setOrgCodes(dataSync.getOrgCodes());
            userExport.setJobCodes(dataSync.getJobCodes());
            userExport.setPostCodes(dataSync.getPostCodes());
            dataSyncVo.setUserList(this.getUserByTime(userExport));
        }
        OrgExportObject exportObject = new OrgExportObject();
        exportObject.setBtime(btime);
        exportObject.setEtime(etime);
        exportObject.setDemCodes(dataSync.getDemCodes());
        exportObject.setOrgCodes(dataSync.getOrgCodes());
        if (dataSync.getIsDem().booleanValue()) {
            dataSyncVo.setDemList(this.demensionService.getDemByTime(exportObject));
        }
        if (dataSync.getIsOrg().booleanValue()) {
            dataSyncVo.setOrgList(this.orgService.getOrgByTime(exportObject));
        }
        if (dataSync.getIsOrgAuth().booleanValue()) {
            dataSyncVo.setOrgAuthList(this.orgAuthService.getOrgAuthByTime(exportObject));
        }
        if (dataSync.getIsJob().booleanValue()) {
            dataSyncVo.setJobList(this.orgJobService.getJobByTime(btime, etime));
        }
        if (dataSync.getIsPost().booleanValue()) {
            dataSyncVo.setPostList(this.orgService.getOrgPostByTime(exportObject));
        }
        if (dataSync.getIsOrgUser().booleanValue()) {
            dataSyncVo.setOrgUserList(this.orgService.getOrgUserByTime(exportObject));
        }
        if (dataSync.getIsUnder().booleanValue()) {
            dataSyncVo.setUnderList(this.orgService.getUserUnderByTime(exportObject));
        }
        if (dataSync.getIsOrgRole().booleanValue()) {
            dataSyncVo.setOrgRoleList(this.orgService.getOrgRoleByTime(exportObject));
        }
        if (dataSync.getIsParams().booleanValue()) {
            dataSyncVo.setParamsList(this.paramsService.getParamsByTime(btime, etime));
        }
        if (dataSync.getIsUserParams().booleanValue()) {
            dataSyncVo.setUserParamList(this.getUserParamByTime(btime, etime));
        }
        if (dataSync.getIsOrgParams().booleanValue()) {
            dataSyncVo.setOrgParamList(this.orgService.getOrgParamByTime(exportObject));
        }
        if (dataSync.getIsRole().booleanValue()) {
            dataSyncVo.setRoleList(this.roleService.getRoleByTime(btime, etime));
        }
        if (dataSync.getIsUserRole().booleanValue()) {
            dataSyncVo.setUserRoleList(this.getUserRoleByTime(btime, etime));
        }
        if (dataSync.getIsGroup().booleanValue()) {
            dataSyncVo.setGroupList(this.userGroupService.getUserGroupByTime(btime, etime));
        }
        if (dataSync.getIsUserRel().booleanValue()) {
            dataSyncVo.setUserRelList(this.userRelService.getUserRelByTime(btime, etime));
        }
        return dataSyncVo;
    }

    private void cleanPhotoFolder(String account, String exceptFile) throws IOException {
        Path path = Paths.get(this.attachPath, account);
        if (Files.notExists(path, new LinkOption[0]) || StringUtil.isEmpty((String)exceptFile)) {
            return;
        }
        UserPhotoFileFindVisitor userPhotoFileFindVisitor = new UserPhotoFileFindVisitor(exceptFile);
        Files.walkFileTree(path, userPhotoFileFindVisitor);
        for (String fileName : userPhotoFileFindVisitor.getFilenameList()) {
            Files.delete(Paths.get(fileName, new String[0]));
        }
    }

    @Override
    @Transactional
    public void saveUser(UserPolymer userPolymer) throws Exception {
        UserVo user = userPolymer.getUser();
        String account = user.getAccount();
        if (userPolymer.getAdding().booleanValue()) {
            this.addUser(user);
        } else {
            this.updateUser(user);
        }
        this.cleanPhotoFolder(account, user.getPhoto());
        List<UserPolymerRole> roles = userPolymer.getRoles();
        int roleSize = BeanUtils.isEmpty(roles) ? 0 : roles.size();
        String[] roleCodes = new String[roleSize];
        for (int i = 0; i < roleSize; ++i) {
            UserPolymerRole userPolymerRole = roles.get(i);
            roleCodes[i] = userPolymerRole.getCode();
        }
        this.userRoleService.saveUserRole(account, roleCodes);
        List<UserPolymerOrgPos> orgsPoses = userPolymer.getOrgsPoses();
        this.orgUserService.saveOrgUser(account, orgsPoses);
    }

    private void duplicateUserByMobile(String account, String mobile) throws BaseException {
        if (StringUtil.isEmpty((String)account) || StringUtil.isEmpty((String)mobile)) {
            return;
        }
        List<User> userList = ((UserDao)this.baseMapper).listByMobile(mobile);
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        User user = userList.stream().filter(userTemp -> !Objects.equals(userTemp.getAccount(), account) && Objects.equals(userTemp.getMobile(), mobile)).findFirst().orElse(null);
        if (user != null) {
            throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u8d26\u53f7\u4e3a\u3010" + user.getAccount() + "\u3011\u7684\u624b\u673a\u53f7\u3010" + mobile + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }

    @Override
    @Transactional
    public CommonResult<String> saveUser(UserVo user) {
        try {
            String account = user.getAccount();
            if (StringUtil.isEmpty((String)user.getAccount())) {
                throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5e10\u53f7\u3010account\u3011\u5fc5\u586b\uff01");
            }
            User u = this.getByAccount(user.getAccount());
            if (BeanUtils.isEmpty((Object)u)) {
                throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u5931\u8d25\uff0c\u6839\u636e\u3010" + user.getAccount() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
            }
            if (StringUtil.isNotEmpty((String)user.getBirthday())) {
                u.setBirthday(DateFormatUtil.parse((String)user.getBirthday(), (String)"yyyy-MM-dd").toLocalDate());
            } else {
                u.setBirthday(null);
            }
            u.setStatus(user.getStatus());
            u.setAddress(user.getAddress());
            u.setEducation(user.getEducation());
            u.setSex(user.getSex());
            u.setPhoto(user.getPhoto());
            u.setIdCard(user.getIdCard());
            this.update((Model)u);
            this.cleanPhotoFolder(account, user.getPhoto());
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object)e.getMessage());
        }
        return new CommonResult(true, "\u4fee\u6539\u7528\u6237\u4fe1\u606f\u6210\u529f", (Object)"");
    }

    @Override
    public ChartOption getUserRelCharts(String json) throws Exception {
        User user = this.getUserByJson(json);
        if (BeanUtils.isEmpty((Object)user)) {
            throw new RuntimeException("\u6839\u636e\u7528\u6237\u6807\u8bc6\u4fe1\u606f\u83b7\u53d6\u4e0d\u5230\u7528\u6237\uff01");
        }
        String currentUserName = user.getFullname();
        String text = "\u3010" + currentUserName + "\u3011\u7684\u6c47\u62a5\u5173\u7cfb\u56fe";
        String subtext = "\u6570\u636e\u6765\u81ea\u534e\u6da6\u4e09\u4e5d\u7528\u6237\u4e2d\u5fc3";
        ArrayList<String> legend = new ArrayList<String>();
        legend.add("\u7ec4\u7ec7\u9886\u5bfc");
        legend.add("\u6c47\u62a5\u7ebf");
        String seriesName = "\u6c47\u62a5\u5173\u7cfb";
        ArrayNode categories = (ArrayNode)JsonUtil.toJsonNode((String)"[{name: '\u5f53\u524d\u7528\u6237'},{name: '\u7ec4\u7ec7\u9886\u5bfc'},{name:'\u6c47\u62a5\u7ebf'}]");
        ArrayList<ChartNode> nodes = new ArrayList<ChartNode>();
        ArrayList<ChartLink> links = new ArrayList<ChartLink>();
        ChartNode root = new ChartNode("root", 0, currentUserName + "\n\uff08\u5f53\u524d\u7528\u6237\uff09", "\u5f53\u524d\u4eba", currentUserName + "\n\uff08\u5f53\u524d\u7528\u6237\uff09", 35);
        nodes.add(root);
        HashMap<String, ChartNode> nodeIdMap = new HashMap<String, ChartNode>();
        ChartOption option = new ChartOption(text, subtext, legend, seriesName, categories);
        this.getUserRelOptions(root, option, nodes, links, user.getAccount(), nodeIdMap);
        this.getOrgOptions(root, option, nodes, links, user.getId(), nodeIdMap);
        option.setNodes(nodes);
        option.setLinks(links);
        return option;
    }

    private void getUserRelOptions(ChartNode root, ChartOption option, List<ChartNode> nodes, List<ChartLink> links, String account, Map<String, ChartNode> nodeIdMap) throws Exception {
        List<UserRel> rels = this.userRelService.getUserRels(account, null);
        for (UserRel userRel : rels) {
            if (userRel.getParentId().equals(userRel.getTypeId())) continue;
            ArrayList<ChartNode> relNodes = new ArrayList<ChartNode>();
            ArrayList<ChartLink> relLinks = new ArrayList<ChartLink>();
            UserRel pRel = (UserRel)this.userRelService.get((Serializable)((Object)userRel.getParentId()));
            if (!BeanUtils.isNotEmpty((Object)pRel) || pRel.getStatus() != 1) continue;
            ObjectNode proType = this.portalFeignService.getSysTypeById(pRel.getTypeId());
            String typeName = BeanUtils.isEmpty((Object)proType) ? "\u672a\u627e\u5230\uff01" : proType.get("name").asText();
            this.getSupRel(root, userRel, pRel, relNodes, relLinks, true, nodeIdMap, typeName);
            if (BeanUtils.isNotEmpty(relNodes)) {
                nodes.addAll(relNodes);
            }
            if (!BeanUtils.isNotEmpty(relLinks)) continue;
            links.addAll(relLinks);
        }
    }

    private void getSupRel(ChartNode root, UserRel nowRel, UserRel pRel, List<ChartNode> relNodes, List<ChartLink> relLinks, boolean isFirst, Map<String, ChartNode> nodeIdMap, String typeName) throws Exception {
        if (BeanUtils.isNotEmpty((Object)pRel)) {
            ChartNode node = nodeIdMap.get(pRel.getId());
            if (BeanUtils.isEmpty((Object)node)) {
                String label = this.getRelLabel(pRel);
                node = new ChartNode(pRel.getId(), 2, label, "\u6240\u5c5e\u6c47\u62a5\u7ebf\u3010" + typeName + "\u3011", label, 30);
                nodeIdMap.put(pRel.getId(), node);
                relNodes.add(node);
            }
            ChartLink link = new ChartLink("\u6c47\u62a5\u7ebf", isFirst ? root.getId() : nowRel.getId(), pRel.getId(), isFirst ? 5 : 3);
            relLinks.add(link);
            UserRel ppRel = (UserRel)this.userRelService.get((Serializable)((Object)pRel.getParentId()));
            if (BeanUtils.isNotEmpty((Object)ppRel) && ppRel.getStatus() == 1) {
                this.getSupRel(root, pRel, ppRel, relNodes, relLinks, false, nodeIdMap, typeName);
            }
        }
    }

    private String getRelLabel(UserRel rel) throws Exception {
        StringBuilder sbd = new StringBuilder();
        List<User> users = this.userRelService.getUsersByRel(rel.getAlias());
        sbd.append(rel.getName());
        sbd.append("\n");
        sbd.append("\uff08");
        switch (rel.getGroupType()) {
            case "user": {
                sbd.append("\u7528\u6237");
                break;
            }
            case "org": {
                sbd.append("\u7ec4\u7ec7");
                break;
            }
            case "pos": {
                sbd.append("\u5c97\u4f4d");
                break;
            }
            case "role": {
                sbd.append("\u89d2\u8272");
                break;
            }
            case "group": {
                sbd.append("\u7fa4\u7ec4");
            }
        }
        if (!"user".equals(rel.getGroupType())) {
            sbd.append("\u3010");
            sbd.append(BeanUtils.isNotEmpty(users) ? this.getUserNames(users) : "\u672a\u627e\u5230\u7528\u6237");
            sbd.append("\u3011");
        }
        sbd.append("\uff09");
        return sbd.toString();
    }

    private void getOrgOptions(ChartNode root, ChartOption option, List<ChartNode> nodes, List<ChartLink> links, String userId, Map<String, ChartNode> nodeIdMap) throws Exception {
        List<Org> orgs = this.orgService.getMainOrgListByUser(userId, null);
        for (Org org : orgs) {
            ArrayList<ChartNode> orgNodes = new ArrayList<ChartNode>();
            ArrayList<ChartLink> orgLinks = new ArrayList<ChartLink>();
            Org pOrg = (Org)this.orgService.get((Serializable)((Object)org.getParentId()));
            if (!BeanUtils.isNotEmpty((Object)pOrg)) continue;
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)pOrg.getDemId()));
            String demName = BeanUtils.isEmpty((Object)dem) ? "\u672a\u627e\u5230\uff01" : dem.getDemName();
            this.getSupOrg(root, org, pOrg, orgNodes, orgLinks, true, nodeIdMap, demName);
            if (BeanUtils.isNotEmpty(orgNodes)) {
                nodes.addAll(orgNodes);
            }
            if (!BeanUtils.isNotEmpty(orgLinks)) continue;
            links.addAll(orgLinks);
        }
    }

    private void getSupOrg(ChartNode root, Org nowOrg, Org pOrg, List<ChartNode> orgNodes, List<ChartLink> orgLinks, boolean isFirst, Map<String, ChartNode> nodeIdMap, String demName) throws Exception {
        if (BeanUtils.isNotEmpty((Object)pOrg)) {
            List<OrgPost> posts = this.orgPostService.getRelCharge(pOrg.getId(), true);
            ChartNode node = nodeIdMap.get(pOrg.getId());
            if (BeanUtils.isEmpty((Object)node)) {
                String label = this.getOrgLabel(pOrg, posts);
                node = new ChartNode(pOrg.getId(), 1, label, "\u6240\u5c5e\u7ef4\u5ea6\u3010" + demName + "\u3011", label, 30);
                nodeIdMap.put(pOrg.getId(), node);
                orgNodes.add(node);
            }
            ChartLink link = new ChartLink("\u7ec4\u7ec7\u9886\u5bfc", isFirst ? root.getId() : nowOrg.getId(), pOrg.getId(), isFirst ? 5 : 3);
            orgLinks.add(link);
            Org ppOrg = (Org)this.orgService.get((Serializable)((Object)pOrg.getParentId()));
            if (BeanUtils.isNotEmpty((Object)ppOrg)) {
                this.getSupOrg(root, pOrg, ppOrg, orgNodes, orgLinks, false, nodeIdMap, demName);
            }
        }
    }

    private String getOrgLabel(Org org, List<OrgPost> posts) throws Exception {
        StringBuilder sbd = new StringBuilder();
        sbd.append(org.getName());
        sbd.append("\n");
        sbd.append("\uff08");
        List<User> users = null;
        if (BeanUtils.isNotEmpty(posts)) {
            OrgPost post = posts.get(0);
            users = this.getListByPostId(post.getId());
            sbd.append(post.getName());
            String names = this.getUserNames(users);
            sbd.append("\u3010");
            sbd.append(StringUtil.isNotEmpty((String)names) ? names : "\u672a\u8bbe\u7f6e\u4eba\u5458");
            sbd.append("\u3011");
        } else {
            users = this.getChargesByOrg(org.getCode(), false);
            if (BeanUtils.isEmpty(users)) {
                sbd.append("\u672a\u8bbe\u7f6e\u8d23\u4efb\u5c97\u4f4d\u3001\u8d1f\u8d23\u4eba");
            } else {
                sbd.append("\u8d1f\u8d23\u4eba");
                sbd.append("\u3010");
                sbd.append(this.getUserNames(users));
                sbd.append("\u3011");
            }
        }
        sbd.append("\uff09");
        return sbd.toString();
    }

    private String getUserNames(List<User> users) {
        StringBuilder sbd = new StringBuilder();
        if (BeanUtils.isNotEmpty(users)) {
            boolean isFirst = true;
            for (User user : users) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sbd.append("\uff0c");
                }
                sbd.append(user.getFullname());
            }
        }
        return sbd.toString();
    }

    @Override
    public IPage<User> getRoleUserQuery(QueryFilter filter) {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        return ((UserDao)this.baseMapper).getUserListByRoleCodeMap((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public IPage<User> getOrgUserQuery(QueryFilter<User> queryFilter) {
        List querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            List<Object> userId;
            String property = query.getProperty();
            List value = query.getValue();
            if ("ORG_ID_".equals(property)) {
                String orgIds = value.toString();
                List userId2 = this.getUserListByOrgIds(orgIds).stream().map(User::getUserId).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(userId2)) {
                    value = userId2;
                }
                this.setUserIdCondition(query, value);
            }
            if ("POST_NAME_".equals(property)) {
                String postName = value.toString();
                List postIds = this.orgPostManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(OrgPost::getName, (Object)postName)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().map(OrgPost::getId).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(postIds) && BeanUtils.isNotEmpty(userId = this.getUserByPostIds(String.join((CharSequence)",", postIds)).stream().map(User::getUserId).collect(Collectors.toList()))) {
                    value = userId;
                }
                this.setUserIdCondition(query, value);
            }
            if ("JOB_NAME_".equals(property)) {
                String jobName = value.toString();
                List jobIds = this.orgJobManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(OrgJob::getName, (Object)jobName)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().map(OrgJob::getId).collect(Collectors.toList());
                userId = new ArrayList();
                for (String jobId : jobIds) {
                    List list = this.getListByJobIds(jobId).stream().map(User::getUserId).collect(Collectors.toList());
                    userId.addAll(list);
                }
                if (BeanUtils.isNotEmpty(userId)) {
                    value = userId;
                }
                this.setUserIdCondition(query, value);
            }
            if ("ROLE_NAME_".equals(property)) {
                String roleName = value.toString();
                List roleIds = this.roleManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Role::getName, (Object)roleName)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().map(Role::getId).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(roleIds) && BeanUtils.isNotEmpty(userId = this.getUserListByRoleIds(String.join((CharSequence)",", roleIds)).stream().map(User::getUserId).collect(Collectors.toList()))) {
                    value = userId;
                }
                this.setUserIdCondition(query, value);
            }
            if (!"DEM_ID_".equals(property)) continue;
            String demId = value.toString();
            List demIdList = this.demensionManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Demension::getId, new Object[]{demId})).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().map(Demension::getId).collect(Collectors.toList());
            List orgIdList = this.orgManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Org::getDemId, demIdList)).eq(UcBaseModel::getIsDelete, (Object)"0")).stream().map(Org::getId).collect(Collectors.toList());
            List userId3 = this.getUserListByOrgIds(String.join((CharSequence)",", orgIdList)).stream().map(User::getUserId).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(userId3)) {
                value = userId3;
            }
            this.setUserIdCondition(query, value);
        }
        if (CollUtil.isEmpty((Collection)querys)) {
            PageBean pageBean = queryFilter.getPageBean();
            if (BeanUtils.isEmpty((Object)pageBean)) {
                pageBean = new PageBean(Integer.valueOf(1));
            }
            pageBean.setShowTotal(false);
            queryFilter.withSorter(FieldSort.create((String)"id_", (String)Direction.ASC.name()));
            IPage<User> listUser = ((UserDao)this.baseMapper).getAllUser((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
            listUser.setTotal(((UserDao)this.baseMapper).getAllUserCount().longValue());
            return listUser;
        }
        return ((UserDao)this.baseMapper).getUserListByOrgQuery((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    private void setUserIdCondition(QueryField query, Object value) {
        query.setProperty("id");
        query.setValue(value);
        query.setOperation(QueryOP.IN);
        query.setRelation(FieldRelation.AND);
    }

    private List<Org> getUserManagerOrgs(List<Org> orgs, String userId) throws Exception {
        ArrayList<Org> list = new ArrayList<Org>();
        for (Org org : orgs) {
            if (!this.isUserManagerInOrg(userId, org.getCode())) continue;
            list.add(org);
        }
        return list;
    }

    private boolean isUserManagerInOrg(String userId, String orgCode) throws Exception {
        boolean isIn = false;
        List<OrgPost> orgPosts = this.orgService.getPostsByOrgCodes(orgCode, true);
        if (BeanUtils.isNotEmpty(orgPosts)) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("orguser.user_id_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND);
            queryFilter.addFilter("orguser.pos_id_", (Object)orgPosts.get(0).getId(), QueryOP.EQUAL, FieldRelation.AND);
            List orgUserList = this.queryOrgUserRel(queryFilter);
            if (BeanUtils.isNotEmpty((Object)orgUserList)) {
                return true;
            }
            Org org = this.orgService.getByCode(orgCode);
            if (BeanUtils.isNotEmpty((Object)org)) {
                List<OrgUser> orgUsers = this.orgUserService.getListByOrgIdUserId(org.getId(), userId);
                for (OrgUser orgUser : orgUsers) {
                    if (orgUser.getIsCharge() == 0) continue;
                    return true;
                }
            }
        }
        return isIn;
    }

    @Override
    @Transactional
    public void setStatus(UserStatusVo userStatusVo) throws Exception {
        ((UserDao)this.baseMapper).updateStatusByAccounts(userStatusVo.getStatus(), userStatusVo.getAccounts(), LocalDateTime.now());
    }

    @Override
    public CommonResult<Boolean> isAccountExist(String account) throws Exception {
        Integer amount = ((UserDao)this.baseMapper).queryByAccount(account);
        return new CommonResult(true, "", (Object)(amount > 0 ? 1 : 0));
    }

    @Override
    public CommonResult<Boolean> isUserNumberExist(String account, String userNumber) throws Exception {
        Integer amount = ((UserDao)this.baseMapper).queryByUserNumber(account, userNumber);
        return new CommonResult(true, "", (Object)(amount > 0 ? 1 : 0));
    }

    @Override
    public CommonResult<String> uploadPortrait(String account, MultipartFile file) throws Exception {
        if (!file.isEmpty()) {
            String originalFilename = file.getOriginalFilename();
            String extName = this.getExtName(originalFilename);
            String finalName = UniqueIdUtil.getSuid() + extName;
            Path path = Paths.get(this.attachPath, account, finalName);
            Path parent = path.getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                File dir = new File(parent.toString());
                dir.mkdirs();
            }
            Files.copy(file.getInputStream(), path, new CopyOption[0]);
            return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)(account + "/" + finalName));
        }
        throw new SystemException("Upload file is empty.");
    }

    private String getExtName(String fileName) {
        Pattern regex = Pattern.compile("^.*(\\.\\w+)$");
        Matcher regexMatcher = regex.matcher(fileName);
        if (regexMatcher.matches()) {
            return regexMatcher.group(1);
        }
        return null;
    }

    @Override
    public org.springframework.core.io.Resource downloadPortrait(String account, String filename) throws Exception {
        return this.resourceLoader.getResource("file:" + Paths.get(this.attachPath, account, filename).toString());
    }

    @Override
    public IPage<User> getDemUserQuery(QueryFilter filter) throws Exception {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        Map params = filter.getParams();
        if (BeanUtils.isNotEmpty((Object)params)) {
            String demCode = null;
            if (params.containsKey("demCode")) {
                demCode = params.get("demCode").toString();
            }
            if (params.containsKey("dem_code_")) {
                demCode = params.get("dem_code_").toString();
            }
            String demId = demCode;
            Demension dimension = this.demensionDao.getByCode(demCode);
            if (BeanUtils.isNotEmpty((Object)dimension)) {
                demId = dimension.getId();
            }
            if (BeanUtils.isNotEmpty((Object)demId)) {
                params.put("dem_id_", demId);
            }
        }
        return ((UserDao)this.baseMapper).getDemUserQuery((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public CommonResult<String> setTrigger(TriggerVo triggerVo, String ip) throws Exception {
        return new CommonResult(true, "\u4efb\u52a1\u6267\u884c\u8ba1\u5212\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public CommonResult<UserVo> getUserById(String userId) throws Exception {
        if (StringUtil.isEmpty((String)userId)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\uff1a\u201cuserId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
        }
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237ID\u4e3a\u3010" + userId + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
        }
        UserVo userVo = new UserVo(user);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)userVo);
    }

    @Override
    public PageList<User> queryByType(QueryFilter queryFilter) throws SystemException {
        this.copyQuerysInParams(queryFilter);
        this.handleQueryFilter(queryFilter);
        PageBean pageBean = queryFilter.getPageBean();
        if (BeanUtils.isEmpty((Object)pageBean)) {
            pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(false));
        }
        IPage<User> query = ((UserDao)this.baseMapper).queryByType((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    private Class<? super T> getTypeClass() {
        Class rawType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        return rawType;
    }

    private void handleQueryFilter(QueryFilter queryFilter) throws SystemException {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            throw new SystemException("QueryFilter\u901a\u7528\u67e5\u8be2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a.");
        }
    }

    @Override
    public List<UserVo> queryUser(QueryFilter queryFilter) {
        List users = this.queryNoPage(queryFilter);
        ArrayList<UserVo> userVos = new ArrayList<UserVo>();
        for (User user : users) {
            UserVo userVo = OrgUtil.convertToUserVo(user);
            userVos.add(userVo);
        }
        return userVos;
    }

    @Override
    public List<User> getSuperFromUnder(String userId, String orgId, String demId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (StringUtil.isNotEmpty((String)orgId)) {
            params.put("orgId", orgId);
        }
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
            Demension dimensionByCode = this.demensionDao.getByCode(demId);
            if (BeanUtils.isNotEmpty((Object)dimensionByCode)) {
                params.put("demId", dimensionByCode.getOrganId());
            }
        }
        return ((UserDao)this.baseMapper).getSuperFromUnder(params);
    }

    @Override
    public List<User> getSuperiorFromUnder(String userId, String demId) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
        }
        return ((UserDao)this.baseMapper).getSuperiorFromUnder(params);
    }

    @Override
    public Map<String, Object> getUserDetailed(String userId) {
        return ((UserDao)this.baseMapper).getUserDetailed(userId);
    }

    @Override
    public List<UserVo> getDepHeader(String userId, Boolean isMain) throws Exception {
        Org org = this.getOrgByUserId(userId);
        if (BeanUtils.isNotEmpty((Object)org)) {
            return this.getDepHeaderByOrgId(org.getId(), isMain);
        }
        return new ArrayList<UserVo>();
    }

    private Org getOrgByUserId(String userId) {
        User u = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isNotEmpty((Object)u)) {
            return this.orgService.getMainGroup(userId, "");
        }
        return new Org();
    }

    private ObjectNode getUserInfoByUserId(String userId) throws Exception {
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        User u = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isNotEmpty((Object)u)) {
            objectNode.set("user", JsonUtil.toJsonNode((Object)u));
            Org org = this.orgService.getMainGroup(userId, "");
            if (BeanUtils.isNotEmpty((Object)org)) {
                objectNode.set("org", JsonUtil.toJsonNode((Object)org));
            }
        }
        return objectNode;
    }

    @Override
    public List<UserVo> getDepHeaderByOrg(String orgId, Boolean isMain) throws Exception {
        return this.getDepHeaderByOrgId(orgId, isMain);
    }

    private List<UserVo> getDepHeaderByOrgId(String orgId, Boolean isMain) throws Exception {
        if (BeanUtils.isNotEmpty((Object)orgId)) {
            List<OrgUser> chargesByOrgId = this.orgUserService.getChargesByOrgId(orgId, isMain);
            ArrayList<String> userIds = new ArrayList<String>();
            for (OrgUser orgUser : chargesByOrgId) {
                userIds.add(orgUser.getUserId());
            }
            if (userIds.size() > 0) {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("ID_", userIds, QueryOP.IN);
                PageList query = this.query(queryFilter);
                ArrayList<UserVo> voList = new ArrayList<UserVo>();
                for (User user : query.getRows()) {
                    if (BeanUtils.isEmpty((Object)user)) continue;
                    voList.add(new UserVo(user));
                }
                return voList;
            }
        }
        return null;
    }

    @Override
    @CachePut(value={"eip:uc:userGroups"}, key="#userId", ignoreException=false, firstCache=@FirstCache(expireTime=120, timeUnit=TimeUnit.MINUTES), secondaryCache=@SecondaryCache(expireTime=120, timeUnit=TimeUnit.MINUTES))
    public List<Group> getGroupsByUserId(String userId) {
        List<OrgPost> listOrgRelDef;
        List<OrgJob> listOrgRel;
        List<Role> listRole;
        String type = GroupTypeConstant.All.key();
        ArrayList<UcBaseModel> listMap = new ArrayList<UcBaseModel>();
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            user = this.getByAccount(userId);
        }
        if (BeanUtils.isEmpty((Object)user)) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u7528\u6237id\u6216\u8005\u8d26\u53f7\u672a\u627e\u5230\u7528\u6237");
        }
        userId = user.getId();
        List<Org> listOrg = this.orgService.getOrgListByUserId(userId);
        if (BeanUtils.isNotEmpty(listOrg)) {
            listMap.addAll(listOrg);
        }
        if (BeanUtils.isNotEmpty(listRole = this.roleService.getListByUserId(userId))) {
            listMap.addAll(listRole);
        }
        if (BeanUtils.isNotEmpty(listOrgRel = this.orgJobService.getListByUserId(userId))) {
            listMap.addAll(listOrgRel);
        }
        if (BeanUtils.isNotEmpty(listOrgRelDef = this.orgPostService.getListByUserId(userId, ""))) {
            listMap.addAll(listOrgRelDef);
        }
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (IGroup iGroup : listMap) {
            Group group = new Group();
            group.setGroupId(iGroup.getGroupId());
            group.setGroupCode(iGroup.getGroupCode());
            group.setName(iGroup.getName());
            group.setGroupType(iGroup.getGroupType());
            group.setIdentityType(iGroup.getIdentityType());
            groupList.add(group);
        }
        return groupList;
    }

    @Override
    public List<Group> getGroupsByUserId(String userId, String type) {
        UserManager userManager = (UserManager)AppUtil.getBean(UserManager.class);
        List<Group> allUserGroup = userManager.getGroupsByUserId(userId);
        if (GroupTypeConstant.All.key().equals(type) || StringUtil.isEmpty((String)type)) {
            return allUserGroup;
        }
        List<Group> groupList = allUserGroup.stream().filter(predicate -> type.equals(predicate.getGroupType())).collect(Collectors.toList());
        return groupList;
    }

    @Override
    @CacheEvict(value={"eip:uc:userGroups"}, key="#userId", ignoreException=false)
    public void removeUserGroupsCache(String userId) {
    }

    @Override
    public Map<String, Object> getUserDetailByAccountOrId(String userId) throws IOException {
        Set strings;
        JsonNode orgCodeNode;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        User user = (User)this.get((Serializable)((Object)userId));
        if (BeanUtils.isEmpty((Object)user)) {
            user = this.getByAccount(userId);
        }
        if (BeanUtils.isEmpty((Object)user)) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u8d26\u53f7\u6216\u8005ID\u672a\u627e\u5230\u7528\u6237");
        }
        resultMap.put("user", user);
        List<Map<String, Object>> orgPostList = this.getUserByUserId(user.getId());
        if (BeanUtils.isEmpty(orgPostList)) {
            return resultMap;
        }
        HashMap<String, Map<String, Object>> postMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> allOrgMap = new HashMap<String, Map<String, Object>>();
        HashMap jobMap = new HashMap();
        for (int i = 0; i < orgPostList.size(); ++i) {
            String id;
            if (i == orgPostList.size() - 1) {
                resultMap.put("role", orgPostList.get(i).get("roleName"));
                resultMap.put("roles", orgPostList.get(i).get("roles"));
                continue;
            }
            Map<String, Object> map = orgPostList.get(i);
            if (BeanUtils.isNotEmpty((Object)map.get("pathName")) && BeanUtils.isNotEmpty((Object)map.get("demName"))) {
                map.put("pathName", map.get("demName").toString() + map.get("pathName").toString());
            }
            if (BeanUtils.isNotEmpty((Object)map.get("postId"))) {
                postMap.put(map.get("postId").toString(), map);
            }
            if (BeanUtils.isNotEmpty((Object)map.get("orgId"))) {
                if (BeanUtils.isNotEmpty(orgMap)) {
                    for (Object org : orgMap.values()) {
                        Map obj = (Map)org;
                        if ("1".equals(obj.get("isMaster").toString()) || !"1".equals(map.get("isMaster").toString())) continue;
                        orgMap.clear();
                        orgMap.put(map.get("orgId").toString(), map);
                    }
                    Demension defaultDemension = this.demensionService.getDefaultDemension();
                    if (BeanUtils.isNotEmpty((Object)defaultDemension) && map.get("demName").toString().equals(defaultDemension.getDemName()) && "1".equals(map.get("isMaster").toString())) {
                        orgMap.clear();
                        orgMap.put(map.get("orgId").toString(), map);
                    }
                } else {
                    orgMap.put(map.get("orgId").toString(), map);
                }
                allOrgMap.put(MapUtil.getStringIgnoreKey(map, (String)"orgId", (String)""), map);
            }
            if (!BeanUtils.isNotEmpty((Object)map.get("jobId")) && !BeanUtils.isNotEmpty((Object)map.get("postJobId"))) continue;
            String string = id = BeanUtils.isNotEmpty((Object)map.get("jobId")) ? map.get("jobId").toString() : map.get("postJobId").toString();
            if (jobMap.containsKey(id)) continue;
            HashMap<String, String> job = new HashMap<String, String>(2);
            job.put("id", id);
            job.put("name", map.get("jobName").toString().trim());
            jobMap.put(id, job);
        }
        UserManagerImpl bean = (UserManagerImpl)AppUtil.getBean(this.getClass());
        String curGroupId = bean.getCurrentGroupIdFromCache(user.getUserId());
        JsonNode jsonNode = null;
        String orgName = "";
        String orgCode = "";
        String postName = "";
        if (StringUtil.isNotEmpty((String)curGroupId)) {
            JsonNode postNameNode;
            jsonNode = JsonUtil.toJsonNode(postMap.get(curGroupId));
            JsonNode orgNameNode = jsonNode.findValue("orgName");
            orgCodeNode = jsonNode.findValue("orgCode");
            if (BeanUtils.isNotEmpty((Object)orgNameNode)) {
                orgName = orgNameNode.asText();
                orgCode = orgCodeNode.asText();
            }
            if (BeanUtils.isNotEmpty((Object)(postNameNode = jsonNode.findValue("postName")))) {
                postName = postNameNode.asText();
            }
        }
        if (StringUtil.isEmpty((String)orgName) && BeanUtils.isNotEmpty(orgMap) && (orgCodeNode = (strings = orgMap.keySet()).iterator()).hasNext()) {
            String string = (String)orgCodeNode.next();
            HashMap map = (HashMap)orgMap.get(string);
            orgName = (String)map.get("orgName");
            orgCode = (String)map.get("orgCode");
            postName = BeanUtils.isEmpty((Object)((String)map.get("postName"))) ? "\u6682\u672a\u5206\u914d\u5c97\u4f4d" : (String)map.get("postName");
        }
        ArrayNode orgLists = JsonUtil.createArrayNode();
        if (BeanUtils.isNotEmpty(orgMap)) {
            orgLists = JsonUtil.objectToArray((JsonNode)JsonUtil.toJsonNode(orgMap));
            Locale locale = LocaleContextHolder.getLocale();
            for (JsonNode org : orgLists) {
                JsonNode orgCodeNode2 = org.get("orgCode");
                JsonNode orgNameNode = org.get("orgName");
                if (Objects.isNull(orgCodeNode2) || Objects.isNull(orgNameNode)) continue;
                ((ObjectNode)org).put("orgName", I18nUtil.handleI18nMessage((String)String.format("org.%s", orgCodeNode2.asText()), (String)orgNameNode.asText(), (Locale)locale));
                ((ObjectNode)org).put("name", orgNameNode.asText());
                long parentOrgId = org.get("parentId") == null ? 0L : org.get("parentId").asLong();
                String orgPath = this.recursionOrgPath(parentOrgId, new StringJoiner("/"), (Org)JsonUtil.toBean((JsonNode)org, Org.class));
                String dimension = I18nUtil.handleI18nMessage((String)String.format("org.%s", org.get("demCode") == null ? "" : org.get("demCode").asText()), (String)(org.get("demName") == null ? "" : org.get("demName").asText()), (Locale)locale);
                ((ObjectNode)org).put("pathName", dimension + "/" + this.deptSorter(orgPath));
            }
        }
        orgName = I18nUtil.handleI18nMessage((String)String.format("org.%s", orgCode), (String)orgName);
        resultMap.put("curPost", orgName + " - " + postName);
        resultMap.put("post", postMap);
        resultMap.put("org", orgLists);
        resultMap.put("allOrgMap", new ArrayList(allOrgMap.values()));
        resultMap.put("job", jobMap.values());
        return resultMap;
    }

    private String recursionOrgPath(long parentId, StringJoiner joiner, Org dept) {
        String orgPath = I18nUtil.handleI18nMessage((String)String.format("org.%s", dept.getCode()), (String)dept.getName());
        joiner.add(orgPath);
        dept = parentId == 0L ? dept : (Org)this.orgService.get((Serializable)((Object)String.valueOf(parentId)));
        return parentId > 0L ? this.recursionOrgPath(Long.parseLong(dept.getParentId()), joiner, dept) : joiner.toString();
    }

    private String deptSorter(String orgPath) {
        CharSequence[] split = orgPath.split("/");
        Collections.reverse(Arrays.asList(split));
        return String.join((CharSequence)"/", split);
    }

    @Override
    public List<User> getUserByName(String query) {
        return ((UserDao)this.baseMapper).getUserByName(query);
    }

    @Override
    public Map<String, Object> calculateNodeUser(Map<String, Object> result) {
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            List<Object> recievers = new ArrayList();
            ArrayList<ObjectNode> bpmIdentityList = new ArrayList<ObjectNode>();
            try {
                recievers = this.extractUser((List)entry.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (IUser user : recievers) {
                ObjectNode bpmIdentity = JsonUtil.getMapper().createObjectNode();
                bpmIdentity.put("type", "user");
                bpmIdentity.put("id", user.getUserId());
                bpmIdentity.put("name", user.getFullname());
                bpmIdentityList.add(bpmIdentity);
            }
            result.put(entry.getKey(), bpmIdentityList);
        }
        return result;
    }

    private List<IUser> extractUser(List<Map<String, Object>> bpmIdentities) throws Exception {
        PageList users;
        ArrayList<IUser> results = new ArrayList<IUser>();
        String userIds = "";
        String accounts = "";
        String orbyaccounts = "";
        if (BeanUtils.isEmpty(bpmIdentities)) {
            return results;
        }
        for (Map<String, Object> bpmIdentity : bpmIdentities) {
            if (bpmIdentity.get("type").toString().equals("group")) {
                users = this.getUserListByGroup(bpmIdentity);
                results.addAll((Collection<IUser>)users);
                continue;
            }
            if (!"user".equals(bpmIdentity.get("type").toString()) && !bpmIdentity.get("type").toString().equals("groupUser")) continue;
            if (BeanUtils.isNotEmpty((Object)bpmIdentity.get("id"))) {
                userIds = userIds + bpmIdentity.get("id").toString() + ",";
                continue;
            }
            accounts = accounts + bpmIdentity.get("code").toString() + ",";
            orbyaccounts = orbyaccounts + "'" + bpmIdentity.get("code").toString() + "',";
        }
        if (StringUtil.isNotEmpty((String)userIds)) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("id_", (Object)userIds, QueryOP.IN);
            queryFilter.addFilter("status_", (Object)1, QueryOP.EQUAL);
            PageList users2 = this.query(queryFilter);
            results.addAll(users2.getRows());
        }
        if (StringUtil.isNotEmpty((String)accounts)) {
            StringBuffer orbyaccount = new StringBuffer(orbyaccounts);
            orbyaccount.deleteCharAt(orbyaccount.length() - 1);
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            queryFilter.addFilter("account_", (Object)accounts, QueryOP.IN);
            queryFilter.addParams("orderBySql", (Object)("FIELD(account_," + orbyaccount.toString() + ")"));
            queryFilter.addFilter("status_", (Object)1, QueryOP.EQUAL);
            users = this.query(queryFilter);
            results.addAll(users.getRows());
        }
        return results;
    }

    private List<User> getUserListByGroup(Map<String, Object> bpmIdentityMap) throws Exception {
        List<User> result = new ArrayList<User>();
        if (BeanUtils.isEmpty(bpmIdentityMap)) {
            return result;
        }
        String groupType = MapUtil.getString(bpmIdentityMap, (String)"groupType");
        if (StringUtil.isEmpty((String)groupType)) {
            return result;
        }
        String groupId = MapUtil.getString(bpmIdentityMap, (String)"id");
        String groupCode = MapUtil.getString(bpmIdentityMap, (String)"code");
        if (groupType.equals(GroupTypeConstant.ORG.key())) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            if (StringUtil.isNotEmpty((String)groupId)) {
                queryFilter.addFilter("orgId", (Object)groupId, QueryOP.EQUAL);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                queryFilter.addFilter("orgCode", (Object)groupCode, QueryOP.EQUAL);
            } else {
                return result;
            }
            IPage<User> demUserQuery = this.getDemUserQuery(queryFilter);
            result = demUserQuery.getRecords();
        }
        if (groupType.equals(GroupTypeConstant.ROLE.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUsersByRoleId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUsersByRoleCode(groupCode);
            } else {
                return result;
            }
        }
        if (groupType.equals(GroupTypeConstant.POSITION.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUserByPostId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUserByPostCode(groupCode);
            } else {
                return result;
            }
        }
        if (groupType.equals(GroupTypeConstant.JOB.key())) {
            if (StringUtil.isNotEmpty((String)groupId)) {
                result = this.getUsersByJobId(groupId);
            } else if (StringUtil.isNotEmpty((String)groupCode)) {
                result = this.getUsersByJobCode(groupCode);
            } else {
                return result;
            }
        }
        return result;
    }

    private List<User> getUsersByJobId(String ids) {
        String[] idArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String id : idArray = ids.split(",")) {
            List<User> users;
            OrgJob job = (OrgJob)this.orgJobManager.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)job) || !BeanUtils.isNotEmpty(users = this.getListByJobId(job.getId()))) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    public List<User> getUsersByJobCode(String codes) throws Exception {
        String[] codeArray;
        ArrayList<User> list = new ArrayList<User>();
        for (String code : codeArray = codes.split(",")) {
            List<User> users;
            OrgJob job = this.orgJobManager.getByCode(code);
            if (!BeanUtils.isNotEmpty((Object)job) || !BeanUtils.isNotEmpty(users = this.getListByJobId(job.getId()))) continue;
            list.addAll(users);
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    private List<User> getUserByPostCode(String postCode) {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1apostCode\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RequiredException("\u5c97\u4f4d\u7f16\u7801\u3010" + postCode + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return ((UserDao)this.baseMapper).getUserByPost(postCode);
    }

    private List<User> getUserByPostId(String postId) {
        Assert.notNull((Object)postId, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        OrgPost orgPost = (OrgPost)this.orgPostService.get((Serializable)((Object)postId));
        if (BeanUtils.isEmpty((Object)orgPost)) {
            throw new RequiredException("\u4e0d\u5b58\u5728\u5c97\u4f4dID\u4e3a\u3010" + postId + "\u3011\u7684\u6570\u636e");
        }
        return ((UserDao)this.baseMapper).getUserByPost(orgPost.getCode());
    }

    private List<User> getUserByPostIds(String postIds) {
        Assert.notNull((Object)postIds, (String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((UserDao)this.baseMapper).getUserByPostIds(Arrays.asList(postIds.split(",")));
    }

    private List<User> getUsersByRoleId(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RequiredException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        String[] idArray = ids.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        boolean isFirst = true;
        for (String id : idArray) {
            List<User> users = this.getUserListByRoleId(id);
            if (BeanUtils.isNotEmpty(users)) {
                list.addAll(users);
                isTrue = true;
                continue;
            }
            if (!isFirst) {
                msg.append(",");
            } else {
                isFirst = false;
            }
            msg.append(id);
        }
        if (!isTrue) {
            throw new RequiredException("\u6839\u636e\u89d2\u8272ID\u3010" + msg + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    private List<User> getUsersByRoleCode(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        String[] codeArray = codes.split(",");
        StringBuilder msg = new StringBuilder();
        boolean isTrue = false;
        boolean isFirst = true;
        for (String code : codeArray) {
            List<User> users = this.getUserListByRoleCode(code);
            if (BeanUtils.isNotEmpty(users)) {
                list.addAll(users);
                isTrue = true;
                continue;
            }
            if (!isFirst) {
                msg.append(",");
            } else {
                isFirst = false;
            }
            msg.append(code);
        }
        if (!isTrue) {
            throw new RequiredException("\u6839\u636e\u89d2\u8272\u7f16\u7801\u3010" + msg + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
        }
        OrgUtil.removeDuplicate(list);
        return list;
    }

    @Override
    public CommonResult<UserVo> getUserByOpenId(String openId) {
        try {
            if (StringUtil.isEmpty((String)openId)) {
                return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\uff1a\u201copenId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01", null);
            }
            User user = ((UserDao)this.baseMapper).getUserByOpenId(openId);
            if (BeanUtils.isEmpty((Object)user)) {
                return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237\u5fae\u4fe1\u4e3a\u3010" + openId + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
            }
            UserVo userVo = new UserVo(user);
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)userVo);
        }
        catch (Exception e) {
            return new CommonResult(true, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c" + e.getMessage() + "", null);
        }
    }

    @Override
    public User getUserByMpOpenId(String wxWorkId) {
        return ((UserDao)this.baseMapper).getUserByMpOpenId(wxWorkId);
    }

    @Override
    public Map<String, Map<String, String>> getUserRightMapByIds(Set<String> ids) {
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        QueryFilter orgPostFiler = QueryFilter.build();
        orgPostFiler.addFilter("user_id_", new ArrayList<String>(ids), QueryOP.IN);
        PageList orgPostQuery = this.orgUserService.query(orgPostFiler);
        for (String string : ids) {
            HashMap<String, HashSet<String>> userMap = new HashMap<String, HashSet<String>>();
            userMap.put("user", new HashSet<String>(Arrays.asList(string)));
            resultMap.put(string, userMap);
        }
        HashSet<String> allPostIds = new HashSet<String>();
        if (BeanUtils.isNotEmpty((Object)orgPostQuery)) {
            for (OrgUser orgUser : orgPostQuery.getRows()) {
                Map userMap = (Map)resultMap.get(orgUser.getUserId());
                Iterator orgSet = userMap.containsKey(GroupTypeConstant.ORG.key()) ? (Set)userMap.get(GroupTypeConstant.ORG.key()) : new HashSet<String>();
                orgSet.add(orgUser.getOrgId());
                userMap.put(GroupTypeConstant.ORG.key(), orgSet);
                if (StringUtil.isNotEmpty((String)orgUser.getRelId())) {
                    HashSet<String> postSet = userMap.containsKey(GroupTypeConstant.POSITION.key()) ? (Set)userMap.get(GroupTypeConstant.POSITION.key()) : new HashSet<String>();
                    postSet.add(orgUser.getRelId());
                    userMap.put(GroupTypeConstant.POSITION.key(), postSet);
                    allPostIds.add(orgUser.getRelId());
                }
                resultMap.put(orgUser.getUserId(), userMap);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!allPostIds.isEmpty()) {
            QueryFilter postFilter = QueryFilter.build();
            postFilter.addFilter("ID_", new ArrayList(allPostIds), QueryOP.IN);
            PageList postQuery = this.orgPostService.query(postFilter);
            if (BeanUtils.isNotEmpty((Object)postQuery)) {
                for (OrgPost post : postQuery.getRows()) {
                    hashMap.put(post.getId(), post.getRelDefId());
                }
            }
        }
        QueryFilter roleFiler = QueryFilter.build();
        roleFiler.addFilter("user_id_", new ArrayList<String>(ids), QueryOP.IN);
        roleFiler.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList roleQuery = this.userRoleService.query(roleFiler);
        if (BeanUtils.isNotEmpty((Object)roleQuery)) {
            for (UserRole userRole : roleQuery.getRows()) {
                Map userMap = (Map)resultMap.get(userRole.getUserId());
                HashSet<String> roleSet = userMap.containsKey(GroupTypeConstant.ROLE.key()) ? (Set)userMap.get(GroupTypeConstant.ROLE.key()) : new HashSet<String>();
                roleSet.add(userRole.getRoleId());
                userMap.put(GroupTypeConstant.ROLE.key(), roleSet);
                resultMap.put(userRole.getUserId(), userMap);
            }
        }
        HashMap<String, Map<String, String>> userRightMap = new HashMap<String, Map<String, String>>();
        for (Map.Entry next : resultMap.entrySet()) {
            Map value = (Map)next.getValue();
            HashMap rightMapStr = new HashMap();
            if (value.containsKey(GroupTypeConstant.POSITION.key())) {
                HashSet jobSet = new HashSet();
                for (String postId : (Set)value.get(GroupTypeConstant.POSITION.key())) {
                    jobSet.add(hashMap.get(postId));
                }
                value.put(GroupTypeConstant.JOB.key(), jobSet);
            }
            for (Map.Entry item : value.entrySet()) {
                rightMapStr.put(item.getKey(), StringUtil.convertListToSingleQuotesString((Set)((Set)item.getValue())));
            }
            userRightMap.put((String)next.getKey(), rightMapStr);
        }
        return userRightMap;
    }

    private boolean checkEmail(String email) {
        try {
            String check = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            return matcher.matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public CommonResult<UserVo> getUserByMobile(String mobile) {
        User user = ((UserDao)this.baseMapper).getByMobile(mobile);
        if (BeanUtils.isEmpty((Object)user)) {
            return new CommonResult(false, "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u624b\u673a\u53f7\u4e3a\u3010" + mobile + "\u3011\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
        }
        UserVo userVo = new UserVo(user);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)userVo);
    }

    @Override
    public ArrayNode getUserInfoBySignData(ArrayNode customSignDatas) throws Exception {
        for (JsonNode jsonNode : customSignDatas) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            String executor = objectNode.get("executor").asText();
            JsonNode executorJson = JsonUtil.toJsonNode((String)executor);
            executorJson = executorJson.get(0);
            ObjectNode resultObj = this.getUserInfoByUserId(executorJson.get("id").asText());
            ObjectNode executorObject = (ObjectNode)executorJson;
            executorObject.put("orgName", resultObj.has("org") ? resultObj.get("org").get("name").asText() : "");
            executorObject.put("account", resultObj.has("user") ? resultObj.get("user").get("account").asText() : "");
            objectNode.set("executor", (JsonNode)executorObject);
        }
        return customSignDatas;
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserDao)this.baseMapper).removePhysical();
    }

    @Override
    public CommonResult<String> getTokenByUserName(String userName) {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(userName);
        String token = this.jwtTokenHandler.generateToken(userDetails);
        return new CommonResult(true, "\u83b7\u53d6Token\u6210\u529f\uff01", (Object)token);
    }

    @Override
    public void userExport(List<String> users, HttpServletResponse httpServletResponse) throws Exception {
        long start = System.currentTimeMillis();
        CopyOnWriteArrayList list = new CopyOnWriteArrayList();
        AtomicBoolean res = new AtomicBoolean(false);
        StringBuffer bf = new StringBuffer();
        ForkJoinPool myPool = new ForkJoinPool(8);
        ((ForkJoinTask)myPool.submit(() -> users.parallelStream().forEach(user -> {
            Map u = null;
            try {
                u = JsonUtil.toMap((String)user);
            }
            catch (IOException e) {
                bf.append(e.getMessage());
                res.set(true);
            }
            List<Map<String, Object>> maps = this.putInfo(u);
            maps.stream().forEach(item -> list.add(item));
        }))).get();
        if (res.get()) {
            throw new BaseException(bf.toString());
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("\u603b\u6d88\u8017\u65f6\u95f4\uff1a" + duration / 1000L + "\u79d2");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("pathName", "\u7ec4\u7ec7\u5355\u5143\u540d\u79f0");
        map.put("fullname", "\u59d3\u540d");
        map.put("sex", "\u6027\u522b");
        map.put("mobile", "\u624b\u673a\u53f7\u7801");
        map.put("account", "\u8d26\u53f7");
        map.put("status", "\u5458\u5de5\u72b6\u6001");
        map.put("address", "\u5730\u5740");
        map.put("postName", "\u5c97\u4f4d");
        map.put("jobName", "\u804c\u52a1");
        map.put("weixin", "\u5fae\u4fe1\u53f7");
        map.put("email", "\u90ae\u7bb1");
        map.put("isCharge", "\u90e8\u95e8\u8d1f\u8d23\u4eba");
        map.put("isMaster", "\u662f\u5426\u4e3b\u7ec4\u7ec7");
        HSSFWorkbook sheets = ExcelUtil.exportExcel((String)String.valueOf(start), (int)17, map, list);
        ExcelUtil.downloadExcel((Workbook)sheets, (String)String.valueOf(start), (HttpServletResponse)httpServletResponse);
    }

    @Override
    public IPage<User> selectShiftUser(QueryFilter queryFilter) {
        queryFilter.addFilter("u.is_dele_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        queryFilter.addFilter("su.is_dele_", (Object)Character.valueOf('0'), QueryOP.EQUAL);
        return ((UserDao)this.baseMapper).selectShiftUser((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    private List<Map<String, Object>> putInfo(Map<String, Object> u) {
        String userId = u.get("id").toString();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(200);
        List<OrgUser> orgUserList = this.orgUserManager.getListPostAndJob(userId);
        orgUserList.stream().forEach(orgUser -> {
            Map<String, Object> map = this.userInfoToMap(u, orgUser.getIsMaster(), orgUser.getIsCharge());
            map.put("pathName", orgUser.getPathName());
            map.put("jobName", orgUser.getJobName());
            map.put("postName", orgUser.getPostName());
            list.add(map);
        });
        if (list.size() == 0) {
            Map<String, Object> map = this.userInfoToMap(u, -1, -1);
            list.add(map);
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    private Map<String, Object> userInfoToMap(Map<String, Object> u, Integer isMaster, Integer isCharge) {
        String status;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fullname", u.get("fullname"));
        map.put("sex", u.get("sex"));
        map.put("mobile", u.get("mobile"));
        map.put("address", u.get("address"));
        map.put("account", u.get("account"));
        map.put("email", u.get("email"));
        map.put("weixin", u.get("weixin"));
        switch (status = u.get("status").toString()) {
            case "1": {
                map.put("status", "\u5728\u804c");
                break;
            }
            case "0": {
                map.put("status", "\u7981\u7528");
                break;
            }
            case "-1": {
                map.put("status", "\u5f85\u6fc0\u6d3b");
                break;
            }
            case "-2": {
                map.put("status", "\u79bb\u804c");
            }
        }
        switch (isMaster) {
            case 0: {
                map.put("isMaster", "\u5426");
                break;
            }
            case 1: {
                map.put("isMaster", "\u662f");
                break;
            }
            default: {
                map.put("isMaster", "");
            }
        }
        switch (isCharge) {
            case 0: {
                map.put("isCharge", "\u5426");
                break;
            }
            case 1: {
                map.put("isCharge", "\u662f");
                break;
            }
            case 2: {
                map.put("isCharge", "\u4e3b");
                break;
            }
            default: {
                map.put("isCharge", "");
            }
        }
        return map;
    }

    @Override
    public List<User> getUsersNotYetSyncWxWork(List<String> orgIdList, String bindType) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return ((UserDao)this.baseMapper).getUsersNotYetSyncWxWork(bindType);
        }
        return ((UserDao)this.baseMapper).getUsersNotYetSyncWxWorkByOrgId(orgIdList);
    }

    @Override
    public User getUserByWxWorkId(String wxWorkId) {
        return ((UserDao)this.baseMapper).getUserByWxWorkId(wxWorkId);
    }

    @Override
    public User getUserByFlyBookId(String flyBookId) {
        return ((UserDao)this.baseMapper).getUserByFlyBookId(flyBookId);
    }

    @Override
    public List<User> getUsersNotYetSyncDingtalk(List<String> orgIdList) {
        return ((UserDao)this.baseMapper).getUsersNotYetSyncDingtalk(orgIdList);
    }

    @Override
    public List<User> getUsersNotYetSyncFlybook(List<String> orgIdList) {
        return ((UserDao)this.baseMapper).getUsersNotYetSyncFlybook(orgIdList);
    }

    @Override
    public User getUserByDingtalkId(String dingtalkId) {
        return ((UserDao)this.baseMapper).getUserByDingtalkId(dingtalkId);
    }

    @Override
    public PageList<UserSeletorDto> queryUserWithMainOrgPost(QueryFilter queryFilter) {
        List querys;
        boolean hasOrgCondition = false;
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> orgIds = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)queryFilter) && BeanUtils.isNotEmpty((Object)(querys = queryFilter.getQuerys()))) {
            for (QueryField field : querys) {
                if ("path_".equalsIgnoreCase(field.getProperty())) {
                    pathList.add(String.valueOf(field.getValue()));
                    field.setProperty("uo." + field.getProperty().toLowerCase());
                    continue;
                }
                if ("uo.id_".equalsIgnoreCase(field.getProperty())) {
                    orgIds.add(String.valueOf(field.getValue()));
                    continue;
                }
                if (!"uo.path_".equalsIgnoreCase(field.getProperty())) continue;
                pathList.add(String.valueOf(field.getValue()));
            }
            if (BeanUtils.isNotEmpty(pathList)) {
                hasOrgCondition = true;
                queryFilter.addParams("path_", pathList);
            }
            if (BeanUtils.isNotEmpty(orgIds)) {
                hasOrgCondition = true;
                queryFilter.addParams("orgIds", orgIds);
            }
        }
        IPage<UserSeletorDto> page = null;
        if (!hasOrgCondition) {
            Demension defaultDemension = this.demensionManager.getDefaultDemension();
            Assert.notNull((Object)defaultDemension, (String)"\u5f53\u524d\u7ec4\u7ec7\u67b6\u6784\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u7ef4\u5ea6");
            queryFilter.addParams("dem_id_", (Object)defaultDemension.getId());
            page = ((UserDao)this.baseMapper).queryUserWithMainOrgPost((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
            if (BeanUtils.isNotEmpty((Object)page.getRecords())) {
                List orgList;
                List records = page.getRecords();
                Map<Object, Object> orgMap = new HashMap();
                Map<Object, Object> orgPostMap = new HashMap();
                List orgIdList = records.stream().map(UserSeletorDto::getOrgid).collect(Collectors.toList());
                List postIdList = records.stream().map(UserSeletorDto::getPostid).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(orgIdList) && BeanUtils.isNotEmpty((Object)(orgList = this.orgService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Org::getId, orgIdList)).eq(UcBaseModel::getIsDelete, (Object)"0"))))) {
                    orgMap = orgList.stream().collect(Collectors.toMap(Org::getId, org -> org));
                }
                if (BeanUtils.isNotEmpty(postIdList) && BeanUtils.isNotEmpty((Object)(orgList = this.orgPostManager.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OrgPost::getId, postIdList)).eq(UcBaseModel::getIsDelete, (Object)"0"))))) {
                    orgPostMap = orgList.stream().collect(Collectors.toMap(OrgPost::getId, org -> org));
                }
                for (UserSeletorDto record : records) {
                    if (BeanUtils.isNotEmpty(orgMap.get(record.getOrgid()))) {
                        Org org2 = (Org)orgMap.get(record.getOrgid());
                        record.setOrgname(org2.getName());
                        record.setPath(org2.getPath());
                        record.setPathname(org2.getPathName());
                    }
                    if (!BeanUtils.isNotEmpty(orgPostMap.get(record.getPostid()))) continue;
                    record.setPostname(((OrgPost)orgPostMap.get(record.getPostid())).getName());
                }
            }
        } else {
            page = ((UserDao)this.baseMapper).queryUserWithMainOrgPostByOrgPath((IPage<User>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<User>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        }
        this.handleUserMainOrgAndPost(page.getRecords());
        return new PageList(page);
    }

    @Override
    public void handleUserMainOrgAndPost(List<UserSeletorDto> records) {
        if (BeanUtils.isEmpty(records)) {
            return;
        }
        Optional<UserSeletorDto> first = records.stream().filter(item -> StringUtil.isNotEmpty((String)item.getDemoid())).findFirst();
        String demId = "";
        if (first.isPresent()) {
            demId = first.get().getDemoid();
        } else {
            Demension defaultDemension = this.demensionManager.getDefaultDemension();
            if (defaultDemension == null) {
                return;
            }
            demId = defaultDemension.getId();
        }
        List userIds = records.stream().map(UserSeletorDto::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(OrgUser::getUserId, userIds)).eq(OrgUser::getIsDelete, (Object)"0")).eq(OrgUser::getDemId, (Object)demId)).orderByAsc(OrgUser::getUserId)).orderByDesc(OrgUser::getIsMaster)).orderByDesc(OrgUser::getOrgId);
        List list = this.orgUserManager.list((Wrapper)wrapper);
        Iterator iterator = list.iterator();
        HashMap userOrgPostPolymerDtos = Maps.newHashMap();
        while (iterator.hasNext()) {
            OrgUser curData = (OrgUser)iterator.next();
            UserOrgPostPolymerDto userOrgPostPolymerDto = (UserOrgPostPolymerDto)userOrgPostPolymerDtos.get(curData.getUserId());
            if (BeanUtils.isEmpty((Object)userOrgPostPolymerDto)) {
                userOrgPostPolymerDto = new UserOrgPostPolymerDto();
                userOrgPostPolymerDto.setOrgIds(curData.getOrgId());
                userOrgPostPolymerDto.setId(curData.getUserId());
                userOrgPostPolymerDtos.put(curData.getUserId(), userOrgPostPolymerDto);
            }
            if (!userOrgPostPolymerDto.getId().equals(curData.getUserId()) || !userOrgPostPolymerDto.getOrgIds().equals(curData.getOrgId())) continue;
            if (StringUtil.isEmpty((String)userOrgPostPolymerDto.getPostIds())) {
                userOrgPostPolymerDto.setPostIds(curData.getRelId());
                continue;
            }
            userOrgPostPolymerDto.setPostIds(userOrgPostPolymerDto.getPostIds() + "," + curData.getRelId());
        }
        List<UserOrgPostPolymerVo> userOrgPostPolymerVos = this.convertUserOrgPostPolymerDto(userOrgPostPolymerDtos.values().stream().collect(Collectors.toList()));
        if (userOrgPostPolymerVos.isEmpty()) {
            return;
        }
        Map<String, List<UserOrgPostPolymerVo>> userOrgPostPolymerVoMap = userOrgPostPolymerVos.stream().collect(Collectors.groupingBy(UserOrgPostPolymerVo::getId));
        records.stream().forEach(item -> {
            UserOrgPostPolymerVo userOrgPostPolymerVo;
            if (userOrgPostPolymerVoMap.containsKey(item.getId()) && BeanUtils.isNotEmpty((userOrgPostPolymerVo = (UserOrgPostPolymerVo)((List)userOrgPostPolymerVoMap.get(item.getId())).get(0)).getPostNames())) {
                List orgNames = userOrgPostPolymerVo.getOrgNames().stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(orgNames)) {
                    item.setOrgname((String)orgNames.get(0));
                }
                item.setPostname(StringUtil.join((Collection)userOrgPostPolymerVo.getPostNames().stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList()), (String)"/"));
            }
        });
    }

    @Override
    public IPage<User> getGroupUserQuery(QueryFilter filter) throws Exception {
        PageBean pageBean = filter.getPageBean();
        this.copyQuerysInParams(filter);
        return ((UserDao)this.baseMapper).getUserListByGroupIdMap((IPage<User>)this.convert2IPage(pageBean), (Wrapper<User>)this.convert2Wrapper(filter, this.currentModelClass()));
    }

    @Override
    public List<User> getByAccounts(List<String> accounts) throws Exception {
        return ((UserDao)this.baseMapper).getByAccounts(accounts);
    }

    @Override
    public boolean insertBatch(List<User> list) {
        return this.saveBatch(list);
    }

    @Override
    public boolean updateBatch(List<User> list) {
        return ((UserDao)this.baseMapper).updateBatch(list);
    }

    @Override
    public List<User> getByCompanyRole(String company, String role) {
        List<User> list = ((UserDao)this.baseMapper).getUserListByOrgCode(company);
        List<User> roleList = this.getUserListByRoleCode(role);
        List<User> intersection = list.stream().filter(t -> roleList.stream().anyMatch(t2 -> t2.getId().equals(t.getId()))).collect(Collectors.toList());
        return intersection;
    }

    @Override
    public List<UserVo> getLeaderStep(String userId, Integer grade, boolean res) throws Exception {
        List<User> superFromUnder;
        List<Org> orgList = this.orgService.getParantMainOrgAll(userId);
        Collections.sort(orgList, new Comparator<Org>(){

            @Override
            public int compare(Org o1, Org o2) {
                if (Integer.parseInt(o1.getGrade()) > Integer.parseInt(o2.getGrade())) {
                    return -1;
                }
                if (o1.getGrade().equals(o2.getGrade())) {
                    return 0;
                }
                return 1;
            }
        });
        ArrayList<UserVo> list = new ArrayList<UserVo>();
        if (res && BeanUtils.isNotEmpty(superFromUnder = this.getSuperFromUnder(userId, null, null))) {
            for (User user : superFromUnder) {
                list.add(new UserVo(user));
            }
        }
        orgList = this.handleOrgList(orgList, grade);
        for (int i = 0; i < orgList.size(); ++i) {
            List<UserVo> vo;
            Org item = orgList.get(i);
            if (grade > Integer.parseInt(item.getGrade()) || !BeanUtils.isNotEmpty(vo = this.getDepHeaderByOrg(item.getId(), true))) continue;
            list.addAll(vo);
        }
        return list;
    }

    private ArrayList<Org> handleOrgList(List<Org> orgList, Integer grade) {
        ArrayList<Org> newArr = new ArrayList<Org>();
        Integer i = 5;
        while (i >= grade) {
            HashMap<String, Org> orgMap = new HashMap<String, Org>();
            for (Org org : orgList) {
                if (Integer.parseInt(org.getGrade()) != i) continue;
                orgMap.put(org.getId(), org);
            }
            if (!BeanUtils.isEmpty(orgMap)) {
                if (orgMap.size() == 1) {
                    for (String s : orgMap.keySet()) {
                        newArr.add((Org)orgMap.get(s));
                    }
                } else {
                    LinkedList orgLinkedList = new LinkedList();
                    Integer time = 0;
                    while (orgMap.size() >= 1) {
                        for (String key : orgMap.keySet()) {
                            if (!orgMap.containsKey(((Org)orgMap.get(key)).getParentId())) {
                                orgLinkedList.addLast(orgMap.remove(key));
                                time = 0;
                                break;
                            }
                            Integer n = time;
                            Integer n2 = time = Integer.valueOf(time + 1);
                        }
                        if (time <= orgMap.size()) continue;
                        for (String s : orgMap.keySet()) {
                            orgLinkedList.addLast(orgMap.get(s));
                        }
                    }
                    while (orgLinkedList.size() > 0) {
                        newArr.add((Org)orgLinkedList.removeLast());
                    }
                }
            }
            Integer n = i;
            i = i - 1;
            Integer n3 = i;
        }
        return newArr;
    }

    @Override
    public List<User> getFgUsers(String orgId, String orgParam, String userParam) {
        List<User> list = new ArrayList<User>();
        OrgParams orgParams = this.orgParamsService.getByOrgIdAndAlias(orgId, orgParam);
        if (BeanUtils.isNotEmpty((Object)orgParams) && StringUtil.isNotEmpty((String)orgParams.getValue())) {
            String value = orgParams.getValue();
            String sql = "SELECT USER_ID_ from UC_USER_PARAMS  WHERE CODE_ ='" + userParam + "' AND VALUE_='" + value + "'";
            list = ((UserDao)this.baseMapper).selectList((Wrapper)Wrappers.lambdaQuery().inSql(User::getId, sql));
        }
        return list;
    }

    @Override
    public List<UserVo> getLeaderStepByOrgId(String orgId, Integer grade) throws Exception {
        Org org = (Org)this.orgService.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org)) {
            return new ArrayList<UserVo>();
        }
        ArrayList<UserVo> list = new ArrayList<UserVo>();
        List<UserVo> leadIds = this.getDepHeaderByOrg(orgId, true);
        if (BeanUtils.isNotEmpty(leadIds)) {
            list.addAll(leadIds);
        }
        if (Integer.parseInt(org.getGrade()) > grade) {
            Org parent;
            String parentId = org.getParentId();
            while (!BeanUtils.isEmpty((Object)(parent = (Org)this.orgService.get((Serializable)((Object)parentId)))) && Integer.parseInt(parent.getGrade()) >= grade) {
                List<UserVo> userIds = this.getDepHeaderByOrgId(parent.getId(), true);
                if (BeanUtils.isNotEmpty(userIds)) {
                    for (UserVo userId : userIds) {
                        if (!this.isUserNotInList(list, userId)) continue;
                        list.add(userId);
                    }
                }
                parentId = parent.getParentId();
            }
        }
        if (BeanUtils.isEmpty(list)) {
            return new ArrayList<UserVo>();
        }
        return list;
    }

    @Override
    public ResponseEntity<?> getAppUserMsg(String account) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            QueryFilter filter = QueryFilter.build();
            filter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1000)));
            if (StringUtil.isNotEmpty((String)account)) {
                filter.addFilter("u.ACCOUNT_", (Object)account, QueryOP.EQUAL);
                User user = this.getByAccount(account);
                map.put("user", user);
            }
            IPage<HashMap<String, Object>> orgUserRels = this.orgUserManager.getUserByGroup(filter);
            map.put("orgUserRels", (Serializable)orgUserRels);
            map.put("success", Boolean.valueOf(true));
            return ResponseEntity.ok(map);
        }
        catch (Exception e) {
            return ResponseEntity.notFound().build();
        }
    }

    @Override
    public ResponseEntity<?> getAppOrgMsg(String orgCode) {
        try {
            HashMap<String, List<User>> object = new HashMap<String, List<User>>();
            Org org = this.orgManager.getByCode(orgCode);
            if (org == null) {
                throw new Exception("\u627e\u4e0d\u5230\u7ec4\u7ec7");
            }
            QueryFilter orgUserFilter = QueryFilter.build();
            orgUserFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(1000)));
            orgUserFilter.addParams("orgId", (Object)org.getId());
            List<User> orgUserList = this.queryOrgUser(orgUserFilter);
            QueryFilter orgfilter = QueryFilter.build();
            orgfilter.addParams("demId", (Object)org.getDemId());
            orgfilter.addParams("parentId", (Object)(" ('" + org.getId() + "') "));
            ArrayList<OrgTree> orgTreeList = new ArrayList<OrgTree>();
            List<Org> groupList = this.orgManager.getByParentAndDem(orgfilter);
            for (Org group : groupList) {
                OrgTree groupTree = new OrgTree(group);
                orgTreeList.add(groupTree);
            }
            object.put("orgUserList", orgUserList);
            object.put("orgTreeList", orgTreeList);
            return ResponseEntity.ok(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.notFound().build();
        }
    }

    @Override
    public CommonResult<String> bindOpenId(String account, String openid) {
        if (StringUtil.isNotEmpty((String)account)) {
            try {
                User u = this.getByAccount(account);
                UserUnite userUnite = new UserUnite();
                userUnite.setUserId(u.getId());
                userUnite.setOpenId(openid);
                this.userUniteManager.updateUserUnite(userUnite);
            }
            catch (Exception e) {
                return new CommonResult(false, "\u66f4\u65b0\u7528\u6237openId\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u66f4\u65b0\u7528\u6237openId\u6210\u529f");
    }

    @Override
    public CommonResult<String> bindMpOpenId(String account, String mpOpenid) {
        if (StringUtil.isNotEmpty((String)account)) {
            try {
                User u = this.getByAccount(account);
                UserUnite userUnite = new UserUnite();
                userUnite.setUserId(u.getId());
                userUnite.setMpOpenId(mpOpenid);
                this.userUniteManager.updateUserUnite(userUnite);
            }
            catch (Exception e) {
                return new CommonResult(false, "\u66f4\u65b0\u7528\u6237openId\u5931\u8d25");
            }
        }
        return new CommonResult(true, "\u66f4\u65b0\u7528\u6237openId\u6210\u529f");
    }

    @Override
    public Map<String, Object> updateUserMessage(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (!params.containsKey("account")) {
                throw new Exception("\u7f3a\u5c11account\u53c2\u6570");
            }
            User user = this.getByAccount(params.get("account").toString());
            boolean flag = false;
            if (params.containsKey("mobile")) {
                flag = true;
                user.setMobile(params.get("mobile").toString());
            }
            if (params.containsKey("email")) {
                flag = true;
                user.setEmail(params.get("email").toString());
            }
            if (params.containsKey("fullname")) {
                flag = true;
                user.setFullname(params.get("fullname").toString());
            }
            if (params.containsKey("photo")) {
                flag = true;
                String fileId = params.getOrDefault("photo", "").toString();
                if (!"".equals(fileId)) {
                    String photo = "/system/file/v1/downloadFile?fileId=" + fileId;
                    user.setPhoto(photo);
                    map.put("photo", photo);
                }
            }
            if (flag) {
                this.update((Model)user);
            }
            map.put("success", true);
        }
        catch (Exception e) {
            map.put("success", false);
            map.put("message", "\u7cfb\u7edf\u9519\u8bef");
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public CommonResult getApiToken(String sysCode, String secretKey, String account) {
        CommonResult result;
        User user = null;
        if (account != null) {
            result = this.checkUser(account);
            if (!result.getState().booleanValue()) {
                return result;
            }
            user = (User)result.getValue();
        }
        result = this.portalFeignService.checkSysCode(sysCode, secretKey);
        logger.debug("\u7cfb\u7edf\u7f16\u7801\u548c\u7cfb\u7edf\u5bc6\u5319\u68c0\u6d4b\u7ed3\u679c\uff1a{}", (Object)result);
        if (result.getState().booleanValue()) {
            String username = "";
            if (account == null) {
                try {
                    user = this.getUserNameById((String)result.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sysCode", sysCode);
            map.put("username", user.getUsername());
            map.put("tenantId", user.getTenantId());
            String token = this.jwtTokenHandler.doOpenApiToken(map, user.getUsername());
            logger.debug("\u7528\u6237\u7684\u8d26\u53f7:{},\u673a\u5668\u4ebaID\uff1a{}\uff0c\u751f\u6210\u7684Token\u662f\uff0c{}", new Object[]{account, result.getValue(), token});
            return new CommonResult(true, "\u83b7\u53d6\u5bf9\u5916\u63a5\u53e3\u8bbf\u95ee\u6743\u9650Token\u6210\u529f", (Object)token);
        }
        return result;
    }

    @Override
    public CommonResult getUserNameAndId() {
        QueryWrapper userQueryWrapper = new QueryWrapper();
        ((QueryWrapper)userQueryWrapper.eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"STATUS_", (Object)"1");
        List users = this.userDao.selectList((Wrapper)userQueryWrapper);
        LinkedList list = new LinkedList();
        users.stream().forEach(user -> {
            UserVO userVo = new UserVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)user, (Object)userVo);
            list.add(userVo);
        });
        return new CommonResult().value(list);
    }

    @Override
    public String getAccountByUserId(String userId) {
        return ((UserDao)this.baseMapper).getAccountByUserId(userId);
    }

    @Override
    public List<Map<String, Object>> calculateNodeUsers(List<Map<String, Object>> result) {
        for (int i = result.size() - 1; i > -1; --i) {
            boolean bl;
            Map<String, Object> nodeMap = result.get(i);
            List<Object> recievers = new ArrayList();
            ArrayList<ObjectNode> bpmIdentityList = new ArrayList<ObjectNode>();
            try {
                recievers = this.extractUser((List)nodeMap.get("excutorList"));
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            }
            int postCodeNullCount = 0;
            if (nodeMap.containsKey("emptySkip") && ((Boolean)nodeMap.get("emptySkip")).booleanValue()) {
                for (IUser iUser : recievers) {
                    if (!"postCode_null".equals(iUser.getAccount())) continue;
                    ++postCodeNullCount;
                }
            }
            if ((recievers.size() == 0 || postCodeNullCount == recievers.size()) && nodeMap.containsKey("emptySkip") && ((Boolean)nodeMap.get("emptySkip")).booleanValue() && !"end".equals((String)nodeMap.get("nodeType"))) {
                result.remove(i);
                continue;
            }
            boolean isPartner = false;
            boolean bl2 = false;
            ArrayList<String> partnerNames = new ArrayList<String>();
            for (IUser iUser : recievers) {
                ObjectNode bpmIdentity = JsonUtil.getMapper().createObjectNode();
                if ("partnerRule_null".equals(iUser.getAccount())) {
                    isPartner = true;
                    partnerNames.add(iUser.getFullname());
                    continue;
                }
                if ("postCode_null".equals(iUser.getAccount())) {
                    bl = true;
                    partnerNames.add(iUser.getFullname());
                    continue;
                }
                bpmIdentity.put("type", "user");
                bpmIdentity.put("id", iUser.getUserId());
                bpmIdentity.put("name", iUser.getFullname());
                bpmIdentityList.add(bpmIdentity);
            }
            if (BeanUtils.isNotEmpty(bpmIdentityList) && bpmIdentityList.size() == 1) {
                nodeMap.put("excutor", bpmIdentityList.get(0));
                nodeMap.put("excutorList", "");
            } else {
                HashSet<String> set = new HashSet<String>();
                Iterator iterator = bpmIdentityList.iterator();
                while (iterator.hasNext()) {
                    ObjectNode element = (ObjectNode)iterator.next();
                    if (set.contains(element.get("id").asText())) {
                        iterator.remove();
                        continue;
                    }
                    set.add(element.get("id").asText());
                }
                nodeMap.put("excutorList", bpmIdentityList);
            }
            if (isPartner) {
                nodeMap.put("isPartner", isPartner);
                nodeMap.put("partnerTitle", StringUtils.join(partnerNames, (String)",") + "\u4eba\u5458\u4e3a\u7a7a");
            }
            if (!bl) continue;
            nodeMap.put("isPostCodeNull", bl);
            nodeMap.put("partnerTitle", StringUtils.join(partnerNames, (String)",") + "\u4eba\u5458\u4e3a\u7a7a");
        }
        return result;
    }

    @Override
    public HashMap<String, Object> calculateNodeUsers(HashMap<String, Object> result) {
        for (String key : result.keySet()) {
            boolean bl;
            Map nodeMap = (Map)result.get(key);
            List<Object> recievers = new ArrayList();
            ArrayList<ObjectNode> bpmIdentityList = new ArrayList<ObjectNode>();
            try {
                recievers = this.extractUser((List)nodeMap.get("excutorList"));
            }
            catch (Exception e) {
                logger.error("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
            }
            int postCodeNullCount = 0;
            if (((Boolean)nodeMap.get("emptySkip")).booleanValue()) {
                for (IUser iUser : recievers) {
                    if (!"postCode_null".equals(iUser.getAccount())) continue;
                    ++postCodeNullCount;
                }
            }
            if (BeanUtils.isEmpty(recievers) && ((Boolean)nodeMap.get("emptySkip")).booleanValue() && !"end".equals((String)nodeMap.get("nodeType"))) {
                nodeMap.put("isSkip", true);
                nodeMap.put("excutorList", bpmIdentityList);
                continue;
            }
            boolean isPartner = false;
            boolean bl2 = false;
            ArrayList<String> partnerNames = new ArrayList<String>();
            for (IUser iUser : recievers) {
                ObjectNode bpmIdentity = JsonUtil.getMapper().createObjectNode();
                if ("partnerRule_null".equals(iUser.getAccount())) {
                    isPartner = true;
                    partnerNames.add(iUser.getFullname());
                    continue;
                }
                if ("postCode_null".equals(iUser.getAccount())) {
                    bl = true;
                    partnerNames.add(iUser.getFullname());
                    continue;
                }
                bpmIdentity.put("type", "user");
                bpmIdentity.put("id", iUser.getUserId());
                bpmIdentity.put("name", iUser.getFullname());
                bpmIdentityList.add(bpmIdentity);
            }
            if (BeanUtils.isNotEmpty(bpmIdentityList) && bpmIdentityList.size() == 1) {
                nodeMap.put("excutor", bpmIdentityList.get(0));
                nodeMap.put("excutorList", bpmIdentityList);
            } else {
                HashSet<String> set = new HashSet<String>();
                Iterator iterator = bpmIdentityList.iterator();
                while (iterator.hasNext()) {
                    ObjectNode element = (ObjectNode)iterator.next();
                    if (set.contains(element.get("id").asText())) {
                        iterator.remove();
                        continue;
                    }
                    set.add(element.get("id").asText());
                }
                nodeMap.put("excutorList", bpmIdentityList);
            }
            if (isPartner) {
                nodeMap.put("isPartner", isPartner);
                nodeMap.put("partnerTitle", StringUtils.join(partnerNames, (String)",") + "\u4eba\u5458\u4e3a\u7a7a");
            }
            if (!bl) continue;
            nodeMap.put("isPostCodeNull", bl);
            nodeMap.put("partnerTitle", StringUtils.join(partnerNames, (String)",") + "\u4eba\u5458\u4e3a\u7a7a");
        }
        return result;
    }

    private boolean isUserNotInList(List<UserVo> list, UserVo user) {
        for (UserVo userVo : list) {
            if (!userVo.getId().equals(user.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void batchUpdateUsersFromExterUni(String type, List<WxUser> userList) {
        if (BeanUtils.isNotEmpty(userList)) {
            List userListHasMobile = userList.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getMobile())).collect(Collectors.toList());
            List existUserList = this.getAll();
            ArrayList<WxUser> willCreate = new ArrayList<WxUser>();
            ArrayList<UserUnite> userUniteList = new ArrayList<UserUnite>();
            ArrayList<OrgUser> orgUserList = new ArrayList<OrgUser>();
            for (WxUser wxUser : userListHasMobile) {
                Optional<User> exist = existUserList.stream().filter(e -> wxUser.getMobile().equals(e.getMobile())).findFirst();
                if (exist.isPresent()) {
                    UserUnite userUnite = new UserUnite();
                    userUnite.setUserId(exist.get().getUserId());
                    if ("weChatWork".equals(type)) {
                        userUnite.setWxWorkId(wxUser.getUserid());
                    } else if ("dingtalk".equals(type)) {
                        userUnite.setDingtalkId(wxUser.getUserid());
                    } else if ("flyBook".equals(type)) {
                        userUnite.setFlybookId(wxUser.getUserid());
                    }
                    userUniteList.add(userUnite);
                    if (!BeanUtils.isNotEmpty((Object)wxUser.getDepartment())) continue;
                    for (String deptid : wxUser.getDepartment()) {
                        OrgUser ou = new OrgUser();
                        ou.setUserId(exist.get().getUserId());
                        ou.setOrgId(this.ucOrgUniteManager.getOrgId(deptid, type));
                        orgUserList.add(ou);
                    }
                    continue;
                }
                willCreate.add(wxUser);
            }
            String initPwd = this.pwdStrategyManager.getDefault().getInitPwd();
            Role role = this.roleManager.getByAlias("ybyh");
            String roleId = "1";
            if (BeanUtils.isNotEmpty((Object)role)) {
                roleId = role.getId();
            }
            for (WxUser wxUser : willCreate) {
                wxUser.setPassword(initPwd);
                wxUser.setRoleId(roleId);
                User newUser = this.createUserFromWxUser(wxUser, "weChatWork".equals(type));
                UserUnite userUnite = new UserUnite();
                userUnite.setUserId(newUser.getUserId());
                if ("weChatWork".equals(type)) {
                    userUnite.setWxWorkId(wxUser.getUserid());
                } else if ("dingtalk".equals(type)) {
                    userUnite.setDingtalkId(wxUser.getUserid());
                } else if ("flyBook".equals(type)) {
                    userUnite.setFlybookId(wxUser.getUserid());
                }
                userUniteList.add(userUnite);
                if (!BeanUtils.isNotEmpty((Object)wxUser.getDepartment())) continue;
                for (String deptid : wxUser.getDepartment()) {
                    OrgUser ou = new OrgUser();
                    ou.setUserId(newUser.getUserId());
                    deptid = this.ucOrgUniteManager.getOrgId(deptid, type);
                    ou.setOrgId(deptid);
                    orgUserList.add(ou);
                }
            }
            this.orgUserManager.batchUpdateOrgUser(orgUserList);
            this.userUniteManager.updateUserUniteList(userUniteList);
        }
    }

    public User createUserFromWxUser(WxUser wxUser, boolean isWeChatWork) {
        User newUser = new User();
        newUser.setFullname(wxUser.getName());
        newUser.setAccount(isWeChatWork ? wxUser.getUserid() : wxUser.getMobile());
        newUser.setMobile(wxUser.getMobile());
        newUser.setId(UniqueIdUtil.getSuid());
        newUser.setStatus(1);
        newUser.setCreateTime(LocalDateTime.now());
        newUser.setFrom("restful");
        newUser.setPassword(this.passwordEncoder.encode((CharSequence)wxUser.getPassword()));
        newUser.setPwdCreateTime(LocalDateTime.now());
        User user = this.getByAccount(newUser.getAccount());
        if (user != null) {
            return user;
        }
        try {
            this.create((Model)newUser);
            UserRole userRole = new UserRole();
            userRole.setId(UniqueIdUtil.getSuid());
            userRole.setRoleId(wxUser.getRoleId());
            userRole.setUserId(newUser.getId());
            this.userRoleManager.save(userRole);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return newUser;
    }

    private CommonResult checkUser(String account) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"account_", (Object)account);
        User user = (User)this.userDao.selectOne((Wrapper)queryWrapper);
        if (user == null) {
            logger.info("\u7528\u6237\u8d26\u53f7\uff1a{},\u4e0d\u5b58\u5728", (Object)account);
            return new CommonResult(false, "\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (user.getStatus() != 1) {
            String msg = "";
            switch (user.getStatus()) {
                case 0: {
                    msg = "\u8be5\u8d26\u53f7\u5df2\u88ab\u7981\u7528";
                    break;
                }
                case -1: {
                    msg = "\u8be5\u8d26\u53f7\u672a\u88ab\u6fc0\u6d3b";
                    break;
                }
                case -2: {
                    msg = "\u8be5\u7528\u6237\u8d26\u53f7\u5df2\u79bb\u804c";
                }
            }
            return new CommonResult(false, msg);
        }
        return new CommonResult(true, "\u7528\u6237\u4fe1\u606f\u9a8c\u8bc1\u6b63\u786e", (Object)user);
    }

    private User getUserNameById(String id) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id_", (Object)id);
        User user = null;
        try (MultiTenantIgnoreResult result = MultiTenantHandler.setThreadLocalIgnore();){
            user = (User)this.userDao.selectOne((Wrapper)queryWrapper);
        }
        return user;
    }

    @Cacheable(value={"eip:uc:current_user_group_id"}, key="#userId", firstCache=@FirstCache(expireTime=100, timeUnit=TimeUnit.DAYS))
    public String getCurrentGroupIdFromCache(String userId) {
        return null;
    }

    @Override
    public List<User> getUsersByRoleCode(List<String> codes) {
        List<User> usersByRoleCode = ((UserDao)this.baseMapper).getUsersByRoleCode(codes);
        List<Role> roleList = this.roleManager.getRoleByCodes(codes);
        if (CollUtil.isNotEmpty(roleList)) {
            List roleIdList = roleList.stream().map(Role::getId).collect(Collectors.toList());
            List orgRoleList = this.orgRoleManager.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(OrgRole::getRoleId, roleIdList)).eq(UcBaseModel::getIsDelete, (Object)0));
            if (CollUtil.isNotEmpty((Collection)orgRoleList)) {
                List subOrgList;
                ArrayList<String> orgIdList = new ArrayList<String>();
                ArrayList<String> orgIdInheritList = new ArrayList<String>();
                for (OrgRole orgRole : orgRoleList) {
                    orgIdList.add(orgRole.getOrgId());
                    if (orgRole.getIsInherit() != 1) continue;
                    orgIdInheritList.add(orgRole.getOrgId());
                }
                if (CollUtil.isNotEmpty(orgIdInheritList) && CollUtil.isNotEmpty((Collection)(subOrgList = this.orgManager.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(Org::getParentId, orgIdInheritList)).eq(UcBaseModel::getIsDelete, (Object)0))))) {
                    orgIdList.addAll(subOrgList.stream().map(Org::getId).collect(Collectors.toList()));
                }
                List<User> usersByOrgRoleId = ((UserDao)this.baseMapper).getUserListByOrgIds(orgIdList);
                usersByRoleCode.addAll(usersByOrgRoleId);
            }
        }
        Map userMap = usersByRoleCode.stream().collect(Collectors.toMap(User::getId, Function.identity(), (t1, t2) -> t1));
        return Lists.newArrayList(userMap.values());
    }

    @Override
    public PageList<UserOrgPostPolymerVo> getUserOrgPostPolymer(UserPolymerParam userPolymerParam) {
        PageList result = new PageList((List)Lists.newArrayList());
        PageBean pageBean = new PageBean(Integer.valueOf(userPolymerParam.getPage()), Integer.valueOf(userPolymerParam.getPageSize()));
        HashMap param = Maps.newHashMap();
        param.put("type", userPolymerParam.getType());
        if ("role".equals(userPolymerParam.getType())) {
            List<String> userIds = this.userRoleManager.getListByRoleId(userPolymerParam.getId()).stream().map(UserRole::getUserId).collect(Collectors.toList());
            if (BeanUtils.isEmpty(userIds)) {
                return result;
            }
            userPolymerParam.setType("user");
            userPolymerParam.setIds(userIds);
        }
        if ("user".equals(userPolymerParam.getType())) {
            List partition = Lists.partition(userPolymerParam.getIds(), (int)(pageBean.getPageSize() > 0 ? pageBean.getPageSize() : 1000));
            if (!PageBean.WITHOUT_PAGE.equals(pageBean.getPageSize())) {
                List curPageUserIds = (List)partition.get(pageBean.getPage() - 1);
                partition = Lists.newArrayList();
                partition.add(curPageUserIds);
            }
            for (List ids : partition) {
                param.put("ids", ids);
                param.put("type", "user");
                IPage<UserOrgPostPolymerDto> page = ((UserDao)this.baseMapper).getUserOrgPostPolymer((IPage<User>)this.convert2IPage(pageBean), param);
                result.getRows().addAll(this.convertUserOrgPostPolymerDto(page.getRecords()));
                result.setTotal(page.getTotal());
                result.setPage((long)pageBean.getPage().intValue());
                result.setPageSize(result.getPageSize() + page.getSize());
            }
        } else {
            param.put("id", userPolymerParam.getId());
            IPage<UserOrgPostPolymerDto> page = "job".equals(userPolymerParam.getType()) || "position".equals(userPolymerParam.getType()) ? ((UserDao)this.baseMapper).getUserOrgPostPolymerByPost((IPage<User>)this.convert2IPage(pageBean), param) : ((UserDao)this.baseMapper).getUserOrgPostPolymer((IPage<User>)this.convert2IPage(pageBean), param);
            result.getRows().addAll(this.convertUserOrgPostPolymerDto(page.getRecords()));
            result.setTotal(page.getTotal());
            result.setPage(page.getCurrent());
            result.setPageSize(page.getSize());
        }
        return result;
    }

    @Override
    public PageList<UserSeletorDto> queryUserWithOrgPost(QueryFilter queryFilter) {
        PageList<UserSeletorDto> pageList = this.queryUserWithMainOrgPost(queryFilter);
        this.handleUserOrgPathsList(pageList);
        return pageList;
    }

    @Override
    public void handleUserOrgPathsList(PageList<UserSeletorDto> pageList) {
        if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
            ArrayList userIds = Lists.newArrayList();
            for (UserSeletorDto row : pageList.getRows()) {
                userIds.add(row.getId());
            }
            List<Org> orgByUserIds = this.orgManager.getOrgByUserIds(userIds);
            if (BeanUtils.isNotEmpty(orgByUserIds)) {
                Map<String, List<Org>> collect = orgByUserIds.stream().filter(org -> StringUtil.isNotEmpty((String)org.getPath())).collect(Collectors.groupingBy(Org::getOrgUserId));
                for (UserSeletorDto row : pageList.getRows()) {
                    String userId = row.getId();
                    if (!collect.containsKey(userId)) continue;
                    row.setPaths(collect.get(userId).stream().map(Org::getPath).collect(Collectors.toSet()));
                }
            }
        }
    }

    private List<UserOrgPostPolymerVo> convertUserOrgPostPolymerDto(List<UserOrgPostPolymerDto> list) {
        ArrayList vos = Lists.newArrayList();
        HashMap userOrgMap = Maps.newHashMap();
        HashMap userPostMap = Maps.newHashMap();
        HashSet orgIds = Sets.newHashSet();
        HashSet postIds = Sets.newHashSet();
        for (UserOrgPostPolymerDto dto : list) {
            Collection<Object> ids;
            UserOrgPostPolymerVo vo = new UserOrgPostPolymerVo();
            vo.setId(dto.getId());
            vo.setAccount(dto.getAccount());
            vo.setFullname(dto.getFullname());
            vo.setPhoto(dto.getPhoto());
            if (StringUtils.isNotEmpty((String)dto.getOrgIds())) {
                ids = Sets.newHashSet(Arrays.asList(dto.getOrgIds().split(",")));
                userOrgMap.put(dto.getId(), ids);
                orgIds.addAll(ids);
            }
            if (StringUtils.isNotEmpty((String)dto.getPostIds())) {
                ids = Arrays.asList(dto.getPostIds().split(","));
                userPostMap.put(dto.getId(), ids);
                postIds.addAll(ids);
            }
            vos.add(vo);
        }
        Map<Object, Object> orgsMap = Maps.newHashMap();
        Map<Object, Object> orgPostsMap = Maps.newHashMap();
        if (BeanUtils.isNotEmpty((Object)orgIds)) {
            List orgs = this.orgManager.listByIds(orgIds);
            orgsMap = orgs.stream().collect(Collectors.groupingBy(Org::getId));
        }
        if (BeanUtils.isNotEmpty((Object)postIds)) {
            List posts = this.orgPostManager.listByIds(postIds);
            orgPostsMap = posts.stream().collect(Collectors.groupingBy(OrgPost::getId));
        }
        for (UserOrgPostPolymerVo vo : vos) {
            Collection ids;
            if (userOrgMap.containsKey(vo.getId())) {
                ids = (Set)userOrgMap.get(vo.getId());
                for (String id : ids) {
                    if (!orgsMap.containsKey(id)) continue;
                    vo.getOrgNames().add(((Org)((List)orgsMap.get(id)).get(0)).getName());
                }
            }
            if (!userPostMap.containsKey(vo.getId())) continue;
            ids = (List)userPostMap.get(vo.getId());
            for (String id : ids) {
                if (!BeanUtils.isNotEmpty((Object)orgPostsMap.get(id))) continue;
                vo.getPostNames().add(((OrgPost)((List)orgPostsMap.get(id)).get(0)).getName());
            }
        }
        return vos;
    }

    @Override
    public List<Map<String, Object>> getUserByUserId(String userId) {
        List<Map<String, Object>> mapList = this.orgPostManager.getUserByUserId(userId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Role> roles = this.roleManager.getListByUserId(userId);
        List roleNames = roles.stream().map(Role::getName).collect(Collectors.toList());
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("roleName", StringUtil.join(roleNames, (String)"|"));
        map.put("roleName", objectNode);
        map.put("roles", roles);
        mapList.add(map);
        return mapList;
    }

    @Override
    public List<UserVo> getUsersByOrgId(String orgId) throws Exception {
        if (StringUtil.isEmpty((String)orgId)) {
            return new ArrayList<UserVo>();
        }
        Org org = (Org)this.orgManager.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org)) {
            return new ArrayList<UserVo>();
        }
        return this.orgManager.getUsersByOrgCodes(org.getCode(), true);
    }

    @Override
    public List<User> getUserByOrgParams(String code, String relation, String value, String type) {
        List<Org> orgList = this.orgManager.getByOrgParams(code, relation, value);
        if (BeanUtils.isEmpty(orgList)) {
            return new ArrayList<User>();
        }
        List orgIds = orgList.stream().map(Org::getId).collect(Collectors.toList());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().ge((Object)"orguser.is_charge_", (Object)type)).in((Object)"orguser.org_id_", orgIds)).eq((Object)"u.is_dele_", (Object)"0")).eq((Object)"u.status_", (Object)1);
        return ((UserDao)this.baseMapper).selectUserJoinOrgUser((Wrapper<User>)wrapper);
    }

    @Override
    @CacheEvict(value={"eip:uc:user:frontStyle"}, key="#userId", ignoreException=false)
    public void saveFrontStyle(String json, String userId) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(User::getId, (Object)userId)).set(User::getFrontStyle, (Object)json);
        this.update((Wrapper)wrapper);
    }

    @Override
    public String getFrontStyle(String userId) {
        String frontStyle = ((UserManager)AppUtil.getBean(UserManager.class)).getFrontStyleFromCache(userId);
        if (StringUtil.isNotEmpty((String)frontStyle)) {
            return frontStyle;
        }
        String tenantId = Optional.ofNullable(TenantUtil.getCurrentTenantId()).orElse("-1");
        return this.tenantManageManager.getDefaultStyleById(tenantId);
    }

    @Override
    @Cacheable(value={"eip:uc:user:frontStyle"}, key="#userId", ignoreException=false)
    public String getFrontStyleFromCache(String userId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{User::getFrontStyle}).eq(User::getId, (Object)userId);
        User user = (User)this.getOne((Wrapper)wrapper);
        return Optional.ofNullable(user).map(User::getFrontStyle).orElse(null);
    }
}

