/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.UserParamsDao;
import com.hotent.uc.manager.UserParamsManager;
import com.hotent.uc.model.UserParams;
import java.sql.SQLException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserParamsManagerImpl
extends BaseManagerImpl<UserParamsDao, UserParams>
implements UserParamsManager {
    @Override
    public List<UserParams> getByUserId(String id) {
        return ((UserParamsDao)this.baseMapper).getByUserId(id);
    }

    @Override
    @Transactional
    public void saveParams(String userId, List<ObjectNode> lists) throws SQLException {
        for (ObjectNode ObjectNode2 : lists) {
            UserParams params = this.getByUserIdAndAlias(userId, ObjectNode2.get("alias").asText());
            if (BeanUtils.isNotEmpty((Object)params)) {
                if (ObjectNode2.hasNonNull("value") && !"null".equals(ObjectNode2.get("value").asText())) {
                    params.setValue(ObjectNode2.get("value").asText());
                } else {
                    params.setValue("");
                }
                this.update((Model)params);
                continue;
            }
            UserParams userParams = new UserParams();
            userParams.setAlias(ObjectNode2.get("alias").asText());
            if (!"null".equals(ObjectNode2.get("value"))) {
                userParams.setValue(ObjectNode2.get("value").asText());
            }
            userParams.setUserId(userId);
            userParams.setId(UniqueIdUtil.getSuid());
            this.create((Model)userParams);
        }
    }

    @Override
    public UserParams getByUserIdAndAlias(String userId, String key) {
        return ((UserParamsDao)this.baseMapper).getByUserIdAndCode(userId, key);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserParamsDao)this.baseMapper).removePhysical();
    }
}

