/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.uc.dao.UserRoleDao;
import com.hotent.uc.manager.RoleManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.model.Role;
import com.hotent.uc.model.UcBaseModel;
import com.hotent.uc.model.UserRole;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import poi.easypoi.util.ExcelUtils;
import poi.util.ExcelUtil;

@Service
public class UserRoleManagerImpl
extends BaseManagerImpl<UserRoleDao, UserRole>
implements UserRoleManager {
    @Resource
    RoleManager roleService;

    @Override
    public UserRole getByRoleIdUserId(String roleId, String userId) {
        return ((UserRoleDao)this.baseMapper).getByRoleIdUserId(roleId, userId);
    }

    @Override
    public List<UserRole> getListByUserId(String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.getParamNameValuePairs();
        if (params != null && params.size() > 0) {
            Map paramNameValuePairs = wrapper.getParamNameValuePairs();
            paramNameValuePairs.putAll(params);
        }
        return ((UserRoleDao)this.baseMapper).queryByParams((Wrapper<UserRole>)wrapper);
    }

    @Override
    public List<UserRole> getListByRoleId(String roleId) {
        return ((UserRoleDao)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRole::getRoleId, (Object)roleId)).eq(UcBaseModel::getIsDelete, (Object)"0"));
    }

    @Override
    public List<UserRole> getListByAlias(String alias) {
        return ((UserRoleDao)this.baseMapper).getListByCode(alias);
    }

    @Override
    @Transactional
    public void saveUserRole(String account, String ... roleCodes) throws Exception {
        List<UserRole> userRoles = ((UserRoleDao)this.baseMapper).getByAccount(account);
        HashMap<String, UserRole> map = new HashMap<String, UserRole>();
        ArrayList<String> userRoleIds = new ArrayList<String>();
        for (UserRole userRole : userRoles) {
            userRoleIds.add(userRole.getId());
        }
        for (UserRole userRole : userRoles) {
            for (String code : roleCodes) {
                if (!code.equals(userRole.getAlias())) continue;
                map.put(code, userRole);
                userRoleIds.remove(userRole.getId());
            }
        }
        if (userRoleIds.size() > 0) {
            String[] ids = new String[userRoleIds.size()];
            userRoleIds.toArray(ids);
            this.removeByIds(ids);
        }
        Iterator keyIt = map.keySet().iterator();
        ArrayList<String> roleCodeList = new ArrayList<String>(Arrays.asList(roleCodes));
        while (keyIt.hasNext()) {
            String code = (String)keyIt.next();
            roleCodeList.remove(code);
            UserRole userRole = (UserRole)map.get(code);
            userRole.setIsDelete("0");
            this.update((Model)userRole);
        }
        for (String roleCode : roleCodeList) {
            this.roleService.saveUserRole(roleCode, account);
        }
    }

    @Override
    public void removeUserRole(String account, String ... roleCodes) {
        List<UserRole> userRoles = ((UserRoleDao)this.baseMapper).getByAccount(account);
        ArrayList<String> userRoleIds = new ArrayList<String>();
        for (UserRole userRole : userRoles) {
            for (String code : roleCodes) {
                if (!code.equals(userRole.getAlias())) continue;
                userRoleIds.add(userRole.getId());
            }
        }
        this.removeByIds(userRoleIds);
    }

    @Override
    public PageList<UserRole> getUserRolePage(QueryFilter queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        this.copyQuerysInParams(queryFilter);
        List boys = queryFilter.getQuerys();
        Optional<QueryField> queryFieldOptional = boys.stream().filter(s -> s.getProperty().equals("roleName")).findFirst();
        if (queryFieldOptional.isPresent()) {
            queryFilter.addFilter("r.NAME_", (Object)queryFieldOptional.get().getValue().toString(), QueryOP.LIKE);
            queryFilter.getQuerys().remove(queryFieldOptional.get());
        }
        IPage<UserRole> query = ((UserRoleDao)this.baseMapper).queryByParams((IPage<UserRole>)this.convert2IPage(pageBean), (Wrapper<UserRole>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(query);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserRoleDao)this.baseMapper).removePhysical();
    }

    @Override
    @Transactional
    public void removeByUserId(String id, LocalDateTime now) {
        ((UserRoleDao)this.baseMapper).removeByUserId(id, now);
    }

    @Override
    @Transactional
    public void removeByRoleId(String roleId, LocalDateTime now) {
        ((UserRoleDao)this.baseMapper).removeByRoleId(roleId, now);
    }

    @Override
    public boolean insertBatch(List<UserRole> list) {
        return this.saveBatch(list);
    }

    @Override
    public void addCommonRoleUser(String userId) {
        Role role = this.roleService.getByAlias("ybyh");
        String roleId = Optional.ofNullable(role).map(Role::getId).orElse("1");
        UserRole userRole = new UserRole();
        userRole.setId(UniqueIdUtil.getSuid());
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        this.save(userRole);
    }

    @Override
    public void exportUserRole(QueryFilter queryFilter, HttpServletResponse httpServletResponse) throws Exception {
        String filename = "";
        long start = System.currentTimeMillis();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (BeanUtils.isNotEmpty((Object)queryFilter.getParams())) {
            if (queryFilter.getParams().containsKey("ids") && BeanUtils.isNotEmpty(queryFilter.getParams().get("ids"))) {
                queryFilter.setQuerys(new ArrayList());
                queryFilter.withQuery(new QueryField("ur.id_", queryFilter.getParams().get("ids"), QueryOP.IN));
            }
            if (queryFilter.getParams().containsKey("titlePre") && queryFilter.getParams().get("titlePre") != null) {
                filename = filename + String.valueOf(queryFilter.getParams().get("titlePre"));
            }
        }
        filename = filename + "_\u6240\u5c5e\u89d2\u8272_" + String.valueOf(start);
        PageList<UserRole> userRolePage = this.getUserRolePage(queryFilter);
        List collect = userRolePage.getRows().stream().map(entity -> BeanUtil.beanToMap((Object)entity, (String[])new String[0])).collect(Collectors.toList());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("roleName", "\u540d\u79f0");
        map.put("alias", "\u7f16\u7801");
        Workbook sheets = ExcelUtils.exportExcel((String)filename, map, collect);
        ExcelUtil.downloadExcel((Workbook)sheets, (String)filename, (HttpServletResponse)httpServletResponse);
    }
}

