/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service;

import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.cache.annotation.SecondaryCache;
import com.hotent.base.constants.PlatformConsts;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.CertificateException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.manager.OrgManager;
import com.hotent.uc.manager.TenantManageManager;
import com.hotent.uc.manager.UserManager;
import com.hotent.uc.manager.UserRoleManager;
import com.hotent.uc.model.TenantManage;
import com.hotent.uc.model.User;
import com.hotent.uc.model.UserRole;
import com.hotent.uc.service.UserDetailsFacade;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Primary
@Service
public class UserManagerDetailsServiceImpl
implements UserDetailsService {
    @Resource
    UserManager userManager;
    @Resource
    UserRoleManager userRoleManager;
    @Resource
    UserDetailsFacade userDetailsFacade;
    @Resource
    OrgManager orgManager;
    @Resource
    TenantManageManager tenantManageManager;

    @Cacheable(value={"eip:uc:userAccount"}, key="#username", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, CertificateException {
        User user = this.convertUserDetails2User(this.loadUserByUsernameFromDB(username));
        Assert.notNull((Object)user, (String)("UserManagerDetailsServiceImpl.loadUserByUsernameFromDB  returned null for username " + username + ". This is an interface contract violation"));
        return user;
    }

    private UserDetails loadUserByUsernameFromDB(String username) {
        try {
            User user = this.userManager.getByAccount(username);
            if (BeanUtils.isEmpty((Object)user)) {
                throw new UsernameNotFoundException("");
            }
            if (StringUtil.isNotEmpty((String)user.getTenantId()) && !"-1".equals(user.getTenantId())) {
                TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)user.getTenantId()));
                if (BeanUtils.isEmpty((Object)((Object)tenant))) {
                    throw new CertificateException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u79df\u6237\u4fe1\u606f\u3002");
                }
                if (!"enable".equals(tenant.getStatus())) {
                    throw new CertificateException("\u7528\u6237\u6240\u5c5e\u79df\u6237\u672a\u542f\u7528\u3002");
                }
            }
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            if (user.isAdmin()) {
                authorities.add((GrantedAuthority)PlatformConsts.ROLE_GRANT_SUPER);
            }
            List<UserRole> userRoles = this.userRoleManager.getListByUserId(user.getId());
            for (UserRole userRole : userRoles) {
                SimpleGrantedAuthority role = new SimpleGrantedAuthority(userRole.getAlias());
                authorities.add((GrantedAuthority)role);
            }
            user.setAttributes(this.getOrgIdByUserId(user.getUserId()));
            return this.userDetailsFacade.loadUserDetails(authorities, user);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> getOrgIdByUserId(String userId) {
        List<String> subOrgByIds;
        HashMap<String, String> map = new HashMap<String, String>();
        List<Map<String, Object>> orgIdMapList = this.orgManager.getOrgIdMapByUserId(userId);
        ArrayList newOrgIdMapList = new ArrayList();
        if (BeanUtils.isNotEmpty(orgIdMapList)) {
            for (Map<String, Object> orgMap : orgIdMapList) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> next : orgMap.entrySet()) {
                    newMap.put(next.getKey().toLowerCase(), next.getValue());
                }
                newOrgIdMapList.add(newMap);
            }
        }
        HashSet<String> orgIds = new HashSet<String>();
        newOrgIdMapList.forEach(orgIdMap -> {
            String orgId = MapUtil.getString((Map)orgIdMap, (String)"orgid");
            String isMaster = MapUtil.getString((Map)orgIdMap, (String)"ismaster");
            String orgCode = MapUtil.getString((Map)orgIdMap, (String)"orgcode");
            String orgName = MapUtil.getString((Map)orgIdMap, (String)"orgname");
            if (StringUtil.isNotEmpty((String)orgId)) {
                orgIds.add(orgId);
            }
            if ("1".equals(isMaster)) {
                map.put("CURRENT_USER_MAIN_ORGID", orgId);
                map.put("CURRENT_USER_MAIN_ORGCODE", orgCode);
                map.put("CURRENT_USER_MAIN_ORGNAME", orgName);
            }
        });
        if (!orgIds.isEmpty()) {
            map.put("CURRENT_USER_ORGIDS", String.join((CharSequence)",", orgIds));
        }
        if (BeanUtils.isNotEmpty(subOrgByIds = this.orgManager.getSubOrgByIds(orgIds))) {
            HashSet<String> orgIdsAndSub = new HashSet<String>(subOrgByIds);
            orgIdsAndSub.addAll(orgIds);
            map.put("CURRENT_USER_SUB_ORGIDS", String.join((CharSequence)",", orgIdsAndSub));
        }
        return map;
    }

    private User convertUserDetails2User(UserDetails userDetails) {
        if (BeanUtils.isEmpty((Object)userDetails)) {
            return null;
        }
        if (userDetails instanceof User) {
            return (User)userDetails;
        }
        IUser iuser = (IUser)userDetails;
        String userId = iuser.getUserId();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        Collection extendsAuthorities = iuser.getAuthorities();
        if (BeanUtils.isNotEmpty((Object)extendsAuthorities)) {
            authorities.addAll(extendsAuthorities);
        }
        String account = iuser.getAccount();
        String fullname = iuser.getFullname();
        String password = iuser.getPassword();
        Integer status = iuser.getStatus();
        String email = iuser.getEmail();
        String mobile = iuser.getMobile();
        LocalDateTime pwdCreateTime = iuser.getPwdCreateTime();
        User user = new User(account, fullname, password, authorities);
        user.setUserId(userId);
        user.setEmail(email);
        user.setMobile(mobile);
        user.setStatus(status);
        user.setPwdCreateTime(pwdCreateTime);
        user.setClientId(iuser.getClientId());
        user.setClientToken(iuser.getClientToken());
        return user;
    }
}

