/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.matrix.impl;

import cn.hutool.db.sql.SqlBuilder;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.uc.model.Matrix;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.service.matrix.MatrixDataService;
import com.hotent.uc.service.matrix.impl.AbstractMatrixDataServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonMatrixDataServiceImpl
extends AbstractMatrixDataServiceImpl
implements MatrixDataService {
    public CommonMatrixDataServiceImpl(CommonManager commonManager) {
        super(commonManager);
    }

    @Override
    String generateSql(String matrixCode, List<MatrixColField> colFields) {
        StringBuilder sql = new StringBuilder("select ");
        ArrayList<String> fields = new ArrayList<String>();
        for (MatrixColField field : colFields) {
            fields.add(field.getField());
        }
        String dbType = SQLUtil.getDbType();
        if (dbType.equals("postgresql") || dbType.equals("oracle") || dbType.equals("dm") || dbType.equals("kingbasees")) {
            for (int i = 0; i < fields.size(); ++i) {
                sql.append((String)fields.get(i)).append(" as \"").append((String)fields.get(i)).append("\"");
                if (i == fields.size() - 1) continue;
                sql.append(",");
            }
        } else {
            sql.append(String.join((CharSequence)",", fields));
        }
        sql.append(" from UC_MATRIX_").append(matrixCode).append(" ");
        return sql.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(Matrix matrix, List<Map<String, Object>> list, String foreignKey) {
        this.validateDuplicate(matrix, list);
        this.validateEmpty(matrix, list);
        SqlBuilder removeSql = new SqlBuilder();
        removeSql.delete("UC_MATRIX_" + matrix.getCode());
        this.commonManager.execute(removeSql.toString());
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        List addList = list.stream().map(item -> this.convertNewData(matrix, (Map<String, Object>)item)).collect(Collectors.toList());
        this.commonManager.batchInsert("UC_MATRIX_" + matrix.getCode(), addList);
    }

    @Override
    public void save(Matrix matrix, Map<String, Object> data, String foreignKey) {
        if (BeanUtils.isNotEmpty(data)) {
            String existSql = this.constructIsCondKeyExistSql(matrix.getCode(), data);
            List query = this.commonManager.query(existSql);
            if (query != null && query.size() > 0) {
                throw new RuntimeException("\u6761\u4ef6\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\u3002");
            }
            boolean isCreate = BeanUtils.isEmpty((Object)data.get("ID_"));
            Map<String, Object> newData = this.convertNewData(matrix, data);
            if (!isCreate) {
                this.commonManager.batchUpdate("UC_MATRIX_" + matrix.getCode(), foreignKey, Collections.singletonList(newData), Boolean.valueOf(true));
            } else {
                this.commonManager.batchInsert("UC_MATRIX_" + matrix.getCode(), Collections.singletonList(newData));
            }
        }
    }

    private String constructIsCondKeyExistSql(String matrixCode, Map<String, Object> bean) {
        StringBuffer sb = new StringBuffer("select * from ");
        sb.append("UC_MATRIX_" + matrixCode);
        String dbType = SQLUtil.getDbType();
        ArrayList<String> setFields = new ArrayList<String>();
        for (String key : bean.keySet()) {
            if (!key.contains("CONDK_") && !key.contains("CONDV_")) continue;
            Object value = bean.get(key);
            if (BeanUtils.isNotEmpty((Object)value)) {
                if ("oracle".equals(dbType)) {
                    setFields.add("to_char(" + key + ") = '" + value + "'");
                    continue;
                }
                setFields.add(key + " = '" + value + "'");
                continue;
            }
            String empty = "(" + key + " is null or " + key + "='')";
            setFields.add(empty);
        }
        if (BeanUtils.isNotEmpty((Object)bean.get("ID_"))) {
            setFields.add("ID_ != '" + bean.get("ID_") + "'");
        }
        if (setFields.size() > 0) {
            sb.append(" where ");
        }
        sb.append(String.join((CharSequence)" and ", setFields));
        return sb.toString();
    }

    private void validateDuplicate(Matrix matrix, List<Map<String, Object>> list) {
        HashMap<String, Integer> keySet = new HashMap<String, Integer>();
        int index = 0;
        for (Map<String, Object> data : list) {
            ++index;
            ArrayList<String> keys = new ArrayList<String>();
            for (MatrixColDef cond : matrix.getCondList()) {
                Object value = MapUtil.getIgnoreCase(data, (String)cond.getCondkFieldName(), (Object)"null");
                keys.add(String.valueOf(value));
            }
            String key = String.join((CharSequence)"-", keys);
            if (keySet.containsKey(key)) {
                throw new BaseException(String.format("\u7b2c%d\u4e0e\u7b2c%d\u7684\u6761\u4ef6\u7ec4\u5408\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\uff01", keySet.get(key), index));
            }
            keySet.put(key, index);
        }
    }

    private void validateEmpty(Matrix matrix, List<Map<String, Object>> list) {
        int index = 0;
        for (Map<String, Object> data : list) {
            boolean empty = true;
            ++index;
            for (MatrixColDef cond : matrix.getCondList()) {
                Object value = MapUtil.getIgnoreCase(data, (String)cond.getCondkFieldName());
                empty &= BeanUtils.isEmpty((Object)value);
            }
            if (!empty) continue;
            throw new BaseException(String.format("\u7b2c%d\u884c\u6761\u4ef6\u4e0d\u80fd\u5168\u4e3a\u7a7a", index));
        }
    }
}

