/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.service.matrix.impl;

import cn.hutool.db.sql.Condition;
import cn.hutool.db.sql.SqlBuilder;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.uc.model.MatrixColDef;
import com.hotent.uc.model.MatrixColField;
import com.hotent.uc.service.matrix.MatrixDataService;
import com.hotent.uc.service.matrix.impl.AbstractMatrixDataServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class OrgMatrixDataServiceImpl
extends AbstractMatrixDataServiceImpl
implements MatrixDataService {
    public OrgMatrixDataServiceImpl(CommonManager commonManager) {
        super(commonManager);
        this.idColumn = "ucOrgId";
        this.nameColumn = "ucOrgName";
        this.codeColumn = "ucOrgCode";
        this.nameDbColumn = "uc_org.name_";
        this.ctrlType = "org";
    }

    @Override
    String generateSql(String matrixCode, List<MatrixColField> colFields) {
        Optional<MatrixColField> first = this.getSuitableColField(colFields);
        String codeField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondkFieldName).orElse(this.codeColumn);
        String nameField = first.map(MatrixColField::getColDef).map(MatrixColDef::getCondvFieldName).orElse(this.nameColumn);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(String.format("uc_org.code_ \"%s\"", codeField));
        fields.add(String.format("uc_org.name_ \"%s\"", nameField));
        for (MatrixColField field : colFields) {
            if (codeField.equals(field.getField()) || nameField.equals(field.getField())) continue;
            fields.add(String.format("%s.%s \"%s\"", "uc_matrix", field.getField(), field.getField()));
        }
        fields.add("(SELECT count( org2.id_ ) FROM uc_org org2 WHERE org2.PARENT_ID_ = uc_org.ID_) \"childrenCount\"");
        Condition condition = new Condition("uc_org.code_", (Object)("uc_matrix." + first.map(MatrixColField::getField).orElse("code_")));
        Condition condition1 = new Condition("uc_org.parent_id_", (Object)"parent_uc_org.id_");
        condition.setPlaceHolder(false);
        condition1.setPlaceHolder(false);
        SqlBuilder sqlBuilder = SqlBuilder.create().select(fields).from(new String[]{"uc_org uc_org"}).join("UC_MATRIX_" + matrixCode + " " + "uc_matrix", SqlBuilder.Join.LEFT).on(new Condition[]{condition}).join("uc_org parent_uc_org", SqlBuilder.Join.LEFT).on(new Condition[]{condition1});
        return sqlBuilder.toString();
    }

    @Override
    public void addQueryFilter(QueryFilter<?> queryFilter) {
        queryFilter.addFilter("uc_org.is_dele_", (Object)0, QueryOP.EQUAL);
    }
}

