/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.uc.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.uc.model.Org;
import com.hotent.uc.model.OrgPost;
import com.hotent.uc.model.OrgUser;
import com.hotent.uc.model.User;
import java.util.HashMap;
import java.util.Map;

public class LogFormatUtil {
    public static final String[] orgFields = new String[]{"name", "parentId", "grade", "demId", "orderNo", "path", "pathName"};
    public static final String[] postFields = new String[]{"relName", "isCharge"};
    public static final String[] userFields = new String[]{"fullname", "password", "email", "mobile", "address", "photo", "sex", "from", "status", "hasSyncToWx", "notifyType", "userNumber", "idCard", "phone", "birthday", "entryDate", "education"};
    private static final Map<String, String> orgLableMap = new HashMap<String, String>();
    private static final Map<String, String> postLableMap;
    private static final Map<String, String> orgUserLableMap;
    private static final Map<String, String> userLableMap;

    public static String getOrgLog(Org newOrg, Org oldOrg) {
        StringBuilder msg = new StringBuilder();
        if (BeanUtils.isEmpty((Object)newOrg)) {
            return "";
        }
        if (BeanUtils.isEmpty((Object)oldOrg)) {
            msg.append("\u65b0\u589e\u7ec4\u7ec7\uff1a" + newOrg.getName() + "\u3010" + newOrg.getCode() + "\u3011\uff1b");
        } else {
            String updateMsg = LogFormatUtil.getCommonLog(newOrg, oldOrg, orgFields, orgLableMap);
            if (StringUtil.isNotEmpty((String)updateMsg)) {
                msg.append("\u66f4\u65b0\u7ec4\u7ec7\uff1a" + oldOrg.getName() + "\u3010" + newOrg.getCode() + "\u3011\uff1a");
                msg.append(updateMsg);
            }
        }
        return msg.toString();
    }

    public static String getUserLog(User newUser, User oldUser) {
        StringBuilder msg = new StringBuilder();
        if (BeanUtils.isEmpty((Object)newUser)) {
            return "";
        }
        if (BeanUtils.isEmpty((Object)oldUser)) {
            msg.append("\u65b0\u589e\u7528\u6237\uff1a" + newUser.getFullname() + "\u3010" + newUser.getAccount() + "\u3011\uff1b");
        } else {
            String updateMsg = LogFormatUtil.getCommonLog(newUser, oldUser, userFields, userLableMap);
            if (StringUtil.isNotEmpty((String)updateMsg)) {
                msg.append("\u66f4\u65b0\u7528\u6237\uff1a" + oldUser.getFullname() + "\u3010" + newUser.getAccount() + "\u3011\uff1a");
                msg.append(updateMsg);
            }
        }
        return msg.toString();
    }

    public static String getPostLog(OrgPost newPost, OrgPost oldPost) {
        StringBuilder msg = new StringBuilder();
        if (BeanUtils.isEmpty((Object)newPost)) {
            return "";
        }
        if (BeanUtils.isEmpty((Object)oldPost)) {
            msg.append("\u65b0\u589e\u5c97\u4f4d\uff1a" + newPost.getName() + "\u3010" + newPost.getCode() + "\u3011\uff1b");
        } else {
            String updateMsg = LogFormatUtil.getCommonLog(newPost, oldPost, orgFields, orgLableMap);
            if (StringUtil.isNotEmpty((String)updateMsg)) {
                msg.append("\u66f4\u65b0\u5c97\u4f4d\uff1a" + newPost.getName() + "\u3010" + newPost.getCode() + "\u3011\uff1a");
                msg.append(updateMsg);
            }
        }
        return msg.toString();
    }

    public static String getOrgUserLog(OrgUser orgUser, Map<String, String> userMap, Map<String, String> orgMap, Map<String, String> postMap) {
        StringBuilder msg = new StringBuilder();
        if (BeanUtils.isEmpty((Object)orgUser)) {
            return "";
        }
        msg.append("\u7528\u6237\u7ec4\u7ec7\u5173\u7cfb\uff1aid\u3010" + orgUser.getId() + "\u3011\uff0c");
        msg.append("\u7ec4\u7ec7\u3010" + orgMap.get(orgUser.getOrgId()) + "\u3011\uff0c");
        msg.append("\u7528\u6237\u3010" + userMap.get(orgUser.getUserId()) + "\u3011\uff0c");
        if (StringUtil.isNotEmpty((String)orgUser.getRelId())) {
            msg.append("\u5c97\u4f4d\u3010" + postMap.get(orgUser.getRelId()) + "\u3011");
        }
        msg.append("\uff1b");
        return msg.toString();
    }

    public static String getCommonLog(Object newObject, Object oldObject, String[] objectFields, Map<String, String> lableMap) {
        StringBuilder msg = new StringBuilder();
        try {
            ObjectNode newJson = (ObjectNode)JsonUtil.toJsonNode((Object)newObject);
            if (BeanUtils.isNotEmpty((Object)oldObject)) {
                ObjectNode oldJson = (ObjectNode)JsonUtil.toJsonNode((Object)oldObject);
                for (String field : objectFields) {
                    Object newValue = newJson.get(field);
                    Object oldValue = oldJson.get(field);
                    if (BeanUtils.isEmpty((Object)newValue)) {
                        newValue = new Object();
                    }
                    if (BeanUtils.isEmpty((Object)oldValue)) {
                        oldValue = new Object();
                    }
                    if (BeanUtils.isEmpty((Object)oldJson.get(field)) && BeanUtils.isEmpty((Object)newJson.get(field)) || newValue.equals(oldValue)) continue;
                    msg.append(lableMap.get(field) + "\u7531\u3010" + oldJson.get(field) + "\u3011\u66f4\u65b0\u4e3a\u3010" + newJson.get(field) + "\u3011");
                }
            } else {
                boolean isFirst = true;
                for (String key : lableMap.keySet()) {
                    if (!isFirst) {
                        msg.append("\uff0c");
                    } else {
                        isFirst = false;
                    }
                    msg.append(lableMap.get(key) + "\uff1a" + newJson.get(key));
                }
                msg.append("\uff1b");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg.toString();
    }

    static {
        orgLableMap.put("id", "\u7ec4\u7ec7id");
        orgLableMap.put("code", "\u7ec4\u7ec7\u7f16\u7801");
        orgLableMap.put("name", "\u7ec4\u7ec7\u540d\u79f0");
        orgLableMap.put("parentId", "\u7236\u7ec4\u7ec7id");
        orgLableMap.put("grade", "\u7ec4\u7ec7\u7ea7\u522b");
        orgLableMap.put("demId", "\u7ef4\u5ea6id");
        orgLableMap.put("orderNo", "\u5e8f\u53f7");
        orgLableMap.put("path", "\u7ec4\u7ec7\u8def\u5f84");
        orgLableMap.put("pathName", "\u8def\u5f84\u540d\u79f0");
        postLableMap = new HashMap<String, String>();
        postLableMap.put("id", "\u5c97\u4f4did");
        postLableMap.put("orgId", "\u7ec4\u7ec7id");
        postLableMap.put("relDefId", "\u804c\u52a1id");
        postLableMap.put("relName", "\u5c97\u4f4d\u540d\u79f0");
        postLableMap.put("relCode", "\u5c97\u4f4d\u7f16\u7801");
        postLableMap.put("isCharge", "\u662f\u5426\u4e3b\u5c97\u4f4d");
        orgUserLableMap = new HashMap<String, String>();
        orgUserLableMap.put("id", "\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbid");
        orgUserLableMap.put("orgId", "\u7ec4\u7ec7id");
        orgUserLableMap.put("userId", "\u7528\u6237id");
        orgUserLableMap.put("isMaster", "\u662f\u5426\u4e3b\u7ec4\u7ec7");
        orgUserLableMap.put("isCharge", "\u662f\u5426\u7ec4\u7ec7\u8d1f\u8d23\u4eba");
        orgUserLableMap.put("relId", "\u5c97\u4f4did");
        orgUserLableMap.put("isRelActive", "\u662f\u5426\u751f\u6548");
        userLableMap = new HashMap<String, String>();
        userLableMap.put("id", "\u7528\u6237id");
        userLableMap.put("fullname", "\u59d3\u540d");
        userLableMap.put("account", "\u8d26\u53f7");
        userLableMap.put("password", "\u5bc6\u7801");
        userLableMap.put("email", "\u90ae\u7bb1");
        userLableMap.put("mobile", "\u624b\u673a\u53f7\u7801");
        userLableMap.put("address", "\u5730\u5740");
        userLableMap.put("photo", "\u5934\u50cf");
        userLableMap.put("sex", "\u6027\u522b");
        userLableMap.put("from", "\u6765\u6e90");
        userLableMap.put("status", "\u72b6\u6001\uff1a0:\u7981\u7528\uff0c1\u6b63\u5e38\uff0c-1\u672a\u6fc0\u6d3b\uff0c-2\u79bb\u804c");
        userLableMap.put("hasSyncToWx", "\u5fae\u4fe1\u540c\u6b65\u5173\u6ce8\u72b6\u6001");
        userLableMap.put("notifyType", "\u6d88\u606f\u901a\u77e5\u7c7b\u578b");
        userLableMap.put("userNumber", "\u5de5\u53f7");
        userLableMap.put("idCard", "\u8eab\u4efd\u8bc1\u53f7");
        userLableMap.put("phone", "\u529e\u516c\u7535\u8bdd");
        userLableMap.put("birthday", "\u751f\u65e5");
        userLableMap.put("entryDate", "\u5165\u804c\u65e5\u671f");
        userLableMap.put("education", "\u5b66\u5386");
    }
}

